/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.safeDelete.NonCodeUsageSearchInfo;
import com.intellij.refactoring.safeDelete.SafeDeleteProcessor;
import com.intellij.refactoring.safeDelete.SafeDeleteProcessorDelegateBase;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class StringResourceSafeDeleteProcessorDelegate
extends SafeDeleteProcessorDelegateBase {
    StringResourceSafeDeleteProcessorDelegate() {
    }

    public boolean handlesElement(@NotNull PsiElement element) {
        return StringResourceSafeDeleteProcessorDelegate.handlesElementImpl(element);
    }

    static boolean handlesElementImpl(@NotNull PsiElement element) {
        return element instanceof XmlTag && AndroidResourceUtil.isStringResource((XmlTag)element);
    }

    @NotNull
    public Collection<? extends PsiElement> getElementsToSearch(@NotNull PsiElement element, @Nullable Module module, @NotNull Collection<PsiElement> elementsToDelete) {
        return Collections.singletonList(element);
    }

    @NotNull
    public Collection<PsiElement> getAdditionalElementsToDelete(@NotNull PsiElement element, @NotNull Collection<PsiElement> elementsToDelete, boolean askUser) {
        return Collections.emptyList();
    }

    @NotNull
    public NonCodeUsageSearchInfo findUsages(@NotNull PsiElement element, @NotNull PsiElement[] elementsToDelete, @NotNull List<UsageInfo> result2) {
        ArrayList<Object> elements = new ArrayList<Object>();
        XmlTag tag = (XmlTag)element;
        XmlAttribute attribute = tag.getAttribute("name");
        assert (attribute != null);
        elements.add(attribute.getValueElement());
        elements.addAll(Arrays.asList(AndroidResourceUtil.findResourceFieldsForValueResource(tag, true)));
        elements.forEach(e -> SafeDeleteProcessor.findGenericElementUsages((PsiElement)e, (List)result2, (PsiElement[])elementsToDelete));
        return new NonCodeUsageSearchInfo(SafeDeleteProcessor.getDefaultInsideDeletedCondition((PsiElement[])elementsToDelete), elements);
    }

    @NotNull
    public UsageInfo[] preprocessUsages(@NotNull Project project, @NotNull UsageInfo[] usages) {
        return usages;
    }

    @Nullable
    public Collection<String> findConflicts(@NotNull PsiElement element, @NotNull PsiElement[] elementsToDelete) {
        return null;
    }

    public void prepareForDeletion(@NotNull PsiElement element) throws IncorrectOperationException {
    }

    public boolean isToSearchInComments(@NotNull PsiElement element) {
        return false;
    }

    public void setToSearchInComments(@NotNull PsiElement element, boolean enabled) {
    }

    public boolean isToSearchForTextOccurrences(@NotNull PsiElement element) {
        return false;
    }

    public void setToSearchForTextOccurrences(@NotNull PsiElement element, boolean enabled) {
    }
}

