/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings;

import com.android.tools.adtui.font.FontUtil;
import com.android.tools.idea.actions.BrowserHelpAction;
import com.android.tools.idea.editors.strings.AddKeyAction;
import com.android.tools.idea.editors.strings.AddLocaleAction;
import com.android.tools.idea.editors.strings.DeleteStringAction;
import com.android.tools.idea.editors.strings.FilterKeysAction;
import com.android.tools.idea.editors.strings.FilterLocalesAction;
import com.android.tools.idea.editors.strings.GoToDeclarationAction;
import com.android.tools.idea.editors.strings.MultilineStringEditorDialog;
import com.android.tools.idea.editors.strings.ReloadStringResourcesAction;
import com.android.tools.idea.editors.strings.RemoveKeysAction;
import com.android.tools.idea.editors.strings.RemoveLocaleMouseListener;
import com.android.tools.idea.editors.strings.ResourceLoadingTask;
import com.android.tools.idea.editors.strings.TranslationsEditorPasteAction;
import com.android.tools.idea.editors.strings.TranslationsEditorTextField;
import com.android.tools.idea.editors.strings.table.FrozenColumnTableEvent;
import com.android.tools.idea.editors.strings.table.FrozenColumnTableListener;
import com.android.tools.idea.editors.strings.table.StringResourceTable;
import com.android.tools.idea.editors.strings.table.StringResourceTableModel;
import com.android.tools.idea.editors.strings.table.StringTableCellEditor;
import com.android.tools.idea.rendering.Locale;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public final class StringResourceViewPanel
implements Disposable {
    private final AndroidFacet myFacet;
    private final JBLoadingPanel myLoadingPanel;
    private JPanel myContainer;
    private JPanel myToolbarPanel;
    private StringResourceTable myTable;
    private JTextComponent myKeyTextField;
    @VisibleForTesting
    TextFieldWithBrowseButton myDefaultValueTextField;
    private TextFieldWithBrowseButton myTranslationTextField;
    private RemoveKeysAction myRemoveKeysAction;
    private AddLocaleAction myAddLocaleAction;
    private GoToDeclarationAction myGoToAction;
    private DeleteStringAction myDeleteAction;

    StringResourceViewPanel(AndroidFacet facet, Disposable parentDisposable) {
        this.myFacet = facet;
        this.$$$setupUI$$$();
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        this.myToolbarPanel.add(this.createToolbar().getComponent());
        GridConstraints constraints = new GridConstraints();
        constraints.setFill(3);
        constraints.setRow(1);
        this.myContainer.add(this.myTable.getScrollPane(), constraints);
        this.myLoadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)this, 200);
        this.myLoadingPanel.setLoadingText("Loading string resource data");
        this.myLoadingPanel.setName("translationsEditor");
        this.myLoadingPanel.add((Component)this.myContainer);
        this.myLoadingPanel.startLoading();
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            new ResourceLoadingTask(this).queue();
        }
    }

    public void dispose() {
    }

    public void removeSelectedKeys() {
        this.myRemoveKeysAction.perform();
    }

    void addDocumentListener(@NotNull DocumentListener listener2) {
        StringTableCellEditor editor2 = (StringTableCellEditor)this.myTable.getDefaultEditor(String.class);
        assert (editor2 != null);
        editor2.getComponent().getDocument().addDocumentListener(listener2);
        this.myDefaultValueTextField.getTextField().getDocument().addDocumentListener(listener2);
        this.myTranslationTextField.getTextField().getDocument().addDocumentListener(listener2);
    }

    void addFocusListener(@NotNull FocusListener listener2) {
        DefaultCellEditor editor2 = (DefaultCellEditor)this.myTable.getDefaultEditor(String.class);
        assert (editor2 != null);
        editor2.getComponent().addFocusListener(listener2);
        this.myDefaultValueTextField.getTextField().addFocusListener(listener2);
        this.myTranslationTextField.getTextField().addFocusListener(listener2);
    }

    private void createUIComponents() {
        this.createTable();
        this.createTablePopupMenu();
        this.myKeyTextField = new TranslationsEditorTextField(this.myTable, 0);
        this.createDefaultValueTextField();
        this.createTranslationTextField();
    }

    private void createTable() {
        this.myRemoveKeysAction = new RemoveKeysAction(this);
        this.myDeleteAction = new DeleteStringAction(this);
        this.myGoToAction = new GoToDeclarationAction(this);
        this.myTable = new StringResourceTable();
        this.myTable.putInActionMap("delete", this.myDeleteAction);
        this.myTable.addFrozenColumnTableListener(new CellSelectionListener());
        this.myTable.addFrozenColumnTableListener(new RemoveLocaleMouseListener(this));
    }

    private void createTablePopupMenu() {
        final JPopupMenu menu = new JPopupMenu();
        final JMenuItem goTo = menu.add(this.myGoToAction);
        final JMenuItem delete = menu.add(this.myDeleteAction);
        this.myTable.addFrozenColumnTableListener(new FrozenColumnTableListener(){

            @Override
            public void cellPopupTriggered(@NotNull FrozenColumnTableEvent event) {
                StringResourceViewPanel.this.myGoToAction.update(goTo, event);
                StringResourceViewPanel.this.myDeleteAction.update(delete, event);
                if (goTo.isVisible() || delete.isVisible()) {
                    Point point = event.getPoint();
                    menu.show(event.getSubcomponent(), point.x, point.y);
                }
            }
        });
    }

    private void createDefaultValueTextField() {
        TranslationsEditorTextField textField2 = new TranslationsEditorTextField(this.myTable, 3);
        new TranslationsEditorPasteAction().registerCustomShortcutSet((JComponent)((Object)textField2), this);
        this.myDefaultValueTextField = new TextFieldWithBrowseButton((JTextField)((Object)textField2), (ActionListener)new ShowMultilineActionListener(), (Disposable)this);
        this.myDefaultValueTextField.setButtonIcon(AllIcons.Actions.ShowViewer);
    }

    private void createTranslationTextField() {
        TranslationsEditorTextField textField2 = new TranslationsEditorTextField(this.myTable, this.myTable::getSelectedModelColumnIndex);
        new TranslationsEditorPasteAction().registerCustomShortcutSet((JComponent)((Object)textField2), this);
        this.myTranslationTextField = new TextFieldWithBrowseButton((JTextField)((Object)textField2), (ActionListener)new ShowMultilineActionListener(), (Disposable)this);
        this.myTranslationTextField.setButtonIcon(AllIcons.Actions.ShowViewer);
    }

    void reloadData() {
        this.myLoadingPanel.setLoadingText("Updating string resource data");
        this.myLoadingPanel.startLoading();
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            new ResourceLoadingTask(this).queue();
        }
    }

    private ActionToolbar createToolbar() {
        this.myAddLocaleAction = new AddLocaleAction(this);
        DefaultActionGroup group = new DefaultActionGroup();
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("TranslationsEditorToolbar", (ActionGroup)group, true);
        JComponent toolbarComponent = toolbar.getComponent();
        toolbarComponent.setName("toolbar");
        group.add((AnAction)new AddKeyAction(this));
        group.add((AnAction)this.myRemoveKeysAction);
        group.add((AnAction)this.myAddLocaleAction);
        group.add((AnAction)new FilterKeysAction(this.myTable));
        group.add((AnAction)new FilterLocalesAction(this.myTable));
        group.add((AnAction)new ReloadStringResourcesAction(this));
        group.add((AnAction)new BrowserHelpAction("Translations editor", "https://developer.android.com/r/studio-ui/translations-editor.html"));
        return toolbar;
    }

    @NotNull
    AndroidFacet getFacet() {
        return this.myFacet;
    }

    @NotNull
    JBLoadingPanel getLoadingPanel() {
        return this.myLoadingPanel;
    }

    @NotNull
    public StringResourceTable getTable() {
        return this.myTable;
    }

    @NotNull
    JComponent getPreferredFocusedComponent() {
        return this.myTable.getScrollableTable();
    }

    @VisibleForTesting
    @NotNull
    AddLocaleAction getAddLocaleAction() {
        return this.myAddLocaleAction;
    }

    private static boolean isValueEditableInline(@NotNull String value2) {
        return !StringUtil.containsChar((String)value2, (char)'\n');
    }

    private static void setTextAndEditable(@NotNull JTextComponent component, @NotNull String text, boolean editable) {
        component.setText(text);
        component.setCaretPosition(0);
        component.setEditable(editable);
        component.getCaret().setVisible(editable && component.hasFocus());
        component.setFont(FontUtil.getFontAbleToDisplay((String)text, (Font)component.getFont()));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        this.createUIComponents();
        this.myContainer = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(5, 5, 5, 5), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(2, 0, 1, 1, 2, 1, 3, 1, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Key:");
        jPanel3.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        JTextComponent jTextComponent = this.myKeyTextField;
        ((Component)jTextComponent).setEnabled(false);
        jTextComponent.setName("keyTextField");
        jPanel3.add((Component)jTextComponent, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Default Value:");
        jPanel3.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Translation:");
        jPanel3.add((Component)jBLabel3, new GridConstraints(2, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        TextFieldWithBrowseButton textFieldWithBrowseButton = this.myDefaultValueTextField;
        textFieldWithBrowseButton.setName("defaultValueTextField");
        jPanel3.add((Component)textFieldWithBrowseButton, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        TextFieldWithBrowseButton textFieldWithBrowseButton2 = this.myTranslationTextField;
        textFieldWithBrowseButton2.setEnabled(false);
        textFieldWithBrowseButton2.setName("translationTextField");
        jPanel3.add((Component)textFieldWithBrowseButton2, new GridConstraints(2, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myToolbarPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 1, 1, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContainer;
    }

    private class ShowMultilineActionListener
    implements ActionListener {
        private ShowMultilineActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (StringResourceViewPanel.this.myTable.getSelectedRowCount() != 1 || StringResourceViewPanel.this.myTable.getSelectedColumnCount() != 1) {
                return;
            }
            int row = StringResourceViewPanel.this.myTable.getSelectedModelRowIndex();
            int column = StringResourceViewPanel.this.myTable.getSelectedModelColumnIndex();
            StringResourceTableModel model2 = StringResourceViewPanel.this.myTable.getModel();
            String value2 = (String)model2.getValueAt(row, 3);
            Locale locale = model2.getLocale(column);
            String translation = locale == null ? null : (String)model2.getValueAt(row, column);
            MultilineStringEditorDialog d = new MultilineStringEditorDialog(StringResourceViewPanel.this.myFacet, model2.getKey(row).getName(), value2, locale, translation);
            if (d.showAndGet()) {
                if (!StringUtil.equals((CharSequence)value2, (CharSequence)d.getDefaultValue())) {
                    model2.setValueAt(d.getDefaultValue(), row, 3);
                    StringResourceViewPanel.setTextAndEditable(StringResourceViewPanel.this.myDefaultValueTextField.getTextField(), d.getDefaultValue(), StringResourceViewPanel.isValueEditableInline(d.getDefaultValue()));
                }
                if (locale != null && !StringUtil.equals((CharSequence)translation, (CharSequence)d.getTranslation())) {
                    model2.setValueAt(d.getTranslation(), row, column);
                    StringResourceViewPanel.setTextAndEditable(StringResourceViewPanel.this.myTranslationTextField.getTextField(), d.getTranslation(), StringResourceViewPanel.isValueEditableInline(d.getTranslation()));
                }
            }
        }
    }

    private final class CellSelectionListener
    implements FrozenColumnTableListener {
        private CellSelectionListener() {
        }

        @Override
        public void selectedCellChanged() {
            if (StringResourceViewPanel.this.myTable.getSelectedColumnCount() != 1 || StringResourceViewPanel.this.myTable.getSelectedRowCount() != 1) {
                StringResourceViewPanel.setTextAndEditable(StringResourceViewPanel.this.myKeyTextField, "", false);
                StringResourceViewPanel.setTextAndEditable(StringResourceViewPanel.this.myDefaultValueTextField.getTextField(), "", false);
                StringResourceViewPanel.setTextAndEditable(StringResourceViewPanel.this.myTranslationTextField.getTextField(), "", false);
                StringResourceViewPanel.this.myDefaultValueTextField.getButton().setEnabled(false);
                StringResourceViewPanel.this.myTranslationTextField.getButton().setEnabled(false);
                return;
            }
            StringResourceViewPanel.this.myKeyTextField.setEnabled(true);
            StringResourceViewPanel.this.myDefaultValueTextField.setEnabled(true);
            StringResourceViewPanel.this.myTranslationTextField.setEnabled(true);
            StringResourceTableModel model2 = StringResourceViewPanel.this.myTable.getModel();
            int row = StringResourceViewPanel.this.myTable.getSelectedModelRowIndex();
            int column = StringResourceViewPanel.this.myTable.getSelectedModelColumnIndex();
            Locale locale = model2.getLocale(column);
            StringResourceViewPanel.setTextAndEditable(StringResourceViewPanel.this.myKeyTextField, model2.getKey(row).getName(), false);
            String defaultValue = (String)model2.getValueAt(row, 3);
            boolean defaultValueEditable = StringResourceViewPanel.isValueEditableInline(defaultValue);
            StringResourceViewPanel.setTextAndEditable(StringResourceViewPanel.this.myDefaultValueTextField.getTextField(), defaultValue, defaultValueEditable);
            StringResourceViewPanel.this.myDefaultValueTextField.getButton().setEnabled(true);
            boolean translationEditable = false;
            String translation = "";
            if (locale != null) {
                translation = (String)model2.getValueAt(row, column);
                translationEditable = StringResourceViewPanel.isValueEditableInline(translation);
            }
            StringResourceViewPanel.setTextAndEditable(StringResourceViewPanel.this.myTranslationTextField.getTextField(), translation, translationEditable);
            StringResourceViewPanel.this.myTranslationTextField.getButton().setEnabled(locale != null);
        }
    }
}

