/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings;

import com.android.tools.idea.editors.AndroidFakeFileSystem;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.ex.FakeFileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.testFramework.LightVirtualFile;
import icons.StudioIcons;
import javax.swing.Icon;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringsVirtualFile
extends LightVirtualFile {
    public static final String NAME = "Translations Editor";
    private static final Key<StringsVirtualFile> KEY = Key.create((String)StringsVirtualFile.class.getName());
    @NotNull
    private final AndroidFacet myFacet;

    private StringsVirtualFile(@NotNull AndroidFacet facet) {
        super(NAME, (FileType)StringsResourceFileType.INSTANCE, (CharSequence)"");
        this.myFacet = facet;
    }

    @NotNull
    public AndroidFacet getFacet() {
        return this.myFacet;
    }

    public VirtualFile getParent() {
        VirtualFile moduleFile = this.myFacet.getModule().getModuleFile();
        return moduleFile == null ? null : moduleFile.getParent();
    }

    @NotNull
    public String getPath() {
        Module module = this.myFacet.getModule();
        return module.getProject().isDisposed() ? super.getPath() : AndroidFakeFileSystem.constructPathForFile(this.getName(), module);
    }

    @Nullable
    public static StringsVirtualFile getInstance(@NotNull Project project, @NotNull VirtualFile file) {
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project);
        return module == null ? null : StringsVirtualFile.getStringsVirtualFile(module);
    }

    @Nullable
    public static StringsVirtualFile getStringsVirtualFile(@NotNull Module module) {
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet == null) {
            return null;
        }
        StringsVirtualFile file = (StringsVirtualFile)((Object)facet.getUserData(KEY));
        if (file == null) {
            file = new StringsVirtualFile(facet);
            facet.putUserData(KEY, (Object)file);
        }
        return file;
    }

    @NotNull
    public VirtualFileSystem getFileSystem() {
        return AndroidFakeFileSystem.INSTANCE;
    }

    private static class StringsResourceFileType
    extends FakeFileType {
        public static final StringsResourceFileType INSTANCE = new StringsResourceFileType();

        private StringsResourceFileType() {
        }

        public boolean isMyFileType(@NotNull VirtualFile file) {
            return file.getFileType() instanceof StringsResourceFileType;
        }

        @NotNull
        public String getName() {
            return "";
        }

        @NotNull
        public String getDescription() {
            return "";
        }

        public Icon getIcon() {
            return StudioIcons.LayoutEditor.Toolbar.LANGUAGE;
        }
    }
}

