/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings.table;

import com.android.tools.idea.editors.strings.table.FrozenColumnTableEvent;
import com.android.tools.idea.editors.strings.table.FrozenColumnTableListener;
import com.android.tools.idea.editors.strings.table.SubTable;
import com.android.tools.idea.editors.strings.table.SubTableModel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.components.JBScrollPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.IntUnaryOperator;
import javax.swing.Action;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.RowSorter;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FrozenColumnTable {
    private TableModel myModel;
    private final int myFrozenColumnCount;
    private final Collection<FrozenColumnTableListener> myListeners;
    private SubTable myFrozenTable;
    private SubTable myScrollableTable;
    private JScrollPane myScrollPane;
    private int rowHeight;
    private int mySelectedRow;
    private int mySelectedColumn;

    FrozenColumnTable(@NotNull TableModel model2, int frozenColumnCount) {
        this.myModel = model2;
        this.myFrozenColumnCount = frozenColumnCount;
        this.myListeners = new ArrayList<FrozenColumnTableListener>();
        this.initFrozenTable();
        this.initScrollableTable();
        this.initScrollPane();
        this.mySelectedRow = -1;
        this.mySelectedColumn = -1;
    }

    private void initFrozenTable() {
        this.myFrozenTable = new SubTable(new SubTableModel(this.myModel, () -> 0, () -> this.myFrozenColumnCount), this);
        this.myFrozenTable.setName("frozenTable");
        IntUnaryOperator converter = IntUnaryOperator.identity();
        this.myFrozenTable.getTableHeader().addMouseListener(new HeaderPopupTriggerListener(converter));
        this.myFrozenTable.getSelectionModel().addListSelectionListener(event -> {
            this.myScrollableTable.setSelectedRow(this.myFrozenTable.getSelectedRow());
            this.fireSelectedCellChanged();
        });
        this.myFrozenTable.getColumnModel().getSelectionModel().addListSelectionListener(event -> {
            if (this.myFrozenTable.getSelectedColumn() == -1) {
                return;
            }
            this.myScrollableTable.getColumnModel().getSelectionModel().clearSelection();
            this.fireSelectedCellChanged();
        });
        this.myFrozenTable.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(@NotNull ComponentEvent event) {
                JViewport header = FrozenColumnTable.this.myScrollPane.getRowHeader();
                Dimension size = ((Component)header).getPreferredSize();
                size.width = FrozenColumnTable.this.myFrozenTable.getWidth();
                ((Component)header).setPreferredSize(size);
                FrozenColumnTable.this.myScrollPane.revalidate();
            }
        });
        this.myFrozenTable.addMouseListener(new CellPopupTriggerListener(converter));
    }

    private void initScrollableTable() {
        this.myScrollableTable = new SubTable(new SubTableModel(this.myModel, () -> this.myFrozenColumnCount, this.myModel::getColumnCount), this);
        this.myScrollableTable.setName("scrollableTable");
        IntUnaryOperator converter = viewColumnIndex -> this.myFrozenTable.getColumnCount() + viewColumnIndex;
        this.myScrollableTable.getTableHeader().addMouseListener(new HeaderPopupTriggerListener(converter));
        this.myScrollableTable.getSelectionModel().addListSelectionListener(event -> {
            this.myFrozenTable.setSelectedRow(this.myScrollableTable.getSelectedRow());
            this.fireSelectedCellChanged();
        });
        this.myScrollableTable.getColumnModel().getSelectionModel().addListSelectionListener(event -> {
            if (this.myScrollableTable.getSelectedColumn() == -1) {
                return;
            }
            this.myFrozenTable.getColumnModel().getSelectionModel().clearSelection();
            this.fireSelectedCellChanged();
        });
        this.myScrollableTable.addMouseListener(new CellPopupTriggerListener(converter));
    }

    private void fireSelectedCellChanged() {
        int selectedRow = this.getSelectedRow();
        int selectedColumn = this.getSelectedColumn();
        if (this.mySelectedRow == selectedRow && this.mySelectedColumn == selectedColumn) {
            return;
        }
        this.mySelectedRow = selectedRow;
        this.mySelectedColumn = selectedColumn;
        this.myListeners.forEach(listener2 -> listener2.selectedCellChanged());
    }

    private void initScrollPane() {
        this.myScrollPane = new JBScrollPane((Component)((Object)this.myScrollableTable));
        this.myScrollPane.setCorner("UPPER_LEFT_CORNER", this.myFrozenTable.getTableHeader());
        this.myScrollPane.setRowHeaderView((Component)((Object)this.myFrozenTable));
    }

    boolean includeColumn(int modelColumnIndex) {
        return true;
    }

    @NotNull
    TableColumn createColumn(int modelColumnIndex) {
        return new TableColumn(modelColumnIndex);
    }

    public final void selectCellAt(int viewRowIndex, int viewColumnIndex) {
        int count = this.myFrozenTable.getColumnCount();
        if (viewColumnIndex < count) {
            this.myFrozenTable.setRowSelectionInterval(viewRowIndex, viewRowIndex);
            this.myFrozenTable.setColumnSelectionInterval(viewColumnIndex, viewColumnIndex);
            return;
        }
        this.myScrollableTable.setRowSelectionInterval(viewRowIndex, viewRowIndex);
        this.myScrollableTable.setColumnSelectionInterval(viewColumnIndex -= count, viewColumnIndex);
    }

    public final int getSelectedModelRowIndex() {
        int index = this.myFrozenTable.convertRowIndexToModel(this.myFrozenTable.getSelectedRow());
        assert (index == this.myScrollableTable.convertRowIndexToModel(this.myScrollableTable.getSelectedRow()));
        return index;
    }

    public final int getSelectedModelColumnIndex() {
        SubTable table2;
        int index = this.getSelectedColumn();
        if (index == -1) {
            return -1;
        }
        int count = this.myFrozenTable.getColumnCount();
        if (index < count) {
            table2 = this.myFrozenTable;
        } else {
            table2 = this.myScrollableTable;
            index -= count;
        }
        return ((SubTableModel)((JTable)((Object)table2)).getModel()).convertColumnIndexToDelegate(((JTable)((Object)table2)).getColumnModel().getColumn(index).getModelIndex());
    }

    public final int[] getSelectedModelRowIndices() {
        int[] indices = this.myFrozenTable.getSelectedModelRowIndices();
        assert (Arrays.equals(indices, this.myScrollableTable.getSelectedModelRowIndices()));
        return indices;
    }

    public final int[] getSelectedModelColumnIndices() {
        int[] frozenIndices = this.myFrozenTable.getSelectedModelColumnIndices();
        int[] scrollableIndices = this.myScrollableTable.getSelectedModelColumnIndices();
        int[] indices = new int[frozenIndices.length + scrollableIndices.length];
        System.arraycopy(frozenIndices, 0, indices, 0, frozenIndices.length);
        System.arraycopy(scrollableIndices, 0, indices, frozenIndices.length, scrollableIndices.length);
        return indices;
    }

    public final int getFrozenColumnCount() {
        return this.myFrozenTable.getColumnCount();
    }

    @NotNull
    public final TableColumn getColumn(int viewColumnIndex) {
        if (viewColumnIndex < this.myFrozenTable.getColumnCount()) {
            return this.myFrozenTable.getColumnModel().getColumn(viewColumnIndex);
        }
        return this.myScrollableTable.getColumnModel().getColumn(viewColumnIndex - this.myFrozenTable.getColumnCount());
    }

    final int convertRowIndexToModel(int viewRowIndex) {
        int modelRowIndex = this.myFrozenTable.convertRowIndexToModel(viewRowIndex);
        assert (modelRowIndex == this.myScrollableTable.convertRowIndexToModel(viewRowIndex));
        return modelRowIndex;
    }

    final int convertColumnIndexToModel(int viewColumnIndex) {
        SubTable table2;
        int count = this.myFrozenTable.getColumnCount();
        if (viewColumnIndex < count) {
            table2 = this.myFrozenTable;
        } else {
            table2 = this.myScrollableTable;
            viewColumnIndex -= count;
        }
        return ((SubTableModel)((JTable)((Object)table2)).getModel()).convertColumnIndexToDelegate(((JTable)((Object)table2)).convertColumnIndexToModel(viewColumnIndex));
    }

    @NotNull
    final TableCellRenderer getDefaultTableHeaderRenderer() {
        return this.myFrozenTable.getTableHeader().getDefaultRenderer();
    }

    @NotNull
    final TableCellRenderer getCellRenderer(int viewRowIndex, int viewColumnIndex) {
        int count = this.myFrozenTable.getColumnCount();
        if (viewColumnIndex < count) {
            return this.myFrozenTable.getCellRenderer(viewRowIndex, viewColumnIndex);
        }
        return this.myScrollableTable.getCellRenderer(viewRowIndex, viewColumnIndex - count);
    }

    final int getPreferredWidth(@NotNull TableCellRenderer renderer, @NotNull Object value2, int viewRowIndex, int viewColumnIndex) {
        SubTable table2;
        int count = this.myFrozenTable.getColumnCount();
        if (viewColumnIndex < count) {
            table2 = this.myFrozenTable;
        } else {
            table2 = this.myScrollableTable;
            viewColumnIndex -= count;
        }
        return renderer.getTableCellRendererComponent((JTable)((Object)table2), (Object)value2, (boolean)false, (boolean)false, (int)viewRowIndex, (int)viewColumnIndex).getPreferredSize().width + 2;
    }

    @NotNull
    public final JTable getFrozenTable() {
        return this.myFrozenTable;
    }

    @NotNull
    public final JTable getScrollableTable() {
        return this.myScrollableTable;
    }

    @NotNull
    public final Component getScrollPane() {
        return this.myScrollPane;
    }

    final int getRowHeight() {
        return this.rowHeight;
    }

    final void setRowHeight(int rowHeight) {
        this.rowHeight = rowHeight;
    }

    final void putInInputMap(@NotNull KeyStroke keyStroke, @NotNull Object actionMapKey) {
        this.myFrozenTable.getInputMap().put(keyStroke, actionMapKey);
        this.myScrollableTable.getInputMap().put(keyStroke, actionMapKey);
    }

    public final void putInActionMap(@NotNull Object key, @NotNull Action action2) {
        this.myFrozenTable.getActionMap().put(key, action2);
        this.myScrollableTable.getActionMap().put(key, action2);
    }

    public final void addFrozenColumnTableListener(@NotNull FrozenColumnTableListener listener2) {
        this.myListeners.add(listener2);
    }

    @NotNull
    final Iterable<FrozenColumnTableListener> getListeners() {
        return this.myListeners;
    }

    boolean isPastePossible() {
        return false;
    }

    final void paste(@NotNull Transferable transferable) {
        if (this.getSelectedRowCount() != 1 || this.getSelectedColumnCount() != 1) {
            return;
        }
        if (!transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            return;
        }
        int row = this.getSelectedRow();
        int rowCount = this.getRowCount();
        int selectedColumn = this.getSelectedColumn();
        int columnCount = this.getColumnCount();
        for (String values : FrozenColumnTable.getTransferDataAsString(transferable).split("\n")) {
            if (row >= rowCount) break;
            int column = selectedColumn;
            for (String value2 : values.split("\t")) {
                if (column >= columnCount) break;
                this.setValueAt(value2, row, column++);
            }
            ++row;
        }
    }

    @NotNull
    private static String getTransferDataAsString(@NotNull Transferable transferable) {
        try {
            return (String)transferable.getTransferData(DataFlavor.stringFlavor);
        }
        catch (UnsupportedFlavorException | IOException exception) {
            Logger.getInstance(FrozenColumnTable.class).warn((Throwable)exception);
            return "";
        }
    }

    final void createDefaultColumnsFromModel() {
        this.myFrozenTable.createDefaultColumnsFromModel();
        this.myScrollableTable.createDefaultColumnsFromModel();
    }

    final void setDefaultRenderer(@NotNull Class<?> c, @NotNull TableCellRenderer renderer) {
        this.myFrozenTable.setDefaultRenderer(c, renderer);
        this.myScrollableTable.setDefaultRenderer(c, renderer);
    }

    @Nullable
    public final TableCellEditor getDefaultEditor(@NotNull Class<?> c) {
        TableCellEditor editor2 = this.myFrozenTable.getDefaultEditor(c);
        assert (editor2 == this.myScrollableTable.getDefaultEditor(c));
        return editor2;
    }

    final void setDefaultEditor(@NotNull Class<?> c, @NotNull TableCellEditor editor2) {
        this.myFrozenTable.setDefaultEditor(c, editor2);
        this.myScrollableTable.setDefaultEditor(c, editor2);
    }

    @NotNull
    RowSorter<? extends TableModel> getRowSorter() {
        RowSorter sorter = this.myFrozenTable.getRowSorter();
        assert (sorter == this.myScrollableTable.getRowSorter());
        return sorter;
    }

    final void setRowSorter(@NotNull RowSorter<? extends TableModel> sorter) {
        this.myFrozenTable.setRowSorter(sorter);
        this.myScrollableTable.setRowSorter(sorter);
    }

    public final void setRowSelectionInterval(int viewRowIndex1, int viewRowIndex2) {
        this.myFrozenTable.setRowSelectionInterval(viewRowIndex1, viewRowIndex2);
        assert (Arrays.equals(this.myFrozenTable.getSelectedRows(), this.myScrollableTable.getSelectedRows()));
    }

    public final void setColumnSelectionInterval(int viewColumnIndex1, int viewColumnIndex2) {
        assert (viewColumnIndex1 <= viewColumnIndex2);
        int count = this.myFrozenTable.getColumnCount();
        if (viewColumnIndex2 < count) {
            this.myFrozenTable.setColumnSelectionInterval(viewColumnIndex1, viewColumnIndex2);
            return;
        }
        if (viewColumnIndex1 >= count) {
            this.myScrollableTable.setColumnSelectionInterval(viewColumnIndex1 - count, viewColumnIndex2 - count);
            return;
        }
        throw new UnsupportedOperationException();
    }

    public final int getSelectedRow() {
        int row = this.myFrozenTable.getSelectedRow();
        assert (row == this.myScrollableTable.getSelectedRow());
        return row;
    }

    public final int getSelectedColumn() {
        int column = this.myFrozenTable.getSelectedColumn();
        if (column != -1) {
            return column;
        }
        column = this.myScrollableTable.getSelectedColumn();
        if (column != -1) {
            return this.myFrozenTable.getColumnCount() + column;
        }
        return -1;
    }

    public final int getSelectedRowCount() {
        int count = this.myFrozenTable.getSelectedRowCount();
        assert (count == this.myScrollableTable.getSelectedRowCount());
        return count;
    }

    public final int getSelectedColumnCount() {
        return this.myFrozenTable.getSelectedColumnCount() + this.myScrollableTable.getSelectedColumnCount();
    }

    public final int getRowCount() {
        int count = this.myFrozenTable.getRowCount();
        assert (count == this.myScrollableTable.getRowCount());
        return count;
    }

    public final int getColumnCount() {
        return this.myFrozenTable.getColumnCount() + this.myScrollableTable.getColumnCount();
    }

    @NotNull
    public final String getColumnName(int viewColumnIndex) {
        int count = this.myFrozenTable.getColumnCount();
        if (viewColumnIndex < count) {
            return this.myFrozenTable.getColumnName(viewColumnIndex);
        }
        return this.myScrollableTable.getColumnName(viewColumnIndex - count);
    }

    @NotNull
    public final Object getValueAt(int viewRowIndex, int viewColumnIndex) {
        int count = this.myFrozenTable.getColumnCount();
        if (viewColumnIndex < count) {
            return this.myFrozenTable.getValueAt(viewRowIndex, viewColumnIndex);
        }
        return this.myScrollableTable.getValueAt(viewRowIndex, viewColumnIndex - count);
    }

    private void setValueAt(@NotNull Object value2, int viewRowIndex, int viewColumnIndex) {
        int count = this.myFrozenTable.getColumnCount();
        if (viewColumnIndex < count) {
            this.myFrozenTable.setValueAt(value2, viewRowIndex, viewColumnIndex);
            return;
        }
        this.myScrollableTable.setValueAt(value2, viewRowIndex, viewColumnIndex - count);
    }

    public final boolean editCellAt(int viewRowIndex, int viewColumnIndex) {
        int count = this.myFrozenTable.getColumnCount();
        if (viewColumnIndex < count) {
            return this.myFrozenTable.editCellAt(viewRowIndex, viewColumnIndex);
        }
        return this.myScrollableTable.editCellAt(viewRowIndex, viewColumnIndex - count);
    }

    @NotNull
    public TableModel getModel() {
        return this.myModel;
    }

    public void setModel(@NotNull TableModel model2) {
        this.myModel = model2;
        this.myFrozenTable.setModel(new SubTableModel(model2, () -> 0, () -> this.myFrozenColumnCount));
        this.myScrollableTable.setModel(new SubTableModel(model2, () -> this.myFrozenColumnCount, model2::getColumnCount));
    }

    @Nullable
    public final TableCellEditor getCellEditor() {
        if (this.myFrozenTable.isEditing()) {
            return this.myFrozenTable.getCellEditor();
        }
        return this.myScrollableTable.getCellEditor();
    }

    @NotNull
    final Font getFont() {
        Font font = this.myFrozenTable.getFont();
        assert (font.equals(this.myScrollableTable.getFont()));
        return font;
    }

    private static final class CellPopupTriggerListener
    extends MouseAdapter {
        private final IntUnaryOperator myConverter;

        private CellPopupTriggerListener(@NotNull IntUnaryOperator converter) {
            this.myConverter = converter;
        }

        @Override
        public void mousePressed(@NotNull MouseEvent event) {
            this.mousePressedOrReleased(event);
        }

        @Override
        public void mouseReleased(@NotNull MouseEvent event) {
            this.mousePressedOrReleased(event);
        }

        private void mousePressedOrReleased(@NotNull MouseEvent event) {
            if (!event.isPopupTrigger()) {
                return;
            }
            SubTable subTable = (SubTable)((Object)event.getSource());
            Point point = event.getPoint();
            FrozenColumnTable source = subTable.getFrozenColumnTable();
            int viewRowIndex = subTable.rowAtPoint(point);
            int viewColumnIndex = this.myConverter.applyAsInt(subTable.columnAtPoint(point));
            FrozenColumnTableEvent frozenColumnTableEvent = new FrozenColumnTableEvent(source, viewRowIndex, viewColumnIndex, point, (Component)((Object)subTable));
            source.getListeners().forEach(listener2 -> listener2.cellPopupTriggered(frozenColumnTableEvent));
        }
    }

    private static final class HeaderPopupTriggerListener
    extends MouseAdapter {
        private final IntUnaryOperator myConverter;

        private HeaderPopupTriggerListener(@NotNull IntUnaryOperator converter) {
            this.myConverter = converter;
        }

        @Override
        public void mousePressed(@NotNull MouseEvent event) {
            this.mousePressedOrReleased(event);
        }

        @Override
        public void mouseReleased(@NotNull MouseEvent event) {
            this.mousePressedOrReleased(event);
        }

        private void mousePressedOrReleased(@NotNull MouseEvent event) {
            Point point;
            if (!event.isPopupTrigger()) {
                return;
            }
            JTableHeader header = (JTableHeader)event.getSource();
            int subTableIndex = header.columnAtPoint(point = event.getPoint());
            if (subTableIndex == -1) {
                return;
            }
            FrozenColumnTable source = ((SubTable)((Object)header.getTable())).getFrozenColumnTable();
            int frozenColumnTableIndex = this.myConverter.applyAsInt(subTableIndex);
            FrozenColumnTableEvent frozenColumnTableEvent = new FrozenColumnTableEvent(source, -1, frozenColumnTableIndex, point, header);
            source.getListeners().forEach(listener2 -> listener2.headerPopupTriggered(frozenColumnTableEvent));
        }
    }
}

