/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings.table;

import com.android.tools.idea.configurations.LocaleMenuAction;
import com.android.tools.idea.editors.strings.StringResource;
import com.android.tools.idea.editors.strings.table.StringResourceTableModel;
import com.android.tools.idea.editors.strings.table.StringResourceTableRowFilter;
import com.android.tools.idea.rendering.Locale;
import com.intellij.openapi.actionSystem.Presentation;
import javax.swing.RowFilter;
import org.jetbrains.annotations.NotNull;

public final class NeedsTranslationForLocaleRowFilter
extends StringResourceTableRowFilter {
    private final Locale myLocale;

    public NeedsTranslationForLocaleRowFilter(@NotNull Locale locale) {
        this.myLocale = locale;
    }

    @Override
    public void update(@NotNull Presentation presentation) {
        presentation.setIcon(this.myLocale.getFlagImage());
        presentation.setText("Show Keys Needing a Translation for " + LocaleMenuAction.getLocaleLabel(this.myLocale, false));
    }

    @Override
    public boolean include(@NotNull RowFilter.Entry<? extends StringResourceTableModel, ? extends Integer> entry) {
        StringResource resource = entry.getModel().getStringResourceAt(entry.getIdentifier());
        return resource.isTranslatable() && resource.getTranslationAsString(this.myLocale).isEmpty();
    }
}

