/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings.table;

import com.android.tools.idea.editors.strings.StringResourceData;
import com.android.tools.idea.editors.strings.table.FrozenColumnTable;
import com.android.tools.idea.editors.strings.table.LocaleRenderer;
import com.android.tools.idea.editors.strings.table.StringResourceTableColumnFilter;
import com.android.tools.idea.editors.strings.table.StringResourceTableModel;
import com.android.tools.idea.editors.strings.table.StringResourceTableRowFilter;
import com.android.tools.idea.editors.strings.table.StringTableCellEditor;
import com.android.tools.idea.editors.strings.table.StringsCellRenderer;
import com.android.tools.idea.rendering.Locale;
import com.intellij.util.ui.JBUI;
import java.util.List;
import java.util.OptionalInt;
import java.util.stream.IntStream;
import javax.swing.DefaultRowSorter;
import javax.swing.KeyStroke;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StringResourceTable
extends FrozenColumnTable {
    private final TableCellRenderer myLocaleRenderer;
    @Nullable
    private StringResourceTableColumnFilter myColumnFilter;
    private boolean myColumnPreferredWidthsSet;

    public StringResourceTable() {
        super(new StringResourceTableModel(), 4);
        this.setDefaultEditor(String.class, new StringTableCellEditor());
        this.setDefaultRenderer(String.class, (TableCellRenderer)((Object)new StringsCellRenderer()));
        this.setRowSorter(new ThreeStateTableRowSorter<StringResourceTableModel>(this.getModel()));
        this.putInInputMap(KeyStroke.getKeyStroke(8, 0), "delete");
        this.putInInputMap(KeyStroke.getKeyStroke(127, 0), "delete");
        this.myLocaleRenderer = new LocaleRenderer(this.getDefaultTableHeaderRenderer());
    }

    @Nullable
    public StringResourceData getData() {
        return this.getModel().getData();
    }

    @Nullable
    public StringResourceTableRowFilter getRowFilter() {
        return (StringResourceTableRowFilter)((DefaultRowSorter)this.getRowSorter()).getRowFilter();
    }

    public void setRowFilter(@Nullable StringResourceTableRowFilter filter2) {
        ((DefaultRowSorter)this.getRowSorter()).setRowFilter(filter2);
    }

    @Nullable
    public StringResourceTableColumnFilter getColumnFilter() {
        return this.myColumnFilter;
    }

    public void setColumnFilter(@Nullable StringResourceTableColumnFilter filter2) {
        this.myColumnFilter = filter2;
        this.createDefaultColumnsFromModel();
    }

    @Override
    boolean includeColumn(int modelColumnIndex) {
        if (modelColumnIndex < 4) {
            return true;
        }
        if (this.myColumnFilter == null) {
            return true;
        }
        Locale locale = this.getModel().getLocale(modelColumnIndex);
        assert (locale != null);
        return this.myColumnFilter.include(locale);
    }

    @Override
    @NotNull
    TableColumn createColumn(int modelColumnIndex) {
        TableColumn column = new TableColumn(modelColumnIndex);
        if (modelColumnIndex >= 4) {
            column.setHeaderRenderer(this.myLocaleRenderer);
        }
        return column;
    }

    @NotNull
    public TableRowSorter<StringResourceTableModel> getRowSorter() {
        return (TableRowSorter)super.getRowSorter();
    }

    @Override
    @NotNull
    public StringResourceTableModel getModel() {
        return (StringResourceTableModel)super.getModel();
    }

    @Override
    public void setModel(@NotNull TableModel model2) {
        super.setModel(model2);
        ((TableRowSorter)this.getRowSorter()).setModel((StringResourceTableModel)model2);
        if (this.myColumnPreferredWidthsSet) {
            return;
        }
        IntStream.range(0, this.getColumnCount()).forEach(viewColumnIndex -> this.getColumn(viewColumnIndex).setPreferredWidth(this.getPreferredColumnWidth(viewColumnIndex)));
        this.myColumnPreferredWidthsSet = true;
    }

    private int getPreferredColumnWidth(int viewColumnIndex) {
        int minColumnWidth;
        OptionalInt optionalMaxCellWidth;
        int headerWidth = this.getPreferredHeaderWidth(viewColumnIndex);
        int columnWidth = Math.max(headerWidth, (optionalMaxCellWidth = IntStream.range(0, this.getRowCount()).map(viewRowIndex -> this.getPreferredCellWidth(viewRowIndex, viewColumnIndex)).max()).orElse(minColumnWidth = JBUI.scale((int)20)));
        if (columnWidth < minColumnWidth) {
            return minColumnWidth;
        }
        int maxColumnWidth = JBUI.scale((int)200);
        if (columnWidth > maxColumnWidth) {
            return maxColumnWidth;
        }
        return columnWidth;
    }

    private int getPreferredHeaderWidth(int viewColumnIndex) {
        TableCellRenderer renderer = this.getColumn(viewColumnIndex).getHeaderRenderer();
        if (renderer == null) {
            renderer = this.getDefaultTableHeaderRenderer();
        }
        return this.getPreferredWidth(renderer, this.getColumnName(viewColumnIndex), -1, viewColumnIndex);
    }

    private int getPreferredCellWidth(int viewRowIndex, int viewColumnIndex) {
        TableCellRenderer renderer = this.getCellRenderer(viewRowIndex, viewColumnIndex);
        return this.getPreferredWidth(renderer, this.getValueAt(viewRowIndex, viewColumnIndex), viewRowIndex, viewColumnIndex);
    }

    @Override
    boolean isPastePossible() {
        if (this.getSelectedRowCount() != 1 || this.getSelectedColumnCount() != 1) {
            return false;
        }
        int column = this.getSelectedColumn();
        return column != 0 && column != 2;
    }

    static class ThreeStateTableRowSorter<M extends TableModel>
    extends TableRowSorter<M> {
        public ThreeStateTableRowSorter(M model2) {
            super(model2);
        }

        @Override
        public void toggleSortOrder(int column) {
            List<RowSorter.SortKey> sortKeys = this.getSortKeys();
            if (!sortKeys.isEmpty() && sortKeys.get(0).getSortOrder() == SortOrder.DESCENDING) {
                this.setSortKeys(null);
                return;
            }
            super.toggleSortOrder(column);
        }

        @Override
        public void modelStructureChanged() {
            List<RowSorter.SortKey> sortKeys = this.getSortKeys();
            super.modelStructureChanged();
            this.setSortKeys(sortKeys);
        }
    }
}

