/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings.table;

import com.android.tools.idea.editors.strings.table.FrozenColumnTable;
import com.android.tools.idea.editors.strings.table.SubTableModel;
import com.google.common.collect.Maps;
import com.intellij.ide.PasteProvider;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.table.JBTable;
import java.awt.datatransfer.Transferable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.IntStream;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class SubTable
extends JBTable
implements DataProvider,
PasteProvider {
    private final FrozenColumnTable myFrozenColumnTable;

    SubTable(@NotNull SubTableModel model2, @NotNull FrozenColumnTable frozenColumnTable) {
        super((TableModel)model2);
        this.getSelectionModel().setSelectionMode(0);
        this.getColumnModel().getSelectionModel().setSelectionMode(0);
        this.setAutoResizeMode(0);
        this.setCellSelectionEnabled(true);
        new TableSpeedSearch((JTable)((Object)this));
        this.myFrozenColumnTable = frozenColumnTable;
    }

    @NotNull
    FrozenColumnTable getFrozenColumnTable() {
        return this.myFrozenColumnTable;
    }

    void setSelectedRow(int selectedViewRowIndex) {
        if (this.getSelectedRow() == selectedViewRowIndex) {
            return;
        }
        if (selectedViewRowIndex == -1) {
            this.getSelectionModel().clearSelection();
            return;
        }
        this.setRowSelectionInterval(selectedViewRowIndex, selectedViewRowIndex);
    }

    @NotNull
    int[] getSelectedModelRowIndices() {
        return Arrays.stream(this.getSelectedRows()).map(arg_0 -> this.convertRowIndexToModel(arg_0)).toArray();
    }

    @NotNull
    int[] getSelectedModelColumnIndices() {
        SubTableModel model2 = (SubTableModel)this.getModel();
        return Arrays.stream(this.getSelectedColumns()).map(arg_0 -> this.convertColumnIndexToModel(arg_0)).map(model2::convertColumnIndexToDelegate).toArray();
    }

    @NotNull
    protected JTableHeader createDefaultTableHeader() {
        JBTable.JBTableHeader header = new JBTable.JBTableHeader((JBTable)this);
        header.setReorderingAllowed(false);
        return header;
    }

    public int getRowHeight() {
        int frozenColumnTableRowHeight;
        int subTableRowHeight = super.getRowHeight();
        if (subTableRowHeight > (frozenColumnTableRowHeight = this.myFrozenColumnTable.getRowHeight())) {
            this.myFrozenColumnTable.setRowHeight(subTableRowHeight);
            return subTableRowHeight;
        }
        return frozenColumnTableRowHeight;
    }

    public void createDefaultColumnsFromModel() {
        if (this.myFrozenColumnTable == null) {
            return;
        }
        this.addColumns(this.removeAllColumns());
    }

    private void addColumns(@NotNull Map<Integer, TableColumn> map2) {
        SubTableModel model2 = (SubTableModel)this.getModel();
        IntStream.range(0, this.dataModel.getColumnCount()).map(model2::convertColumnIndexToDelegate).filter(this.myFrozenColumnTable::includeColumn).map(model2::convertColumnIndexToModel).mapToObj(modelColumnIndex -> this.getOrCreateColumn(map2, modelColumnIndex, model2)).forEach(arg_0 -> this.addColumn(arg_0));
    }

    @NotNull
    private TableColumn getOrCreateColumn(@NotNull Map<Integer, TableColumn> map2, int modelColumnIndex, @NotNull SubTableModel model2) {
        TableColumn column = map2.get(modelColumnIndex);
        if (column == null) {
            column = this.myFrozenColumnTable.createColumn(model2.convertColumnIndexToDelegate(modelColumnIndex));
            column.setModelIndex(modelColumnIndex);
        }
        column.setHeaderValue(null);
        return column;
    }

    @NotNull
    private Map<Integer, TableColumn> removeAllColumns() {
        HashMap map2 = Maps.newHashMapWithExpectedSize((int)this.columnModel.getColumnCount());
        while (this.columnModel.getColumnCount() != 0) {
            TableColumn column = this.columnModel.getColumn(0);
            this.removeColumn(column);
            map2.put(column.getModelIndex(), column);
        }
        return map2;
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        return dataId.equals(PlatformDataKeys.PASTE_PROVIDER.getName()) ? this : null;
    }

    public boolean isPastePossible(@NotNull DataContext dataContext) {
        return this.myFrozenColumnTable.isPastePossible();
    }

    public boolean isPasteEnabled(@NotNull DataContext dataContext) {
        return this.myFrozenColumnTable.isPastePossible();
    }

    public void performPaste(@NotNull DataContext dataContext) {
        Transferable transferable = CopyPasteManager.getInstance().getContents();
        if (transferable == null) {
            return;
        }
        this.myFrozenColumnTable.paste(transferable);
    }

    public String toString() {
        return this.getName();
    }
}

