/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings.table;

import com.android.tools.idea.editors.strings.table.SubTableModel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.jetbrains.annotations.NotNull;

final class SubTableModelListener
implements TableModelListener {
    private final SubTableModel myModel;
    private final TableModelListener myDelegate;

    SubTableModelListener(@NotNull SubTableModel model2, @NotNull TableModelListener delegate) {
        this.myModel = model2;
        this.myDelegate = delegate;
    }

    @NotNull
    TableModelListener delegate() {
        return this.myDelegate;
    }

    @Override
    public void tableChanged(@NotNull TableModelEvent event) {
        int delegateColumnIndex = event.getColumn();
        if (delegateColumnIndex == -1) {
            this.myDelegate.tableChanged(new TableModelEvent(this.myModel, event.getFirstRow(), event.getLastRow(), -1, event.getType()));
            return;
        }
        if (this.myModel.getStartColumnSupplier().getAsInt() > delegateColumnIndex || delegateColumnIndex >= this.myModel.getEndColumnSupplier().getAsInt()) {
            return;
        }
        this.myDelegate.tableChanged(new TableModelEvent(this.myModel, event.getFirstRow(), event.getLastRow(), this.myModel.convertColumnIndexToModel(delegateColumnIndex), event.getType()));
    }
}

