/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme;

import com.android.tools.idea.model.MergedManifestManager;
import com.android.tools.idea.run.activity.ActivityLocatorUtils;
import com.android.tools.idea.run.editor.SpecificActivityConfigurable;
import com.android.tools.idea.run.editor.SpecificActivityLaunch;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;

public class ActivityChooser
extends DialogWrapper {
    private static final int DROPDOWN_LIMIT = 10;
    private final Module myModule;
    private final ComboBox<Element> myActivitySelector;
    private final JComponent myChooserComponent;
    private final SpecificActivityConfigurable myChooser;
    private final JPanel myPanel;

    protected ActivityChooser(@NotNull Module module) {
        super(module.getProject());
        this.myModule = module;
        this.myChooser = new SpecificActivityConfigurable(module.getProject(), () -> module);
        this.setTitle("Select Activity");
        List<Element> activities = MergedManifestManager.getSnapshot(module).getActivities();
        Element[] first10 = (Element[])activities.stream().limit(10L).toArray(Element[]::new);
        this.myActivitySelector = new ComboBox<Element>(new DefaultComboBoxModel<Element>(first10)){

            protected void selectedItemChanged() {
                super.selectedItemChanged();
                if (this.dataModel.getSelectedItem() == null) {
                    this.fireItemStateChanged(new ItemEvent((ItemSelectable)((Object)this), 701, null, 1));
                }
            }
        };
        if (activities.size() > 10) {
            ((DefaultComboBoxModel)this.myActivitySelector.getModel()).addElement(null);
        }
        this.myActivitySelector.setRenderer((ListCellRenderer)new ColoredListCellRenderer<Element>(){

            protected void customizeCellRenderer(@NotNull JList<? extends Element> list, Element value2, int index, boolean selected, boolean hasFocus) {
                if (value2 == null) {
                    this.append("Specify activity name...");
                } else {
                    this.append(value2.getAttributeNS("http://schemas.android.com/apk/res/android", "name"));
                    String label = value2.getAttributeNS("http://schemas.android.com/apk/res/android", "label");
                    if (!StringUtil.isEmpty((String)label)) {
                        this.append(" (" + label + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
                    }
                }
            }
        });
        this.myChooserComponent = this.myChooser.createComponent();
        assert (this.myChooserComponent != null);
        this.myChooserComponent.setVisible(false);
        this.myActivitySelector.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                Element item = (Element)e.getItem();
                this.myChooserComponent.setVisible(item == null);
            }
        });
        this.myPanel = new JPanel(new BorderLayout());
        this.myPanel.add((Component)this.myActivitySelector, "North");
        this.myPanel.add(this.myChooserComponent);
        this.init();
    }

    @NotNull
    public String getActivity() {
        if (this.myChooserComponent.isVisible()) {
            SpecificActivityLaunch.State state = new SpecificActivityLaunch.State();
            this.myChooser.applyTo(state);
            return state.ACTIVITY_CLASS;
        }
        Element item = (Element)this.myActivitySelector.getSelectedItem();
        return item.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
    }

    @NotNull
    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        String activity = this.getActivity();
        Project project = this.myModule.getProject();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        PsiClass activityClass = facade.findClass("android.app.Activity", ProjectScope.getAllScope((Project)project));
        if (activityClass == null) {
            return new ValidationInfo(AndroidBundle.message("cant.find.activity.class.error", new Object[0]));
        }
        PsiClass c = JavaExecutionUtil.findMainClass((Project)project, (String)activity, (GlobalSearchScope)GlobalSearchScope.allScope((Project)project));
        if (c == null || !c.isInheritor(activityClass, true)) {
            return new ValidationInfo(AndroidBundle.message("not.activity.subclass.error", activity));
        }
        Element element = MergedManifestManager.getSnapshot(this.myModule).findActivity(ActivityLocatorUtils.getQualifiedActivityName(c));
        if (element == null) {
            return new ValidationInfo(AndroidBundle.message("activity.not.declared.in.manifest", c.getName()));
        }
        return null;
    }
}

