/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme;

import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.VersionQualifier;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.editors.theme.ThemeEditorContext;
import com.android.tools.idea.editors.theme.ThemeEditorProvider;
import com.android.tools.idea.editors.theme.ThemeEditorUtils;
import com.android.tools.idea.editors.theme.datamodels.ConfiguredThemeEditorStyle;
import com.android.tools.idea.editors.theme.preview.ThemePreviewComponent;
import com.android.tools.idea.editors.theme.qualifiers.RestrictedConfiguration;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.rendering.multi.CompatibilityRenderTarget;
import com.android.tools.idea.res.ResourceHelper;
import com.google.common.collect.Collections2;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import icons.AndroidIcons;
import java.awt.Color;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.uipreview.AndroidEditorSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidThemePreviewToolWindowManager
implements ProjectComponent {
    private static final String TOOL_WINDOW_ID = "Theme Preview";
    private final CaretListener myCaretListener = new MyCaretListener();
    private final DocumentListener myDocumentListener = new MyDocumentListener();
    private final Project myProject;
    private final FileEditorManager myFileEditorManager;
    private volatile ToolWindow myToolWindow;
    private TextEditor myActiveEditor;
    private ThemePreviewComponent myPreviewPanel;
    private ThemeEditorContext myThemeEditorContext;
    private final MergingUpdateQueue myToolWindowUpdateQueue;
    private boolean myIsToolWindowVisible = false;
    private final Update myPreviewUpdate = new Update("ThemePreviewUpdate"){

        public void run() {
            if (!AndroidThemePreviewToolWindowManager.this.myIsToolWindowVisible || AndroidThemePreviewToolWindowManager.this.myActiveEditor == null) {
                return;
            }
            Document document = AndroidThemePreviewToolWindowManager.this.myActiveEditor.getEditor().getDocument();
            int offset = AndroidThemePreviewToolWindowManager.this.myActiveEditor.getEditor().getCaretModel().getOffset();
            AndroidThemePreviewToolWindowManager.this.myThemeEditorContext.updateThemeResolver();
            ConfiguredThemeEditorStyle previewTheme = AndroidThemePreviewToolWindowManager.this.getThemeAtEditorOffset(document, offset);
            if (previewTheme != null) {
                AndroidThemePreviewToolWindowManager.this.myThemeEditorContext.setCurrentTheme(previewTheme);
                Configuration configuration = AndroidThemePreviewToolWindowManager.this.myThemeEditorContext.getConfiguration();
                configuration.setTheme(previewTheme.getStyleResourceUrl());
                ResourceResolver resourceResolver = AndroidThemePreviewToolWindowManager.this.myThemeEditorContext.getResourceResolver();
                assert (resourceResolver != null);
                if (AndroidThemePreviewToolWindowManager.this.myPreviewPanel == null) {
                    ContentManager contentManager = AndroidThemePreviewToolWindowManager.this.myToolWindow.getContentManager();
                    AndroidThemePreviewToolWindowManager.this.myPreviewPanel = new ThemePreviewComponent(AndroidThemePreviewToolWindowManager.this.myThemeEditorContext);
                    Disposer.register((Disposable)AndroidThemePreviewToolWindowManager.this.myProject, (Disposable)AndroidThemePreviewToolWindowManager.this.myPreviewPanel);
                    Content content = contentManager.getFactory().createContent((JComponent)AndroidThemePreviewToolWindowManager.this.myPreviewPanel, null, false);
                    contentManager.addContent(content);
                } else {
                    AndroidThemePreviewToolWindowManager.this.myPreviewPanel.reloadPreviewContents();
                }
                AndroidThemePreviewToolWindowManager.this.myPreviewPanel.setBackground((Color)ThemeEditorUtils.getGoodContrastPreviewBackground(previewTheme, resourceResolver));
                AndroidThemePreviewToolWindowManager.this.myToolWindow.setTitle(String.format("[%1$s]", previewTheme.getName()));
            }
        }
    };

    private AndroidThemePreviewToolWindowManager(@NotNull Project project, @NotNull FileEditorManager filedEditorManager) {
        this.myProject = project;
        this.myFileEditorManager = filedEditorManager;
        MessageBusConnection connection = project.getMessageBus().connect((Disposable)project);
        connection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new MyFileEditorManagerListener());
        this.myToolWindowUpdateQueue = new MergingUpdateQueue("android.style.preview", 150, true, null, (Disposable)project);
        this.myToolWindowUpdateQueue.setRestartTimerOnAdd(true);
        Disposer.register((Disposable)project, (Disposable)this.myToolWindowUpdateQueue);
    }

    public void projectOpened() {
        this.initToolWindow();
        StartupManager.getInstance((Project)this.myProject).registerPostStartupActivity(() -> ApplicationManager.getApplication().invokeLater(this::processFileEditorChange));
    }

    public void projectClosed() {
        this.processFileEditorChange(null);
        this.myPreviewPanel = null;
    }

    private void initToolWindow() {
        this.myToolWindow = ToolWindowManager.getInstance((Project)this.myProject).registerToolWindow(TOOL_WINDOW_ID, false, ToolWindowAnchor.RIGHT, (Disposable)this.myProject, false);
        this.myToolWindow.setIcon(AndroidIcons.ThemesPreview);
        this.myToolWindow.setAvailable(false, null);
        this.myToolWindow.setAutoHide(false);
        this.myProject.getMessageBus().connect().subscribe(ToolWindowManagerListener.TOPIC, (Object)new ToolWindowManagerListener(){

            public void stateChanged() {
                if (AndroidThemePreviewToolWindowManager.this.myProject.isDisposed()) {
                    return;
                }
                ToolWindow window = ToolWindowManager.getInstance((Project)AndroidThemePreviewToolWindowManager.this.myProject).getToolWindow(AndroidThemePreviewToolWindowManager.TOOL_WINDOW_ID);
                if (window != null && window.isAvailable()) {
                    boolean visible = window.isVisible();
                    AndroidEditorSettings.getInstance().getGlobalState().setVisible(visible);
                    if (visible && !AndroidThemePreviewToolWindowManager.this.myIsToolWindowVisible) {
                        AndroidThemePreviewToolWindowManager.this.updatePreview();
                    }
                    AndroidThemePreviewToolWindowManager.this.myIsToolWindowVisible = visible;
                }
            }
        });
    }

    @Nullable
    private static Configuration getBestConfiguration(@Nullable PsiFile psiFile) {
        Module module;
        Module module2 = module = psiFile != null ? ModuleUtilCore.findModuleForPsiElement((PsiElement)psiFile) : null;
        if (module == null) {
            return null;
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet == null) {
            return null;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        ConfigurationManager manager = ConfigurationManager.getOrCreateInstance(module);
        List<VirtualFile> variations = ResourceHelper.getResourceVariations(virtualFile, false);
        if (variations.isEmpty()) {
            return manager.getConfiguration(virtualFile);
        }
        Collection incompatible = Collections2.transform(variations, input -> {
            assert (input != null);
            return ResourceHelper.getFolderConfiguration(input);
        });
        FolderConfiguration selectedFileFolderConfiguration = ResourceHelper.getFolderConfiguration(psiFile);
        if (selectedFileFolderConfiguration == null) {
            return null;
        }
        RestrictedConfiguration restrictedConfiguration = RestrictedConfiguration.restrict(selectedFileFolderConfiguration, incompatible);
        if (restrictedConfiguration == null) {
            return null;
        }
        FolderConfiguration restricted = restrictedConfiguration.getAny();
        Configuration newConfiguration = Configuration.create(manager, virtualFile, null, restricted);
        VersionQualifier newVersionQualifier = restricted.getVersionQualifier();
        if (newVersionQualifier != null) {
            IAndroidTarget realTarget;
            IAndroidTarget iAndroidTarget = realTarget = manager.getHighestApiTarget() != null ? manager.getHighestApiTarget() : manager.getTarget();
            assert (realTarget != null);
            newConfiguration.setTarget(new CompatibilityRenderTarget(realTarget, newVersionQualifier.getVersion(), null));
        }
        return newConfiguration;
    }

    private void processFileEditorChange(@Nullable TextEditor newEditor) {
        if (this.myToolWindow == null) {
            return;
        }
        if (this.myActiveEditor == newEditor) {
            return;
        }
        this.myToolWindowUpdateQueue.cancelAllUpdates();
        if (this.myActiveEditor != null) {
            this.myActiveEditor.getEditor().getCaretModel().removeCaretListener(this.myCaretListener);
            this.myActiveEditor.getEditor().getDocument().removeDocumentListener(this.myDocumentListener);
            this.myActiveEditor = null;
        }
        boolean available = false;
        if (newEditor != null && this.isApplicableEditor(newEditor)) {
            if (DumbService.getInstance((Project)this.myProject).isDumb()) {
                DumbService.getInstance((Project)this.myProject).runWhenSmart(() -> {
                    if (newEditor.isValid()) {
                        this.processFileEditorChange(newEditor);
                    }
                });
                this.myToolWindow.setAvailable(false, null);
                return;
            }
            this.myActiveEditor = newEditor;
            CaretModel caretModel = this.myActiveEditor.getEditor().getCaretModel();
            caretModel.addCaretListener(this.myCaretListener);
            Document document = this.myActiveEditor.getEditor().getDocument();
            document.addDocumentListener(this.myDocumentListener);
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document);
            Configuration configuration = AndroidThemePreviewToolWindowManager.getBestConfiguration(psiFile);
            if (configuration != null) {
                if (this.myThemeEditorContext == null) {
                    this.myThemeEditorContext = new ThemeEditorContext(configuration);
                } else {
                    this.myThemeEditorContext.setConfiguration(configuration);
                }
                if (this.getThemeAtEditorOffset(document, caretModel.getOffset()) != null) {
                    available = true;
                    this.updatePreview();
                }
            }
        }
        this.myToolWindow.setAvailable(available, null);
    }

    private void processFileEditorChange() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        FileEditor[] fileEditors = this.myFileEditorManager.getSelectedEditors();
        if (fileEditors.length > 0 && fileEditors[0] instanceof TextEditor) {
            TextEditor textEditor = (TextEditor)fileEditors[0];
            this.processFileEditorChange(textEditor);
        } else {
            this.processFileEditorChange(null);
        }
    }

    private boolean isApplicableEditor(@NotNull TextEditor editor2) {
        if (!((Boolean)StudioFlags.THEME_EDITOR_ENABLED.get()).booleanValue()) {
            return false;
        }
        Document document = editor2.getEditor().getDocument();
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document);
        return ThemeEditorProvider.isAndroidTheme(psiFile);
    }

    private void updatePreview() {
        this.myToolWindowUpdateQueue.queue(this.myPreviewUpdate);
    }

    @Nullable
    private ConfiguredThemeEditorStyle getThemeAtEditorOffset(@NotNull Document document, int offset) {
        if (offset == -1 || this.myThemeEditorContext == null) {
            return null;
        }
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document);
        if (psiFile == null) {
            return null;
        }
        if (!(psiFile instanceof XmlFile)) {
            return null;
        }
        XmlTag rootTag = ((XmlFile)psiFile).getRootTag();
        if (rootTag == null) {
            return null;
        }
        XmlTag tag = (XmlTag)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)psiFile, (int)offset, XmlTag.class, (boolean)false);
        if (tag == null) {
            return null;
        }
        if (!"style".equals(tag.getLocalName())) {
            tag = tag.getParentTag();
        }
        if (tag != null && "style".equals(tag.getLocalName())) {
            String styleName = tag.getAttributeValue("name");
            return styleName != null ? this.myThemeEditorContext.getThemeResolver().getTheme(styleName) : null;
        }
        return null;
    }

    private class MyDocumentListener
    implements DocumentListener {
        private MyDocumentListener() {
        }

        public void documentChanged(@NotNull DocumentEvent event) {
            AndroidThemePreviewToolWindowManager.this.updatePreview();
        }
    }

    private class MyCaretListener
    implements CaretListener {
        private MyCaretListener() {
        }

        public void caretPositionChanged(@NotNull CaretEvent e) {
            if (e.getCaret() == null) {
                AndroidThemePreviewToolWindowManager.this.myToolWindow.setAvailable(false, null);
                return;
            }
            CaretModel caretModel = e.getCaret().getCaretModel();
            int offset = caretModel.getOffset();
            if (offset == -1) {
                AndroidThemePreviewToolWindowManager.this.myToolWindow.setAvailable(false, null);
                return;
            }
            Document document = e.getEditor().getDocument();
            ConfiguredThemeEditorStyle previewTheme = AndroidThemePreviewToolWindowManager.this.getThemeAtEditorOffset(document, offset);
            AndroidThemePreviewToolWindowManager.this.myToolWindow.setAvailable(previewTheme != null, null);
            if (previewTheme != null && !previewTheme.equals(AndroidThemePreviewToolWindowManager.this.myThemeEditorContext.getCurrentTheme())) {
                AndroidThemePreviewToolWindowManager.this.updatePreview();
            }
        }
    }

    private class MyFileEditorManagerListener
    implements FileEditorManagerListener {
        private MyFileEditorManagerListener() {
        }

        public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
            AndroidThemePreviewToolWindowManager.this.processFileEditorChange();
        }

        public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
            ApplicationManager.getApplication().invokeLater(() -> AndroidThemePreviewToolWindowManager.this.processFileEditorChange(), AndroidThemePreviewToolWindowManager.this.myProject.getDisposed());
        }

        public void selectionChanged(@NotNull FileEditorManagerEvent event) {
            TextEditor textEditor;
            FileEditor newEditor = event.getNewEditor();
            TextEditor applicableTextEditor = null;
            if (newEditor instanceof TextEditor && AndroidThemePreviewToolWindowManager.this.isApplicableEditor(textEditor = (TextEditor)newEditor)) {
                applicableTextEditor = textEditor;
            }
            AndroidThemePreviewToolWindowManager.this.processFileEditorChange(applicableTextEditor);
        }
    }
}

