/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme;

import com.android.tools.idea.editors.theme.AccentSuggestionsUtils;
import com.android.tools.idea.ui.MaterialColors;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.awt.Color;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MaterialColorUtils {
    private static final ImmutableMap<Color, Color> PRIMARY_DARK_COLORS_MAP = ImmutableMap.builder().put((Object)MaterialColors.RED_500, (Object)MaterialColors.RED_700).put((Object)MaterialColors.PINK_500, (Object)MaterialColors.PINK_700).put((Object)MaterialColors.PURPLE_500, (Object)MaterialColors.PURPLE_700).put((Object)MaterialColors.DEEP_PURPLE_500, (Object)MaterialColors.DEEP_PURPLE_700).put((Object)MaterialColors.INDIGO_500, (Object)MaterialColors.INDIGO_700).put((Object)MaterialColors.BLUE_500, (Object)MaterialColors.BLUE_700).put((Object)MaterialColors.LIGHT_BLUE_500, (Object)MaterialColors.LIGHT_BLUE_700).put((Object)MaterialColors.CYAN_500, (Object)MaterialColors.CYAN_700).put((Object)MaterialColors.TEAL_500, (Object)MaterialColors.TEAL_700).put((Object)MaterialColors.GREEN_500, (Object)MaterialColors.GREEN_700).put((Object)MaterialColors.LIGHT_GREEN_500, (Object)MaterialColors.LIGHT_GREEN_700).put((Object)MaterialColors.LIME_500, (Object)MaterialColors.LIME_700).put((Object)MaterialColors.YELLOW_500, (Object)MaterialColors.YELLOW_700).put((Object)MaterialColors.AMBER_500, (Object)MaterialColors.AMBER_700).put((Object)MaterialColors.ORANGE_500, (Object)MaterialColors.ORANGE_700).put((Object)MaterialColors.DEEP_ORANGE_500, (Object)MaterialColors.DEEP_ORANGE_700).put((Object)MaterialColors.BROWN_500, (Object)MaterialColors.BROWN_700).put((Object)MaterialColors.GRAY_500, (Object)MaterialColors.GRAY_700).put((Object)MaterialColors.BLUE_GRAY_500, (Object)MaterialColors.BLUE_GRAY_700).build();
    private static final ImmutableMap<Color, String> MATERIAL_NAMES_MAP = ImmutableMap.builder().put((Object)MaterialColors.RED_50, (Object)"Material Red 50").put((Object)MaterialColors.RED_100, (Object)"Material Red 100").put((Object)MaterialColors.RED_200, (Object)"Material Red 200").put((Object)MaterialColors.RED_300, (Object)"Material Red 300").put((Object)MaterialColors.RED_400, (Object)"Material Red 400").put((Object)MaterialColors.RED_500, (Object)"Material Red 500").put((Object)MaterialColors.RED_600, (Object)"Material Red 600").put((Object)MaterialColors.RED_700, (Object)"Material Red 700").put((Object)MaterialColors.RED_800, (Object)"Material Red 800").put((Object)MaterialColors.RED_900, (Object)"Material Red 900").put((Object)MaterialColors.PINK_50, (Object)"Material Pink 50").put((Object)MaterialColors.PINK_100, (Object)"Material Pink 100").put((Object)MaterialColors.PINK_200, (Object)"Material Pink 200").put((Object)MaterialColors.PINK_300, (Object)"Material Pink 300").put((Object)MaterialColors.PINK_400, (Object)"Material Pink 400").put((Object)MaterialColors.PINK_500, (Object)"Material Pink 500").put((Object)MaterialColors.PINK_600, (Object)"Material Pink 600").put((Object)MaterialColors.PINK_700, (Object)"Material Pink 700").put((Object)MaterialColors.PINK_800, (Object)"Material Pink 800").put((Object)MaterialColors.PINK_900, (Object)"Material Pink 900").put((Object)MaterialColors.PURPLE_50, (Object)"Material Purple 50").put((Object)MaterialColors.PURPLE_100, (Object)"Material Purple 100").put((Object)MaterialColors.PURPLE_200, (Object)"Material Purple 200").put((Object)MaterialColors.PURPLE_300, (Object)"Material Purple 300").put((Object)MaterialColors.PURPLE_400, (Object)"Material Purple 400").put((Object)MaterialColors.PURPLE_500, (Object)"Material Purple 500").put((Object)MaterialColors.PURPLE_600, (Object)"Material Purple 600").put((Object)MaterialColors.PURPLE_700, (Object)"Material Purple 700").put((Object)MaterialColors.PURPLE_800, (Object)"Material Purple 800").put((Object)MaterialColors.PURPLE_900, (Object)"Material Purple 900").put((Object)MaterialColors.DEEP_PURPLE_50, (Object)"Material Deep Purple 50").put((Object)MaterialColors.DEEP_PURPLE_100, (Object)"Material Deep Purple 100").put((Object)MaterialColors.DEEP_PURPLE_200, (Object)"Material Deep Purple 200").put((Object)MaterialColors.DEEP_PURPLE_300, (Object)"Material Deep Purple 300").put((Object)MaterialColors.DEEP_PURPLE_400, (Object)"Material Deep Purple 400").put((Object)MaterialColors.DEEP_PURPLE_500, (Object)"Material Deep Purple 500").put((Object)MaterialColors.DEEP_PURPLE_600, (Object)"Material Deep Purple 600").put((Object)MaterialColors.DEEP_PURPLE_700, (Object)"Material Deep Purple 700").put((Object)MaterialColors.DEEP_PURPLE_800, (Object)"Material Deep Purple 800").put((Object)MaterialColors.DEEP_PURPLE_900, (Object)"Material Deep Purple 900").put((Object)MaterialColors.INDIGO_50, (Object)"Material Indigo 50").put((Object)MaterialColors.INDIGO_100, (Object)"Material Indigo 100").put((Object)MaterialColors.INDIGO_200, (Object)"Material Indigo 200").put((Object)MaterialColors.INDIGO_300, (Object)"Material Indigo 300").put((Object)MaterialColors.INDIGO_400, (Object)"Material Indigo 400").put((Object)MaterialColors.INDIGO_500, (Object)"Material Indigo 500").put((Object)MaterialColors.INDIGO_600, (Object)"Material Indigo 600").put((Object)MaterialColors.INDIGO_700, (Object)"Material Indigo 700").put((Object)MaterialColors.INDIGO_800, (Object)"Material Indigo 800").put((Object)MaterialColors.INDIGO_900, (Object)"Material Indigo 900").put((Object)MaterialColors.BLUE_50, (Object)"Material Blue 50").put((Object)MaterialColors.BLUE_100, (Object)"Material Blue 100").put((Object)MaterialColors.BLUE_200, (Object)"Material Blue 200").put((Object)MaterialColors.BLUE_300, (Object)"Material Blue 300").put((Object)MaterialColors.BLUE_400, (Object)"Material Blue 400").put((Object)MaterialColors.BLUE_500, (Object)"Material Blue 500").put((Object)MaterialColors.BLUE_600, (Object)"Material Blue 600").put((Object)MaterialColors.BLUE_700, (Object)"Material Blue 700").put((Object)MaterialColors.BLUE_800, (Object)"Material Blue 800").put((Object)MaterialColors.BLUE_900, (Object)"Material Blue 900").put((Object)MaterialColors.LIGHT_BLUE_50, (Object)"Material Light Blue 50").put((Object)MaterialColors.LIGHT_BLUE_100, (Object)"Material Light Blue 100").put((Object)MaterialColors.LIGHT_BLUE_200, (Object)"Material Light Blue 200").put((Object)MaterialColors.LIGHT_BLUE_300, (Object)"Material Light Blue 300").put((Object)MaterialColors.LIGHT_BLUE_400, (Object)"Material Light Blue 400").put((Object)MaterialColors.LIGHT_BLUE_500, (Object)"Material Light Blue 500").put((Object)MaterialColors.LIGHT_BLUE_600, (Object)"Material Light Blue 600").put((Object)MaterialColors.LIGHT_BLUE_700, (Object)"Material Light Blue 700").put((Object)MaterialColors.LIGHT_BLUE_800, (Object)"Material Light Blue 800").put((Object)MaterialColors.LIGHT_BLUE_900, (Object)"Material Light Blue 900").put((Object)MaterialColors.CYAN_50, (Object)"Material Cyan 50").put((Object)MaterialColors.CYAN_100, (Object)"Material Cyan 100").put((Object)MaterialColors.CYAN_200, (Object)"Material Cyan 200").put((Object)MaterialColors.CYAN_300, (Object)"Material Cyan 300").put((Object)MaterialColors.CYAN_400, (Object)"Material Cyan 400").put((Object)MaterialColors.CYAN_500, (Object)"Material Cyan 500").put((Object)MaterialColors.CYAN_600, (Object)"Material Cyan 600").put((Object)MaterialColors.CYAN_700, (Object)"Material Cyan 700").put((Object)MaterialColors.CYAN_800, (Object)"Material Cyan 800").put((Object)MaterialColors.CYAN_900, (Object)"Material Cyan 900").put((Object)MaterialColors.TEAL_50, (Object)"Material Teal 50").put((Object)MaterialColors.TEAL_100, (Object)"Material Teal 100").put((Object)MaterialColors.TEAL_200, (Object)"Material Teal 200").put((Object)MaterialColors.TEAL_300, (Object)"Material Teal 300").put((Object)MaterialColors.TEAL_400, (Object)"Material Teal 400").put((Object)MaterialColors.TEAL_500, (Object)"Material Teal 500").put((Object)MaterialColors.TEAL_600, (Object)"Material Teal 600").put((Object)MaterialColors.TEAL_700, (Object)"Material Teal 700").put((Object)MaterialColors.TEAL_800, (Object)"Material Teal 800").put((Object)MaterialColors.TEAL_900, (Object)"Material Teal 900").put((Object)MaterialColors.GREEN_50, (Object)"Material Green 50").put((Object)MaterialColors.GREEN_100, (Object)"Material Green 100").put((Object)MaterialColors.GREEN_200, (Object)"Material Green 200").put((Object)MaterialColors.GREEN_300, (Object)"Material Green 300").put((Object)MaterialColors.GREEN_400, (Object)"Material Green 400").put((Object)MaterialColors.GREEN_500, (Object)"Material Green 500").put((Object)MaterialColors.GREEN_600, (Object)"Material Green 600").put((Object)MaterialColors.GREEN_700, (Object)"Material Green 700").put((Object)MaterialColors.GREEN_800, (Object)"Material Green 800").put((Object)MaterialColors.GREEN_900, (Object)"Material Green 900").put((Object)MaterialColors.LIGHT_GREEN_50, (Object)"Material Light Green 50").put((Object)MaterialColors.LIGHT_GREEN_100, (Object)"Material Light Green 100").put((Object)MaterialColors.LIGHT_GREEN_200, (Object)"Material Light Green 200").put((Object)MaterialColors.LIGHT_GREEN_300, (Object)"Material Light Green 300").put((Object)MaterialColors.LIGHT_GREEN_400, (Object)"Material Light Green 400").put((Object)MaterialColors.LIGHT_GREEN_500, (Object)"Material Light Green 500").put((Object)MaterialColors.LIGHT_GREEN_600, (Object)"Material Light Green 600").put((Object)MaterialColors.LIGHT_GREEN_700, (Object)"Material Light Green 700").put((Object)MaterialColors.LIGHT_GREEN_800, (Object)"Material Light Green 800").put((Object)MaterialColors.LIGHT_GREEN_900, (Object)"Material Light Green 900").put((Object)MaterialColors.LIME_50, (Object)"Material Lime 50").put((Object)MaterialColors.LIME_100, (Object)"Material Lime 100").put((Object)MaterialColors.LIME_200, (Object)"Material Lime 200").put((Object)MaterialColors.LIME_300, (Object)"Material Lime 300").put((Object)MaterialColors.LIME_400, (Object)"Material Lime 400").put((Object)MaterialColors.LIME_500, (Object)"Material Lime 500").put((Object)MaterialColors.LIME_600, (Object)"Material Lime 600").put((Object)MaterialColors.LIME_700, (Object)"Material Lime 700").put((Object)MaterialColors.LIME_800, (Object)"Material Lime 800").put((Object)MaterialColors.LIME_900, (Object)"Material Lime 900").put((Object)MaterialColors.YELLOW_50, (Object)"Material Yellow 50").put((Object)MaterialColors.YELLOW_100, (Object)"Material Yellow 100").put((Object)MaterialColors.YELLOW_200, (Object)"Material Yellow 200").put((Object)MaterialColors.YELLOW_300, (Object)"Material Yellow 300").put((Object)MaterialColors.YELLOW_400, (Object)"Material Yellow 400").put((Object)MaterialColors.YELLOW_500, (Object)"Material Yellow 500").put((Object)MaterialColors.YELLOW_600, (Object)"Material Yellow 600").put((Object)MaterialColors.YELLOW_700, (Object)"Material Yellow 700").put((Object)MaterialColors.YELLOW_800, (Object)"Material Yellow 800").put((Object)MaterialColors.YELLOW_900, (Object)"Material Yellow 900").put((Object)MaterialColors.AMBER_50, (Object)"Material Amber 50").put((Object)MaterialColors.AMBER_100, (Object)"Material Amber 100").put((Object)MaterialColors.AMBER_200, (Object)"Material Amber 200").put((Object)MaterialColors.AMBER_300, (Object)"Material Amber 300").put((Object)MaterialColors.AMBER_400, (Object)"Material Amber 400").put((Object)MaterialColors.AMBER_500, (Object)"Material Amber 500").put((Object)MaterialColors.AMBER_600, (Object)"Material Amber 600").put((Object)MaterialColors.AMBER_700, (Object)"Material Amber 700").put((Object)MaterialColors.AMBER_800, (Object)"Material Amber 800").put((Object)MaterialColors.AMBER_900, (Object)"Material Amber 900").put((Object)MaterialColors.ORANGE_50, (Object)"Material Orange 50").put((Object)MaterialColors.ORANGE_100, (Object)"Material Orange 100").put((Object)MaterialColors.ORANGE_200, (Object)"Material Orange 200").put((Object)MaterialColors.ORANGE_300, (Object)"Material Orange 300").put((Object)MaterialColors.ORANGE_400, (Object)"Material Orange 400").put((Object)MaterialColors.ORANGE_500, (Object)"Material Orange 500").put((Object)MaterialColors.ORANGE_600, (Object)"Material Orange 600").put((Object)MaterialColors.ORANGE_700, (Object)"Material Orange 700").put((Object)MaterialColors.ORANGE_800, (Object)"Material Orange 800").put((Object)MaterialColors.ORANGE_900, (Object)"Material Orange 900").put((Object)MaterialColors.DEEP_ORANGE_50, (Object)"Material Deep Orange 50").put((Object)MaterialColors.DEEP_ORANGE_100, (Object)"Material Deep Orange 100").put((Object)MaterialColors.DEEP_ORANGE_200, (Object)"Material Deep Orange 200").put((Object)MaterialColors.DEEP_ORANGE_300, (Object)"Material Deep Orange 300").put((Object)MaterialColors.DEEP_ORANGE_400, (Object)"Material Deep Orange 400").put((Object)MaterialColors.DEEP_ORANGE_500, (Object)"Material Deep Orange 500").put((Object)MaterialColors.DEEP_ORANGE_600, (Object)"Material Deep Orange 600").put((Object)MaterialColors.DEEP_ORANGE_700, (Object)"Material Deep Orange 700").put((Object)MaterialColors.DEEP_ORANGE_800, (Object)"Material Deep Orange 800").put((Object)MaterialColors.DEEP_ORANGE_900, (Object)"Material Deep Orange 900").put((Object)MaterialColors.BROWN_50, (Object)"Material Brown 50").put((Object)MaterialColors.BROWN_100, (Object)"Material Brown 100").put((Object)MaterialColors.BROWN_200, (Object)"Material Brown 200").put((Object)MaterialColors.BROWN_300, (Object)"Material Brown 300").put((Object)MaterialColors.BROWN_400, (Object)"Material Brown 400").put((Object)MaterialColors.BROWN_500, (Object)"Material Brown 500").put((Object)MaterialColors.BROWN_600, (Object)"Material Brown 600").put((Object)MaterialColors.BROWN_700, (Object)"Material Brown 700").put((Object)MaterialColors.BROWN_800, (Object)"Material Brown 800").put((Object)MaterialColors.BROWN_900, (Object)"Material Brown 900").put((Object)MaterialColors.GRAY_50, (Object)"Material Gray 50").put((Object)MaterialColors.GRAY_100, (Object)"Material Gray 100").put((Object)MaterialColors.GRAY_200, (Object)"Material Gray 200").put((Object)MaterialColors.GRAY_300, (Object)"Material Gray 300").put((Object)MaterialColors.GRAY_400, (Object)"Material Gray 400").put((Object)MaterialColors.GRAY_500, (Object)"Material Gray 500").put((Object)MaterialColors.GRAY_600, (Object)"Material Gray 600").put((Object)MaterialColors.GRAY_700, (Object)"Material Gray 700").put((Object)MaterialColors.GRAY_800, (Object)"Material Gray 800").put((Object)MaterialColors.GRAY_900, (Object)"Material Gray 900").put((Object)MaterialColors.BLUE_GRAY_50, (Object)"Material Blue Gray 50").put((Object)MaterialColors.BLUE_GRAY_100, (Object)"Material Blue Gray 100").put((Object)MaterialColors.BLUE_GRAY_200, (Object)"Material Blue Gray 200").put((Object)MaterialColors.BLUE_GRAY_300, (Object)"Material Blue Gray 300").put((Object)MaterialColors.BLUE_GRAY_400, (Object)"Material Blue Gray 400").put((Object)MaterialColors.BLUE_GRAY_500, (Object)"Material Blue Gray 500").put((Object)MaterialColors.BLUE_GRAY_600, (Object)"Material Blue Gray 600").put((Object)MaterialColors.BLUE_GRAY_700, (Object)"Material Blue Gray 700").put((Object)MaterialColors.BLUE_GRAY_800, (Object)"Material Blue Gray 800").put((Object)MaterialColors.BLUE_GRAY_900, (Object)"Material Blue Gray 900").put((Object)MaterialColors.RED_ACCENT_100, (Object)"Red accent 100").put((Object)MaterialColors.RED_ACCENT_200, (Object)"Red accent 200").put((Object)MaterialColors.RED_ACCENT_400, (Object)"Red accent 400").put((Object)MaterialColors.RED_ACCENT_700, (Object)"Red accent 700").put((Object)MaterialColors.PINK_ACCENT_100, (Object)"Pink accent 100").put((Object)MaterialColors.PINK_ACCENT_200, (Object)"Pink accent 200").put((Object)MaterialColors.PINK_ACCENT_400, (Object)"Pink accent 400").put((Object)MaterialColors.PINK_ACCENT_700, (Object)"Pink accent 700").put((Object)MaterialColors.PURPLE_ACCENT_100, (Object)"Purple accent 100").put((Object)MaterialColors.PURPLE_ACCENT_200, (Object)"Purple accent 200").put((Object)MaterialColors.PURPLE_ACCENT_400, (Object)"Purple accent 400").put((Object)MaterialColors.PURPLE_ACCENT_700, (Object)"Purple accent 700").put((Object)MaterialColors.INDIGO_ACCENT_100, (Object)"Indigo accent 100").put((Object)MaterialColors.INDIGO_ACCENT_200, (Object)"Indigo accent 200").put((Object)MaterialColors.INDIGO_ACCENT_400, (Object)"Indigo accent 400").put((Object)MaterialColors.INDIGO_ACCENT_700, (Object)"Indigo accent 700").put((Object)MaterialColors.DEEP_PURPLE_ACCENT_100, (Object)"Deep purple accent 100").put((Object)MaterialColors.DEEP_PURPLE_ACCENT_200, (Object)"Deep purple accent 200").put((Object)MaterialColors.DEEP_PURPLE_ACCENT_400, (Object)"Deep purple accent 400").put((Object)MaterialColors.DEEP_PURPLE_ACCENT_700, (Object)"Deep purple accent 700").put((Object)MaterialColors.BLUE_ACCENT_100, (Object)"Blue accent 100").put((Object)MaterialColors.BLUE_ACCENT_200, (Object)"Blue accent 200").put((Object)MaterialColors.BLUE_ACCENT_400, (Object)"Blue accent 400").put((Object)MaterialColors.BLUE_ACCENT_700, (Object)"Blue accent 700").put((Object)MaterialColors.LIGHT_BLUE_ACCENT_100, (Object)"Light blue accent 100").put((Object)MaterialColors.LIGHT_BLUE_ACCENT_200, (Object)"Light blue accent 200").put((Object)MaterialColors.LIGHT_BLUE_ACCENT_400, (Object)"Light blue accent 400").put((Object)MaterialColors.LIGHT_BLUE_ACCENT_700, (Object)"Light blue accent 700").put((Object)MaterialColors.CYAN_ACCENT_100, (Object)"Cyan accent 100").put((Object)MaterialColors.CYAN_ACCENT_200, (Object)"Cyan accent 200").put((Object)MaterialColors.CYAN_ACCENT_400, (Object)"Cyan accent 400").put((Object)MaterialColors.CYAN_ACCENT_700, (Object)"Cyan accent 700").put((Object)MaterialColors.TEAL_ACCENT_100, (Object)"Teal accent 100").put((Object)MaterialColors.TEAL_ACCENT_200, (Object)"Teal accent 200").put((Object)MaterialColors.TEAL_ACCENT_400, (Object)"Teal accent 400").put((Object)MaterialColors.TEAL_ACCENT_700, (Object)"Teal accent 700").put((Object)MaterialColors.GREEN_ACCENT_100, (Object)"Green accent 100").put((Object)MaterialColors.GREEN_ACCENT_200, (Object)"Green accent 200").put((Object)MaterialColors.GREEN_ACCENT_400, (Object)"Green accent 400").put((Object)MaterialColors.GREEN_ACCENT_700, (Object)"Green accent 700").put((Object)MaterialColors.LIGHT_GREEN_ACCENT_100, (Object)"Light green accent 100").put((Object)MaterialColors.LIGHT_GREEN_ACCENT_200, (Object)"Light green accent 200").put((Object)MaterialColors.LIGHT_GREEN_ACCENT_400, (Object)"Light green accent 400").put((Object)MaterialColors.LIGHT_GREEN_ACCENT_700, (Object)"Light green accent 700").put((Object)MaterialColors.LIME_ACCENT_100, (Object)"Lime accent 100").put((Object)MaterialColors.LIME_ACCENT_200, (Object)"Lime accent 200").put((Object)MaterialColors.LIME_ACCENT_400, (Object)"Lime accent 400").put((Object)MaterialColors.LIME_ACCENT_700, (Object)"Lime accent 700").put((Object)MaterialColors.YELLOW_ACCENT_100, (Object)"Yellow accent 100").put((Object)MaterialColors.YELLOW_ACCENT_200, (Object)"Yellow accent 200").put((Object)MaterialColors.YELLOW_ACCENT_400, (Object)"Yellow accent 400").put((Object)MaterialColors.YELLOW_ACCENT_700, (Object)"Yellow accent 700").put((Object)MaterialColors.AMBER_ACCENT_100, (Object)"Amber accent 100").put((Object)MaterialColors.AMBER_ACCENT_200, (Object)"Amber accent 200").put((Object)MaterialColors.AMBER_ACCENT_400, (Object)"Amber accent 400").put((Object)MaterialColors.AMBER_ACCENT_700, (Object)"Amber accent 700").put((Object)MaterialColors.ORANGE_ACCENT_100, (Object)"Orange accent 100").put((Object)MaterialColors.ORANGE_ACCENT_200, (Object)"Orange accent 200").put((Object)MaterialColors.ORANGE_ACCENT_400, (Object)"Orange accent 400").put((Object)MaterialColors.ORANGE_ACCENT_700, (Object)"Orange accent 700").put((Object)MaterialColors.DEEP_ORANGE_ACCENT_100, (Object)"Deep orange accent 100").put((Object)MaterialColors.DEEP_ORANGE_ACCENT_200, (Object)"Deep orange accent 200").put((Object)MaterialColors.DEEP_ORANGE_ACCENT_400, (Object)"Deep orange accent 400").put((Object)MaterialColors.DEEP_ORANGE_ACCENT_700, (Object)"Deep orange accent 700").put((Object)Color.BLACK, (Object)"Black").put((Object)Color.WHITE, (Object)"White").build();
    private static final ImmutableList<Color> PRIMARY_COLORS_LIST = ImmutableList.copyOf((Collection)PRIMARY_DARK_COLORS_MAP.keySet());

    @NotNull
    public static List<Color> suggestPrimaryColors() {
        return PRIMARY_COLORS_LIST;
    }

    @NotNull
    public static List<Color> suggestAccentColors(@NotNull Color primaryColor) {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (AccentSuggestionsUtils.isMaterialPrimary(primaryColor)) {
            builder.addAll(AccentSuggestionsUtils.getMonochromaticAccents(primaryColor));
            builder.addAll(AccentSuggestionsUtils.getAssociatedAccents(primaryColor));
            builder.addAll(AccentSuggestionsUtils.getComplementaryAccents(primaryColor));
            builder.addAll(AccentSuggestionsUtils.getTriadAccents(primaryColor));
        } else {
            float[] hsv = Color.RGBtoHSB(primaryColor.getRed(), primaryColor.getGreen(), primaryColor.getBlue(), null);
            hsv[2] = Math.max(0.6f, hsv[2]);
            builder.add((Object)Color.getHSBColor(hsv[0], 0.75f, 1.0f));
            builder.add((Object)Color.getHSBColor(hsv[0], 1.0f, hsv[2]));
            float associatedHue1 = (hsv[0] + 0.125f) % 1.0f;
            builder.add((Object)Color.getHSBColor(associatedHue1, 0.75f, 1.0f));
            builder.add((Object)Color.getHSBColor(associatedHue1, 1.0f, hsv[2]));
            float associatedHue2 = (hsv[0] + 0.875f) % 1.0f;
            builder.add((Object)Color.getHSBColor(associatedHue2, 0.75f, 1.0f));
            builder.add((Object)Color.getHSBColor(associatedHue2, 1.0f, hsv[2]));
            float complementaryHue = (hsv[0] + 0.5f) % 1.0f;
            builder.add((Object)Color.getHSBColor(complementaryHue, 0.75f, 1.0f));
            builder.add((Object)Color.getHSBColor(complementaryHue, 1.0f, hsv[2]));
            float triadHue1 = (hsv[0] + 0.625f) % 1.0f;
            builder.add((Object)Color.getHSBColor(triadHue1, 0.75f, 1.0f));
            builder.add((Object)Color.getHSBColor(triadHue1, 1.0f, hsv[2]));
            float triadHue2 = (hsv[0] + 0.375f) % 1.0f;
            builder.add((Object)Color.getHSBColor(triadHue2, 0.75f, 1.0f));
            builder.add((Object)Color.getHSBColor(triadHue2, 1.0f, hsv[2]));
        }
        return builder.build();
    }

    @NotNull
    public static List<Color> suggestPrimaryDarkColors(@NotNull Color primaryColor) {
        Color suggestedColor = (Color)PRIMARY_DARK_COLORS_MAP.get((Object)primaryColor);
        if (suggestedColor == null) {
            suggestedColor = primaryColor.darker();
        }
        return ImmutableList.of((Object)suggestedColor);
    }

    @Nullable
    public static String getMaterialName(@NotNull Color color) {
        return (String)MATERIAL_NAMES_MAP.get((Object)color);
    }

    @NotNull
    public static Color getClosestMaterialColor(@NotNull Color color) {
        String name = (String)MATERIAL_NAMES_MAP.get((Object)color);
        if (name == null) {
            float minDistance = Float.MAX_VALUE;
            Color minDistanceColor = null;
            for (Color materialColor : MATERIAL_NAMES_MAP.keySet()) {
                float distance = MaterialColorUtils.colorDistance(color, materialColor);
                if (!(distance < minDistance)) continue;
                minDistance = distance;
                minDistanceColor = materialColor;
            }
            return minDistanceColor;
        }
        return color;
    }

    public static float colorDistance(Color c1, Color c2) {
        double rmean = (double)(c1.getRed() + c2.getRed()) / 2.0;
        int r = c1.getRed() - c2.getRed();
        int g = c1.getGreen() - c2.getGreen();
        int b = c1.getBlue() - c2.getBlue();
        double weightR = 2.0 + rmean / 256.0;
        double weightG = 4.0;
        double weightB = 2.0 + (255.0 - rmean) / 256.0;
        return (float)Math.sqrt(weightR * (double)r * (double)r + weightG * (double)g * (double)g + weightB * (double)b * (double)b);
    }
}

