/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme;

import java.util.List;

public class SeparatedList {
    private final Object mySeparator;
    private final Group[] myLists;

    public SeparatedList(Object separator, Group ... lists) {
        this.mySeparator = separator;
        this.myLists = lists;
    }

    public int size() {
        int result2 = 0;
        for (Group list : this.myLists) {
            if (list.size() == 0) continue;
            result2 += (result2 == 0 ? 0 : 1) + list.size();
        }
        return result2;
    }

    public Object get(int index) {
        int offset = 0;
        for (Group list : this.myLists) {
            if (list.size() == 0) continue;
            if (index == offset && offset > 0) {
                return this.mySeparator;
            }
            if (offset > 0) {
                ++offset;
            }
            if (index < offset + list.size()) {
                return list.get(index - offset);
            }
            offset += list.size();
        }
        throw new IndexOutOfBoundsException();
    }

    public static Group group(Object ... objects) {
        return new Group(objects);
    }

    public static class Group {
        private final Object[] myContents;

        Group(Object[] contents) {
            this.myContents = contents;
        }

        int size() {
            int result2 = 0;
            for (Object object : this.myContents) {
                if (object instanceof List) {
                    result2 += ((List)object).size();
                    continue;
                }
                ++result2;
            }
            return result2;
        }

        Object get(int index) {
            int offset = 0;
            for (Object object : this.myContents) {
                if (object instanceof List) {
                    List list = (List)object;
                    if (index < offset + list.size()) {
                        return list.get(index - offset);
                    }
                    offset += list.size();
                    continue;
                }
                if (index == offset) {
                    return object;
                }
                ++offset;
            }
            throw new IndexOutOfBoundsException();
        }
    }
}

