/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme;

import com.android.tools.idea.editors.theme.ThemeEditorComponent;
import com.android.tools.idea.editors.theme.ThemeEditorState;
import com.android.tools.idea.editors.theme.ThemeEditorVirtualFile;
import com.android.tools.idea.editors.theme.datamodels.ConfiguredThemeEditorStyle;
import com.android.tools.idea.editors.theme.datamodels.ThemeEditorStyle;
import com.intellij.ProjectTopics;
import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThemeEditor
extends UserDataHolderBase
implements FileEditor {
    private final ThemeEditorVirtualFile myVirtualFile;
    private final ThemeEditorComponent myComponent;

    public ThemeEditor(@NotNull Project project, @NotNull VirtualFile file) {
        this.myVirtualFile = (ThemeEditorVirtualFile)file;
        this.myComponent = new ThemeEditorComponent(project);
        Disposer.register((Disposable)this, (Disposable)this.myComponent);
        project.getMessageBus().connect((Disposable)this).subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ThemeEditorStyle theme = null;
                        ThemeEditorStyle subStyle = null;
                        if (!ThemeEditor.this.myComponent.getSelectedModule().isDisposed()) {
                            if (ModuleRootManager.getInstance((Module)ThemeEditor.this.myComponent.getSelectedModule()).getSdk() == null) {
                                return;
                            }
                            theme = ThemeEditor.this.myComponent.getSelectedTheme();
                            subStyle = ThemeEditor.this.myComponent.getCurrentSubStyle();
                        }
                        ThemeEditor.this.myComponent.reload(theme == null ? null : theme.getQualifiedName(), subStyle == null ? null : subStyle.getQualifiedName());
                    }
                });
            }
        });
    }

    @NotNull
    public JComponent getComponent() {
        return this.myComponent;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return null;
    }

    @NotNull
    public String getName() {
        return "Theme Editor";
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel fileEditorStateLevel) {
        ConfiguredThemeEditorStyle theme = this.myComponent.getSelectedTheme();
        ConfiguredThemeEditorStyle subStyle = this.myComponent.getCurrentSubStyle();
        return new ThemeEditorState(theme == null ? null : theme.getQualifiedName(), subStyle == null ? null : subStyle.getQualifiedName(), Float.valueOf(this.myComponent.getProportion()), this.myComponent.getSelectedModule().getName());
    }

    public void setState(@NotNull FileEditorState fileEditorState) {
        if (!(fileEditorState instanceof ThemeEditorState)) {
            return;
        }
        ThemeEditorState state = (ThemeEditorState)fileEditorState;
        this.myComponent.reload(state.getThemeName(), state.getSubStyleName(), state.getModuleName());
        this.myComponent.setProportion(state.getProportion());
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return this.myVirtualFile.isValid();
    }

    public void selectNotify() {
        this.myComponent.selectNotify();
    }

    public void deselectNotify() {
        this.myComponent.deselectNotify();
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener propertyChangeListener) {
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener propertyChangeListener) {
    }

    @Nullable
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    @Nullable
    public StructureViewBuilder getStructureViewBuilder() {
        return null;
    }

    @NotNull
    public ThemeEditorVirtualFile getVirtualFile() {
        return this.myVirtualFile;
    }

    public void dispose() {
    }
}

