/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme;

import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.editors.theme.ThemeEditorProvider;
import com.android.tools.idea.editors.theme.ThemeEditorUtils;
import com.android.tools.idea.flags.StudioFlags;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThemeEditorNotificationProvider
extends EditorNotifications.Provider<InfoPanel> {
    private static final Key<InfoPanel> KEY = Key.create((String)"android.editors.theme");
    @NotNull
    private final Project myProject;
    private boolean myDismissed = false;

    public ThemeEditorNotificationProvider(@NotNull Project project) {
        this.myProject = project;
    }

    @NotNull
    public Key<InfoPanel> getKey() {
        return KEY;
    }

    @Nullable
    public InfoPanel createNotificationPanel(@NotNull VirtualFile file, @NotNull FileEditor fileEditor) {
        if (!((Boolean)StudioFlags.THEME_EDITOR_ENABLED.get()).booleanValue()) {
            return null;
        }
        if (this.myDismissed) {
            return null;
        }
        PsiFile psiFile = AndroidPsiUtils.getPsiFileSafely(this.myProject, file);
        if (!ThemeEditorProvider.isAndroidTheme(psiFile)) {
            return null;
        }
        if (!ThemeEditorUtils.findAndroidModules(this.myProject).findAny().isPresent()) {
            return null;
        }
        final InfoPanel panel2 = new InfoPanel();
        panel2.setText("Edit all themes in the project in the theme editor.");
        panel2.createActionLabel("Open editor", new Runnable(){

            @Override
            public void run() {
                ThemeEditorUtils.openThemeEditor(ThemeEditorNotificationProvider.this.myProject);
            }
        });
        panel2.createActionLabel("Hide notification", new Runnable(){

            @Override
            public void run() {
                panel2.setVisible(false);
                ThemeEditorNotificationProvider.this.myDismissed = true;
            }
        });
        return panel2;
    }

    public static class InfoPanel
    extends EditorNotificationPanel {
        public Color getBackground() {
            Color color = EditorColorsManager.getInstance().getGlobalScheme().getColor(EditorColors.READONLY_BACKGROUND_COLOR);
            return color == null ? UIUtil.getPanelBackground() : color;
        }
    }
}

