/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme;

import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceResolver;
import com.android.tools.idea.editors.theme.ResourcesCompletionProvider;
import com.android.tools.idea.editors.theme.ThemeEditorComponent;
import com.android.tools.idea.editors.theme.ThemeEditorContext;
import com.android.tools.idea.editors.theme.attributes.AttributesTableModel;
import com.android.tools.idea.editors.theme.attributes.ShowJavadocAction;
import com.android.tools.idea.editors.theme.attributes.TableLabel;
import com.android.tools.idea.editors.theme.attributes.editors.AttributeReferenceRendererEditor;
import com.android.tools.idea.editors.theme.attributes.editors.BooleanRendererEditor;
import com.android.tools.idea.editors.theme.attributes.editors.ColorRendererEditor;
import com.android.tools.idea.editors.theme.attributes.editors.DelegatingCellEditor;
import com.android.tools.idea.editors.theme.attributes.editors.DelegatingCellRenderer;
import com.android.tools.idea.editors.theme.attributes.editors.DrawableRendererEditor;
import com.android.tools.idea.editors.theme.attributes.editors.EnumRendererEditor;
import com.android.tools.idea.editors.theme.attributes.editors.FlagRendererEditor;
import com.android.tools.idea.editors.theme.attributes.editors.IntegerRenderer;
import com.android.tools.idea.editors.theme.attributes.editors.ParentRendererEditor;
import com.android.tools.idea.editors.theme.datamodels.ConfiguredThemeEditorStyle;
import com.android.tools.idea.editors.theme.datamodels.EditedStyleItem;
import com.android.tools.idea.editors.theme.preview.AndroidThemePreviewPanel;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ColorUIResource;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jetbrains.android.dom.drawable.DrawableDomElement;
import org.jetbrains.android.dom.resources.Flag;
import org.jetbrains.annotations.NotNull;
import spantable.CellSpanModel;
import spantable.CellSpanTable;

public class ThemeEditorTable
extends CellSpanTable {
    private Map<Class<?>, Integer> myClassHeights;
    private ShowJavadocAction myJavadocAction;
    private ThemeEditorComponent.GoToListener myGoToListener;
    private ThemeEditorContext myContext;
    private static final String GO_TO_DECLARATION = "Go To Declaration";

    public ThemeEditorTable() {
        this.putClientProperty("terminateEditOnFocusLost", true);
        this.setAutoCreateColumnsFromModel(false);
        for (int c = 0; c < 2; ++c) {
            this.addColumn(new TableColumn(c));
        }
    }

    public int convertRowIndexToModel(int viewRowIndex) {
        if (viewRowIndex < 0) {
            viewRowIndex = 0;
        }
        return super.convertRowIndexToModel(viewRowIndex);
    }

    public void setGoToListener(@NotNull ThemeEditorComponent.GoToListener goToListener) {
        this.myGoToListener = goToListener;
    }

    public void customizeTable(@NotNull ThemeEditorContext context, @NotNull AndroidThemePreviewPanel previewPanel, @NotNull ParentRendererEditor.ThemeParentChangedListener themeParentChangedListener) {
        this.myContext = context;
        this.myJavadocAction = new ShowJavadocAction((JTable)((Object)this), this.myContext);
        this.setRenderersAndEditors(previewPanel, themeParentChangedListener);
    }

    public JPopupMenu getComponentPopupMenu() {
        Point point = MouseInfo.getPointerInfo().getLocation();
        SwingUtilities.convertPointFromScreen(point, (Component)((Object)this));
        return this.getPopupMenuAtCell(this.rowAtPoint(point), this.columnAtPoint(point));
    }

    public void setRowSorter(RowSorter<? extends TableModel> sorter) {
        super.setRowSorter(sorter);
        this.updateRowHeights();
    }

    public void updateRowHeights() {
        TableModel rawModel = this.getModel();
        if (!(rawModel instanceof CellSpanModel)) {
            return;
        }
        CellSpanModel myModel = (CellSpanModel)rawModel;
        int defaultRowHeight = this.myClassHeights.get(Object.class);
        this.setRowHeight(defaultRowHeight);
        for (int row = 0; row < myModel.getRowCount(); ++row) {
            int viewRow;
            int maxRowHeight = -1;
            for (int col = 0; col < myModel.getColumnCount(); col += myModel.getColumnSpan(row, col)) {
                Class cellClass = myModel.getCellClass(row, col);
                Integer rowHeight = this.myClassHeights.get(cellClass);
                if (rowHeight == null) continue;
                maxRowHeight = Math.max(maxRowHeight, rowHeight);
            }
            if (maxRowHeight == -1 || (viewRow = this.convertRowIndexToView(row)) == -1) continue;
            this.setRowHeight(viewRow, maxRowHeight);
        }
    }

    public void setClassHeights(Map<Class<?>, Integer> classHeights) {
        this.myClassHeights = classHeights;
        this.updateRowHeights();
    }

    private void setRenderersAndEditors(@NotNull AndroidThemePreviewPanel previewPanel, @NotNull ParentRendererEditor.ThemeParentChangedListener themeParentChangedListener) {
        Project project = this.myContext.getProject();
        ResourcesCompletionProvider completionProvider2 = new ResourcesCompletionProvider(this.myContext);
        AttributeReferenceRendererEditor styleEditor = new AttributeReferenceRendererEditor(project, completionProvider2);
        this.setDefaultRenderer(Color.class, new DelegatingCellRenderer(new ColorRendererEditor(this.myContext, previewPanel, false)));
        this.setDefaultRenderer(EditedStyleItem.class, new DelegatingCellRenderer(new AttributeReferenceRendererEditor(project, completionProvider2)));
        this.setDefaultRenderer(ConfiguredThemeEditorStyle.class, new DelegatingCellRenderer(new AttributeReferenceRendererEditor(project, completionProvider2)));
        this.setDefaultRenderer(String.class, new DelegatingCellRenderer(this.getDefaultRenderer(String.class)));
        this.setDefaultRenderer(Integer.class, new DelegatingCellRenderer(new IntegerRenderer()));
        this.setDefaultRenderer(Boolean.class, new DelegatingCellRenderer(new BooleanRendererEditor(this.myContext)));
        this.setDefaultRenderer(Enum.class, new DelegatingCellRenderer(new EnumRendererEditor()));
        this.setDefaultRenderer(Flag.class, new DelegatingCellRenderer(new FlagRendererEditor()));
        this.setDefaultRenderer(AttributesTableModel.ParentAttribute.class, new DelegatingCellRenderer(new ParentRendererEditor(this.myContext, themeParentChangedListener)));
        this.setDefaultRenderer(DrawableDomElement.class, new DelegatingCellRenderer(new DrawableRendererEditor(this.myContext, previewPanel, false)));
        this.setDefaultRenderer(TableLabel.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table2, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table2, value2, isSelected, hasFocus, row, column);
                Font regularFont = UIUtil.getLabelFont();
                int regularFontSize = this.getFontMetrics(regularFont).getHeight();
                Font headerFont = regularFont.deriveFont((float)regularFontSize * 1.3f);
                this.setFont(headerFont);
                return this;
            }
        });
        this.setDefaultEditor(Color.class, new DelegatingCellEditor(false, (TableCellEditor)((Object)new ColorRendererEditor(this.myContext, previewPanel, true))));
        this.setDefaultEditor(EditedStyleItem.class, new DelegatingCellEditor(false, (TableCellEditor)((Object)new AttributeReferenceRendererEditor(project, completionProvider2))));
        this.setDefaultEditor(String.class, new DelegatingCellEditor(false, this.getDefaultEditor(String.class)));
        this.setDefaultEditor(Integer.class, new DelegatingCellEditor(this.getDefaultEditor(Integer.class)));
        this.setDefaultEditor(Boolean.class, new DelegatingCellEditor(false, (TableCellEditor)((Object)new BooleanRendererEditor(this.myContext))));
        this.setDefaultEditor(Enum.class, new DelegatingCellEditor(false, (TableCellEditor)((Object)new EnumRendererEditor())));
        this.setDefaultEditor(Flag.class, new DelegatingCellEditor(false, (TableCellEditor)((Object)new FlagRendererEditor())));
        this.setDefaultEditor(AttributesTableModel.ParentAttribute.class, new DelegatingCellEditor(false, (TableCellEditor)((Object)new ParentRendererEditor(this.myContext, themeParentChangedListener))));
        this.setDefaultEditor(ConfiguredThemeEditorStyle.class, new DelegatingCellEditor(false, (TableCellEditor)((Object)styleEditor)));
        this.setDefaultEditor(DrawableDomElement.class, new DelegatingCellEditor(false, (TableCellEditor)((Object)new DrawableRendererEditor(this.myContext, previewPanel, true))));
    }

    private JPopupMenu getPopupMenuAtCell(int row, int column) {
        if (row < 0 || column < 0) {
            return null;
        }
        TableModel rawModel = this.getModel();
        if (!(rawModel instanceof AttributesTableModel)) {
            return null;
        }
        final AttributesTableModel model2 = (AttributesTableModel)rawModel;
        AttributesTableModel.RowContents contents = model2.getRowContents(this.convertRowIndexToModel(row));
        if (contents instanceof AttributesTableModel.AttributeContents) {
            final AttributesTableModel.AttributeContents attribute = (AttributesTableModel.AttributeContents)contents;
            final EditedStyleItem item = attribute.getValue();
            if (item == null) {
                return null;
            }
            JBPopupMenu popupMenu = new JBPopupMenu();
            if (attribute.getCellClass(1) == ConfiguredThemeEditorStyle.class) {
                popupMenu.add((Action)new AbstractAction(GO_TO_DECLARATION){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ThemeEditorTable.this.myGoToListener.goTo(item);
                    }
                });
            } else {
                VirtualFile virtualFile;
                ResourceResolver resolver = this.myContext.getResourceResolver();
                assert (resolver != null);
                final Project project = this.myContext.getProject();
                ResourceValue resourceValue2 = resolver.resolveResValue((ResourceValue)item.getSelectedValue());
                File file = new File(resourceValue2.getValue());
                VirtualFileManager manager = VirtualFileManager.getInstance();
                VirtualFile virtualFile2 = virtualFile = file.exists() ? manager.findFileByUrl("file://" + file.getAbsolutePath()) : null;
                if (virtualFile != null) {
                    popupMenu.add((Action)new AbstractAction(GO_TO_DECLARATION){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            OpenFileDescriptor descriptor2 = new OpenFileDescriptor(project, virtualFile);
                            FileEditorManager.getInstance((Project)project).openEditor(descriptor2, true);
                        }
                    });
                }
            }
            this.myJavadocAction.setCurrentItem(item);
            popupMenu.add((Action)this.myJavadocAction);
            final ConfiguredThemeEditorStyle selectedStyle = model2.getSelectedStyle();
            if (!selectedStyle.isReadOnly() && selectedStyle.hasItem(item)) {
                popupMenu.add((Action)new AbstractAction("Reset value"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        selectedStyle.removeAttribute(item.getQualifiedName());
                        model2.fireTableCellUpdated(attribute.getRowIndex(), 0);
                    }
                });
            }
            return popupMenu;
        }
        if (contents instanceof AttributesTableModel.ParentAttribute) {
            ConfiguredThemeEditorStyle parentStyle = model2.getSelectedStyle().getParent();
            if (parentStyle == null) {
                return null;
            }
            JBPopupMenu menu = new JBPopupMenu();
            menu.add((Action)new AbstractAction(GO_TO_DECLARATION){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ThemeEditorTable.this.myGoToListener.goToParent();
                }
            });
            return menu;
        }
        return null;
    }

    public void setBackground(Color color) {
        if (color instanceof ColorUIResource) {
            color = null;
        }
        super.setBackground(color);
    }
}

