/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme;

import com.android.builder.model.SourceProvider;
import com.android.ide.common.blame.SourceFilePosition;
import com.android.ide.common.blame.SourcePosition;
import com.android.ide.common.rendering.api.AttributeFormat;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.StyleItemResourceValue;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.VersionQualifier;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.AndroidTextUtils;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.configurations.ResourceResolverCache;
import com.android.tools.idea.configurations.ThemeSelectionPanel;
import com.android.tools.idea.editors.manifest.ManifestUtils;
import com.android.tools.idea.editors.theme.ActivityChooser;
import com.android.tools.idea.editors.theme.MaterialColorUtils;
import com.android.tools.idea.editors.theme.NewStyleDialog;
import com.android.tools.idea.editors.theme.ResolutionUtils;
import com.android.tools.idea.editors.theme.ThemeEditor;
import com.android.tools.idea.editors.theme.ThemeEditorComponent;
import com.android.tools.idea.editors.theme.ThemeEditorContext;
import com.android.tools.idea.editors.theme.ThemeEditorVirtualFile;
import com.android.tools.idea.editors.theme.ThemeResolver;
import com.android.tools.idea.editors.theme.datamodels.ConfiguredThemeEditorStyle;
import com.android.tools.idea.editors.theme.datamodels.EditedStyleItem;
import com.android.tools.idea.editors.theme.datamodels.ThemeEditorStyle;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.javadoc.AndroidJavaDocRenderer;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceFolderRegistry;
import com.android.tools.idea.res.ResourceFolderRepository;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.idea.ui.resourcechooser.ChooseResourceDialog;
import com.android.utils.ImmutableCollectors;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.JBColor;
import com.intellij.util.Processor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JComponent;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.resources.ResourceElement;
import org.jetbrains.android.dom.resources.Style;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.android.intentions.OverrideResourceAction;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThemeEditorUtils {
    private static final Logger LOG = Logger.getInstance(ThemeEditorUtils.class);
    private static final Cache<String, String> ourTooltipCache = CacheBuilder.newBuilder().weakValues().maximumSize(30L).build();
    private static final String[] CUSTOM_WIDGETS_JAR_PATHS = new String[]{"/plugins/android/lib/androidWidgets/theme-editor-widgets.jar", "/../adt/idea/android/lib/androidWidgets/theme-editor-widgets.jar", "/community/android/android/lib/androidWidgets/theme-editor-widgets.jar", "/android/android/lib/androidWidgets/theme-editor-widgets.jar"};

    private ThemeEditorUtils() {
    }

    @NotNull
    public static String generateToolTipText(@NotNull StyleItemResourceValue resValue, @NotNull Module module, @NotNull Configuration configuration) {
        LocalResourceRepository repository = ResourceRepositoryManager.getAppResources(module);
        if (repository == null) {
            return "";
        }
        String tooltipKey = resValue.toString() + module.toString() + configuration.toString() + repository.getModificationCount();
        String cachedTooltip = (String)ourTooltipCache.getIfPresent((Object)tooltipKey);
        if (cachedTooltip != null) {
            return cachedTooltip;
        }
        ResourceUrl url = ResourceUrl.parse((String)ResolutionUtils.getResourceUrlFromQualifiedName(ResolutionUtils.getQualifiedItemAttrName(resValue), "attr"));
        assert (url != null);
        String tooltipContents = AndroidJavaDocRenderer.render(module, configuration, url);
        assert (tooltipContents != null);
        ourTooltipCache.put((Object)tooltipKey, (Object)tooltipContents);
        return tooltipContents;
    }

    @NotNull
    public static String getDisplayHtml(EditedStyleItem item) {
        return item.isDeprecated() ? "<html><body><strike>" + item.getQualifiedName() + "</strike></body></html>" : item.getQualifiedName();
    }

    public static boolean isThemeEditorSelected(@NotNull Project project) {
        for (FileEditor editor2 : FileEditorManager.getInstance((Project)project).getSelectedEditors()) {
            if (!(editor2 instanceof ThemeEditor)) continue;
            return true;
        }
        return false;
    }

    public static void openThemeEditor(@NotNull Project project) {
        ApplicationManager.getApplication().invokeLater(() -> {
            ThemeEditorVirtualFile file = ThemeEditorVirtualFile.getThemeEditorFile(project);
            OpenFileDescriptor descriptor2 = new OpenFileDescriptor(project, (VirtualFile)file);
            FileEditorManager.getInstance((Project)project).openEditor(descriptor2, true);
        });
    }

    @Nullable
    public static StyleItemResourceValue resolveItemFromParents(@NotNull ConfiguredThemeEditorStyle theme, @NotNull String name, boolean isFrameworkAttr) {
        ConfiguredThemeEditorStyle currentTheme = theme;
        for (int i2 = 0; i2 < 50 && currentTheme != null; currentTheme = currentTheme.getParent(), ++i2) {
            StyleItemResourceValue item = currentTheme.getItem(name, isFrameworkAttr);
            if (item == null) continue;
            return item;
        }
        return null;
    }

    @NotNull
    public static Object extractRealValue(@NotNull EditedStyleItem item, @NotNull Class<?> desiredClass) {
        String value2 = item.getValue();
        if (desiredClass == Boolean.class && ("true".equals(value2) || "false".equals(value2))) {
            return Boolean.valueOf(value2);
        }
        if (desiredClass == Integer.class) {
            try {
                return Integer.parseInt(value2);
            }
            catch (NumberFormatException e) {
                return value2;
            }
        }
        return value2;
    }

    public static boolean acceptsFormat(@Nullable AttributeDefinition attrDefByName, @NotNull AttributeFormat want) {
        if (attrDefByName == null) {
            return false;
        }
        return attrDefByName.getFormats().contains(want);
    }

    @NotNull
    private static ImmutableList<ConfiguredThemeEditorStyle> findThemes(@NotNull Collection<ConfiguredThemeEditorStyle> themes, @NotNull ThemeResolver themeResolver) {
        List<ResourceReference> recommendedThemes = themeResolver.getRecommendedThemes();
        Map candidates = themes.stream().collect(Collectors.toMap(ThemeEditorStyle::getStyleReference, Function.identity()));
        return (ImmutableList)recommendedThemes.stream().map(ref -> (ConfiguredThemeEditorStyle)candidates.get(ref)).filter(theme -> theme != null).collect(ImmutableCollectors.toImmutableList());
    }

    @NotNull
    public static Stream<Module> findAndroidModules(@NotNull Project project) {
        ModuleManager manager = ModuleManager.getInstance((Project)project);
        return Arrays.stream(manager.getModules()).filter(module -> AndroidFacet.getInstance(module) != null);
    }

    @NotNull
    public static ImmutableList<String> getDefaultThemeNames(@NotNull ThemeResolver themeResolver) {
        ImmutableList<ConfiguredThemeEditorStyle> readOnlyFrameworkThemes = themeResolver.getFrameworkThemes();
        ImmutableList<ConfiguredThemeEditorStyle> readOnlyLibThemes = themeResolver.getExternalLibraryThemes();
        ImmutableList readOnlyLibAndFrameworkThemes = (ImmutableList)Stream.concat(readOnlyFrameworkThemes.stream(), readOnlyLibThemes.stream()).collect(ImmutableCollectors.toImmutableList());
        ImmutableList<ConfiguredThemeEditorStyle> foundThemes = ThemeEditorUtils.findThemes((Collection<ConfiguredThemeEditorStyle>)readOnlyLibAndFrameworkThemes, themeResolver);
        if (!foundThemes.isEmpty()) {
            return (ImmutableList)foundThemes.stream().map(ThemeEditorStyle::getQualifiedName).collect(ImmutableCollectors.toImmutableList());
        }
        return (ImmutableList)readOnlyFrameworkThemes.stream().map(ThemeEditorStyle::getQualifiedName).sorted(String.CASE_INSENSITIVE_ORDER).collect(ImmutableCollectors.toImmutableList());
    }

    public static int getMinApiLevel(@NotNull Module module) {
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet == null) {
            return 1;
        }
        AndroidModuleInfo moduleInfo = AndroidModuleInfo.getInstance(facet);
        return moduleInfo.getMinSdkVersion().getApiLevel();
    }

    @Nullable
    public static URL getCustomWidgetsJarUrl() {
        String homePath = FileUtil.toSystemIndependentName((String)PathManager.getHomePath());
        StringBuilder notFoundPaths = new StringBuilder();
        for (String path : CUSTOM_WIDGETS_JAR_PATHS) {
            String jarPath = homePath + path;
            VirtualFile root = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)jarPath));
            if (root != null) {
                File rootFile = VfsUtilCore.virtualToIoFile((VirtualFile)root);
                if (!rootFile.exists()) continue;
                try {
                    LOG.debug("Theme editor custom widgets found at " + jarPath);
                    return rootFile.toURI().toURL();
                }
                catch (MalformedURLException e) {
                    LOG.error((Throwable)e);
                    continue;
                }
            }
            notFoundPaths.append(jarPath).append('\n');
        }
        LOG.error("Unable to find theme-editor-widgets.jar in paths:\n" + notFoundPaths.toString());
        return null;
    }

    public static boolean createNewStyle(final @NotNull Project project, final @NotNull VirtualFile resourceDir, final @NotNull String newStyleName, final @Nullable String parentStyleName, final @NotNull String fileName, final @NotNull List<String> folderNames) {
        return (Boolean)new WriteCommandAction<Boolean>(project, "Create new style " + newStyleName, new PsiFile[0]){

            protected void run(@NotNull Result<Boolean> result2) {
                CommandProcessor.getInstance().addAffectedFiles(project, new VirtualFile[]{ThemeEditorVirtualFile.getThemeEditorFile(project)});
                result2.setResult((Object)AndroidResourceUtil.createValueResource(project, resourceDir, newStyleName, null, ResourceType.STYLE, fileName, folderNames, (Processor<ResourceElement>)((Processor)element -> {
                    assert (element instanceof Style);
                    Style style = (Style)element;
                    if (parentStyleName != null) {
                        style.getParentStyle().setStringValue(parentStyleName);
                    }
                    return true;
                })));
            }
        }.execute().getResultObject();
    }

    @Nullable
    public static String showCreateNewStyleDialog(@Nullable ConfiguredThemeEditorStyle defaultParentStyle, @NotNull ThemeEditorContext themeEditorContext, boolean isTheme, boolean enableParentChoice, @Nullable String message2, @Nullable ThemeSelectionPanel.ThemeChangedListener themeChangedListener) {
        boolean createStyle;
        String defaultParentStyleName = null;
        if (isTheme && defaultParentStyle == null) {
            ImmutableList<String> defaultThemes = ThemeEditorUtils.getDefaultThemeNames(themeEditorContext.getThemeResolver());
            defaultParentStyleName = !defaultThemes.isEmpty() ? (String)defaultThemes.get(0) : null;
        } else if (defaultParentStyle != null) {
            defaultParentStyleName = defaultParentStyle.getQualifiedName();
        }
        NewStyleDialog dialog2 = new NewStyleDialog(isTheme, themeEditorContext, defaultParentStyleName, defaultParentStyle == null ? null : defaultParentStyle.getName(), message2);
        dialog2.enableParentChoice(enableParentChoice);
        if (themeChangedListener != null) {
            dialog2.setThemeChangedListener(themeChangedListener);
        }
        if (!(createStyle = dialog2.showAndGet())) {
            return null;
        }
        int minModuleApi = ThemeEditorUtils.getMinApiLevel(themeEditorContext.getCurrentContextModule());
        int minAcceptableApi = ResolutionUtils.getOriginalApiLevel(ResolutionUtils.getStyleResourceUrl(dialog2.getStyleParentName()), themeEditorContext.getProject());
        String fileName = AndroidResourceUtil.getDefaultResourceFileName(ResourceType.STYLE);
        FolderConfiguration config = new FolderConfiguration();
        if (minModuleApi < minAcceptableApi) {
            VersionQualifier qualifier = new VersionQualifier(minAcceptableApi);
            config.setVersionQualifier(qualifier);
        }
        if (fileName == null) {
            LOG.error("Couldn't find a default filename for ResourceType.STYLE");
            return null;
        }
        List<String> dirNames = Collections.singletonList(config.getFolderName(ResourceFolderType.VALUES));
        String parentStyleName = dialog2.getStyleParentName();
        Module module = themeEditorContext.getCurrentContextModule();
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet == null) {
            LOG.error("Create new style for non-Android module " + module.getName());
            return null;
        }
        Project project = module.getProject();
        VirtualFile resourceDir = ResourceFolderManager.getInstance(facet).getPrimaryFolder();
        if (resourceDir == null) {
            AndroidUtils.reportError(project, AndroidBundle.message("check.resource.dir.error", module.getName()));
            return null;
        }
        boolean isCreated = ThemeEditorUtils.createNewStyle(project, resourceDir, dialog2.getStyleName(), parentStyleName, fileName, dirNames);
        return isCreated ? dialog2.getStyleName() : null;
    }

    public static boolean isSelectedAppCompatTheme(@NotNull ThemeEditorContext context) {
        ConfiguredThemeEditorStyle currentTheme = context.getCurrentTheme();
        return currentTheme != null && ThemeEditorUtils.isAppCompatTheme(currentTheme);
    }

    public static boolean isAppCompatTheme(@NotNull ConfiguredThemeEditorStyle configuredThemeEditorStyle) {
        ConfiguredThemeEditorStyle currentTheme = configuredThemeEditorStyle;
        for (int i2 = 0; i2 < 50 && currentTheme != null; currentTheme = currentTheme.getParent(), ++i2) {
            if (!currentTheme.getName().startsWith("Theme.AppCompat") || currentTheme.getSourceModule() != null) continue;
            return true;
        }
        return false;
    }

    public static void copyTheme(int apiLevel, @NotNull XmlTag toBeCopied) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        PsiFile file = toBeCopied.getContainingFile();
        assert (file instanceof XmlFile) : file;
        ResourceFolderType folderType = ResourceHelper.getFolderType(file);
        assert (folderType != null) : file;
        FolderConfiguration config = ResourceHelper.getFolderConfiguration(file);
        assert (config != null) : file;
        VersionQualifier qualifier = new VersionQualifier(apiLevel);
        config.setVersionQualifier(qualifier);
        String folder = config.getFolderName(folderType);
        if (folderType != ResourceFolderType.VALUES) {
            OverrideResourceAction.forkResourceFile((XmlFile)file, folder, false);
        } else {
            XmlTag tag = OverrideResourceAction.getValueTag((XmlTag)PsiTreeUtil.getParentOfType((PsiElement)toBeCopied, XmlTag.class, (boolean)false));
            if (tag != null) {
                PsiDirectory dir = null;
                PsiDirectory resFolder = file.getParent();
                if (resFolder != null) {
                    resFolder = resFolder.getParent();
                }
                if (resFolder != null && (dir = resFolder.findSubdirectory(folder)) == null) {
                    dir = resFolder.createSubdirectory(folder);
                }
                OverrideResourceAction.forkResourceValue(toBeCopied.getProject(), tag, file, dir, false);
            }
        }
    }

    public static int getVersionFromConfiguration(@NotNull FolderConfiguration configuration) {
        VersionQualifier qualifier = configuration.getVersionQualifier();
        return qualifier != null ? qualifier.getVersion() : -1;
    }

    public static int getMinFolderApi(@NotNull List<String> folderNames, @NotNull Module module) {
        int minFolderApi = Integer.MAX_VALUE;
        int minModuleApi = ThemeEditorUtils.getMinApiLevel(module);
        for (String folderName : folderNames) {
            FolderConfiguration folderConfig = FolderConfiguration.getConfigForFolder((String)folderName);
            if (folderConfig == null) continue;
            VersionQualifier version2 = folderConfig.getVersionQualifier();
            int folderApi = version2 != null ? version2.getVersion() : minModuleApi;
            minFolderApi = Math.min(minFolderApi, folderApi);
        }
        return minFolderApi;
    }

    @NotNull
    public static Configuration getConfigurationForModule(@NotNull Module module) {
        Project project = module.getProject();
        AndroidFacet facet = AndroidFacet.getInstance(module);
        assert (facet != null) : "moduleComboModel must contain only Android modules";
        ConfigurationManager configurationManager = ConfigurationManager.getOrCreateInstance(module);
        VirtualFile projectFile = project.getProjectFile();
        assert (projectFile != null);
        return configurationManager.getConfiguration(projectFile);
    }

    @NotNull
    public static List<ResourceFolderRepository> getResourceFolderRepositoriesFromSourceSet(@NotNull AndroidFacet facet, @Nullable SourceProvider provider) {
        if (provider == null) {
            return Collections.emptyList();
        }
        Collection resDirectories = provider.getResDirectories();
        LocalFileSystem fileSystem = LocalFileSystem.getInstance();
        ArrayList folders = Lists.newArrayListWithExpectedSize((int)resDirectories.size());
        for (File dir : resDirectories) {
            VirtualFile virtualFile = fileSystem.findFileByIoFile(dir);
            if (virtualFile == null) continue;
            folders.add(ResourceFolderRegistry.getInstance(facet.getModule().getProject()).get(facet, virtualFile));
        }
        return folders;
    }

    public static JBColor getGoodContrastPreviewBackground(@NotNull ConfiguredThemeEditorStyle theme, @NotNull ResourceResolver resourceResolver) {
        float backgroundDistance;
        String colorBackgroundValue;
        Color colorBackground;
        StyleItemResourceValue themeColorBackgroundItem = ThemeEditorUtils.resolveItemFromParents(theme, "colorBackground", true);
        ResourceValue backgroundResourceValue = resourceResolver.resolveResValue((ResourceValue)themeColorBackgroundItem);
        if (backgroundResourceValue != null && (colorBackground = ResourceHelper.parseColor(colorBackgroundValue = backgroundResourceValue.getValue())) != null && (backgroundDistance = MaterialColorUtils.colorDistance(colorBackground, (Color)ThemeEditorComponent.PREVIEW_BACKGROUND)) < 8.5f && backgroundDistance < MaterialColorUtils.colorDistance(colorBackground, (Color)ThemeEditorComponent.ALT_PREVIEW_BACKGROUND)) {
            return ThemeEditorComponent.ALT_PREVIEW_BACKGROUND;
        }
        return ThemeEditorComponent.PREVIEW_BACKGROUND;
    }

    public static void acceptResourceResolverVisitor(@NotNull AndroidFacet mainFacet, @NotNull ResourceFolderVisitor visitor) {
        List dependencies = Lists.reverse(AndroidUtils.getAllAndroidDependencies(mainFacet.getModule(), true));
        for (AndroidFacet dependency : Iterables.concat((Iterable)dependencies, (Iterable)ImmutableList.of((Object)((Object)mainFacet)))) {
            AndroidModuleModel androidModel = AndroidModuleModel.get(dependency);
            if (androidModel == null) {
                SourceProvider provider = dependency.getMainSourceProvider();
                for (LocalResourceRepository localResourceRepository : ThemeEditorUtils.getResourceFolderRepositoriesFromSourceSet(dependency, provider)) {
                    visitor.visitResourceFolder(localResourceRepository, dependency.getName(), provider.getName(), true);
                }
                continue;
            }
            List<SourceProvider> activeProviders = androidModel.getActiveSourceProviders();
            for (SourceProvider sourceProvider : activeProviders) {
                for (LocalResourceRepository localResourceRepository : ThemeEditorUtils.getResourceFolderRepositoriesFromSourceSet(dependency, sourceProvider)) {
                    visitor.visitResourceFolder(localResourceRepository, dependency.getName(), sourceProvider.getName(), true);
                }
            }
            ImmutableSet selectedProviders = ImmutableSet.copyOf(activeProviders);
            for (SourceProvider provider : androidModel.getAllSourceProviders()) {
                if (selectedProviders.contains((Object)provider)) continue;
                for (LocalResourceRepository localResourceRepository : ThemeEditorUtils.getResourceFolderRepositoriesFromSourceSet(dependency, provider)) {
                    visitor.visitResourceFolder(localResourceRepository, dependency.getName(), provider.getName(), false);
                }
            }
        }
    }

    @NotNull
    public static ImmutableList<String> getModuleThemeQualifiedNamesList(@NotNull Module module) {
        AndroidFacet facet = AndroidFacet.getInstance(module);
        assert (facet != null);
        ConfigurationManager manager = ConfigurationManager.getOrCreateInstance(module);
        ResourceResolverCache resolverCache = new ResourceResolverCache(manager);
        IAndroidTarget target = manager.getTarget();
        HashMap cache2 = new HashMap();
        TreeSet themeNamesSet = Sets.newTreeSet((Comparator)String.CASE_INSENSITIVE_ORDER);
        ResourceFolderVisitor visitor = (resources, moduleName, variantName, isSelected) -> {
            if (!isSelected) {
                return;
            }
            block0: for (String simpleThemeName : resources.getResources(ResourceNamespace.TODO(), ResourceType.STYLE).keySet()) {
                String themeStyleResourceUrl = "@style/" + simpleThemeName;
                List<ResourceItem> themeItems = resources.getResources(ResourceNamespace.TODO(), ResourceType.STYLE, simpleThemeName);
                for (ResourceItem themeItem : themeItems) {
                    ResourceResolver resolver = resolverCache.getResourceResolver(target, themeStyleResourceUrl, themeItem.getConfiguration());
                    ResourceValue themeItemResourceValue = themeItem.getResourceValue();
                    assert (themeItemResourceValue != null);
                    if (!resolver.isTheme(themeItemResourceValue, cache2)) continue;
                    themeNamesSet.add(simpleThemeName);
                    continue block0;
                }
            }
        };
        ThemeEditorUtils.acceptResourceResolverVisitor(facet, visitor);
        return ImmutableList.copyOf((Collection)themeNamesSet);
    }

    @NotNull
    public static ChooseResourceDialog getResourceDialog(@NotNull EditedStyleItem item, @NotNull ThemeEditorContext context, @NotNull EnumSet<ResourceType> allowedTypes) {
        ResourceUrl url;
        Module module = context.getModuleForResources();
        StyleItemResourceValue itemSelectedValue = item.getSelectedValue();
        String value2 = itemSelectedValue.getValue();
        boolean isFrameworkValue = itemSelectedValue.isFramework();
        String nameSuggestion = value2;
        ResourceUrl resourceUrl = url = value2 != null ? ResourceUrl.parse((String)value2, (boolean)isFrameworkValue) : null;
        if (url != null) {
            nameSuggestion = url.name;
        }
        nameSuggestion = nameSuggestion != null ? ThemeEditorUtils.getDefaultResourceName(context, nameSuggestion) : null;
        ChooseResourceDialog.ResourceNameVisibility resourceNameVisibility = ChooseResourceDialog.ResourceNameVisibility.FORCE;
        if (StringUtil.startsWithChar((CharSequence)nameSuggestion, (char)'#')) {
            nameSuggestion = null;
            resourceNameVisibility = ChooseResourceDialog.ResourceNameVisibility.SHOW;
        }
        ChooseResourceDialog dialog2 = ChooseResourceDialog.builder().setModule(module).setTypes(allowedTypes).setCurrentValue(value2).setIsFrameworkValue(isFrameworkValue).setResourceNameVisibility(resourceNameVisibility).setResourceNameSuggestion(nameSuggestion).build();
        dialog2.setUseGlobalUndo();
        dialog2.setTitle("Select Resource for " + item.getQualifiedName());
        return dialog2;
    }

    @NotNull
    private static String getDefaultResourceName(@NotNull ThemeEditorContext context, @NotNull String initialName) {
        if (context.getCurrentTheme() == null || !context.getCurrentTheme().isReadOnly()) {
            return initialName;
        }
        ResourceResolver resolver = context.getResourceResolver();
        assert (resolver != null);
        ResourceValue value2 = resolver.findResValue("@color/" + initialName, false);
        if (value2 == null) {
            return initialName;
        }
        for (int i2 = 1; i2 <= 50; ++i2) {
            String name = initialName + "_" + i2;
            if (resolver.findResValue("@color/" + name, false) != null) continue;
            return name;
        }
        return "";
    }

    @NotNull
    public static String simplifyThemeName(@NotNull ConfiguredThemeEditorStyle theme) {
        String name = theme.getQualifiedName();
        String[] pieces = name.split("\\.");
        String result2 = pieces.length > 1 && !"Light".equals(pieces[1]) ? pieces[1] : "Theme";
        for (ConfiguredThemeEditorStyle parent = theme; parent != null; parent = parent.getParent()) {
            if (!"Theme.Light".equals(parent.getName())) continue;
            return result2 + " Light";
        }
        return result2 + " Dark";
    }

    @NotNull
    public static String generateWordEnumeration(@NotNull Collection<String> words) {
        return AndroidTextUtils.generateCommaSeparatedList(words, (String)"and");
    }

    @NotNull
    public static Font scaleFontForAttribute(@NotNull Font font) {
        return font.deriveFont((float)Math.ceil((float)font.getSize() * 0.9f));
    }

    public static void setInheritsPopupMenuRecursive(JComponent comp) {
        comp.setInheritsPopupMenu(true);
        for (Component child : comp.getComponents()) {
            if (!(child instanceof JComponent)) continue;
            ThemeEditorUtils.setInheritsPopupMenuRecursive((JComponent)child);
        }
    }

    public static void quickfixThemeToActivity(@NotNull Module module, final @NotNull String themeUrl) {
        ActivityChooser chooser2 = new ActivityChooser(module);
        if (chooser2.showAndGet()) {
            String activity = chooser2.getActivity();
            final SourceFilePosition sourceFilePosition = ManifestUtils.getSourceFilePosition(module, activity);
            if (sourceFilePosition == null) {
                Messages.showErrorDialog((Project)module.getProject(), (String)"Not a Project Activity", (String)"Set Theme Error");
                return;
            }
            File ioFile = sourceFilePosition.getFile().getSourceFile();
            assert (ioFile != null);
            VirtualFile file = LocalFileSystem.getInstance().findFileByIoFile(ioFile);
            assert (file != null);
            final XmlFile psiFile = (XmlFile)PsiManager.getInstance((Project)module.getProject()).findFile(file);
            assert (psiFile != null);
            new WriteCommandAction.Simple(module.getProject(), "Set Theme for Activity", new PsiFile[]{psiFile}){

                protected void run() throws Throwable {
                    SourcePosition sourcePosition = sourceFilePosition.getPosition();
                    XmlTag activityTag = ThemeEditorUtils.getXmlTag(psiFile, sourcePosition.getStartLine(), sourcePosition.getStartColumn());
                    assert (activityTag != null);
                    activityTag.setAttribute("theme", "http://schemas.android.com/apk/res/android", themeUrl);
                }
            }.execute();
        }
    }

    @Nullable
    public static XmlTag getXmlTag(@NotNull XmlFile file, int line, int col) {
        XmlElement element = ThemeEditorUtils.getXmlElement(file, line, col);
        return element instanceof XmlTag ? (XmlTag)element : null;
    }

    @Nullable
    public static XmlElement getXmlElement(@NotNull XmlFile file, int line, int col) {
        if (line < 0 || col < 0) {
            throw new IllegalArgumentException();
        }
        Document doc = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument((PsiFile)file);
        assert (doc != null);
        int offset = doc.getLineStartOffset(line) + col;
        PsiElement psiElement = file.findElementAt(offset);
        PsiElement parent = psiElement == null ? null : psiElement.getParent();
        return parent instanceof XmlElement ? (XmlElement)parent : null;
    }

    public static interface ResourceFolderVisitor {
        public void visitResourceFolder(@NotNull LocalResourceRepository var1, String var2, @NotNull String var3, boolean var4);
    }
}

