/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme;

import com.android.tools.idea.editors.AndroidFakeFileSystem;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.ex.FakeFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.testFramework.LightVirtualFile;
import icons.StudioIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThemeEditorVirtualFile
extends LightVirtualFile {
    public static final String FILENAME = "Theme Editor";
    private static final Key<ThemeEditorVirtualFile> KEY = Key.create((String)ThemeEditorVirtualFile.class.getName());
    private static final Key<Boolean> CACHE_LOOKUP_KEY = Key.create((String)"cache_lookup_key");
    private VirtualFile myParent;
    private final String myPath;

    private ThemeEditorVirtualFile(@NotNull Project project) {
        super(FILENAME);
        this.myPath = AndroidFakeFileSystem.constructPathForFile(FILENAME, project);
    }

    @NotNull
    public static ThemeEditorVirtualFile getThemeEditorFile(@NotNull Project project) {
        ThemeEditorVirtualFile vFile = (ThemeEditorVirtualFile)((Object)project.getUserData(KEY));
        if (vFile == null) {
            vFile = ThemeEditorVirtualFile.getThemeEditorVirtualFileFromCache(project);
            if (vFile == null) {
                vFile = new ThemeEditorVirtualFile(project);
            }
            vFile.myParent = project.getBaseDir();
            project.putUserData(KEY, (Object)vFile);
        }
        return vFile;
    }

    @Nullable
    private static ThemeEditorVirtualFile getThemeEditorVirtualFileFromCache(@NotNull Project project) {
        if (project.getUserData(CACHE_LOOKUP_KEY) == null) {
            project.putUserData(CACHE_LOOKUP_KEY, (Object)true);
            String url = AndroidFakeFileSystem.INSTANCE.getProtocol() + "://" + AndroidFakeFileSystem.constructPathForFile(FILENAME, project);
            VirtualFilePointer pointer = VirtualFilePointerManager.getInstance().create(url, (Disposable)project, null);
            return (ThemeEditorVirtualFile)pointer.getFile();
        }
        return null;
    }

    @Nullable
    public VirtualFile getParent() {
        return this.myParent;
    }

    @NotNull
    public FileType getFileType() {
        return ThemeEditorFileType.INSTANCE;
    }

    @NotNull
    public VirtualFileSystem getFileSystem() {
        return AndroidFakeFileSystem.INSTANCE;
    }

    @NotNull
    public String getPath() {
        return this.myPath;
    }

    private static class ThemeEditorFileType
    extends FakeFileType {
        public static final ThemeEditorFileType INSTANCE = new ThemeEditorFileType();

        private ThemeEditorFileType() {
        }

        public boolean isMyFileType(@NotNull VirtualFile file) {
            return file.getFileType() instanceof ThemeEditorFileType;
        }

        @NotNull
        public String getName() {
            return "";
        }

        @NotNull
        public String getDescription() {
            return "";
        }

        public Icon getIcon() {
            return StudioIcons.Shell.Menu.THEME_EDITOR;
        }

        public boolean isBinary() {
            return false;
        }
    }
}

