/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.attributes;

import com.android.ide.common.rendering.api.AttributeFormat;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceResolver;
import com.android.resources.ResourceType;
import com.android.tools.idea.editors.theme.ResolutionUtils;
import com.android.tools.idea.editors.theme.ThemeAttributeResolver;
import com.android.tools.idea.editors.theme.ThemeEditorComponent;
import com.android.tools.idea.editors.theme.ThemeEditorContext;
import com.android.tools.idea.editors.theme.ThemeEditorUtils;
import com.android.tools.idea.editors.theme.attributes.AttributesGrouper;
import com.android.tools.idea.editors.theme.attributes.TableLabel;
import com.android.tools.idea.editors.theme.datamodels.ConfiguredThemeEditorStyle;
import com.android.tools.idea.editors.theme.datamodels.EditedStyleItem;
import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.swing.table.AbstractTableModel;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.drawable.DrawableDomElement;
import org.jetbrains.android.dom.resources.Flag;
import org.jetbrains.annotations.NotNull;
import spantable.CellSpanModel;

public class AttributesTableModel
extends AbstractTableModel
implements CellSpanModel {
    private static final Logger LOG = Logger.getInstance(AttributesTableModel.class);
    public static final int COL_COUNT = 2;
    private static final Set<Class<?>> WIDE_CLASSES = ImmutableSet.of(Color.class, DrawableDomElement.class);
    protected final List<EditedStyleItem> myAttributes;
    private List<TableLabel> myLabels;
    protected final ConfiguredThemeEditorStyle mySelectedStyle;
    private final AttributesGrouper.GroupBy myGroupBy;
    private final ThemeEditorContext myContext;
    private final List<ThemePropertyChangedListener> myThemePropertyChangedListeners = new ArrayList<ThemePropertyChangedListener>();
    private final ParentAttribute myParentAttribute = new ParentAttribute();

    public void addThemePropertyChangedListener(ThemePropertyChangedListener listener2) {
        this.myThemePropertyChangedListeners.add(listener2);
    }

    public ImmutableSet<String> getDefinedAttributes() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (EditedStyleItem item : this.myAttributes) {
            builder.add((Object)item.getQualifiedName());
        }
        return builder.build();
    }

    public AttributesTableModel(@NotNull ConfiguredThemeEditorStyle selectedStyle, @NotNull AttributesGrouper.GroupBy groupBy, @NotNull ThemeEditorContext context) {
        this.myContext = context;
        this.myAttributes = new ArrayList<EditedStyleItem>();
        this.myLabels = new ArrayList<TableLabel>();
        this.mySelectedStyle = selectedStyle;
        this.myGroupBy = groupBy;
        this.reloadContent();
    }

    private void reloadContent() {
        List<EditedStyleItem> rawAttributes = ThemeAttributeResolver.resolveAll(this.mySelectedStyle, this.myContext.getConfiguration().getConfigurationManager());
        Collections.sort(rawAttributes, ThemeEditorComponent.SIMPLE_MODE_COMPARATOR);
        this.myAttributes.clear();
        this.myLabels = AttributesGrouper.generateLabels(this.myGroupBy, rawAttributes, this.myAttributes);
        this.fireTableStructureChanged();
    }

    @NotNull
    public RowContents getRowContents(int rowIndex) {
        if (rowIndex == 0) {
            return this.myParentAttribute;
        }
        int offset = 1;
        for (TableLabel label : this.myLabels) {
            int labelRowIndex = label.getRowPosition() + offset;
            if (labelRowIndex < rowIndex) {
                ++offset;
                continue;
            }
            if (labelRowIndex == rowIndex) {
                return new LabelContents(label);
            }
            return new AttributeContents(rowIndex - offset);
        }
        return new AttributeContents(rowIndex - offset);
    }

    public boolean isThemeParentRow(int row) {
        return row == 0;
    }

    @Override
    public int getRowCount() {
        return this.myAttributes.size() + this.myLabels.size() + 1;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.getRowContents(rowIndex).getValue();
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.getRowContents(rowIndex).setValueAt(columnIndex, (String)aValue);
    }

    public int getColumnSpan(int row, int column) {
        return this.getRowContents(row).getColumnSpan(column);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.getRowContents(rowIndex).isCellEditable(columnIndex);
    }

    public int getRowSpan(int row, int column) {
        return 1;
    }

    public Class<?> getCellClass(int row, int column) {
        return this.getRowContents(row).getCellClass(column);
    }

    @NotNull
    public ConfiguredThemeEditorStyle getSelectedStyle() {
        return this.mySelectedStyle;
    }

    public class AttributeContents
    implements RowContents<EditedStyleItem> {
        private final int myRowIndex;

        public AttributeContents(int rowIndex) {
            this.myRowIndex = rowIndex;
        }

        public int getRowIndex() {
            return this.myRowIndex;
        }

        @Override
        public int getColumnSpan(int column) {
            if (WIDE_CLASSES.contains(this.getCellClass(column))) {
                return column == 0 ? AttributesTableModel.this.getColumnCount() : 0;
            }
            return 1;
        }

        @Override
        public EditedStyleItem getValue() {
            return AttributesTableModel.this.myAttributes.get(this.myRowIndex);
        }

        @Override
        public Class<?> getCellClass(int column) {
            if (AttributesTableModel.this.myContext.getCurrentContextModule().isDisposed()) {
                return null;
            }
            ResourceResolver resolver = AttributesTableModel.this.myContext.getResourceResolver();
            if (resolver == null) {
                LOG.error("Unable to get resource resolver");
                return null;
            }
            EditedStyleItem item = AttributesTableModel.this.myAttributes.get(this.myRowIndex);
            ResourceValue resourceValue2 = resolver.resolveResValue((ResourceValue)item.getSelectedValue());
            if (resourceValue2 == null) {
                LOG.error("Unable to resolve " + item.getValue());
                return null;
            }
            ResourceType urlType = resourceValue2.getResourceType();
            if (urlType == ResourceType.DRAWABLE) {
                return DrawableDomElement.class;
            }
            AttributeDefinition attrDefinition = ResolutionUtils.getAttributeDefinition(AttributesTableModel.this.myContext.getConfiguration(), item.getSelectedValue());
            String attributeName = item.getAttrName().toLowerCase(Locale.US);
            if (urlType == ResourceType.COLOR || ThemeEditorUtils.acceptsFormat(attrDefinition, AttributeFormat.COLOR) || attributeName.contains("color")) {
                return Color.class;
            }
            if (ThemeEditorUtils.acceptsFormat(attrDefinition, AttributeFormat.REFERENCE) && attributeName.contains("background") && !attributeName.contains("style")) {
                return DrawableDomElement.class;
            }
            if (urlType == ResourceType.STYLE) {
                return ConfiguredThemeEditorStyle.class;
            }
            if (ThemeEditorUtils.acceptsFormat(attrDefinition, AttributeFormat.FLAGS)) {
                return Flag.class;
            }
            if (ThemeEditorUtils.acceptsFormat(attrDefinition, AttributeFormat.ENUM)) {
                return Enum.class;
            }
            if (urlType == ResourceType.INTEGER || ThemeEditorUtils.acceptsFormat(attrDefinition, AttributeFormat.INTEGER)) {
                return Integer.class;
            }
            String value2 = resourceValue2.getValue();
            if (urlType == ResourceType.BOOL || ("true".equals(value2) || "false".equals(value2)) && ThemeEditorUtils.acceptsFormat(attrDefinition, AttributeFormat.BOOLEAN)) {
                return Boolean.class;
            }
            return EditedStyleItem.class;
        }

        @Override
        public boolean isCellEditable(int column) {
            EditedStyleItem item = AttributesTableModel.this.myAttributes.get(this.myRowIndex);
            return (WIDE_CLASSES.contains(this.getCellClass(column)) || column == 1) && item.isPublicAttribute();
        }

        @Override
        public void setValueAt(int column, String value2) {
            if (value2 == null) {
                return;
            }
            if (AttributesTableModel.this.mySelectedStyle.isReadOnly()) {
                for (ThemePropertyChangedListener listener2 : AttributesTableModel.this.myThemePropertyChangedListeners) {
                    listener2.attributeChangedOnReadOnlyTheme(this.getValue(), value2);
                }
                return;
            }
            if (this.setAttributeValue(value2)) {
                AttributesTableModel.this.fireTableCellUpdated(this.myRowIndex, column);
            }
        }

        private boolean setAttributeValue(@NotNull String strValue) {
            EditedStyleItem rv = AttributesTableModel.this.myAttributes.get(this.myRowIndex);
            if (strValue.equals(rv.getValue())) {
                return false;
            }
            String propertyName = rv.getQualifiedName();
            AttributesTableModel.this.mySelectedStyle.setValue(propertyName, strValue);
            return true;
        }
    }

    public class LabelContents
    implements RowContents<TableLabel> {
        private final TableLabel myLabel;

        private LabelContents(TableLabel label) {
            this.myLabel = label;
        }

        @Override
        public int getColumnSpan(int column) {
            return column == 0 ? AttributesTableModel.this.getColumnCount() : 0;
        }

        @Override
        public TableLabel getValue() {
            return this.myLabel;
        }

        @Override
        public Class<?> getCellClass(int column) {
            return TableLabel.class;
        }

        @Override
        public boolean isCellEditable(int column) {
            return false;
        }

        @Override
        public void setValueAt(int column, String value2) {
            throw new RuntimeException(String.format("Tried to setValue at immutable label row of LabelledModel, column = %1$d", column));
        }
    }

    public class ParentAttribute
    implements RowContents<Object> {
        @Override
        public int getColumnSpan(int column) {
            return column == 0 ? AttributesTableModel.this.getColumnCount() : 0;
        }

        @Override
        public Object getValue() {
            return AttributesTableModel.this.mySelectedStyle;
        }

        @Override
        public void setValueAt(int column, String newName2) {
            ConfiguredThemeEditorStyle parent = AttributesTableModel.this.mySelectedStyle.getParent();
            if (parent == null || !parent.getQualifiedName().equals(newName2)) {
                AttributesTableModel.this.mySelectedStyle.setParent(newName2);
                AttributesTableModel.this.fireTableCellUpdated(0, 0);
            }
        }

        @Override
        public Class<?> getCellClass(int column) {
            return ParentAttribute.class;
        }

        @Override
        public boolean isCellEditable(int column) {
            return !AttributesTableModel.this.mySelectedStyle.isReadOnly();
        }
    }

    public static interface RowContents<T> {
        public int getColumnSpan(int var1);

        public T getValue();

        public void setValueAt(int var1, String var2);

        public Class<?> getCellClass(int var1);

        public boolean isCellEditable(int var1);
    }

    public static interface ThemePropertyChangedListener {
        public void attributeChangedOnReadOnlyTheme(EditedStyleItem var1, String var2);
    }
}

