/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.attributes;

import com.android.tools.idea.editors.theme.ThemeEditorContext;
import com.android.tools.idea.editors.theme.ThemeEditorUtils;
import com.android.tools.idea.editors.theme.datamodels.EditedStyleItem;
import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.ui.awt.RelativePoint;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JTable;
import org.jetbrains.annotations.NotNull;

public class ShowJavadocAction
extends AbstractAction {
    private static final Point ORIGIN = new Point(0, 0);
    protected final JTable myAttributesTable;
    private final ThemeEditorContext myContext;
    private EditedStyleItem myCurrentItem;

    public ShowJavadocAction(@NotNull JTable attributesTable, @NotNull ThemeEditorContext context) {
        super("Show documentation");
        this.myAttributesTable = attributesTable;
        this.myContext = context;
    }

    public void setCurrentItem(EditedStyleItem currentItem) {
        this.myCurrentItem = currentItem;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        EditedStyleItem item = this.myCurrentItem;
        if (item == null) {
            return;
        }
        Project project = this.myContext.getProject();
        DocumentationManager documentationManager = DocumentationManager.getInstance((Project)project);
        final DocumentationComponent docComponent = new DocumentationComponent(documentationManager);
        String tooltip = ThemeEditorUtils.generateToolTipText(item.getSelectedValue(), this.myContext.getCurrentContextModule(), this.myContext.getConfiguration());
        docComponent.setText(tooltip, (PsiElement)new FakePsiElement(){

            public boolean isValid() {
                return true;
            }

            @NotNull
            public Project getProject() {
                return ShowJavadocAction.this.myContext.getProject();
            }

            public PsiElement getParent() {
                return null;
            }

            public PsiFile getContainingFile() {
                return null;
            }
        }, null);
        docComponent.clearHistory();
        JBPopup hint = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)docComponent, (JComponent)docComponent).setProject(project).setDimensionServiceKey(project, "javadoc.popup", false).setResizable(true).setMovable(true).setRequestFocus(true).setTitle(item.getAttrName()).setCancelCallback((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                Disposer.dispose((Disposable)docComponent);
                return Boolean.TRUE;
            }
        }).createPopup();
        docComponent.setHint(hint);
        Disposer.register((Disposable)hint, (Disposable)docComponent);
        hint.show(new RelativePoint((Component)this.myAttributesTable.getParent(), ORIGIN));
    }
}

