/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.attributes.editors;

import com.android.ide.common.rendering.api.ResourceValue;
import com.android.resources.ResourceType;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.editors.theme.ThemeEditorConstants;
import com.android.tools.idea.editors.theme.ThemeEditorContext;
import com.android.tools.idea.editors.theme.ThemeEditorUtils;
import com.android.tools.idea.editors.theme.attributes.editors.GraphicalResourceRendererEditor;
import com.android.tools.idea.editors.theme.datamodels.EditedStyleItem;
import com.android.tools.idea.editors.theme.preview.AndroidThemePreviewPanel;
import com.android.tools.idea.editors.theme.ui.ResourceComponent;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.ui.resourcechooser.ResourceSwatchComponent;
import com.google.common.collect.Iterables;
import com.intellij.openapi.module.Module;
import com.intellij.ui.ColorUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.EnumSet;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DrawableRendererEditor
extends GraphicalResourceRendererEditor {
    private static final int MIN_DRAWABLE_PREVIEW_SIZE = JBUI.scale((int)25);
    @Nullable
    private RenderTask myRenderTask;

    public DrawableRendererEditor(@NotNull ThemeEditorContext context, @NotNull AndroidThemePreviewPanel previewPanel, boolean isEditor) {
        super(context, previewPanel, isEditor);
    }

    @NotNull
    public static RenderTask configureRenderTask(@NotNull Module module, @NotNull Configuration configuration) {
        AndroidFacet facet = AndroidFacet.getInstance(module);
        assert (facet != null);
        RenderService service = RenderService.getInstance(module.getProject());
        RenderLogger logger = new RenderLogger("ThemeEditorLogger", null);
        RenderTask task = service.taskBuilder(facet, configuration).withLogger(logger).buildSynchronously();
        assert (task != null);
        task.getLayoutlibCallback().setLogger(logger);
        return task;
    }

    @Override
    protected void updateComponent(@NotNull ThemeEditorContext context, @NotNull ResourceComponent component, @NotNull EditedStyleItem item) {
        ResourceSwatchComponent.SwatchIcon icon2;
        assert (context.getResourceResolver() != null);
        Dimension iconSize = component.getSwatchIconSize();
        int iconWidth = Math.max(iconSize.width, MIN_DRAWABLE_PREVIEW_SIZE);
        int iconHeight = Math.max(iconSize.height, MIN_DRAWABLE_PREVIEW_SIZE);
        if (this.myRenderTask == null || this.myRenderTask.getContext().getModule() != context.getCurrentContextModule()) {
            this.myRenderTask = DrawableRendererEditor.configureRenderTask(context.getCurrentContextModule(), context.getConfiguration());
        }
        this.myRenderTask.setMaxRenderSize(iconWidth, iconHeight);
        List<BufferedImage> images = this.myRenderTask.renderDrawableAllStates((ResourceValue)item.getSelectedValue());
        if (images.isEmpty()) {
            icon2 = ResourceSwatchComponent.WARNING_ICON;
        } else {
            icon2 = new ResourceSwatchComponent.SquareImageIcon((BufferedImage)Iterables.getLast(images));
            icon2.setIsStack(images.size() > 1);
        }
        component.setSwatchIcon(icon2);
        String nameText = String.format("<html><nobr><b><font color=\"#%1$s\">%2$s", ColorUtil.toHex((Color)ThemeEditorConstants.RESOURCE_ITEM_COLOR), ThemeEditorUtils.getDisplayHtml(item));
        component.setNameText(nameText);
        component.setValueText(item.getValue());
    }

    @Override
    @NotNull
    protected EnumSet<ResourceType> getAllowedResourceTypes() {
        return GraphicalResourceRendererEditor.DRAWABLES_ONLY;
    }
}

