/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.attributes.editors;

import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.StyleItemResourceValue;
import com.android.ide.common.resources.ResourceResolver;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ThemeSelectionPanel;
import com.android.tools.idea.editors.theme.ThemeEditorContext;
import com.android.tools.idea.editors.theme.ThemeEditorUtils;
import com.android.tools.idea.editors.theme.ThemeResolver;
import com.android.tools.idea.editors.theme.ThemesListModel;
import com.android.tools.idea.editors.theme.attributes.editors.ColorPaletteComponent;
import com.android.tools.idea.editors.theme.attributes.editors.StyleListCellRenderer;
import com.android.tools.idea.editors.theme.datamodels.ConfiguredThemeEditorStyle;
import com.android.tools.idea.res.ResourceHelper;
import java.awt.Color;
import javax.swing.JComboBox;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StyleListPaletteCellRenderer
extends StyleListCellRenderer {
    private static final String PRIMARY_MATERIAL = "colorPrimary";
    private static final String PRIMARY_DARK_MATERIAL = "colorPrimaryDark";
    private static final String ACCENT_MATERIAL = "colorAccent";
    private ColorPaletteComponent myColorPaletteComponent = null;
    @NotNull
    private final ThemeSelectionPanel.ThemeChangedListener myThemeChangedListener;
    @NotNull
    private final ThemeEditorContext myContext;

    public StyleListPaletteCellRenderer(@NotNull ThemeEditorContext context, @NotNull ThemeSelectionPanel.ThemeChangedListener themeChangedListener, @Nullable JComboBox comboBox) {
        super(context, comboBox);
        this.myContext = context;
        this.myColorPaletteComponent = new ColorPaletteComponent();
        this.myThemeChangedListener = themeChangedListener;
    }

    @Override
    protected void customizeCellRenderer(@NotNull JList list, Object value2, int index, boolean selected, boolean hasFocus) {
        super.customizeCellRenderer(list, value2, index, selected, hasFocus);
        if (!(value2 instanceof String) || ThemesListModel.isSpecialOption((String)value2)) {
            this.myColorPaletteComponent.reset();
            return;
        }
        ThemeResolver themeResolver = this.myContext.getThemeResolver();
        ConfiguredThemeEditorStyle theme = themeResolver.getTheme((String)value2);
        if (theme == null) {
            this.myColorPaletteComponent.reset();
            this.setIcon(null);
            return;
        }
        boolean isFrameworkAttr = !ThemeEditorUtils.isAppCompatTheme(theme);
        StyleItemResourceValue primaryResourceValue = ThemeEditorUtils.resolveItemFromParents(theme, PRIMARY_MATERIAL, isFrameworkAttr);
        StyleItemResourceValue primaryDarkResourceValue = ThemeEditorUtils.resolveItemFromParents(theme, PRIMARY_DARK_MATERIAL, isFrameworkAttr);
        StyleItemResourceValue accentResourceValue = ThemeEditorUtils.resolveItemFromParents(theme, ACCENT_MATERIAL, isFrameworkAttr);
        if (primaryResourceValue != null && primaryDarkResourceValue != null && accentResourceValue != null) {
            Configuration configuration = theme.getConfiguration();
            ResourceResolver resourceResolver = configuration.getConfigurationManager().getResolverCache().getResourceResolver(configuration.getRealTarget(), theme.getStyleResourceUrl(), configuration.getFullConfig());
            Color primaryColor = ResourceHelper.resolveColor((RenderResources)resourceResolver, (ResourceValue)primaryResourceValue, this.myContext.getProject());
            Color primaryDarkColor = ResourceHelper.resolveColor((RenderResources)resourceResolver, (ResourceValue)primaryDarkResourceValue, this.myContext.getProject());
            Color accentColor = ResourceHelper.resolveColor((RenderResources)resourceResolver, (ResourceValue)accentResourceValue, this.myContext.getProject());
            if (primaryColor != null && primaryDarkColor != null && accentColor != null) {
                this.myColorPaletteComponent.setValues(primaryColor, primaryDarkColor, accentColor);
            }
            this.setIcon(this.myColorPaletteComponent);
        } else {
            this.myColorPaletteComponent.reset();
            this.setIcon(null);
        }
        if (selected) {
            this.myThemeChangedListener.themeChanged(theme.getQualifiedName());
        }
    }
}

