/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.datamodels;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.StyleItemResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValueImpl;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.ResourceType;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.editors.theme.ResolutionUtils;
import com.android.tools.idea.editors.theme.ThemeResolver;
import com.android.tools.idea.editors.theme.datamodels.ConfiguredElement;
import com.android.tools.idea.editors.theme.datamodels.EditedStyleItem;
import com.android.tools.idea.editors.theme.datamodels.ThemeEditorStyle;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.module.Module;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfiguredThemeEditorStyle
extends ThemeEditorStyle {
    @NotNull
    private final StyleResourceValueImpl myStyleResourceValue;
    @NotNull
    private final Configuration myConfiguration;
    @Nullable
    private final Module mySourceModule;

    public ConfiguredThemeEditorStyle(@NotNull Configuration configuration, @NotNull StyleResourceValue styleResourceValue, @Nullable Module sourceModule) {
        super(configuration.getConfigurationManager(), styleResourceValue.asReference());
        this.myStyleResourceValue = StyleResourceValueImpl.copyOf((StyleResourceValue)styleResourceValue);
        this.myConfiguration = configuration;
        this.mySourceModule = sourceModule;
    }

    @NotNull
    public String getStyleResourceUrl() {
        return this.myStyleResourceValue.getResourceUrl().toString();
    }

    @NotNull
    public StyleResourceValueImpl getStyleResourceValue() {
        return this.myStyleResourceValue;
    }

    public boolean isReadOnly() {
        return !this.isProjectStyle();
    }

    @NotNull
    public ImmutableCollection<ConfiguredElement<StyleItemResourceValue>> getConfiguredValues() {
        ImmutableList.Builder itemResourceValues = ImmutableList.builder();
        if (this.isFramework()) {
            ResourceRepository frameworkResources = this.myConfiguration.getFrameworkResources();
            assert (frameworkResources != null);
            List styleItems = frameworkResources.getResources(ResourceNamespace.ANDROID, ResourceType.STYLE, this.myStyleResourceValue.getName());
            for (ResourceItem item : styleItems) {
                ResourceValue styleResourceValue = item.getResourceValue();
                if (!(styleResourceValue instanceof StyleResourceValue)) continue;
                FolderConfiguration folderConfiguration = item.getConfiguration();
                for (StyleItemResourceValue value2 : ((StyleResourceValue)styleResourceValue).getDefinedItems()) {
                    itemResourceValues.add(ConfiguredElement.create(folderConfiguration, value2));
                }
            }
        } else {
            for (ResourceItem styleDefinition : this.getStyleResourceItems()) {
                ResourceValue styleResourceValue = styleDefinition.getResourceValue();
                FolderConfiguration folderConfiguration = styleDefinition.getConfiguration();
                if (!(styleResourceValue instanceof StyleResourceValue)) continue;
                for (StyleItemResourceValue value3 : ((StyleResourceValue)styleResourceValue).getDefinedItems()) {
                    itemResourceValues.add(ConfiguredElement.create(folderConfiguration, value3));
                }
            }
        }
        return itemResourceValues.build();
    }

    public Collection<ConfiguredElement<String>> getParentNames() {
        if (this.isFramework()) {
            ConfiguredThemeEditorStyle parent = this.getParent();
            if (parent != null) {
                return ImmutableList.of(ConfiguredElement.create(new FolderConfiguration(), parent.getQualifiedName()));
            }
            return Collections.emptyList();
        }
        ImmutableList.Builder parents = ImmutableList.builder();
        for (ResourceItem styleItem : this.getStyleResourceItems()) {
            StyleResourceValue style = (StyleResourceValue)styleItem.getResourceValue();
            assert (style != null);
            String parentName = ResolutionUtils.getParentQualifiedName(style);
            if (parentName == null) continue;
            parents.add(ConfiguredElement.create(styleItem.getConfiguration(), parentName));
        }
        return parents.build();
    }

    public boolean hasItem(@Nullable EditedStyleItem item) {
        ResourceReference attrReference = item == null ? null : item.getAttrReference();
        return attrReference != null && this.getStyleResourceValue().getItem(attrReference) != null;
    }

    public StyleItemResourceValue getItem(@NotNull String name, boolean isFramework) {
        return this.getStyleResourceValue().getItem(ResourceNamespace.fromBoolean((boolean)isFramework), name);
    }

    public ConfiguredThemeEditorStyle getParent() {
        return this.getParent(null);
    }

    @Nullable
    public ConfiguredThemeEditorStyle getParent(@Nullable ThemeResolver themeResolver) {
        ResourceResolver resolver = this.myConfiguration.getResourceResolver();
        assert (resolver != null);
        StyleResourceValue parent = resolver.getParent((StyleResourceValue)this.getStyleResourceValue());
        if (parent == null) {
            return null;
        }
        if (themeResolver == null) {
            return ResolutionUtils.getThemeEditorStyle(this.myConfiguration, parent.asReference(), null);
        }
        return themeResolver.getTheme(parent.asReference());
    }

    public String toString() {
        if (!this.isReadOnly()) {
            return "[" + this.getName() + "]";
        }
        return this.getName();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ConfiguredThemeEditorStyle)) {
            return false;
        }
        return this.getStyleReference().equals((Object)((ConfiguredThemeEditorStyle)obj).getStyleReference());
    }

    public int hashCode() {
        return this.getStyleReference().hashCode();
    }

    @NotNull
    public Configuration getConfiguration() {
        return this.myConfiguration;
    }

    @Nullable
    public final Module getSourceModule() {
        return this.mySourceModule;
    }
}

