/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.datamodels;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.StyleItemResourceValue;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.ResourceType;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.editors.theme.ResolutionUtils;
import com.android.tools.idea.editors.theme.datamodels.ConfiguredElement;
import com.android.tools.idea.editors.theme.datamodels.ConfiguredThemeEditorStyle;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.sdk.AndroidTargetData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditedStyleItem
implements Comparable<EditedStyleItem> {
    private static final Logger LOG = Logger.getInstance(EditedStyleItem.class);
    private static final String DEPRECATED = "deprecated";
    private final ConfiguredThemeEditorStyle mySourceTheme;
    private final ConfiguredElement<StyleItemResourceValue> mySelectedValue;
    private final Collection<ConfiguredElement<StyleItemResourceValue>> myNonSelectedValues;
    private final String myAttrGroup;

    public EditedStyleItem(@NotNull ConfiguredElement<StyleItemResourceValue> selectedValue, @NotNull Iterable<ConfiguredElement<StyleItemResourceValue>> nonSelectedValues, @NotNull ConfiguredThemeEditorStyle sourceTheme) {
        this.mySourceTheme = sourceTheme;
        this.myNonSelectedValues = ImmutableList.copyOf(nonSelectedValues);
        this.mySelectedValue = selectedValue;
        AttributeDefinition attrDef = ResolutionUtils.getAttributeDefinition(sourceTheme.getConfiguration(), (StyleItemResourceValue)this.mySelectedValue.myValue);
        String attrGroup = attrDef == null ? null : attrDef.getGroupName();
        this.myAttrGroup = attrGroup == null ? "Other non-theme attributes." : attrGroup;
    }

    public EditedStyleItem(@NotNull ConfiguredElement<StyleItemResourceValue> selectedValue, @NotNull ConfiguredThemeEditorStyle sourceTheme) {
        this(selectedValue, Collections.emptyList(), sourceTheme);
    }

    public StyleItemResourceValue getSelectedValue() {
        return (StyleItemResourceValue)this.mySelectedValue.myValue;
    }

    @NotNull
    public String getAttrGroup() {
        return this.myAttrGroup;
    }

    @NotNull
    public String getValue() {
        return ResolutionUtils.getQualifiedValue(this.getSelectedValue());
    }

    @NotNull
    public String getAttrName() {
        return this.getSelectedValue().getAttr().getName();
    }

    @Nullable
    public ResourceReference getAttrReference() {
        return this.getSelectedValue().getAttr();
    }

    @NotNull
    public ConfiguredThemeEditorStyle getSourceStyle() {
        return this.mySourceTheme;
    }

    @NotNull
    public FolderConfiguration getSelectedValueConfiguration() {
        return this.mySelectedValue.getConfiguration();
    }

    @NotNull
    public ConfiguredElement<StyleItemResourceValue> getSelectedItemResourceValue() {
        return this.mySelectedValue;
    }

    @NotNull
    public Collection<ConfiguredElement<StyleItemResourceValue>> getAllConfiguredItems() {
        return ImmutableList.builder().add(this.mySelectedValue).addAll(this.getNonSelectedItemResourceValues()).build();
    }

    @NotNull
    public Collection<ConfiguredElement<StyleItemResourceValue>> getNonSelectedItemResourceValues() {
        return this.myNonSelectedValues;
    }

    public boolean isAttr() {
        ResourceReference reference2 = this.getSelectedValue().getReference();
        return reference2 != null && reference2.getResourceType() == ResourceType.ATTR;
    }

    public String toString() {
        StringBuilder output = new StringBuilder(String.format("[%1$s] %2$s = %3$s (%4$s)", this.mySourceTheme, this.getAttrName(), this.getValue(), this.mySelectedValue.myFolderConfiguration));
        for (ConfiguredElement<StyleItemResourceValue> item : this.myNonSelectedValues) {
            output.append('\n').append(String.format("   %1$s = %2$s (%3$s)", ((StyleItemResourceValue)item.myValue).getAttrName(), ((StyleItemResourceValue)item.myValue).getValue(), item.getConfiguration()));
        }
        return output.toString();
    }

    @NotNull
    public String getQualifiedName() {
        return ResolutionUtils.getQualifiedItemAttrName(this.getSelectedValue());
    }

    public String getAttrPropertyName() {
        if (!this.isAttr()) {
            return "";
        }
        String propertyName = (String)Splitter.on((char)'/').limit(2).splitToList((CharSequence)this.getValue()).get(1);
        return (this.getValue().startsWith("?android:") ? "android:" : "") + propertyName;
    }

    public boolean isDeprecated() {
        AttributeDefinition def = ResolutionUtils.getAttributeDefinition(this.mySourceTheme.getConfiguration(), this.getSelectedValue());
        String doc = def == null ? null : def.getDescription(null);
        return doc != null && StringUtil.containsIgnoreCase((String)doc, (String)DEPRECATED);
    }

    public boolean isPublicAttribute() {
        ResourceReference attr = this.getSelectedValue().getAttr();
        if (attr == null || attr.getNamespace() != ResourceNamespace.ANDROID) {
            return true;
        }
        Configuration configuration = this.mySourceTheme.getConfiguration();
        IAndroidTarget target = configuration.getRealTarget();
        if (target == null) {
            LOG.error("Unable to get IAndroidTarget.");
            return false;
        }
        AndroidTargetData androidTargetData = AndroidTargetData.getTargetData(target, configuration.getModule());
        if (androidTargetData == null) {
            LOG.error("Unable to get AndroidTargetData.");
            return false;
        }
        return androidTargetData.isResourcePublic(ResourceType.ATTR.getName(), this.getAttrName());
    }

    @Override
    public int compareTo(EditedStyleItem that) {
        return this.getAttrName().compareTo(that.getAttrName());
    }
}

