/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.preview;

import com.android.SdkConstants;
import com.android.resources.Density;
import com.android.tools.adtui.ui.NavigationComponent;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationHolder;
import com.android.tools.idea.configurations.ConfigurationListener;
import com.android.tools.idea.editors.theme.ThemeEditorContext;
import com.android.tools.idea.editors.theme.ThemeEditorUtils;
import com.android.tools.idea.editors.theme.preview.ThemePreviewBuilder;
import com.android.tools.idea.editors.theme.preview.ToolbarComponentDefinition;
import com.android.tools.swing.layoutlib.AndroidPreviewPanel;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.Query;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.xml.parsers.ParserConfigurationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidThemePreviewPanel
extends Box
implements ConfigurationHolder,
Disposable {
    private static final Logger LOG = Logger.getInstance(AndroidThemePreviewPanel.class);
    private static final Map<String, ThemePreviewBuilder.ComponentDefinition> SUPPORT_LIBRARY_COMPONENTS = ImmutableMap.of((Object)SdkConstants.FLOATING_ACTION_BUTTON.oldName(), (Object)new ThemePreviewBuilder.ComponentDefinition("Fab", ThemePreviewBuilder.ComponentGroup.FAB_BUTTON, SdkConstants.FLOATING_ACTION_BUTTON.oldName()).set("src", "?android:attr/homeAsUpIndicator").set("layout_width", "56dp").set("layout_height", "56dp"), (Object)SdkConstants.FLOATING_ACTION_BUTTON.newName(), (Object)new ThemePreviewBuilder.ComponentDefinition("Fab", ThemePreviewBuilder.ComponentGroup.FAB_BUTTON, SdkConstants.FLOATING_ACTION_BUTTON.newName()).set("src", "?android:attr/homeAsUpIndicator").set("layout_width", "wrap_content").set("layout_height", "wrap_content").set("app", "fabSize", "normal"), (Object)SdkConstants.TOOLBAR_V7.oldName(), (Object)ToolbarComponentDefinition.getSupportToolbar(SdkConstants.TOOLBAR_V7.oldName()), (Object)SdkConstants.TOOLBAR_V7.newName(), (Object)ToolbarComponentDefinition.getSupportToolbar(SdkConstants.TOOLBAR_V7.newName()));
    private static final Map<String, String> SUPPORT_LIBRARY_REPLACEMENTS = ImmutableMap.of((Object)SdkConstants.TOOLBAR_V7.oldName(), (Object)"Toolbar", (Object)SdkConstants.TOOLBAR_V7.newName(), (Object)"Toolbar");
    private static final boolean ENABLE_COMPONENTS_DRILL_DOWN = false;
    private static final String ERROR = "Error";
    private static final String PROGRESS = "Progress";
    private static final String PREVIEW = "Preview";
    private final JPanel myMainPanel;
    private Box myErrorPanel;
    private JTextPane myErrorLabel;
    private Box myProgressPanel;
    private AsyncProcessIcon myProgressIcon;
    private String mySearchTerm = "";
    private List<ThemePreviewBuilder.ComponentDefinition> myCustomComponents = Collections.emptyList();
    private List<ThemePreviewBuilder.ComponentDefinition> mySupportLibraryComponents = Collections.emptyList();
    private final List<String> myDisabledComponents = new ArrayList<String>();
    private final ThemeEditorContext myContext;
    protected final NavigationComponent<Breadcrumb> myBreadcrumbs;
    protected final AndroidPreviewPanel myAndroidPreviewPanel;
    protected final JBScrollPane myScrollPane;
    protected final DumbService myDumbService;
    private final Predicate<ThemePreviewBuilder.ComponentDefinition> myGroupFilter = new Predicate<ThemePreviewBuilder.ComponentDefinition>(){

        public boolean apply(@Nullable ThemePreviewBuilder.ComponentDefinition input) {
            if (input == null) {
                return false;
            }
            Breadcrumb breadcrumb = (Breadcrumb)AndroidThemePreviewPanel.this.myBreadcrumbs.peek();
            return breadcrumb == null || breadcrumb.myGroup == null || breadcrumb.myGroup.equals((Object)input.group);
        }
    };
    private final Predicate<ThemePreviewBuilder.ComponentDefinition> mySupportReplacementsFilter = input -> {
        if (input == null) {
            return false;
        }
        return !this.myDisabledComponents.contains(input.name);
    };
    private float myScale = 1.0f;
    private boolean myIsAppCompatTheme = false;
    private boolean myShowError = false;

    public AndroidThemePreviewPanel(@NotNull ThemeEditorContext context, @NotNull Color background) {
        super(3);
        this.setOpaque(true);
        this.setMinimumSize((Dimension)JBUI.size((int)200, (int)0));
        this.myContext = context;
        this.myContext.getProject().getMessageBus().connect((Disposable)this).subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

            public void enteredDumbMode() {
                AndroidThemePreviewPanel.this.updateMainPanel();
            }

            public void exitDumbMode() {
                AndroidThemePreviewPanel.this.updateMainPanel();
            }
        });
        this.myAndroidPreviewPanel = new AndroidPreviewPanel(this.myContext.getConfiguration());
        this.myContext.addChangeListener(new ThemeEditorContext.ChangeListener(){

            @Override
            public void onNewConfiguration(ThemeEditorContext context) {
                AndroidThemePreviewPanel.this.refreshConfiguration();
            }
        });
        this.myAndroidPreviewPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.myBreadcrumbs = new NavigationComponent();
        this.myBreadcrumbs.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
        this.myDumbService = DumbService.getInstance((Project)context.getProject());
        this.myScrollPane = new JBScrollPane((Component)this.myAndroidPreviewPanel, 20, 31);
        this.myScrollPane.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.myScrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.myScrollPane.setViewportBorder(null);
        this.myBreadcrumbs.setRootItem((NavigationComponent.Item)new Breadcrumb("All components"));
        this.createErrorPanel();
        this.createProgressPanel();
        this.add(Box.createRigidArea((Dimension)JBUI.size((int)0, (int)5)));
        this.add((Component)this.myBreadcrumbs);
        this.add(Box.createRigidArea((Dimension)JBUI.size((int)0, (int)10)));
        this.myMainPanel = new JPanel(new CardLayout());
        this.myMainPanel.add((Component)this.myErrorPanel, ERROR);
        this.myMainPanel.add((Component)this.myProgressPanel, PROGRESS);
        this.myMainPanel.add((Component)this.myScrollPane, PREVIEW);
        this.add(this.myMainPanel);
        this.setBackground(background);
        this.reloadComponents();
        this.myBreadcrumbs.addItemListener((NavigationComponent.ItemListener)new NavigationComponent.ItemListener<Breadcrumb>(){

            public void itemSelected(@NotNull Breadcrumb item) {
                AndroidThemePreviewPanel.this.myBreadcrumbs.goTo((NavigationComponent.Item)item);
                AndroidThemePreviewPanel.this.rebuild();
            }
        });
        this.myContext.addConfigurationListener(new ConfigurationListener(){

            @Override
            public boolean changed(int flags) {
                AndroidThemePreviewPanel.this.refreshConfiguration();
                if (ThemeEditorUtils.isSelectedAppCompatTheme(AndroidThemePreviewPanel.this.myContext) != AndroidThemePreviewPanel.this.myIsAppCompatTheme) {
                    AndroidThemePreviewPanel.this.rebuild();
                }
                return true;
            }
        });
        this.refreshScale();
        this.updateMainPanel();
    }

    private void updateMainPanel() {
        if (this.myDumbService.isDumb()) {
            this.myProgressIcon.resume();
            ((CardLayout)this.myMainPanel.getLayout()).show(this.myMainPanel, PROGRESS);
        } else {
            this.myProgressIcon.suspend();
            ((CardLayout)this.myMainPanel.getLayout()).show(this.myMainPanel, this.myShowError ? ERROR : PREVIEW);
        }
    }

    public void setSearchTerm(@NotNull String searchTerm) {
        if (searchTerm.equals(this.mySearchTerm)) {
            return;
        }
        this.mySearchTerm = searchTerm;
        this.rebuild();
    }

    @Override
    public void setBackground(Color bg) {
        if (Objects.equal((Object)bg, (Object)this.getBackground())) {
            return;
        }
        super.setBackground(bg);
        this.myAndroidPreviewPanel.setBackground(bg);
        this.myScrollPane.getViewport().setBackground(bg);
        this.myBreadcrumbs.setBackground(bg);
        this.myMainPanel.setBackground(bg);
        this.rebuild();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.rebuild();
    }

    public void reloadComponents() {
        this.myDumbService.runWhenSmart(() -> {
            Project project = this.myContext.getProject();
            if (!project.isOpen()) {
                return;
            }
            PsiClass viewClass = JavaPsiFacade.getInstance((Project)project).findClass("android.view.View", GlobalSearchScope.allScope((Project)project));
            if (viewClass == null) {
                LOG.debug("Unable to find 'android.view.View'");
                return;
            }
            Query viewClasses = ClassInheritorsSearch.search((PsiClass)viewClass, (SearchScope)ProjectScope.getProjectScope((Project)project), (boolean)true);
            ArrayList customComponents = new ArrayList();
            viewClasses.forEach(psiClass -> {
                String description = psiClass.getName();
                String className = psiClass.getQualifiedName();
                if (description == null || className == null) {
                    return false;
                }
                customComponents.add(new ThemePreviewBuilder.ComponentDefinition(description, ThemePreviewBuilder.ComponentGroup.CUSTOM, className));
                return true;
            });
            this.myDisabledComponents.clear();
            HashSet supportLibraryComponents = new HashSet();
            viewClasses = ClassInheritorsSearch.search((PsiClass)viewClass, (SearchScope)ProjectScope.getLibrariesScope((Project)project), (boolean)true);
            viewClasses.forEach(psiClass -> {
                String className = psiClass.getQualifiedName();
                ThemePreviewBuilder.ComponentDefinition component = SUPPORT_LIBRARY_COMPONENTS.get(className);
                if (component != null) {
                    supportLibraryComponents.add(component);
                    String replaces = SUPPORT_LIBRARY_REPLACEMENTS.get(className);
                    if (replaces != null) {
                        this.myDisabledComponents.add(replaces);
                    }
                }
                return true;
            });
            this.myCustomComponents = Collections.unmodifiableList(customComponents);
            this.mySupportLibraryComponents = ImmutableList.copyOf(supportLibraryComponents);
            if (!this.myCustomComponents.isEmpty() || !this.mySupportLibraryComponents.isEmpty()) {
                this.rebuild();
            }
        });
        this.rebuild(false);
    }

    private void rebuild(boolean forceRepaint) {
        try {
            Configuration configuration = this.myContext.getConfiguration();
            int minApiLevel = configuration.getTarget() != null ? configuration.getTarget().getVersion().getApiLevel() : Integer.MAX_VALUE;
            ThemePreviewBuilder builder = new ThemePreviewBuilder().setBackgroundColor(this.getBackground()).addAllComponents(ThemePreviewBuilder.AVAILABLE_BASE_COMPONENTS).addNavigationBar(configuration.supports(19)).addAllComponents(this.myCustomComponents).addComponentFilter(new ThemePreviewBuilder.SearchFilter(this.mySearchTerm)).addComponentFilter(new ThemePreviewBuilder.ApiLevelFilter(minApiLevel)).addComponentFilter(this.myGroupFilter);
            this.myIsAppCompatTheme = ThemeEditorUtils.isSelectedAppCompatTheme(this.myContext);
            if (this.myIsAppCompatTheme) {
                builder.addComponentFilter(this.mySupportReplacementsFilter).addAllComponents(this.mySupportLibraryComponents);
            }
            this.myAndroidPreviewPanel.setDocument(builder.build());
            if (forceRepaint) {
                this.repaint();
            }
        }
        catch (ParserConfigurationException e) {
            LOG.error("Unable to generate dynamic theme preview", (Throwable)e);
        }
    }

    private void rebuild() {
        this.rebuild(true);
    }

    private void refreshScale() {
        Configuration configuration = this.myContext.getConfiguration();
        if (configuration.getDeviceState() != null) {
            float reverseDeviceScale = (float)Density.DEFAULT_DENSITY / (float)configuration.getDeviceState().getHardware().getScreen().getPixelDensity().getDpiValue();
            this.myAndroidPreviewPanel.setScale(JBUI.scale((float)(reverseDeviceScale * this.myScale)));
        }
    }

    private void refreshConfiguration() {
        Configuration configuration = this.myContext.getConfiguration();
        this.myAndroidPreviewPanel.updateConfiguration(configuration);
        this.refreshScale();
    }

    private void createProgressPanel() {
        this.myProgressIcon = new AsyncProcessIcon("Indexing");
        Disposer.register((Disposable)this, (Disposable)this.myProgressIcon);
        JLabel progressMessage = new JLabel("Waiting for indexing...");
        JPanel progressBlock = new JPanel(){

            @Override
            public Dimension getMaximumSize() {
                return super.getPreferredSize();
            }
        };
        progressBlock.add((Component)this.myProgressIcon);
        progressBlock.add(progressMessage);
        progressBlock.setOpaque(false);
        this.myProgressPanel = new Box(3);
        this.myProgressPanel.add(Box.createVerticalGlue());
        this.myProgressPanel.add(progressBlock);
        this.myProgressPanel.add(Box.createVerticalGlue());
        this.myProgressPanel.setOpaque(false);
    }

    private void createErrorPanel() {
        this.myErrorLabel = new JTextPane(){

            @Override
            public Dimension getMaximumSize() {
                return super.getPreferredSize();
            }
        };
        this.myErrorLabel.setOpaque(false);
        this.myErrorPanel = new Box(3);
        this.myErrorPanel.add(Box.createVerticalGlue());
        this.myErrorPanel.add(this.myErrorLabel);
        this.myErrorPanel.add(Box.createVerticalGlue());
        this.myErrorPanel.setOpaque(false);
        StyledDocument document = this.myErrorLabel.getStyledDocument();
        SimpleAttributeSet attributes = new SimpleAttributeSet();
        StyleConstants.setAlignment(attributes, 1);
        document.setParagraphAttributes(0, document.getLength(), attributes, false);
    }

    public void setErrorMessage(@Nullable String errorMessage) {
        boolean bl = this.myShowError = errorMessage != null;
        if (errorMessage != null) {
            this.myErrorLabel.setText(errorMessage);
        }
        this.updateMainPanel();
    }

    public void setScale(float scale) {
        this.myScale = scale;
    }

    public void invalidateGraphicsRenderer() {
        this.myAndroidPreviewPanel.invalidateGraphicsRenderer();
    }

    public void dispose() {
    }

    @Override
    @Nullable
    public Configuration getConfiguration() {
        return this.myContext.getConfiguration();
    }

    static class Breadcrumb
    extends NavigationComponent.Item {
        private final ThemePreviewBuilder.ComponentGroup myGroup;
        private final String myDisplayText;

        private Breadcrumb(@NotNull String name, @Nullable ThemePreviewBuilder.ComponentGroup group) {
            this.myDisplayText = name;
            this.myGroup = group;
        }

        public Breadcrumb(@NotNull String name) {
            this(name, null);
        }

        public Breadcrumb(@NotNull ThemePreviewBuilder.ComponentGroup group) {
            this(group.name, group);
        }

        @NotNull
        public String getDisplayText() {
            return this.myDisplayText;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Breadcrumb that = (Breadcrumb)((Object)o);
            return Objects.equal((Object)((Object)this.myGroup), (Object)((Object)that.myGroup)) && Objects.equal((Object)this.myDisplayText, (Object)that.myDisplayText);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.myGroup, this.myDisplayText});
        }
    }
}

