/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.preview;

import com.android.tools.idea.editors.theme.preview.ThemePreviewBuilder;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class ToolbarComponentDefinition
extends ThemePreviewBuilder.ComponentDefinition {
    private final boolean myIsAppCompat;

    private ToolbarComponentDefinition(boolean isAppCompat, @NotNull String tagName) {
        super("Toolbar", ThemePreviewBuilder.ComponentGroup.TOOLBAR, tagName);
        this.myIsAppCompat = isAppCompat;
        if (!isAppCompat) {
            this.setApiLevel(21);
            this.set("layout_height", "?android:attr/actionBarSize");
        } else {
            this.set("app", "contentInsetStart", "0dp");
            this.set("app", "contentInsetLeft", "0dp");
        }
        String attrPrefix = ToolbarComponentDefinition.getAttrPrefix(isAppCompat);
        this.set("layout_width", "match_parent");
        this.set("layout_height", attrPrefix + "actionBarSize");
        this.set("background", attrPrefix + "colorPrimary");
        this.set("theme", attrPrefix + "actionBarTheme");
        this.addAlias("Actionbar");
    }

    @NotNull
    static ToolbarComponentDefinition getFrameworkToolbar() {
        return new ToolbarComponentDefinition(false, "Toolbar");
    }

    @NotNull
    static ToolbarComponentDefinition getSupportToolbar(@NotNull String tagName) {
        return new ToolbarComponentDefinition(false, tagName);
    }

    private static String getAttrPrefix(boolean isAppCompat) {
        return isAppCompat ? "?attr/" : "?android:attr/";
    }

    @Override
    Element build(@NotNull Document document) {
        Element toolbarComponent = super.build(document);
        String attrPrefix = ToolbarComponentDefinition.getAttrPrefix(this.myIsAppCompat);
        Element navIcon = document.createElement("ImageButton");
        navIcon.setAttributeNS("http://schemas.android.com/apk/res/android", "layout_width", "wrap_content");
        navIcon.setAttributeNS("http://schemas.android.com/apk/res/android", "layout_height", attrPrefix + "actionBarSize");
        if (this.myIsAppCompat) {
            navIcon.setAttribute("style", "?attr/toolbarNavigationButtonStyle");
        } else {
            navIcon.setAttributeNS("http://schemas.android.com/apk/res/android", "background", "@android:color/transparent");
            navIcon.setAttributeNS("http://schemas.android.com/apk/res/android", "layout_marginRight", "10dp");
        }
        navIcon.setAttributeNS("http://schemas.android.com/apk/res/android", "src", attrPrefix + "homeAsUpIndicator");
        navIcon.setAttributeNS("http://schemas.android.com/apk/res/android", "tint", attrPrefix + "actionMenuTextColor");
        navIcon.setAttributeNS("http://schemas.android.com/tools/preview/builder", "group", this.group.name());
        toolbarComponent.appendChild(navIcon);
        Element title = document.createElement("TextView");
        title.setAttributeNS("http://schemas.android.com/apk/res/android", "text", "Toolbar");
        if (this.myIsAppCompat) {
            title.setAttributeNS("http://schemas.android.com/apk/res/android", "textAppearance", "@style/TextAppearance.Widget.AppCompat.Toolbar.Title");
        } else {
            title.setAttributeNS("http://schemas.android.com/apk/res/android", "textAppearance", "@android:style/TextAppearance.Material.Widget.Toolbar.Title");
        }
        title.setAttributeNS("http://schemas.android.com/apk/res/android", "layout_width", "wrap_content");
        title.setAttributeNS("http://schemas.android.com/apk/res/android", "layout_height", attrPrefix + "actionBarSize");
        title.setAttributeNS("http://schemas.android.com/apk/res/android", "gravity", "center_vertical");
        title.setAttributeNS("http://schemas.android.com/apk/res/android", "ellipsize", "end");
        title.setAttributeNS("http://schemas.android.com/apk/res/android", "singleLine", "true");
        title.setAttributeNS("http://schemas.android.com/tools/preview/builder", "group", this.group.name());
        toolbarComponent.appendChild(title);
        Element menuIcon = document.createElement("ImageButton");
        menuIcon.setAttributeNS("http://schemas.android.com/apk/res/android", "layout_width", "40dp");
        menuIcon.setAttributeNS("http://schemas.android.com/apk/res/android", "layout_height", attrPrefix + "actionBarSize");
        menuIcon.setAttributeNS("http://schemas.android.com/apk/res/android", "layout_gravity", "right");
        menuIcon.setAttribute("style", attrPrefix + "actionOverflowButtonStyle");
        menuIcon.setAttributeNS("http://schemas.android.com/tools/preview/builder", "group", this.group.name());
        toolbarComponent.appendChild(menuIcon);
        return toolbarComponent;
    }
}

