/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.qualifiers;

import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.ide.common.resources.configuration.ResourceQualifier;
import com.android.ide.common.resources.configuration.VersionQualifier;
import com.android.resources.ResourceEnum;
import com.android.tools.idea.editors.theme.datamodels.ConfiguredElement;
import com.android.tools.idea.editors.theme.qualifiers.QualifierUtils;
import com.android.tools.idea.editors.theme.qualifiers.RestrictedEnum;
import com.android.tools.idea.editors.theme.qualifiers.RestrictedLocale;
import com.android.tools.idea.editors.theme.qualifiers.RestrictedQualifier;
import com.android.tools.idea.editors.theme.qualifiers.RestrictedValue;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RestrictedConfiguration {
    private final RestrictedQualifier[] myRestrictedQualifiers = new RestrictedQualifier[FolderConfiguration.getQualifierCount()];
    private final Class<? extends ResourceQualifier>[] myQualifiersClasses = new Class[FolderConfiguration.getQualifierCount()];

    public RestrictedConfiguration() {
        FolderConfiguration configuration = FolderConfiguration.createDefault();
        for (int i2 = 0; i2 < FolderConfiguration.getQualifierCount(); ++i2) {
            ResourceQualifier qualifier = configuration.getQualifier(i2);
            assert (qualifier != null);
            this.myQualifiersClasses[i2] = qualifier.getClass();
            if (this.myQualifiersClasses[i2].equals(LocaleQualifier.class)) {
                this.myRestrictedQualifiers[i2] = new RestrictedLocale();
                continue;
            }
            if (this.myQualifiersClasses[i2].equals(VersionQualifier.class)) {
                this.myRestrictedQualifiers[i2] = new RestrictedValue();
                continue;
            }
            Class getValueType = QualifierUtils.getValueReturnType(this.myQualifiersClasses[i2]);
            if (getValueType == null) continue;
            if (getValueType.equals(Integer.TYPE)) {
                this.myRestrictedQualifiers[i2] = new RestrictedValue();
                continue;
            }
            assert (Arrays.asList(getValueType.getInterfaces()).contains(ResourceEnum.class));
            this.myRestrictedQualifiers[i2] = new RestrictedEnum(getValueType);
        }
    }

    @Nullable
    public RestrictedConfiguration intersect(@NotNull RestrictedConfiguration otherRestricted) {
        RestrictedConfiguration resultRestricted = new RestrictedConfiguration();
        for (int i2 = 0; i2 < FolderConfiguration.getQualifierCount(); ++i2) {
            RestrictedQualifier thisQualifier = this.myRestrictedQualifiers[i2];
            RestrictedQualifier otherQualifier = otherRestricted.myRestrictedQualifiers[i2];
            if (thisQualifier == null) {
                assert (otherQualifier == null);
                continue;
            }
            RestrictedQualifier intersection = thisQualifier.intersect(otherQualifier);
            if (intersection == null) {
                return null;
            }
            resultRestricted.myRestrictedQualifiers[i2] = intersection;
        }
        return resultRestricted;
    }

    @NotNull
    public FolderConfiguration getAny() {
        FolderConfiguration configuration = new FolderConfiguration();
        for (int i2 = 0; i2 < FolderConfiguration.getQualifierCount(); ++i2) {
            Object value2;
            if (this.myRestrictedQualifiers[i2] == null || (value2 = this.myRestrictedQualifiers[i2].getAny()) == null) continue;
            configuration.addQualifier(QualifierUtils.createNewResourceQualifier(this.myQualifiersClasses[i2], value2));
        }
        return configuration;
    }

    @Nullable
    public static RestrictedConfiguration restrict(@NotNull FolderConfiguration compatible, @NotNull Collection<FolderConfiguration> incompatibles) {
        RestrictedConfiguration restricted = new RestrictedConfiguration();
        if (incompatibles.isEmpty()) {
            return restricted;
        }
        ArrayList matchingIncompatibles = Lists.newArrayList(incompatibles);
        for (int qualifierIndex = 0; qualifierIndex < FolderConfiguration.getQualifierCount(); ++qualifierIndex) {
            ResourceQualifier compatibleQualifier = compatible.getQualifier(qualifierIndex);
            RestrictedQualifier restrictedQualifier = restricted.myRestrictedQualifiers[qualifierIndex];
            ArrayList incompatibleQualifiers = Lists.newArrayList();
            for (FolderConfiguration matching : matchingIncompatibles) {
                ResourceQualifier qualifier = matching.getQualifier(qualifierIndex);
                if (!ResourceQualifier.isValid((ResourceQualifier)qualifier)) continue;
                incompatibleQualifiers.add(qualifier);
            }
            if (!ResourceQualifier.isValid((ResourceQualifier)compatibleQualifier) && incompatibleQualifiers.isEmpty()) continue;
            assert (restrictedQualifier != null);
            restrictedQualifier.setRestrictions(compatibleQualifier, incompatibleQualifiers);
            if (restrictedQualifier.isEmpty()) {
                return null;
            }
            Iterator matchingIterator = matchingIncompatibles.iterator();
            while (matchingIterator.hasNext()) {
                ResourceQualifier incompatibleQualifier = ((FolderConfiguration)matchingIterator.next()).getQualifier(qualifierIndex);
                if (compatibleQualifier != null && !restrictedQualifier.isMatchFor(incompatibleQualifier)) {
                    matchingIterator.remove();
                    continue;
                }
                if (compatibleQualifier != null || incompatibleQualifier == null) continue;
                matchingIterator.remove();
            }
            if (!matchingIncompatibles.isEmpty()) continue;
            return restricted;
        }
        return null;
    }

    @Nullable
    public static <T> FolderConfiguration restrict(@NotNull ConfiguredElement<T> compatible, Collection<ConfiguredElement<T>> allItems) {
        ArrayList incompatibleConfigurations = Lists.newArrayListWithCapacity((int)allItems.size());
        boolean found = false;
        for (ConfiguredElement<T> configuredItem : allItems) {
            FolderConfiguration configuration = configuredItem.getConfiguration();
            if (configuredItem.equals(compatible)) {
                found = true;
                continue;
            }
            incompatibleConfigurations.add(configuration);
        }
        assert (found);
        RestrictedConfiguration restricted = RestrictedConfiguration.restrict(compatible.getConfiguration(), incompatibleConfigurations);
        return restricted != null ? restricted.getAny() : null;
    }
}

