/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.qualifiers;

import com.android.ide.common.resources.configuration.ResourceQualifier;
import com.android.resources.ResourceEnum;
import com.android.tools.idea.editors.theme.qualifiers.QualifierUtils;
import com.android.tools.idea.editors.theme.qualifiers.RestrictedQualifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RestrictedEnum
implements RestrictedQualifier {
    private final Class<? extends ResourceEnum> myEnumClass;
    private final EnumSet<? extends ResourceEnum> myPossibleValues;

    public RestrictedEnum(@NotNull Class<? extends ResourceEnum> enumClass) {
        this.myPossibleValues = EnumSet.copyOf(Arrays.asList(enumClass.getEnumConstants()));
        this.myEnumClass = enumClass;
    }

    @NotNull
    private static ResourceEnum getValue(@NotNull ResourceQualifier qualifier) {
        return (ResourceEnum)QualifierUtils.getValue(qualifier);
    }

    @Override
    public void setRestrictions(@Nullable ResourceQualifier compatible, @NotNull Collection<ResourceQualifier> incompatibles) {
        if (ResourceQualifier.isValid((ResourceQualifier)compatible)) {
            this.myPossibleValues.clear();
            this.myPossibleValues.addAll(Collections.singletonList(RestrictedEnum.getValue(compatible)));
        } else {
            for (ResourceQualifier qualifier : incompatibles) {
                if (!qualifier.isValid()) continue;
                this.myPossibleValues.remove(RestrictedEnum.getValue(qualifier));
            }
        }
    }

    @Override
    public boolean isMatchFor(@Nullable ResourceQualifier qualifier) {
        if (!ResourceQualifier.isValid((ResourceQualifier)qualifier)) {
            return false;
        }
        return this.myPossibleValues.contains(RestrictedEnum.getValue(qualifier));
    }

    @Override
    public boolean isEmpty() {
        return this.myPossibleValues.isEmpty();
    }

    @Override
    @Nullable
    public Object getAny() {
        assert (!this.myPossibleValues.isEmpty());
        if (this.myEnumClass.getEnumConstants().length == this.myPossibleValues.size()) {
            return null;
        }
        return this.myPossibleValues.iterator().next();
    }

    @Override
    @Nullable
    public RestrictedQualifier intersect(@NotNull RestrictedQualifier otherRestricted) {
        assert (otherRestricted instanceof RestrictedEnum);
        RestrictedEnum otherRestrictedEnum = (RestrictedEnum)otherRestricted;
        assert (this.myEnumClass.equals(otherRestrictedEnum.myEnumClass));
        RestrictedEnum result2 = new RestrictedEnum(this.myEnumClass);
        result2.myPossibleValues.retainAll(this.myPossibleValues);
        result2.myPossibleValues.retainAll(otherRestrictedEnum.myPossibleValues);
        if (result2.myPossibleValues.isEmpty()) {
            return null;
        }
        return result2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RestrictedEnum that = (RestrictedEnum)o;
        if (!this.myPossibleValues.equals(that.myPossibleValues)) {
            return false;
        }
        return this.myEnumClass.equals(that.myEnumClass);
    }

    public int hashCode() {
        int result2 = this.myPossibleValues.hashCode();
        result2 = 31 * result2 + this.myEnumClass.hashCode();
        return result2;
    }
}

