/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.qualifiers;

import com.android.ide.common.resources.configuration.ResourceQualifier;
import com.android.ide.common.resources.configuration.VersionQualifier;
import com.android.tools.idea.editors.theme.qualifiers.QualifierUtils;
import com.android.tools.idea.editors.theme.qualifiers.RestrictedQualifier;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RestrictedValue
implements RestrictedQualifier {
    private int myMinValue;
    private int myMaxValue;

    RestrictedValue() {
        this.myMinValue = 0;
        this.myMaxValue = Integer.MAX_VALUE;
    }

    RestrictedValue(int minValue, int maxValue) {
        this.myMinValue = minValue;
        this.myMaxValue = maxValue;
    }

    private static int getValue(ResourceQualifier qualifier) {
        if (qualifier instanceof VersionQualifier) {
            return ((VersionQualifier)qualifier).getVersion();
        }
        return (Integer)QualifierUtils.getValue(qualifier);
    }

    @Override
    public void setRestrictions(@Nullable ResourceQualifier compatible, @NotNull Collection<ResourceQualifier> incompatibles) {
        if (compatible != null) {
            this.myMinValue = RestrictedValue.getValue(compatible);
        }
        for (ResourceQualifier qualifier : incompatibles) {
            int value2 = RestrictedValue.getValue(qualifier);
            if (value2 <= this.myMinValue) continue;
            this.myMaxValue = Math.min(this.myMaxValue, value2 - 1);
        }
    }

    @Override
    public boolean isMatchFor(@Nullable ResourceQualifier qualifier) {
        if (qualifier == null) {
            return false;
        }
        int value2 = RestrictedValue.getValue(qualifier);
        return this.myMinValue <= value2 && value2 <= this.myMaxValue;
    }

    @Override
    public boolean isEmpty() {
        return this.myMinValue > this.myMaxValue;
    }

    @Override
    @Nullable
    public Object getAny() {
        if (this.myMinValue == 0 && this.myMaxValue == Integer.MAX_VALUE) {
            return null;
        }
        if (this.myMaxValue != Integer.MAX_VALUE) {
            return this.myMaxValue;
        }
        return this.myMinValue;
    }

    @Override
    @Nullable
    public RestrictedQualifier intersect(@NotNull RestrictedQualifier otherRestricted) {
        int resultMaxValue;
        assert (otherRestricted instanceof RestrictedValue);
        int resultMinValue = Math.max(this.myMinValue, ((RestrictedValue)otherRestricted).myMinValue);
        if (resultMinValue > (resultMaxValue = Math.min(this.myMaxValue, ((RestrictedValue)otherRestricted).myMaxValue))) {
            return null;
        }
        return new RestrictedValue(resultMinValue, resultMaxValue);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RestrictedValue that = (RestrictedValue)o;
        if (this.myMinValue != that.myMinValue) {
            return false;
        }
        return this.myMaxValue == that.myMaxValue;
    }

    public int hashCode() {
        int result2 = this.myMinValue;
        result2 = 31 * result2 + this.myMaxValue;
        return result2;
    }
}

