/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.experimental.codeanalysis.datastructs.graph.node.impl;

import com.android.tools.idea.experimental.codeanalysis.datastructs.graph.BlockGraph;
import com.android.tools.idea.experimental.codeanalysis.datastructs.graph.node.GraphNode;
import com.android.tools.idea.experimental.codeanalysis.datastructs.stmt.Stmt;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class GraphNodeImpl
implements GraphNode {
    protected BlockGraph mBlockGraph;
    protected Set<GraphNode> mInNodes;
    protected Set<GraphNode> mOutNodes;
    protected ArrayList<Stmt> mStmtList;
    protected boolean mContainsInvoke;
    public static GraphNodeImpl[] EMPTY_ARRAY = new GraphNodeImpl[0];

    @Override
    public Stmt[] getStatements() {
        return this.mStmtList.toArray(Stmt.EMPTY_ARRAY);
    }

    @Override
    public BlockGraph getParentGraph() {
        return this.mBlockGraph;
    }

    @Override
    public String getSimpleName() {
        StringBuilder sb = new StringBuilder();
        if (this.mStmtList != null && !this.mStmtList.isEmpty()) {
            for (Stmt stmt : this.mStmtList) {
                sb.append(stmt.getSimpleName() + "\\n");
            }
        } else {
            sb.append("Statement: 0");
        }
        return sb.toString();
    }

    @Override
    public boolean containsInvocation() {
        return this.mContainsInvoke;
    }

    public void setInvocation() {
        this.mContainsInvoke = true;
    }

    @Override
    public GraphNode[] getIn() {
        return this.mInNodes.toArray(GraphNode.EMPTY_ARRAY);
    }

    @Override
    public GraphNode[] getOut() {
        return this.mOutNodes.toArray(GraphNode.EMPTY_ARRAY);
    }

    @Override
    public void addIn(@NotNull GraphNode target) {
        this.mInNodes.add(target);
    }

    @Override
    public void addOut(@NotNull GraphNode target) {
        this.mOutNodes.add(target);
    }

    @Override
    public void removeIn(@NotNull GraphNode target) {
        this.mInNodes.remove(target);
    }

    public ArrayList<Stmt> getStmtList() {
        return this.mStmtList;
    }

    @Override
    public void removeOut(GraphNode target) {
        this.mOutNodes.remove(target);
    }

    public GraphNodeImpl(BlockGraph parentGraph) {
        this.mBlockGraph = parentGraph;
        this.mInNodes = Sets.newHashSet();
        this.mOutNodes = Sets.newHashSet();
        this.mStmtList = Lists.newArrayList();
        this.mContainsInvoke = false;
    }

    public GraphNodeImpl() {
    }
}

