/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.experimental.codeanalysis.utils;

import com.android.tools.idea.experimental.codeanalysis.PsiCFGScene;
import com.android.tools.idea.experimental.codeanalysis.datastructs.PsiCFGClass;
import com.android.tools.idea.experimental.codeanalysis.datastructs.PsiCFGField;
import com.android.tools.idea.experimental.codeanalysis.datastructs.PsiCFGMethod;
import com.android.tools.idea.experimental.codeanalysis.datastructs.graph.BlockGraph;
import com.android.tools.idea.experimental.codeanalysis.datastructs.graph.Graph;
import com.android.tools.idea.experimental.codeanalysis.datastructs.graph.MethodGraph;
import com.android.tools.idea.experimental.codeanalysis.datastructs.graph.SwitchCaseGraph;
import com.android.tools.idea.experimental.codeanalysis.datastructs.graph.impl.BlockGraphImpl;
import com.android.tools.idea.experimental.codeanalysis.datastructs.graph.impl.MethodGraphImpl;
import com.android.tools.idea.experimental.codeanalysis.datastructs.graph.impl.SwitchCaseGraphImpl;
import com.android.tools.idea.experimental.codeanalysis.datastructs.graph.impl.SynchronizedBlockGraphImpl;
import com.android.tools.idea.experimental.codeanalysis.datastructs.graph.node.GraphNode;
import com.android.tools.idea.experimental.codeanalysis.datastructs.graph.node.GraphNodeUtil;
import com.android.tools.idea.experimental.codeanalysis.datastructs.graph.node.SwitchBranchingNode;
import com.android.tools.idea.experimental.codeanalysis.datastructs.graph.node.impl.BlockGraphEntryNodeImpl;
import com.android.tools.idea.experimental.codeanalysis.datastructs.graph.node.impl.BlockGraphExitNodeImpl;
import com.android.tools.idea.experimental.codeanalysis.datastructs.graph.node.impl.BreakBranchingNodeImpl;
import com.android.tools.idea.experimental.codeanalysis.datastructs.graph.node.impl.CaseNodeImpl;
import com.android.tools.idea.experimental.codeanalysis.datastructs.graph.node.impl.ConditionCheckNodeImpl;
import com.android.tools.idea.experimental.codeanalysis.datastructs.graph.node.impl.ContinueBranchingNodeImpl;
import com.android.tools.idea.experimental.codeanalysis.datastructs.graph.node.impl.GraphNodeImpl;
import com.android.tools.idea.experimental.codeanalysis.datastructs.graph.node.impl.IfBranchingNodeImpl;
import com.android.tools.idea.experimental.codeanalysis.datastructs.graph.node.impl.LoopBranchingNodeImpl;
import com.android.tools.idea.experimental.codeanalysis.datastructs.graph.node.impl.SwitchBranchingNodeImpl;
import com.android.tools.idea.experimental.codeanalysis.datastructs.stmt.AssignStmt;
import com.android.tools.idea.experimental.codeanalysis.datastructs.stmt.Stmt;
import com.android.tools.idea.experimental.codeanalysis.datastructs.stmt.impl.AssignStmtImpl;
import com.android.tools.idea.experimental.codeanalysis.datastructs.stmt.impl.DeclarationStmtImpl;
import com.android.tools.idea.experimental.codeanalysis.datastructs.stmt.impl.ReturnStmtImpl;
import com.android.tools.idea.experimental.codeanalysis.datastructs.value.Local;
import com.android.tools.idea.experimental.codeanalysis.datastructs.value.NewExpr;
import com.android.tools.idea.experimental.codeanalysis.datastructs.value.Param;
import com.android.tools.idea.experimental.codeanalysis.datastructs.value.SynthesizedLocal;
import com.android.tools.idea.experimental.codeanalysis.datastructs.value.Value;
import com.android.tools.idea.experimental.codeanalysis.datastructs.value.impl.ArrayAccessRefImpl;
import com.android.tools.idea.experimental.codeanalysis.datastructs.value.impl.BinopExprImpl;
import com.android.tools.idea.experimental.codeanalysis.datastructs.value.impl.CastExprImpl;
import com.android.tools.idea.experimental.codeanalysis.datastructs.value.impl.ConstantImpl;
import com.android.tools.idea.experimental.codeanalysis.datastructs.value.impl.DummyRef;
import com.android.tools.idea.experimental.codeanalysis.datastructs.value.impl.InstanceFieldRefImpl;
import com.android.tools.idea.experimental.codeanalysis.datastructs.value.impl.InstanceInvokeExprImpl;
import com.android.tools.idea.experimental.codeanalysis.datastructs.value.impl.InstanceOfExprImpl;
import com.android.tools.idea.experimental.codeanalysis.datastructs.value.impl.LocalImpl;
import com.android.tools.idea.experimental.codeanalysis.datastructs.value.impl.NewExprImpl;
import com.android.tools.idea.experimental.codeanalysis.datastructs.value.impl.ParamImpl;
import com.android.tools.idea.experimental.codeanalysis.datastructs.value.impl.PolyadicExprImpl;
import com.android.tools.idea.experimental.codeanalysis.datastructs.value.impl.PostfixExprImpl;
import com.android.tools.idea.experimental.codeanalysis.datastructs.value.impl.PrefixExprImpl;
import com.android.tools.idea.experimental.codeanalysis.datastructs.value.impl.StaticFieldRefImpl;
import com.android.tools.idea.experimental.codeanalysis.datastructs.value.impl.StaticInvokeExprImpl;
import com.android.tools.idea.experimental.codeanalysis.datastructs.value.impl.SynthesizedLocalImpl;
import com.android.tools.idea.experimental.codeanalysis.datastructs.value.impl.ThisRefImpl;
import com.android.tools.idea.experimental.codeanalysis.utils.PsiCFGDebugUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Map;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CFGBuilder {
    protected PsiCFGScene mScene;
    protected BlockGraph mGraph;
    protected PsiCodeBlock psiCodeBlock;
    protected PsiCFGClass containerClass;
    protected PsiStatement[] mStatementList;
    protected ArrayList<GraphNode> returnNodeList;
    protected ArrayList<GraphNode> breakNodeList;
    private ArrayList<GraphNode> curWorkingNodeList;
    protected Stack<GraphNode> mNestedStack;
    protected Map<GraphNode, PsiIdentifier> mLabelMap;
    protected boolean mSwitchBlock = false;
    protected boolean mLambda = false;
    protected PsiExpression mLambdaBody;

    public CFGBuilder(PsiCFGScene scene, BlockGraph bg, PsiCFGClass cfgClass, PsiCodeBlock cb) {
        this.mScene = scene;
        this.containerClass = cfgClass;
        this.mGraph = bg;
        this.psiCodeBlock = cb;
        this.mStatementList = null;
        this.curWorkingNodeList = Lists.newArrayList();
        this.mLambdaBody = null;
        if (bg instanceof MethodGraph) {
            this.mNestedStack = new Stack();
            this.mLabelMap = Maps.newHashMap();
        } else {
            this.mNestedStack = null;
            this.mLabelMap = null;
        }
    }

    public CFGBuilder(PsiCFGScene scene, BlockGraph bg, PsiCFGClass cfgClass, PsiStatement[] statementList) {
        this.mScene = scene;
        this.containerClass = cfgClass;
        this.mGraph = bg;
        this.psiCodeBlock = null;
        this.mStatementList = statementList;
        this.curWorkingNodeList = Lists.newArrayList();
        this.mLambdaBody = null;
        if (bg instanceof MethodGraph) {
            this.mNestedStack = new Stack();
            this.mLabelMap = Maps.newHashMap();
        } else {
            this.mNestedStack = null;
            this.mLabelMap = null;
        }
    }

    public CFGBuilder(PsiCFGScene scene, BlockGraph bg, PsiCFGClass cfgClass, PsiExpression lambdaBody) {
        this.mScene = scene;
        this.containerClass = cfgClass;
        this.mGraph = bg;
        this.psiCodeBlock = null;
        this.mStatementList = null;
        this.mLambdaBody = lambdaBody;
        this.curWorkingNodeList = Lists.newArrayList();
        if (bg instanceof MethodGraph) {
            this.mNestedStack = new Stack();
            this.mLabelMap = Maps.newHashMap();
        } else {
            this.mNestedStack = null;
            this.mLabelMap = null;
        }
    }

    public void setLambdaFlag() {
        this.mLambda = true;
    }

    private void setGraphEntryExitTag(@NotNull BlockGraph graph, @NotNull String tag) {
        GraphNode entry = graph.getEntryNode();
        GraphNode exit = graph.getExitNode();
        if (entry instanceof BlockGraphEntryNodeImpl) {
            ((BlockGraphEntryNodeImpl)entry).setTag(tag);
        }
        if (exit instanceof BlockGraphExitNodeImpl) {
            ((BlockGraphExitNodeImpl)exit).setTag(tag);
        }
    }

    public void setNestedStack(@NotNull Stack<GraphNode> loopStack) {
        this.mNestedStack = loopStack;
    }

    public void setNestedLabelMap(Map<GraphNode, PsiIdentifier> loopLabelMap) {
        this.mLabelMap = loopLabelMap;
    }

    public void build() {
        if (this.mLambdaBody != null) {
            this.buildWSingleLambdaExpr();
        } else if (this.mGraph instanceof SwitchCaseGraph) {
            this.buildWSwitch();
        } else {
            this.buildWOSwitch();
        }
    }

    public void buildWSingleLambdaExpr() {
        this.curWorkingNodeList.clear();
        this.curWorkingNodeList.add(this.mGraph.getEntryNode());
        Value exprValue = this.dfsExpressionBuilder(this.mLambdaBody);
        ReturnStmtImpl returnStmt = new ReturnStmtImpl(exprValue, null);
        GraphNodeImpl returnNode = new GraphNodeImpl(this.mGraph);
        returnNode.getStmtList().add(returnStmt);
        this.connectCurrentWorkingNode(returnNode);
        GraphNodeUtil.connectGraphNode(returnNode, this.mGraph.getExitNode());
    }

    public void buildWSwitch() {
        this.curWorkingNodeList.clear();
        PsiStatement[] firstLevelChildren = this.psiCodeBlock.getStatements();
        for (int i2 = 0; i2 < firstLevelChildren.length; ++i2) {
            PsiStatement statement = firstLevelChildren[i2];
            if (statement instanceof PsiSwitchLabelStatement) {
                this.dfsPsiSwitchLabelStatementBuilder((PsiSwitchLabelStatement)statement);
                continue;
            }
            if (this.isNonBranchingStatement(statement)) {
                this.buildNonBranchingStatements(statement);
                continue;
            }
            this.buildBranchingStatements(statement);
        }
        GraphNode switchExit = this.mGraph.getExitNode();
        if (!this.curWorkingNodeList.isEmpty()) {
            for (GraphNode node : this.curWorkingNodeList) {
                if (node.equals(switchExit)) continue;
                GraphNodeUtil.connectGraphNode(node, switchExit);
            }
        }
    }

    public void buildWOSwitch() {
        PsiStatement[] firstLevelChildren = this.mStatementList;
        if (this.psiCodeBlock != null) {
            firstLevelChildren = this.psiCodeBlock.getStatements();
        }
        if (firstLevelChildren.length == 0) {
            GraphNodeUtil.connectGraphNode(this.mGraph.getEntryNode(), this.mGraph.getExitNode());
            return;
        }
        this.curWorkingNodeList.clear();
        this.curWorkingNodeList.add(this.mGraph.getEntryNode());
        for (PsiStatement curPsiStmt : firstLevelChildren) {
            if (this.isWorkingNodeConsiderUnreachable(this.curWorkingNodeList)) {
                this.curWorkingNodeList.clear();
                this.curWorkingNodeList.add(this.mGraph.getUnreachableNodeEntry());
            }
            if (this.isNonBranchingStatement(curPsiStmt)) {
                this.buildNonBranchingStatements(curPsiStmt);
                continue;
            }
            this.buildBranchingStatements(curPsiStmt);
        }
        GraphNode curExit = this.mGraph.getExitNode();
        for (GraphNode node : this.curWorkingNodeList) {
            if (node.equals(curExit)) continue;
            GraphNodeUtil.connectGraphNode(node, curExit);
        }
    }

    public boolean isWorkingNodeConsiderUnreachable(ArrayList<GraphNode> workingNodes) {
        boolean retVal = true;
        for (GraphNode curNode : workingNodes) {
            if (curNode == null) continue;
            return false;
        }
        return retVal;
    }

    public void buildNonBranchingStatements(PsiStatement statement) {
        if (statement instanceof PsiDeclarationStatement) {
            this.dfsDeclarationStatementBuilder((PsiDeclarationStatement)statement);
        } else if (statement instanceof PsiExpressionStatement) {
            this.dfsExpressionStatementBuilder((PsiExpressionStatement)statement);
        } else if (statement instanceof PsiExpressionListStatement) {
            this.dfsExpressionListStatementBuilder((PsiExpressionListStatement)statement);
        } else if (!(statement instanceof PsiEmptyStatement)) {
            PsiCFGDebugUtil.LOG.warning("Not Implemented for statement " + statement.toString());
        }
    }

    @Nullable
    private Param resolveParam(@NotNull PsiParameter param) {
        BlockGraph graph = this.mGraph;
        if (graph instanceof BlockGraph) {
            Param p = graph.getParamFromPsiParameter(param);
            if (p == null) {
                if (graph instanceof MethodGraph) {
                    MethodGraph methodGraph = (MethodGraph)graph;
                    PsiCFGDebugUtil.LOG.warning("Parameter " + param.getName() + " does not exist in method " + methodGraph.getPsiCFGMethod().getName() + " in class " + this.containerClass.getQualifiedClassName());
                } else {
                    PsiStatement psiStmt = graph.getParentStmt();
                    PsiCFGDebugUtil.LOG.warning("Parameter " + param.getName() + " does not exist in context " + psiStmt.getText() + " in class " + this.containerClass.getQualifiedClassName());
                }
            }
            return p;
        }
        PsiCFGDebugUtil.LOG.warning("Parameter " + param.getName() + " does not exist, the graph is not a block graph");
        return null;
    }

    @Nullable
    private Local resolveLocal(@NotNull PsiLocalVariable localVar) {
        Local l = this.mGraph.getLocalFromPsiLocal(localVar);
        if (l != null) {
            return l;
        }
        if (this.containerClass.isNested()) {
            BlockGraph parentBlock = this.containerClass.getDeclaringBlock();
            l = parentBlock.getLocalFromPsiLocal(localVar);
        }
        if (l == null) {
            PsiCFGDebugUtil.LOG.warning(String.format("Local %s cannot be resolved in Class %s", localVar.getText(), this.containerClass.getQualifiedClassName()));
        }
        return l;
    }

    @NotNull
    private PsiType retrieveTypeByPsiClass(@NotNull PsiClass clazz) {
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.mScene.getProject()).getElementFactory();
        PsiClassType retType = factory.createType(clazz);
        return retType;
    }

    @NotNull
    private PsiCFGMethod retrieveDeclaringMethod() {
        Graph graph;
        for (graph = this.mGraph; graph != null && !(graph instanceof MethodGraphImpl); graph = graph.getParentGraph()) {
        }
        if (graph == null) {
            throw new RuntimeException("Cannot find declaring method: ");
        }
        MethodGraphImpl methodGraph = (MethodGraphImpl)graph;
        return methodGraph.getPsiCFGMethod();
    }

    private boolean isNonBranchingStatement(PsiStatement statement) {
        if (statement instanceof PsiDeclarationStatement) {
            return true;
        }
        if (statement instanceof PsiExpressionStatement) {
            return true;
        }
        if (statement instanceof PsiExpressionListStatement) {
            return true;
        }
        return statement instanceof PsiEmptyStatement;
    }

    public void dfsPsiLabeledStatementBuilder(PsiLabeledStatement statement) {
        PsiStatement labeledStatement = statement.getStatement();
        PsiIdentifier label = statement.getLabelIdentifier();
        if (labeledStatement instanceof PsiBreakStatement) {
            return;
        }
        if (labeledStatement instanceof PsiLoopStatement) {
            this.dfsPsiLoopStatementBuilder((PsiLoopStatement)labeledStatement, label);
        }
        if (this.isNonBranchingStatement(labeledStatement)) {
            this.buildNonBranchingStatements(labeledStatement);
        } else {
            this.buildBranchingStatements(labeledStatement);
        }
    }

    public void dfsPsiSwitchLabelStatementBuilder(PsiSwitchLabelStatement statement) {
        PsiExpression caseValueExpr = statement.getCaseValue();
        if (!(this.mGraph instanceof SwitchCaseGraph)) {
            PsiCFGDebugUtil.LOG.warning("Case statement out side of switch in :");
            PsiCFGDebugUtil.debugOutputPsiElement((PsiElement)statement);
            return;
        }
        SwitchCaseGraphImpl switchGraph = (SwitchCaseGraphImpl)this.mGraph;
        SwitchBranchingNodeImpl switchNode = (SwitchBranchingNodeImpl)switchGraph.getSwitchBranchingNode();
        CaseNodeImpl curCaseNode = new CaseNodeImpl(this.mGraph);
        if (statement.isDefaultCase()) {
            curCaseNode.setDefault();
            switchNode.setDefaultTarget(curCaseNode);
        } else {
            Value caseValue;
            if (caseValueExpr == null) {
                PsiCFGDebugUtil.LOG.warning("CaseExpr is null in " + statement.getText());
                return;
            }
            if (caseValueExpr instanceof PsiLiteralExpression) {
                caseValue = this.dfsLiteralExpressionBuilder((PsiLiteralExpression)caseValueExpr);
            } else if (caseValueExpr instanceof PsiReferenceExpression) {
                caseValue = this.dfsRHSReferenceExpressionBuilder((PsiReferenceExpression)caseValueExpr);
            } else {
                PsiCFGDebugUtil.LOG.warning("Case is not using a constant or reference");
                PsiCFGDebugUtil.debugOutputPsiElement((PsiElement)caseValueExpr);
                caseValue = new DummyRef(caseValueExpr.getType(), (PsiElement)caseValueExpr);
            }
            curCaseNode.setLabelValue(caseValue);
            switchNode.setTargetViaKey(caseValue, curCaseNode);
        }
        switchGraph.addCase(curCaseNode);
        if (!this.curWorkingNodeList.isEmpty()) {
            this.connectCurrentWorkingNode(curCaseNode);
        }
        this.curWorkingNodeList.clear();
        this.curWorkingNodeList.add(curCaseNode);
    }

    public void dfsPsiIfStatementBuilder(PsiIfStatement statement) {
        CFGBuilder thenBranchBuilder;
        PsiExpression conditionExpression = statement.getCondition();
        PsiStatement psiThenStmt = statement.getThenBranch();
        PsiStatement psiElseStmt = statement.getElseBranch();
        assert (conditionExpression != null);
        Value conditionExprLocal = this.dfsExpressionBuilder(conditionExpression);
        assert (psiThenStmt != null);
        BlockGraphImpl thenBranchGraph = new BlockGraphImpl();
        this.setGraphEntryExitTag(thenBranchGraph, "[IF THEN]");
        thenBranchGraph.setParentGraph(this.mGraph);
        thenBranchGraph.setParentStmt((PsiStatement)statement);
        if (psiThenStmt instanceof PsiBlockStatement) {
            PsiCodeBlock psiThenBlock = ((PsiBlockStatement)psiThenStmt).getCodeBlock();
            thenBranchBuilder = new CFGBuilder(this.mScene, (BlockGraph)thenBranchGraph, this.containerClass, psiThenBlock);
        } else {
            PsiStatement[] thenBranchStmtArray = new PsiStatement[]{psiThenStmt};
            thenBranchBuilder = new CFGBuilder(this.mScene, (BlockGraph)thenBranchGraph, this.containerClass, thenBranchStmtArray);
        }
        thenBranchBuilder.setNestedLabelMap(this.mLabelMap);
        thenBranchBuilder.setNestedStack(this.mNestedStack);
        thenBranchBuilder.build();
        BlockGraphImpl elseBranchGraph = null;
        if (psiElseStmt != null) {
            CFGBuilder elseBranchBuilder;
            elseBranchGraph = new BlockGraphImpl();
            this.setGraphEntryExitTag(elseBranchGraph, "[IF ELSE]");
            elseBranchGraph.setParentGraph(this.mGraph);
            elseBranchGraph.setParentStmt((PsiStatement)statement);
            if (psiElseStmt instanceof PsiBlockStatement) {
                PsiCodeBlock psiElseBlock = ((PsiBlockStatement)psiElseStmt).getCodeBlock();
                elseBranchBuilder = new CFGBuilder(this.mScene, (BlockGraph)elseBranchGraph, this.containerClass, psiElseBlock);
            } else {
                PsiStatement[] elseBranchStmtArray = new PsiStatement[]{psiElseStmt};
                elseBranchBuilder = new CFGBuilder(this.mScene, (BlockGraph)elseBranchGraph, this.containerClass, elseBranchStmtArray);
            }
            elseBranchBuilder.setNestedLabelMap(this.mLabelMap);
            elseBranchBuilder.setNestedStack(this.mNestedStack);
            elseBranchBuilder.build();
        }
        IfBranchingNodeImpl ifNode = new IfBranchingNodeImpl(this.mGraph, conditionExprLocal, thenBranchGraph, elseBranchGraph);
        this.connectCurrentWorkingNode(ifNode);
        this.curWorkingNodeList.clear();
        if (thenBranchGraph.getExitNode().getIn().length > 0) {
            this.curWorkingNodeList.add(thenBranchGraph.getExitNode());
        }
        if (elseBranchGraph != null) {
            if (elseBranchGraph.getExitNode().getIn().length > 0) {
                this.curWorkingNodeList.add(elseBranchGraph.getExitNode());
            }
        } else {
            this.curWorkingNodeList.add(ifNode.getFalseBranch());
        }
    }

    private void pushLoopNode(LoopBranchingNodeImpl loopNode, PsiIdentifier id) {
        this.mNestedStack.push(loopNode);
        this.mLabelMap.put(loopNode, id);
    }

    private void popLoopNode() {
        GraphNode topNode = this.mNestedStack.pop();
        this.mLabelMap.remove(topNode);
    }

    public void dfsPsiForStatementBuilder(@NotNull PsiForStatement statement, @Nullable PsiIdentifier label) {
        PsiStatement loopBody = statement.getBody();
        int loopType = 0;
        PsiForStatement forStmt = statement;
        PsiStatement initStmt = forStmt.getInitialization();
        if (initStmt != null) {
            this.buildNonBranchingStatements(initStmt);
        }
        LoopBranchingNodeImpl loopNode = new LoopBranchingNodeImpl(this.mGraph, loopType);
        this.connectCurrentWorkingNode(loopNode);
        this.pushLoopNode(loopNode, label);
        PsiExpression psiConditionCheckCode = forStmt.getCondition();
        Value finalCheckVal = this.dfsExpressionBuilder(psiConditionCheckCode);
        ConditionCheckNodeImpl conditionCheckExit = new ConditionCheckNodeImpl(this.mGraph, finalCheckVal);
        GraphNode conditionCheckEntry = loopNode.getOut().length == 0 ? conditionCheckExit : loopNode.getOut()[0];
        this.connectCurrentWorkingNode(conditionCheckExit);
        BlockGraph loopBodyGraph = this.loopbodyBuilder(loopBody, (PsiStatement)statement);
        GraphNodeUtil.connectGraphNode(conditionCheckExit.getTrueBranch(), loopBodyGraph.getEntryNode());
        this.curWorkingNodeList.clear();
        this.curWorkingNodeList.add(loopBodyGraph.getExitNode());
        PsiStatement postLoopUpdateStatment = forStmt.getUpdate();
        this.buildNonBranchingStatements(postLoopUpdateStatment);
        GraphNode postLoopEntry = loopBodyGraph.getExitNode().getOut()[0];
        GraphNode postLoopExit = this.curWorkingNodeList.get(0);
        this.connectCurrentWorkingNode(conditionCheckEntry);
        this.curWorkingNodeList.clear();
        this.curWorkingNodeList.add(conditionCheckExit.getFalseBranch());
        loopNode.setConditionCheckEntry(conditionCheckEntry);
        loopNode.setConditionCheckExitNode(conditionCheckExit);
        loopNode.setPostLoopEntryNode(postLoopEntry);
        loopNode.setPostLoopExitNode(postLoopExit);
        loopNode.setLoopBody(loopBodyGraph);
        loopNode.connectSpecialNodes();
        this.popLoopNode();
    }

    public void dfsPsiWhileStatementBuilder(@NotNull PsiWhileStatement statement, @Nullable PsiIdentifier label) {
        PsiStatement loopBody = statement.getBody();
        PsiWhileStatement whileStmt = statement;
        int loopType = 1;
        LoopBranchingNodeImpl loopNode = new LoopBranchingNodeImpl(this.mGraph, loopType);
        this.connectCurrentWorkingNode(loopNode);
        this.pushLoopNode(loopNode, label);
        PsiExpression psiConditionCheckCode = whileStmt.getCondition();
        Value finalCheckVal = this.dfsExpressionBuilder(psiConditionCheckCode);
        ConditionCheckNodeImpl conditionCheckExit = new ConditionCheckNodeImpl(this.mGraph, finalCheckVal);
        GraphNode conditionCheckEntry = loopNode.getOut().length == 0 ? conditionCheckExit : loopNode.getOut()[0];
        this.connectCurrentWorkingNode(conditionCheckExit);
        BlockGraph loopBodyGraph = this.loopbodyBuilder(loopBody, (PsiStatement)statement);
        GraphNodeUtil.connectGraphNode(conditionCheckExit.getTrueBranch(), loopBodyGraph.getEntryNode());
        this.curWorkingNodeList.clear();
        this.curWorkingNodeList.add(loopBodyGraph.getExitNode());
        this.connectCurrentWorkingNode(conditionCheckEntry);
        this.curWorkingNodeList.clear();
        this.curWorkingNodeList.add(conditionCheckExit.getFalseBranch());
        loopNode.setConditionCheckEntry(conditionCheckEntry);
        loopNode.setConditionCheckExitNode(conditionCheckExit);
        loopNode.setPostLoopEntryNode(null);
        loopNode.setPostLoopExitNode(null);
        loopNode.setLoopBody(loopBodyGraph);
        loopNode.connectSpecialNodes();
        this.popLoopNode();
    }

    public void dfsPsiDoWhileStatementBuilder(@NotNull PsiDoWhileStatement statement, @Nullable PsiIdentifier label) {
        PsiStatement loopBody = statement.getBody();
        int loopType = 2;
        PsiDoWhileStatement dowhileStmt = statement;
        LoopBranchingNodeImpl loopNode = new LoopBranchingNodeImpl(this.mGraph, loopType);
        this.connectCurrentWorkingNode(loopNode);
        this.pushLoopNode(loopNode, label);
        BlockGraph loopBodyGraph = this.loopbodyBuilder(loopBody, (PsiStatement)statement);
        this.connectCurrentWorkingNode(loopBodyGraph.getEntryNode());
        this.curWorkingNodeList.clear();
        this.curWorkingNodeList.add(loopBodyGraph.getExitNode());
        PsiExpression psiConditionCheckCode = dowhileStmt.getCondition();
        Value finalCheckVal = this.dfsExpressionBuilder(psiConditionCheckCode);
        ConditionCheckNodeImpl conditionCheckExit = new ConditionCheckNodeImpl(this.mGraph, finalCheckVal);
        GraphNode conditionCheckEntry = loopBodyGraph.getExitNode().getOut().length == 0 ? conditionCheckExit : loopBodyGraph.getExitNode().getOut()[0];
        this.connectCurrentWorkingNode(conditionCheckExit);
        GraphNodeUtil.connectGraphNode(conditionCheckExit.getTrueBranch(), loopBodyGraph.getEntryNode());
        this.curWorkingNodeList.clear();
        this.curWorkingNodeList.add(conditionCheckExit.getFalseBranch());
        loopNode.setConditionCheckEntry(conditionCheckEntry);
        loopNode.setConditionCheckExitNode(conditionCheckExit);
        loopNode.setLoopBody(loopBodyGraph);
        loopNode.setPostLoopEntryNode(null);
        loopNode.setPostLoopExitNode(null);
        loopNode.connectSpecialNodes();
        this.popLoopNode();
    }

    public void dfsPsiForeachStatementBuilder(@NotNull PsiForeachStatement statement, @Nullable PsiIdentifier label) {
        PsiStatement loopBody = statement.getBody();
        int loopType = 3;
        PsiParameter iterParam = statement.getIterationParameter();
        PsiExpression iterValue = statement.getIteratedValue();
        if (iterParam == null) {
            return;
        }
        if (iterParam == null) {
            return;
        }
        Value iterV = this.dfsExpressionBuilder(iterValue);
        ParamImpl iterP = new ParamImpl(iterParam);
        LoopBranchingNodeImpl loopNode = new LoopBranchingNodeImpl(this.mGraph, loopType);
        this.connectCurrentWorkingNode(loopNode);
        this.pushLoopNode(loopNode, label);
        BlockGraph loopBodyGraph = this.loopbodyBuilder(loopBody, (PsiStatement)statement, iterParam, iterP);
        loopNode.setLoopBody(loopBodyGraph);
        loopNode.setForeachIteratorParam(iterP);
        loopNode.setForeachIteratorValue(iterV);
        GraphNodeUtil.connectGraphNode(loopNode, loopBodyGraph.getEntryNode());
        GraphNodeUtil.connectGraphNode(loopNode, loopBodyGraph.getExitNode());
        GraphNodeUtil.connectGraphNode(loopBodyGraph.getExitNode(), loopNode);
        loopNode.connectSpecialNodes();
        this.curWorkingNodeList.clear();
        this.curWorkingNodeList.add(loopBodyGraph.getExitNode());
        this.popLoopNode();
    }

    public void dfsPsiLoopStatementBuilder(@NotNull PsiLoopStatement statement, @Nullable PsiIdentifier label) {
        PsiStatement loopBody = statement.getBody();
        if (statement instanceof PsiForStatement) {
            this.dfsPsiForStatementBuilder((PsiForStatement)statement, label);
        } else if (statement instanceof PsiWhileStatement) {
            this.dfsPsiWhileStatementBuilder((PsiWhileStatement)statement, label);
        } else if (statement instanceof PsiDoWhileStatement) {
            this.dfsPsiDoWhileStatementBuilder((PsiDoWhileStatement)statement, label);
        } else if (statement instanceof PsiForeachStatement) {
            this.dfsPsiForeachStatementBuilder((PsiForeachStatement)statement, label);
        } else {
            PsiCFGDebugUtil.LOG.warning("Unknown loop:" + statement.getClass().getSimpleName());
        }
    }

    private BlockGraph loopbodyBuilder(PsiStatement statement, PsiStatement parentStatment) {
        CFGBuilder builder;
        BlockGraphImpl loopBody = new BlockGraphImpl();
        loopBody.setParentGraph(this.mGraph);
        loopBody.setParentStmt(parentStatment);
        if (statement instanceof PsiBlockStatement) {
            PsiCodeBlock block = ((PsiBlockStatement)statement).getCodeBlock();
            builder = new CFGBuilder(this.mScene, (BlockGraph)loopBody, this.containerClass, block);
        } else {
            PsiStatement[] loopStmtArray = new PsiStatement[]{statement};
            builder = new CFGBuilder(this.mScene, (BlockGraph)loopBody, this.containerClass, loopStmtArray);
        }
        builder.setNestedLabelMap(this.mLabelMap);
        builder.setNestedStack(this.mNestedStack);
        builder.build();
        this.setGraphEntryExitTag(loopBody, "[LOOP]");
        return loopBody;
    }

    private BlockGraph loopbodyBuilder(PsiStatement statement, PsiStatement parentStatment, PsiParameter psiParam, Param param) {
        CFGBuilder builder;
        BlockGraphImpl loopBody = new BlockGraphImpl();
        loopBody.addParam(psiParam, param);
        loopBody.setParentGraph(this.mGraph);
        loopBody.setParentStmt(parentStatment);
        if (statement instanceof PsiBlockStatement) {
            PsiCodeBlock block = ((PsiBlockStatement)statement).getCodeBlock();
            builder = new CFGBuilder(this.mScene, (BlockGraph)loopBody, this.containerClass, block);
        } else {
            PsiStatement[] loopStmtArray = new PsiStatement[]{statement};
            builder = new CFGBuilder(this.mScene, (BlockGraph)loopBody, this.containerClass, loopStmtArray);
        }
        builder.setNestedLabelMap(this.mLabelMap);
        builder.setNestedStack(this.mNestedStack);
        builder.build();
        this.setGraphEntryExitTag(loopBody, "[LOOP]");
        return loopBody;
    }

    public void dfsPsiBlockStatementBuilder(PsiBlockStatement statement) {
        PsiCodeBlock codeBlock = statement.getCodeBlock();
        BlockGraphImpl blockStatementGraph = new BlockGraphImpl();
        blockStatementGraph.setParentGraph(this.mGraph);
        blockStatementGraph.setParentStmt((PsiStatement)statement);
        CFGBuilder builder = new CFGBuilder(this.mScene, (BlockGraph)blockStatementGraph, this.containerClass, codeBlock);
        builder.setNestedLabelMap(this.mLabelMap);
        builder.setNestedStack(this.mNestedStack);
        builder.build();
        this.connectCurrentWorkingNode(blockStatementGraph.getEntryNode());
        this.curWorkingNodeList.clear();
        this.curWorkingNodeList.add(blockStatementGraph.getExitNode());
    }

    public void dfsPsiSynchronizedStatementBuilder(PsiSynchronizedStatement statement) {
        PsiExpression syncExpr = statement.getLockExpression();
        Value syncExprVal = this.dfsExpressionBuilder(syncExpr);
        PsiCodeBlock codeBlock = statement.getBody();
        SynchronizedBlockGraphImpl blockStatementGraph = new SynchronizedBlockGraphImpl();
        blockStatementGraph.setParentGraph(this.mGraph);
        blockStatementGraph.setParentStmt((PsiStatement)statement);
        blockStatementGraph.setSynchronizedExpression(syncExprVal);
        CFGBuilder builder = new CFGBuilder(this.mScene, (BlockGraph)blockStatementGraph, this.containerClass, codeBlock);
        builder.setNestedLabelMap(this.mLabelMap);
        builder.setNestedStack(this.mNestedStack);
        builder.build();
        this.connectCurrentWorkingNode(blockStatementGraph.getEntryNode());
        this.curWorkingNodeList.clear();
        this.curWorkingNodeList.add(blockStatementGraph.getExitNode());
    }

    public void dfsPsiSwitchStatementBuilder(PsiSwitchStatement statement) {
        PsiExpression checkedPsiExpr = statement.getExpression();
        PsiCodeBlock switchCodeBlock = statement.getBody();
        Value checkedValue = this.dfsExpressionBuilder(checkedPsiExpr);
        SwitchBranchingNodeImpl switchNode = new SwitchBranchingNodeImpl(this.mGraph);
        switchNode.setCheckedValue(checkedValue);
        this.mNestedStack.push(switchNode);
        this.mLabelMap.put(switchNode, null);
        SwitchCaseGraphImpl switchGraph = new SwitchCaseGraphImpl();
        switchGraph.setParentGraph(this.mGraph);
        switchNode.setSwitchCaseGraph(switchGraph);
        switchGraph.setSwitchBranchingNode(switchNode);
        CFGBuilder switchGraphBuilder = new CFGBuilder(this.mScene, (BlockGraph)switchGraph, this.containerClass, switchCodeBlock);
        switchGraphBuilder.setNestedStack(this.mNestedStack);
        switchGraphBuilder.setNestedLabelMap(this.mLabelMap);
        switchGraphBuilder.build();
        this.connectCurrentWorkingNode(switchNode);
        this.curWorkingNodeList.clear();
        this.curWorkingNodeList.add(switchNode.getSwitchCaseGraph().getExitNode());
        this.mLabelMap.remove(switchNode);
        this.mNestedStack.pop();
    }

    public void buildBranchingStatements(PsiStatement statement) {
        ArrayList retList = Lists.newArrayList();
        if (statement instanceof PsiIfStatement) {
            this.dfsPsiIfStatementBuilder((PsiIfStatement)statement);
            return;
        }
        if (statement instanceof PsiSynchronizedStatement) {
            this.dfsPsiSynchronizedStatementBuilder((PsiSynchronizedStatement)statement);
            return;
        }
        if (statement instanceof PsiBreakStatement) {
            this.dfsPsiBreakStatementBuilder((PsiBreakStatement)statement);
            return;
        }
        if (statement instanceof PsiReturnStatement) {
            this.dfsPsiReturnStmtBuilder((PsiReturnStatement)statement);
            return;
        }
        if (statement instanceof PsiSwitchStatement) {
            this.dfsPsiSwitchStatementBuilder((PsiSwitchStatement)statement);
            return;
        }
        if (statement instanceof PsiSwitchLabelStatement) {
            this.dfsPsiSwitchLabelStatementBuilder((PsiSwitchLabelStatement)statement);
            return;
        }
        if (statement instanceof PsiLoopStatement) {
            this.dfsPsiLoopStatementBuilder((PsiLoopStatement)statement, null);
            return;
        }
        if (!(statement instanceof PsiThrowStatement) && !(statement instanceof PsiAssertStatement)) {
            if (statement instanceof PsiContinueStatement) {
                this.dfsPsiContinueStatementBuilder((PsiContinueStatement)statement);
                return;
            }
            if (statement instanceof PsiTryStatement) {
                this.dfsPsiTryStatementBuilder((PsiTryStatement)statement);
            } else if (statement instanceof PsiBlockStatement) {
                this.dfsPsiBlockStatementBuilder((PsiBlockStatement)statement);
            } else if (statement instanceof PsiLabeledStatement) {
                this.dfsPsiLabeledStatementBuilder((PsiLabeledStatement)statement);
            }
        }
    }

    public void dfsPsiTryStatementBuilder(PsiTryStatement statement) {
        PsiCodeBlock psiTryBlock = statement.getTryBlock();
        PsiCodeBlock psiFinallyBlock = statement.getFinallyBlock();
        if (psiTryBlock != null) {
            BlockGraphImpl tryBlockStatementGraph = new BlockGraphImpl();
            tryBlockStatementGraph.setParentGraph(this.mGraph);
            tryBlockStatementGraph.setParentStmt((PsiStatement)statement);
            CFGBuilder tryBuilder = new CFGBuilder(this.mScene, (BlockGraph)tryBlockStatementGraph, this.containerClass, psiTryBlock);
            tryBuilder.setNestedLabelMap(this.mLabelMap);
            tryBuilder.setNestedStack(this.mNestedStack);
            tryBuilder.build();
            this.connectCurrentWorkingNode(tryBlockStatementGraph.getEntryNode());
            this.curWorkingNodeList.clear();
            this.curWorkingNodeList.add(tryBlockStatementGraph.getExitNode());
        }
        if (psiFinallyBlock != null) {
            BlockGraphImpl finallyBlockStatementGraph = new BlockGraphImpl();
            finallyBlockStatementGraph.setParentGraph(this.mGraph);
            finallyBlockStatementGraph.setParentStmt((PsiStatement)statement);
            CFGBuilder finallyBuilder = new CFGBuilder(this.mScene, (BlockGraph)finallyBlockStatementGraph, this.containerClass, psiFinallyBlock);
            finallyBuilder.setNestedLabelMap(this.mLabelMap);
            finallyBuilder.setNestedStack(this.mNestedStack);
            finallyBuilder.build();
            this.connectCurrentWorkingNode(finallyBlockStatementGraph.getEntryNode());
            this.curWorkingNodeList.clear();
            this.curWorkingNodeList.add(finallyBlockStatementGraph.getExitNode());
        }
    }

    protected LoopBranchingNodeImpl lookupLoopNodeFromIdentifier(PsiIdentifier id) {
        for (int i2 = this.mNestedStack.size() - 1; i2 >= 0; --i2) {
            PsiIdentifier idForCurNode;
            GraphNode curNode = (GraphNode)this.mNestedStack.get(i2);
            if (!(curNode instanceof LoopBranchingNodeImpl) || (idForCurNode = this.mLabelMap.get(curNode)) == null || !idForCurNode.getText().equals(id.getText())) continue;
            return (LoopBranchingNodeImpl)curNode;
        }
        return null;
    }

    protected LoopBranchingNodeImpl lookForTopMostLoop() {
        for (int i2 = this.mNestedStack.size() - 1; i2 >= 0; --i2) {
            GraphNode curNode = (GraphNode)this.mNestedStack.get(i2);
            if (!(curNode instanceof LoopBranchingNodeImpl)) continue;
            return (LoopBranchingNodeImpl)curNode;
        }
        return null;
    }

    public void dfsPsiBreakStatementBuilder(PsiBreakStatement statement) {
        if (this.mNestedStack.isEmpty()) {
            return;
        }
        PsiIdentifier label = statement.getLabelIdentifier();
        if (label == null) {
            GraphNode curTop = this.mNestedStack.peek();
            if (curTop instanceof LoopBranchingNodeImpl) {
                LoopBranchingNodeImpl curLoop = (LoopBranchingNodeImpl)curTop;
                BreakBranchingNodeImpl breakNode = new BreakBranchingNodeImpl(this.mGraph);
                this.connectCurrentWorkingNode(breakNode);
                this.curWorkingNodeList.clear();
                curLoop.addBreak(breakNode);
            } else if (curTop instanceof SwitchBranchingNode) {
                SwitchBranchingNodeImpl curSwitchNode = (SwitchBranchingNodeImpl)curTop;
                SwitchCaseGraph curSwitchGraph = curSwitchNode.getSwitchCaseGraph();
                BreakBranchingNodeImpl breakNode = new BreakBranchingNodeImpl(this.mGraph);
                this.connectCurrentWorkingNode(breakNode);
                GraphNodeUtil.connectGraphNode(breakNode, curSwitchGraph.getExitNode());
                this.curWorkingNodeList.clear();
            } else {
                PsiCFGDebugUtil.LOG.info("The Nested stack contains an entry that isnot a loop or a switch: " + curTop.getClass().getSimpleName());
            }
        } else {
            LoopBranchingNodeImpl loopNode = this.lookupLoopNodeFromIdentifier(label);
            if (loopNode != null) {
                BreakBranchingNodeImpl breakNode = new BreakBranchingNodeImpl(this.mGraph);
                this.connectCurrentWorkingNode(breakNode);
                loopNode.addBreak(breakNode);
                this.curWorkingNodeList.clear();
            }
        }
    }

    public void dfsPsiContinueStatementBuilder(PsiContinueStatement statement) {
        if (this.mNestedStack.isEmpty()) {
            return;
        }
        PsiIdentifier label = statement.getLabelIdentifier();
        if (label == null) {
            LoopBranchingNodeImpl curLoop = this.lookForTopMostLoop();
            if (curLoop == null) {
                return;
            }
            ContinueBranchingNodeImpl continueNode = new ContinueBranchingNodeImpl(this.mGraph);
            curLoop.addContinue(continueNode);
        } else {
            LoopBranchingNodeImpl loopNode = this.lookupLoopNodeFromIdentifier(label);
            if (loopNode != null) {
                ContinueBranchingNodeImpl continueNode = new ContinueBranchingNodeImpl(this.mGraph);
                loopNode.addContinue(continueNode);
            }
        }
    }

    public Value dfsExpressionStatementBuilder(PsiExpressionStatement statement) {
        PsiExpression expression = statement.getExpression();
        return this.dfsExpressionBuilder(expression);
    }

    public Value dfsExpressionListStatementBuilder(PsiExpressionListStatement statement) {
        PsiExpressionList listOfExpressions = statement.getExpressionList();
        PsiExpression[] expressionArray = listOfExpressions.getExpressions();
        Value v = null;
        for (PsiExpression expression : expressionArray) {
            v = this.dfsExpressionBuilder(expression);
        }
        return v;
    }

    public void dfsPsiReturnStmtBuilder(PsiReturnStatement statement) {
        PsiExpression returnValueExpr = statement.getReturnValue();
        Value returnVal = null;
        if (returnValueExpr != null) {
            returnVal = this.dfsExpressionBuilder(returnValueExpr);
        }
        ReturnStmtImpl returnStmtImpl = new ReturnStmtImpl(returnVal, (PsiElement)statement);
        GraphNodeImpl returnNode = new GraphNodeImpl(this.mGraph);
        returnNode.getStmtList().add(returnStmtImpl);
        this.connectCurrentWorkingNode(returnNode);
        GraphNode targetExitNode = this.getMethodExit();
        GraphNodeUtil.connectGraphNode(returnNode, targetExitNode);
        this.curWorkingNodeList.clear();
        this.checkUnreachable();
    }

    private GraphNode getMethodExit() {
        Graph currentGraph;
        for (currentGraph = this.mGraph; currentGraph != null && !(currentGraph instanceof MethodGraph); currentGraph = currentGraph.getParentGraph()) {
        }
        if (currentGraph instanceof MethodGraph) {
            return currentGraph.getExitNode();
        }
        return null;
    }

    public Value dfsAssignmentExpressionBuilder(PsiAssignmentExpression expression) {
        PsiExpression LExpr = expression.getLExpression();
        PsiExpression RExpr = expression.getRExpression();
        Value LhsValue = this.dfsLHSExpressionBuilder(LExpr);
        Value RhsValue = this.dfsExpressionBuilder(RExpr);
        AssignStmtImpl assignStmt = new AssignStmtImpl(false, (PsiExpression)expression, expression.getOperationTokenType());
        assignStmt.setLOp(LhsValue);
        assignStmt.setROp(RhsValue);
        this.connectGeneratedStmt(assignStmt);
        return LhsValue;
    }

    public SynthesizedLocalImpl createSynthesizeTemporalVariable(Value expr) {
        SynthesizedLocalImpl synthesizedLocal = new SynthesizedLocalImpl(expr.getType(), expr.getPsiRef().getText(), null);
        AssignStmtImpl synthesizedAssign = new AssignStmtImpl(true, null, JavaTokenType.EQ);
        synthesizedAssign.setLOp(synthesizedLocal);
        synthesizedAssign.setROp(expr);
        synthesizedLocal.setAssignStmt(synthesizedAssign);
        this.connectGeneratedStmt(synthesizedAssign);
        return synthesizedLocal;
    }

    public Value createRHSStaticRefExpression(PsiType fieldType, PsiCFGField cfgField, PsiElement expression) {
        StaticFieldRefImpl staticFieldRef = new StaticFieldRefImpl(fieldType, cfgField, expression);
        SynthesizedLocalImpl synLocal = this.createSynthesizeTemporalVariable(staticFieldRef);
        return synLocal;
    }

    public Value createLHSStaticRefExpression(PsiType fieldType, PsiCFGField cfgField, PsiElement expression) {
        StaticFieldRefImpl staticFieldRef = new StaticFieldRefImpl(fieldType, cfgField, expression);
        return staticFieldRef;
    }

    public Value processLHSRefExprWithTgtPsiFieldQualifierNull(PsiField fieldTarget, PsiCFGClass cfgClass, PsiCFGField cfgField, PsiReferenceExpression expression) {
        if (cfgField.isStatic()) {
            return this.createLHSStaticRefExpression(fieldTarget.getType(), cfgField, (PsiElement)expression);
        }
        PsiCFGClass thisClass = this.containerClass;
        PsiClass thisPsiClass = thisClass.getPsiClass();
        if (thisPsiClass == null) {
            thisPsiClass = fieldTarget.getContainingClass();
        }
        PsiType thisType = this.retrieveTypeByPsiClass(thisPsiClass);
        ThisRefImpl thisRefImpl = new ThisRefImpl(null, thisClass, thisType);
        InstanceFieldRefImpl instanceFieldRef = new InstanceFieldRefImpl(fieldTarget.getType(), cfgField, (PsiElement)expression);
        instanceFieldRef.setBase(thisRefImpl);
        return instanceFieldRef;
    }

    public Value processRefExprWithTgtPsiFieldQualifierNull(PsiField fieldTarget, PsiCFGClass cfgClass, PsiCFGField cfgField, PsiReferenceExpression expression) {
        if (cfgField.isStatic()) {
            return this.createRHSStaticRefExpression(fieldTarget.getType(), cfgField, (PsiElement)expression);
        }
        PsiCFGClass thisClass = this.containerClass;
        PsiClass thisPsiClass = thisClass.getPsiClass();
        if (thisPsiClass == null) {
            thisPsiClass = fieldTarget.getContainingClass();
        }
        PsiType thisType = this.retrieveTypeByPsiClass(thisPsiClass);
        ThisRefImpl thisRefImpl = new ThisRefImpl(null, thisClass, thisType);
        InstanceFieldRefImpl instanceFieldRef = new InstanceFieldRefImpl(fieldTarget.getType(), cfgField, (PsiElement)expression);
        instanceFieldRef.setBase(thisRefImpl);
        SynthesizedLocalImpl synLocal = this.createSynthesizeTemporalVariable(instanceFieldRef);
        return synLocal;
    }

    public Value dfsRHSReferenceExpressionBuilder(PsiReferenceExpression expression) {
        PsiElement target = expression.resolve();
        if (target == null) {
            PsiCFGDebugUtil.LOG.warning("ReferenceExpression cannot be resolved: " + expression.getText());
        }
        if (target instanceof PsiLocalVariable) {
            Local l = this.resolveLocal((PsiLocalVariable)target);
            if (l == null) {
                return new DummyRef(expression.getType(), (PsiElement)expression);
            }
            return l;
        }
        if (target instanceof PsiParameter) {
            Param p = this.resolveParam((PsiParameter)target);
            if (p == null) {
                return new DummyRef(expression.getType(), (PsiElement)expression);
            }
            return p;
        }
        PsiExpression qualifier = expression.getQualifierExpression();
        if (target instanceof PsiField) {
            PsiField fieldTarget = (PsiField)target;
            PsiCFGClass cfgClass = this.mScene.getOrCreateCFGClass(fieldTarget.getContainingClass());
            PsiCFGField cfgField = cfgClass.getField(fieldTarget.getName());
            if (qualifier == null) {
                return this.processRefExprWithTgtPsiFieldQualifierNull(fieldTarget, cfgClass, cfgField, expression);
            }
            if (qualifier instanceof PsiThisExpression) {
                PsiCFGClass thisClass = this.containerClass;
                PsiThisExpression thisPsiExpression = (PsiThisExpression)qualifier;
                ThisRefImpl thisRefImpl = new ThisRefImpl(thisPsiExpression, thisClass, fieldTarget.getType());
                InstanceFieldRefImpl instanceFieldRef = new InstanceFieldRefImpl(fieldTarget.getType(), cfgField, (PsiElement)expression);
                instanceFieldRef.setBase(thisRefImpl);
                SynthesizedLocalImpl synLocal = this.createSynthesizeTemporalVariable(instanceFieldRef);
                return synLocal;
            }
            if (qualifier instanceof PsiSuperExpression) {
                PsiCFGDebugUtil.LOG.warning("Super.field happened at expression: " + expression.getText());
                return new DummyRef(expression.getType(), (PsiElement)expression);
            }
            if (qualifier instanceof PsiReferenceExpression) {
                PsiElement resolveOfQualifier = ((PsiReferenceExpression)qualifier).resolve();
                if (resolveOfQualifier instanceof PsiClass) {
                    return this.createRHSStaticRefExpression(fieldTarget.getType(), cfgField, (PsiElement)expression);
                }
                if (resolveOfQualifier instanceof PsiReferenceExpression) {
                    Value qualifierValue = this.dfsRHSReferenceExpressionBuilder((PsiReferenceExpression)resolveOfQualifier);
                    InstanceFieldRefImpl instanceFieldRef = new InstanceFieldRefImpl(fieldTarget.getType(), cfgField, (PsiElement)expression);
                    instanceFieldRef.setBase(qualifierValue);
                    SynthesizedLocalImpl synLocal = this.createSynthesizeTemporalVariable(instanceFieldRef);
                    return synLocal;
                }
                if (resolveOfQualifier instanceof PsiLocalVariable) {
                    Local local = this.resolveLocal((PsiLocalVariable)resolveOfQualifier);
                    if (local == null) {
                        local = new LocalImpl(qualifier.getType(), (PsiLocalVariable)resolveOfQualifier);
                    }
                    InstanceFieldRefImpl instanceFieldRef = new InstanceFieldRefImpl(fieldTarget.getType(), cfgField, (PsiElement)expression);
                    instanceFieldRef.setBase(local);
                    SynthesizedLocalImpl synLocal = this.createSynthesizeTemporalVariable(instanceFieldRef);
                    return synLocal;
                }
                if (resolveOfQualifier instanceof PsiField || resolveOfQualifier instanceof PsiParameter) {
                    Value field2 = this.dfsRHSReferenceExpressionBuilder((PsiReferenceExpression)qualifier);
                    InstanceFieldRefImpl instanceFieldRef = new InstanceFieldRefImpl(fieldTarget.getType(), cfgField, (PsiElement)expression);
                    instanceFieldRef.setBase(field2);
                    SynthesizedLocalImpl synLocal = this.createSynthesizeTemporalVariable(instanceFieldRef);
                    return synLocal;
                }
                PsiCFGDebugUtil.LOG.warning("Unknown resolve type of qualifer ");
                PsiCFGDebugUtil.debugOutputPsiElement(resolveOfQualifier);
            } else {
                if (qualifier instanceof PsiMethodCallExpression) {
                    Value methodCallLocal = this.dfsPsiMethodCallExpressionBuilder((PsiMethodCallExpression)qualifier);
                    InstanceFieldRefImpl instanceFieldRef = new InstanceFieldRefImpl(fieldTarget.getType(), cfgField, (PsiElement)expression);
                    instanceFieldRef.setBase(methodCallLocal);
                    SynthesizedLocalImpl synLocal = this.createSynthesizeTemporalVariable(instanceFieldRef);
                    return synLocal;
                }
                PsiCFGDebugUtil.LOG.warning("Unsupported Qualifier in expression: " + expression.getText());
                PsiCFGDebugUtil.debugOutputPsiElement((PsiElement)qualifier);
            }
        } else if (target instanceof PsiMethod) {
            PsiCFGDebugUtil.LOG.info("Refering to a method: " + ((PsiMethod)target).getName());
        } else {
            PsiCFGDebugUtil.LOG.info("Other circumstances: target of the Reference Expression is : " + target.getClass().getSimpleName());
        }
        DummyRef ref = new DummyRef(expression.getType(), (PsiElement)expression);
        return ref;
    }

    public Value dfsLHSReferenceExpressionBuilder(PsiReferenceExpression expression) {
        PsiElement target = expression.resolve();
        if (target == null) {
            PsiCFGDebugUtil.LOG.warning("ReferenceExpression cannot be resolved: " + expression.getText());
        }
        if (target instanceof PsiLocalVariable) {
            Local l = this.resolveLocal((PsiLocalVariable)target);
            if (l == null) {
                return new DummyRef(expression.getType(), (PsiElement)expression);
            }
            return l;
        }
        if (target instanceof PsiParameter) {
            Param p = this.resolveParam((PsiParameter)target);
            if (p == null) {
                return new DummyRef(expression.getType(), (PsiElement)expression);
            }
            return p;
        }
        PsiExpression qualifier = expression.getQualifierExpression();
        if (qualifier == null) {
            // empty if block
        }
        if (target instanceof PsiField) {
            PsiField fieldTarget = (PsiField)target;
            PsiCFGClass cfgClass = this.mScene.getOrCreateCFGClass(fieldTarget.getContainingClass());
            PsiCFGField cfgField = cfgClass.getField(fieldTarget.getName());
            if (qualifier == null) {
                return this.processLHSRefExprWithTgtPsiFieldQualifierNull(fieldTarget, cfgClass, cfgField, expression);
            }
            if (qualifier instanceof PsiThisExpression) {
                PsiCFGClass thisClass = this.containerClass;
                PsiThisExpression thisPsiExpression = (PsiThisExpression)qualifier;
                ThisRefImpl thisRefImpl = new ThisRefImpl(thisPsiExpression, thisClass, fieldTarget.getType());
                InstanceFieldRefImpl instanceFieldRef = new InstanceFieldRefImpl(fieldTarget.getType(), cfgField, (PsiElement)expression);
                instanceFieldRef.setBase(thisRefImpl);
                return instanceFieldRef;
            }
            if (qualifier instanceof PsiSuperExpression) {
                PsiCFGDebugUtil.LOG.warning("Super.field happened at expression: " + expression.getText());
                return new DummyRef(expression.getType(), (PsiElement)expression);
            }
            if (qualifier instanceof PsiReferenceExpression) {
                PsiElement resolveOfQualifier = ((PsiReferenceExpression)qualifier).resolve();
                if (resolveOfQualifier instanceof PsiClass) {
                    return this.createLHSStaticRefExpression(fieldTarget.getType(), cfgField, (PsiElement)expression);
                }
                if (resolveOfQualifier instanceof PsiReferenceExpression) {
                    Value qualifierValue = this.dfsRHSReferenceExpressionBuilder((PsiReferenceExpression)resolveOfQualifier);
                    InstanceFieldRefImpl instanceFieldRef = new InstanceFieldRefImpl(fieldTarget.getType(), cfgField, (PsiElement)expression);
                    instanceFieldRef.setBase(qualifierValue);
                    return instanceFieldRef;
                }
                if (resolveOfQualifier instanceof PsiLocalVariable) {
                    Local local = this.resolveLocal((PsiLocalVariable)resolveOfQualifier);
                    if (local == null) {
                        local = new LocalImpl(qualifier.getType(), (PsiLocalVariable)resolveOfQualifier);
                    }
                    InstanceFieldRefImpl instanceFieldRef = new InstanceFieldRefImpl(fieldTarget.getType(), cfgField, (PsiElement)expression);
                    instanceFieldRef.setBase(local);
                    return instanceFieldRef;
                }
                if (resolveOfQualifier instanceof PsiField || resolveOfQualifier instanceof PsiParameter) {
                    Value field2 = this.dfsRHSReferenceExpressionBuilder((PsiReferenceExpression)qualifier);
                    InstanceFieldRefImpl instanceFieldRef = new InstanceFieldRefImpl(fieldTarget.getType(), cfgField, (PsiElement)expression);
                    instanceFieldRef.setBase(field2);
                    return instanceFieldRef;
                }
                PsiCFGDebugUtil.LOG.warning("Unknown resolve type of qualifer ");
                PsiCFGDebugUtil.debugOutputPsiElement(resolveOfQualifier);
            } else {
                if (qualifier instanceof PsiMethodCallExpression) {
                    Value methodCallLocal = this.dfsPsiMethodCallExpressionBuilder((PsiMethodCallExpression)qualifier);
                    InstanceFieldRefImpl instanceFieldRef = new InstanceFieldRefImpl(fieldTarget.getType(), cfgField, (PsiElement)expression);
                    instanceFieldRef.setBase(methodCallLocal);
                    return instanceFieldRef;
                }
                PsiCFGDebugUtil.LOG.warning("Unsupported Qualifier in expression: " + expression.getText());
                PsiCFGDebugUtil.debugOutputPsiElement((PsiElement)qualifier);
            }
        } else if (target instanceof PsiMethod) {
            PsiCFGDebugUtil.LOG.info("Refering to a method: " + ((PsiMethod)target).getName());
        } else {
            PsiCFGDebugUtil.LOG.info("Other circumstances: target of the Reference Expression is : " + target.getClass().getSimpleName());
        }
        DummyRef ref = new DummyRef(expression.getType(), (PsiElement)expression);
        return ref;
    }

    public Value dfsPolyadicExpressionBuilder(PsiPolyadicExpression expression) {
        PsiExpression[] allOperands;
        IElementType iOperator = expression.getOperationTokenType();
        if (expression.getType() == PsiType.BOOLEAN && (iOperator == JavaTokenType.ANDAND || iOperator == JavaTokenType.OROR)) {
            ArrayList returnedWorkingNode = Lists.newArrayList();
            PsiExpression[] expressionArray = expression.getOperands();
            if (iOperator == JavaTokenType.OROR) {
                SynthesizedLocalImpl finalLocal = new SynthesizedLocalImpl((PsiType)PsiType.BOOLEAN, expression.getText(), (PsiElement)expression);
                for (int i2 = 0; i2 < expressionArray.length; ++i2) {
                    Value curExprValue = this.dfsExpressionBuilder(expressionArray[i2]);
                    AssignStmtImpl synAssign = new AssignStmtImpl(true, null, JavaTokenType.EQ);
                    synAssign.setLOp(finalLocal);
                    synAssign.setROp(curExprValue);
                    GraphNodeImpl assignNode = new GraphNodeImpl(this.mGraph);
                    assignNode.getStmtList().add(synAssign);
                    returnedWorkingNode.add(assignNode);
                    if (i2 != expressionArray.length - 1) {
                        ConditionCheckNodeImpl curCond = new ConditionCheckNodeImpl(this.mGraph, curExprValue);
                        this.connectCurrentWorkingNode(curCond);
                        this.curWorkingNodeList.clear();
                        this.curWorkingNodeList.add(curCond.getFalseBranch());
                        GraphNodeUtil.connectGraphNode(curCond.getTrueBranch(), assignNode);
                        continue;
                    }
                    for (GraphNode parent : this.curWorkingNodeList) {
                        GraphNodeUtil.connectGraphNode(parent, assignNode);
                    }
                }
                this.curWorkingNodeList.clear();
                this.curWorkingNodeList.addAll(returnedWorkingNode);
                return finalLocal;
            }
            if (iOperator == JavaTokenType.ANDAND) {
                SynthesizedLocalImpl finalLocal = new SynthesizedLocalImpl((PsiType)PsiType.BOOLEAN, expression.getText(), (PsiElement)expression);
                for (int i3 = 0; i3 < expressionArray.length; ++i3) {
                    Value curExprValue = this.dfsExpressionBuilder(expressionArray[i3]);
                    AssignStmtImpl synAssign = new AssignStmtImpl(true, null, JavaTokenType.EQ);
                    synAssign.setLOp(finalLocal);
                    synAssign.setROp(curExprValue);
                    GraphNodeImpl assignNode = new GraphNodeImpl(this.mGraph);
                    assignNode.getStmtList().add(synAssign);
                    returnedWorkingNode.add(assignNode);
                    if (i3 != expressionArray.length - 1) {
                        ConditionCheckNodeImpl curCond = new ConditionCheckNodeImpl(this.mGraph, curExprValue);
                        this.connectCurrentWorkingNode(curCond);
                        this.curWorkingNodeList.clear();
                        this.curWorkingNodeList.add(curCond.getTrueBranch());
                        GraphNodeUtil.connectGraphNode(curCond.getFalseBranch(), assignNode);
                        continue;
                    }
                    for (GraphNode parent : this.curWorkingNodeList) {
                        GraphNodeUtil.connectGraphNode(parent, assignNode);
                    }
                }
                this.curWorkingNodeList.clear();
                this.curWorkingNodeList.addAll(returnedWorkingNode);
                return finalLocal;
            }
        }
        PolyadicExprImpl mPolyadicExpr = new PolyadicExprImpl(iOperator, expression);
        for (PsiExpression curPsiExpr : allOperands = expression.getOperands()) {
            Value v = this.dfsExpressionBuilder(curPsiExpr);
            mPolyadicExpr.addOperand(v);
        }
        SynthesizedLocalImpl polyadicLocal = this.createSynthesizeTemporalVariable(mPolyadicExpr);
        return polyadicLocal;
    }

    public Value dfsBinaryExpressionBuilder(PsiBinaryExpression binExpression) {
        PsiExpression opL = binExpression.getLOperand();
        PsiExpression opR = binExpression.getROperand();
        IElementType iOperator = binExpression.getOperationTokenType();
        if (binExpression.getType() == PsiType.BOOLEAN && (iOperator == JavaTokenType.ANDAND || iOperator == JavaTokenType.OROR)) {
            if (iOperator == JavaTokenType.OROR) {
                Value LExpr = this.dfsExpressionBuilder(opL);
                ConditionCheckNodeImpl condCheckNode = new ConditionCheckNodeImpl(this.mGraph, LExpr);
                this.connectCurrentWorkingNode(condCheckNode);
                this.curWorkingNodeList.clear();
                this.curWorkingNodeList.add(condCheckNode.getFalseBranch());
                Value RExpr = this.dfsExpressionBuilder(opR);
                SynthesizedLocalImpl synLocal = new SynthesizedLocalImpl((PsiType)PsiType.BOOLEAN, binExpression.getText(), (PsiElement)binExpression);
                AssignStmtImpl trueBranch = new AssignStmtImpl(true, null, JavaTokenType.EQ);
                trueBranch.setLOp(synLocal);
                trueBranch.setROp(LExpr);
                GraphNodeImpl LBranchNode = new GraphNodeImpl(this.mGraph);
                LBranchNode.getStmtList().add(trueBranch);
                GraphNodeUtil.connectGraphNode(condCheckNode.getTrueBranch(), LBranchNode);
                AssignStmtImpl falseBranch = new AssignStmtImpl(true, null, JavaTokenType.EQ);
                falseBranch.setLOp(synLocal);
                falseBranch.setROp(RExpr);
                GraphNodeImpl RBranchNode = new GraphNodeImpl(this.mGraph);
                RBranchNode.getStmtList().add(falseBranch);
                for (GraphNode parentNode : this.curWorkingNodeList) {
                    GraphNodeUtil.connectGraphNode(parentNode, RBranchNode);
                }
                this.curWorkingNodeList.clear();
                this.curWorkingNodeList.add(LBranchNode);
                this.curWorkingNodeList.add(RBranchNode);
                return synLocal;
            }
            if (iOperator == JavaTokenType.ANDAND) {
                Value LExpr = this.dfsExpressionBuilder(opL);
                ConditionCheckNodeImpl condCheckNode = new ConditionCheckNodeImpl(this.mGraph, LExpr);
                this.connectCurrentWorkingNode(condCheckNode);
                this.curWorkingNodeList.clear();
                this.curWorkingNodeList.add(condCheckNode.getTrueBranch());
                Value RExpr = this.dfsExpressionBuilder(opR);
                SynthesizedLocalImpl synLocal = new SynthesizedLocalImpl((PsiType)PsiType.BOOLEAN, binExpression.getText(), (PsiElement)binExpression);
                AssignStmtImpl falseBranch = new AssignStmtImpl(true, null, JavaTokenType.EQ);
                falseBranch.setLOp(synLocal);
                falseBranch.setROp(LExpr);
                GraphNodeImpl LBranchNode = new GraphNodeImpl(this.mGraph);
                LBranchNode.getStmtList().add(falseBranch);
                GraphNodeUtil.connectGraphNode(condCheckNode.getFalseBranch(), LBranchNode);
                AssignStmtImpl trueBranch = new AssignStmtImpl(true, null, JavaTokenType.EQ);
                trueBranch.setLOp(synLocal);
                trueBranch.setROp(RExpr);
                GraphNodeImpl RBranchNode = new GraphNodeImpl(this.mGraph);
                RBranchNode.getStmtList().add(trueBranch);
                for (GraphNode parentNode : this.curWorkingNodeList) {
                    GraphNodeUtil.connectGraphNode(parentNode, RBranchNode);
                }
                this.curWorkingNodeList.clear();
                this.curWorkingNodeList.add(LBranchNode);
                this.curWorkingNodeList.add(RBranchNode);
                return synLocal;
            }
        }
        BinopExprImpl binopExpr = new BinopExprImpl(binExpression);
        Value vOp1 = this.dfsExpressionBuilder(opL);
        Value vOp2 = this.dfsExpressionBuilder(opR);
        binopExpr.setOp1(vOp1);
        binopExpr.setOp2(vOp2);
        binopExpr.setOperator(binExpression.getOperationTokenType());
        SynthesizedLocalImpl binopLocal = this.createSynthesizeTemporalVariable(binopExpr);
        return binopLocal;
    }

    public Value dfsParenthesizedExpression(PsiParenthesizedExpression expression) {
        PsiExpression expr = expression.getExpression();
        Value v = this.dfsExpressionBuilder(expr);
        if (!(v instanceof SynthesizedLocal)) {
            this.createSynthesizeTemporalVariable(v);
        }
        return v;
    }

    public Value dfsLiteralExpressionBuilder(PsiLiteralExpression literalExpression) {
        ConstantImpl constExpr = new ConstantImpl(literalExpression);
        return constExpr;
    }

    public Value dfsLHSExpressionBuilder(PsiExpression expression) {
        if (expression instanceof PsiReferenceExpression) {
            return this.dfsLHSReferenceExpressionBuilder((PsiReferenceExpression)expression);
        }
        return this.dfsExpressionBuilder(expression);
    }

    public Value dfsExpressionBuilder(PsiExpression expression) {
        if (expression instanceof PsiBinaryExpression) {
            return this.dfsBinaryExpressionBuilder((PsiBinaryExpression)expression);
        }
        if (expression instanceof PsiPolyadicExpression) {
            return this.dfsPolyadicExpressionBuilder((PsiPolyadicExpression)expression);
        }
        if (expression instanceof PsiLiteralExpression) {
            return this.dfsLiteralExpressionBuilder((PsiLiteralExpression)expression);
        }
        if (expression instanceof PsiParenthesizedExpression) {
            return this.dfsParenthesizedExpression((PsiParenthesizedExpression)expression);
        }
        if (expression instanceof PsiAssignmentExpression) {
            return this.dfsAssignmentExpressionBuilder((PsiAssignmentExpression)expression);
        }
        if (expression instanceof PsiReferenceExpression) {
            return this.dfsRHSReferenceExpressionBuilder((PsiReferenceExpression)expression);
        }
        if (expression instanceof PsiMethodCallExpression) {
            return this.dfsPsiMethodCallExpressionBuilder((PsiMethodCallExpression)expression);
        }
        if (expression instanceof PsiNewExpression) {
            return this.dfsPsiNewExpressionBuilder((PsiNewExpression)expression);
        }
        if (expression instanceof PsiConditionalExpression) {
            return this.dfsPsiConditionalExpressionBuilder((PsiConditionalExpression)expression);
        }
        if (expression instanceof PsiInstanceOfExpression) {
            return this.dfsPsiInstanceOfExpressionBuilder((PsiInstanceOfExpression)expression);
        }
        if (expression instanceof PsiThisExpression) {
            return this.dfsThisExpressionBuilder((PsiThisExpression)expression);
        }
        if (expression instanceof PsiSuperExpression) {
            return new DummyRef(expression.getType(), (PsiElement)expression);
        }
        if (expression instanceof PsiArrayInitializerExpression) {
            return new DummyRef(expression.getType(), (PsiElement)expression);
        }
        if (expression instanceof PsiTypeCastExpression) {
            return this.dfsPsiTypeCastExpressionBuilder((PsiTypeCastExpression)expression);
        }
        if (expression instanceof PsiArrayAccessExpression) {
            return this.dfsRHSPsiArrayAccessExpressionBuilder((PsiArrayAccessExpression)expression);
        }
        if (expression instanceof PsiPostfixExpression) {
            return this.dfsPsiPostfixExpressionBuilder((PsiPostfixExpression)expression);
        }
        if (expression instanceof PsiPrefixExpression) {
            return this.dfsPsiPrefixExpressionBuilder((PsiPrefixExpression)expression);
        }
        if (expression instanceof PsiClassObjectAccessExpression) {
            return new DummyRef(expression.getType(), (PsiElement)expression);
        }
        if (expression instanceof PsiLambdaExpression) {
            return this.dfsPsiLambdaExpressionBuilder((PsiLambdaExpression)expression);
        }
        PsiCFGDebugUtil.LOG.warning("ExpressionType: " + expression.getClass().getSimpleName() + " not Implemented");
        return new DummyRef(expression.getType(), (PsiElement)expression);
    }

    private boolean isQualifierPsiClass(PsiExpression qualifier) {
        if (qualifier == null || !(qualifier instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiReferenceExpression refExpr = (PsiReferenceExpression)qualifier;
        PsiElement resolveType = refExpr.resolve();
        return resolveType != null && resolveType instanceof PsiClass;
    }

    private Value[] parseMethodCallParams(PsiExpressionList arguments) {
        if (arguments == null) {
            return Value.EMPTY_ARRAY;
        }
        PsiExpression[] paramList = arguments.getExpressions();
        Value[] returnArray = new Value[paramList.length];
        for (int i2 = 0; i2 < paramList.length; ++i2) {
            PsiExpression currentParam = paramList[i2];
            Value currentParamValue = null;
            currentParamValue = currentParam instanceof PsiLambdaExpression ? this.dfsPsiLambdaExpressionBuilder((PsiLambdaExpression)currentParam) : this.dfsExpressionBuilder(currentParam);
            returnArray[i2] = currentParamValue;
        }
        return returnArray;
    }

    public Value dfsPsiLambdaExpressionBuilder(PsiLambdaExpression expression) {
        PsiType interfaceType = expression.getFunctionalInterfaceType();
        PsiClass interfaceClassRef = null;
        if (interfaceType == null) {
            PsiCFGDebugUtil.LOG.warning("Lambda Expression: " + expression.getText() + " cannot be resolved");
            return new DummyRef(expression.getType(), (PsiElement)expression);
        }
        if (!(interfaceType instanceof PsiClassType)) {
            PsiCFGDebugUtil.LOG.warning("Lambda Expression: " + expression.getText() + " type is not interface");
            PsiCFGDebugUtil.LOG.warning("Type: " + interfaceType.getClass().getSimpleName());
            return new DummyRef(expression.getType(), (PsiElement)expression);
        }
        interfaceClassRef = ((PsiClassType)interfaceType).resolve();
        PsiCFGClass lambdaWrapperClass = this.mScene.createLambdaAnonymousClass(expression, interfaceClassRef, this.containerClass);
        NewExprImpl newExprImpl = new NewExprImpl(interfaceType, (PsiElement)expression);
        newExprImpl.setBaseClass(lambdaWrapperClass);
        SynthesizedLocalImpl synLocal = this.createSynthesizeTemporalVariable(newExprImpl);
        return synLocal;
    }

    public Value dfsPsiNewExpressionBuilder(PsiNewExpression expression) {
        PsiCFGClass cfgClassOfNewInstance;
        PsiExpressionList argumentList = expression.getArgumentList();
        Value[] paramValueArray = this.parseMethodCallParams(argumentList);
        PsiType newType = expression.getType();
        PsiAnonymousClass anonymousClass = expression.getAnonymousClass();
        if (newType instanceof PsiArrayType) {
            PsiArrayType newArrayType = (PsiArrayType)newType;
            PsiType baseType = newArrayType.getComponentType();
            NewExprImpl newArrayExprImpl = new NewExprImpl((PsiType)newArrayType, (PsiElement)expression);
            newArrayExprImpl.setArray();
            SynthesizedLocalImpl synthesizedLocalImpl = this.createSynthesizeTemporalVariable(newArrayExprImpl);
            return synthesizedLocalImpl;
        }
        if (anonymousClass != null) {
            cfgClassOfNewInstance = this.mScene.getOrCreateNestedClass((PsiClass)anonymousClass, this.containerClass, this.retrieveDeclaringMethod(), this.mGraph);
        } else {
            PsiJavaCodeReferenceElement classReference = expression.getClassReference();
            if (classReference == null) {
                PsiCFGDebugUtil.LOG.warning("classReference of the new expression is null");
                PsiCFGDebugUtil.debugOutputPsiElement((PsiElement)expression);
                System.out.println(expression.getText());
                PsiExpression[] dimisionExpressions = expression.getArrayDimensions();
                System.out.println("Dimision: " + dimisionExpressions.length);
                System.out.println("Type: " + newType.getCanonicalText() + " " + newType.getClass().getSimpleName());
                throw new RuntimeException("classReference in dfsNewExpressionBuilder is null");
            }
            PsiElement resolvedExpression = classReference.resolve();
            if (resolvedExpression == null || !(resolvedExpression instanceof PsiClass)) {
                PsiCFGDebugUtil.LOG.warning("Cannot resolve the class in the new expression in " + expression.getText());
                return new DummyRef(expression.getType(), (PsiElement)expression);
            }
            PsiClass classOfNewInstance = (PsiClass)resolvedExpression;
            cfgClassOfNewInstance = this.mScene.getOrCreateCFGClass(classOfNewInstance);
        }
        PsiMethod constructorMethod = expression.resolveConstructor();
        NewExprImpl newExprImpl = new NewExprImpl(expression.getType(), (PsiElement)expression);
        newExprImpl.setBaseClass(cfgClassOfNewInstance);
        ArrayList<Value> argsList = newExprImpl.getArgsList();
        for (Value v : paramValueArray) {
            argsList.add(v);
        }
        if (constructorMethod != null) {
            PsiClass psiClass = constructorMethod.getContainingClass();
            PsiCFGClass construtorCFGClass = this.mScene.getOrCreateCFGClass(psiClass);
            PsiCFGMethod constructorCFGMethod = construtorCFGClass.getMethod(constructorMethod);
            if (constructorCFGMethod == null) {
                PsiCFGDebugUtil.LOG.warning("Cannot resolve the constructor for " + constructorMethod.getName());
            } else {
                newExprImpl.setConstrctorInvocation(constructorCFGMethod);
            }
        }
        SynthesizedLocalImpl synthesizedLocalImpl = this.createSynthesizeTemporalVariable(newExprImpl);
        return synthesizedLocalImpl;
    }

    private void experimentalLambdaSolver(PsiExpressionList exprList) {
        PsiExpression[] args;
        for (PsiExpression e : args = exprList.getExpressions()) {
            if (!(e instanceof PsiLambdaExpression)) continue;
            PsiLambdaExpression lE = (PsiLambdaExpression)e;
            lE.getParameterList();
        }
    }

    public Value createStaticInvocation(PsiCFGMethod cfgMethod, PsiCFGClass cfgClass, PsiMethod resolvedMethod, Value[] argsValueArray, PsiElement expression) {
        StaticInvokeExprImpl staticIvk = new StaticInvokeExprImpl(cfgMethod, resolvedMethod.getReturnType(), expression);
        staticIvk.setBaseClass(cfgClass);
        for (Value v : argsValueArray) {
            staticIvk.addArg(v);
        }
        SynthesizedLocalImpl synLocal = this.createSynthesizeTemporalVariable(staticIvk);
        return synLocal;
    }

    public Value dfsRHSPsiArrayAccessExpressionBuilder(PsiArrayAccessExpression expression) {
        PsiExpression arrayPsiExpr = expression.getArrayExpression();
        PsiExpression indexPsiExpr = expression.getIndexExpression();
        Value arrayValue = this.dfsExpressionBuilder(arrayPsiExpr);
        Value indexValue = this.dfsExpressionBuilder(indexPsiExpr);
        ArrayAccessRefImpl arrayAccessRef = new ArrayAccessRefImpl(expression.getType(), (PsiElement)expression);
        arrayAccessRef.setBase(arrayValue);
        arrayAccessRef.setBase(indexValue);
        SynthesizedLocalImpl synLocal = this.createSynthesizeTemporalVariable(arrayAccessRef);
        return synLocal;
    }

    public Value dfsPsiMethodCallExpressionBuilder(PsiMethodCallExpression expression) {
        PsiElement resolvedElement;
        PsiExpressionList argsList = expression.getArgumentList();
        PsiReferenceExpression methodRef = expression.getMethodExpression();
        PsiExpression qualifier = methodRef.getQualifierExpression();
        Value[] argsValueArray = this.parseMethodCallParams(argsList);
        if (methodRef instanceof PsiMethodReferenceExpression) {
            PsiMethodReferenceExpression psiMethodRef = (PsiMethodReferenceExpression)methodRef;
            PsiCFGDebugUtil.LOG.info("The MethodCallExpression contains a PsiMethodReferenceExpression");
        }
        if ((resolvedElement = methodRef.resolve()) instanceof PsiMethod) {
            PsiMethod resolvedMethod = (PsiMethod)resolvedElement;
            PsiClass declaringClass = resolvedMethod.getContainingClass();
            PsiCFGClass cfgClass = this.mScene.getOrCreateCFGClass(declaringClass);
            PsiCFGMethod cfgMethod = cfgClass.getMethod(resolvedMethod);
            if (this.isQualifierPsiClass(qualifier) || cfgMethod.isStatic()) {
                return this.createStaticInvocation(cfgMethod, cfgClass, resolvedMethod, argsValueArray, (PsiElement)expression);
            }
            if (qualifier == null) {
                if (cfgMethod.isStatic()) {
                    return this.createStaticInvocation(cfgMethod, cfgClass, resolvedMethod, argsValueArray, (PsiElement)expression);
                }
                PsiType thisType = this.retrieveTypeByPsiClass(this.containerClass.getPsiClass());
                ThisRefImpl synThisRef = new ThisRefImpl(null, this.containerClass, thisType);
                InstanceInvokeExprImpl instanceInvoke = new InstanceInvokeExprImpl(cfgMethod, resolvedMethod.getReturnType(), (PsiElement)expression);
                instanceInvoke.setBase(synThisRef);
                for (Value v : argsValueArray) {
                    instanceInvoke.addArg(v);
                }
                SynthesizedLocalImpl synLocal = this.createSynthesizeTemporalVariable(instanceInvoke);
                return synLocal;
            }
            if (qualifier instanceof PsiReferenceExpression) {
                Value objLocal = this.dfsRHSReferenceExpressionBuilder((PsiReferenceExpression)qualifier);
                InstanceInvokeExprImpl instanceInvoke = new InstanceInvokeExprImpl(cfgMethod, resolvedMethod.getReturnType(), (PsiElement)expression);
                instanceInvoke.setBase(objLocal);
                for (Value v : argsValueArray) {
                    instanceInvoke.addArg(v);
                }
                if (objLocal == null) {
                    throw new RuntimeException("objectLocal in MethodCallExpression is null");
                }
                PsiType baseType = objLocal.getType();
                if (baseType instanceof PsiClassType) {
                    PsiClass classRef = ((PsiClassType)baseType).resolve();
                    this.mScene.getOrCreateCFGClass(classRef);
                }
                SynthesizedLocalImpl synLocal = this.createSynthesizeTemporalVariable(instanceInvoke);
                return synLocal;
            }
            PsiCFGDebugUtil.LOG.warning("Did not recognize PsiMethodCallExpression: " + expression.getText() + " of type " + qualifier.getClass().getName());
        } else {
            PsiCFGDebugUtil.LOG.warning("Cannot resolve PsiMethodCallExpression e to PsiMethod: " + expression.getText() + "   " + (resolvedElement == null ? "null" : resolvedElement.getClass().getName()));
        }
        return new DummyRef(expression.getType(), resolvedElement);
    }

    public Value dfsPsiConditionalExpressionBuilder(PsiConditionalExpression expression) {
        PsiExpression conditionCheckExpression = expression.getCondition();
        PsiExpression trueBranchExpression = expression.getThenExpression();
        PsiExpression falseBranchExpression = expression.getElseExpression();
        Value conditionCheckExpr = this.dfsExpressionBuilder(conditionCheckExpression);
        ConditionCheckNodeImpl curConditionCheckNode = new ConditionCheckNodeImpl(this.mGraph, conditionCheckExpr);
        this.connectCurrentWorkingNode(curConditionCheckNode);
        SynthesizedLocalImpl synLocal = new SynthesizedLocalImpl(expression.getType(), expression.getText(), (PsiElement)expression);
        this.curWorkingNodeList.clear();
        this.curWorkingNodeList.add(curConditionCheckNode.getTrueBranch());
        Value trueBrachValue = this.dfsExpressionBuilder(trueBranchExpression);
        AssignStmtImpl trueBranchAssign = new AssignStmtImpl(true, null, JavaTokenType.EQ);
        trueBranchAssign.setLOp(synLocal);
        trueBranchAssign.setROp(trueBrachValue);
        GraphNodeImpl trueBranchAssignNode = new GraphNodeImpl(this.mGraph);
        trueBranchAssignNode.getStmtList().add(trueBranchAssign);
        this.connectCurrentWorkingNode(trueBranchAssignNode);
        this.curWorkingNodeList.clear();
        this.curWorkingNodeList.add(curConditionCheckNode.getFalseBranch());
        Value falseBranchValue = this.dfsExpressionBuilder(falseBranchExpression);
        AssignStmtImpl falseBranchAssign = new AssignStmtImpl(true, null, JavaTokenType.EQ);
        falseBranchAssign.setLOp(synLocal);
        falseBranchAssign.setROp(falseBranchValue);
        GraphNodeImpl falseBranchAssignNode = new GraphNodeImpl(this.mGraph);
        falseBranchAssignNode.getStmtList().add(falseBranchAssign);
        this.connectCurrentWorkingNode(falseBranchAssignNode);
        this.curWorkingNodeList.clear();
        this.curWorkingNodeList.add(trueBranchAssignNode);
        this.curWorkingNodeList.add(falseBranchAssignNode);
        return synLocal;
    }

    public Value dfsPsiInstanceOfExpressionBuilder(PsiInstanceOfExpression expression) {
        PsiType checkedType = expression.getCheckType().getType();
        PsiExpression checkedExpr = expression.getOperand();
        Value checkedVal = this.dfsExpressionBuilder(checkedExpr);
        InstanceOfExprImpl curInstanceOfExpr = new InstanceOfExprImpl(checkedType, (PsiElement)expression);
        curInstanceOfExpr.setOp(checkedVal);
        SynthesizedLocalImpl synLocal = this.createSynthesizeTemporalVariable(curInstanceOfExpr);
        return synLocal;
    }

    public Value dfsPsiTypeCastExpressionBuilder(PsiTypeCastExpression expression) {
        PsiType type = expression.getType();
        Value castedVal = this.dfsExpressionBuilder(expression.getOperand());
        CastExprImpl castExpr = new CastExprImpl(type, (PsiElement)expression);
        castExpr.setOp(castedVal);
        SynthesizedLocalImpl synLocal = this.createSynthesizeTemporalVariable(castExpr);
        return synLocal;
    }

    public Value dfsPsiPostfixExpressionBuilder(PsiPostfixExpression expression) {
        PsiExpression valuePsiExpression = expression.getOperand();
        Value valueExpr = this.dfsLHSExpressionBuilder(valuePsiExpression);
        SynthesizedLocalImpl retLocal = new SynthesizedLocalImpl(valuePsiExpression.getType(), expression.getText(), null);
        PostfixExprImpl postfixExpr = new PostfixExprImpl((PsiElement)expression, expression.getOperationTokenType(), valueExpr, expression.getType());
        AssignStmtImpl synAssign = new AssignStmtImpl(true, null, JavaTokenType.EQ);
        synAssign.setLOp(retLocal);
        synAssign.setROp(postfixExpr);
        GraphNodeImpl prefixNode = new GraphNodeImpl(this.mGraph);
        prefixNode.getStmtList().add(synAssign);
        this.connectCurrentWorkingNode(prefixNode);
        return retLocal;
    }

    public Value dfsPsiPrefixExpressionBuilder(PsiPrefixExpression expression) {
        PsiExpression valuePsiExpression = expression.getOperand();
        Value valueExpr = this.dfsLHSExpressionBuilder(valuePsiExpression);
        SynthesizedLocalImpl retLocal = new SynthesizedLocalImpl(valuePsiExpression.getType(), expression.getText(), null);
        PrefixExprImpl prefixExpr = new PrefixExprImpl((PsiElement)expression, expression.getOperationTokenType(), valueExpr, expression.getType());
        AssignStmtImpl synAssign = new AssignStmtImpl(true, null, JavaTokenType.EQ);
        synAssign.setLOp(retLocal);
        synAssign.setROp(prefixExpr);
        GraphNodeImpl prefixNode = new GraphNodeImpl(this.mGraph);
        prefixNode.getStmtList().add(synAssign);
        this.connectCurrentWorkingNode(prefixNode);
        return retLocal;
    }

    public Value dfsThisExpressionBuilder(PsiThisExpression expression) {
        PsiType thisType = expression.getType();
        PsiClassType classType = null;
        PsiCFGClass thisCFGClass = this.containerClass;
        if (thisType instanceof PsiClassType) {
            classType = (PsiClassType)thisType;
        } else {
            PsiCFGDebugUtil.LOG.warning("PsiThisExpression's type is NOT classType :" + thisType.getClass().getSimpleName());
        }
        if (classType != null) {
            PsiClass classPsiRef = classType.resolve();
            thisCFGClass = this.mScene.getOrCreateCFGClass(classPsiRef);
        }
        ThisRefImpl thisRef = new ThisRefImpl(expression, thisCFGClass, thisType);
        return thisRef;
    }

    public Value dfsDeclarationStatementBuilder(PsiDeclarationStatement currentDeclStmt) {
        PsiElement[] retElements;
        for (PsiElement curElement : retElements = currentDeclStmt.getDeclaredElements()) {
            if (curElement == null) {
                PsiCFGDebugUtil.LOG.warning("element in DeclarationStatement " + currentDeclStmt.getText() + " is null");
                continue;
            }
            if (curElement instanceof PsiLocalVariable) {
                PsiLocalVariable curLocal = (PsiLocalVariable)curElement;
                PsiType localType = curLocal.getType();
                DeclarationStmtImpl newDecl = new DeclarationStmtImpl(localType, curLocal, (PsiStatement)currentDeclStmt);
                this.connectGeneratedStmt(newDecl);
                if (this.mGraph instanceof BlockGraph) {
                    this.mGraph.addLocal(curLocal, (LocalImpl)newDecl.getLocal());
                }
                if (!curLocal.hasInitializer()) continue;
                PsiExpression initializer = curLocal.getInitializer();
                Value initExpr = this.dfsExpressionBuilder(initializer);
                AssignStmtImpl initializerStmt = new AssignStmtImpl(true, null, JavaTokenType.EQ);
                LocalImpl localExpr = (LocalImpl)newDecl.getLocal();
                initializerStmt.setROp(initExpr);
                initializerStmt.setLOp(localExpr);
                this.connectGeneratedStmt(initializerStmt);
                continue;
            }
            if (curElement instanceof PsiClass) {
                this.mScene.getOrCreateNestedClass((PsiClass)curElement, this.containerClass, this.retrieveDeclaringMethod(), this.mGraph);
                continue;
            }
            PsiCFGDebugUtil.LOG.warning("element " + curElement.getText() + " in DeclarationStmt " + currentDeclStmt.getText() + " cannot be resolved");
        }
        return null;
    }

    private GraphNode connectGeneratedStmt(Stmt stmt) {
        Value rOP;
        GraphNodeImpl newNode = new GraphNodeImpl(this.mGraph);
        newNode.getStmtList().add(stmt);
        if (this.curWorkingNodeList.isEmpty()) {
            this.curWorkingNodeList.add(this.mGraph.getUnreachableNodeEntry());
        }
        for (GraphNode parentNode : this.curWorkingNodeList) {
            GraphNodeUtil.connectGraphNode(parentNode, newNode);
        }
        this.curWorkingNodeList.clear();
        this.curWorkingNodeList.add(newNode);
        if (stmt.containsInvokeExpr()) {
            newNode.setInvocation();
            this.mScene.addInvocationNode(newNode);
        }
        if (stmt instanceof AssignStmt && (rOP = ((AssignStmt)stmt).getROp()) instanceof NewExpr) {
            NewExpr newExpr = (NewExpr)rOP;
            if (((NewExpr)rOP).containsConstructorInvocation()) {
                newNode.setInvocation();
                this.mScene.addInvocationNode(newNode);
            }
        }
        return newNode;
    }

    private void checkUnreachable() {
        if (this.curWorkingNodeList.isEmpty()) {
            this.curWorkingNodeList.add(this.mGraph.getUnreachableNodeEntry());
        }
    }

    private void connectCurrentWorkingNode(GraphNode node) {
        this.checkUnreachable();
        for (GraphNode parent : this.curWorkingNodeList) {
            parent.addOut(node);
            node.addIn(parent);
        }
        this.curWorkingNodeList.clear();
        this.curWorkingNodeList.add(node);
    }
}

