/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.explorer;

import com.android.tools.idea.concurrent.EdtExecutor;
import com.android.tools.idea.explorer.DeviceExplorerController;
import com.android.tools.idea.explorer.DeviceExplorerFileManagerImpl;
import com.android.tools.idea.explorer.DeviceExplorerModel;
import com.android.tools.idea.explorer.adbimpl.AdbDeviceFileSystemRendererFactory;
import com.android.tools.idea.explorer.adbimpl.AdbDeviceFileSystemService;
import com.android.tools.idea.explorer.ui.DeviceExplorerViewImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowFactory;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.ide.PooledThreadExecutor;

public class DeviceExplorerToolWindowFactory
implements DumbAware,
ToolWindowFactory {
    public static final String TOOL_WINDOW_ID = "Device File Explorer";

    public void createToolWindowContent(@NotNull Project project, @NotNull ToolWindow toolWindow) {
        EdtExecutor edtExecutor = EdtExecutor.INSTANCE;
        ExecutorService taskExecutor = PooledThreadExecutor.INSTANCE;
        AdbDeviceFileSystemService service = new AdbDeviceFileSystemService(aVoid -> AndroidSdkUtils.getAdb(project), (Executor)edtExecutor, taskExecutor, (Disposable)project);
        AdbDeviceFileSystemRendererFactory deviceFileSystemRendererFactory = new AdbDeviceFileSystemRendererFactory(service);
        DeviceExplorerFileManagerImpl fileManager = new DeviceExplorerFileManagerImpl(project, (Executor)edtExecutor);
        DeviceExplorerModel model2 = new DeviceExplorerModel();
        DeviceExplorerViewImpl view = new DeviceExplorerViewImpl(project, toolWindow, deviceFileSystemRendererFactory, model2);
        DeviceExplorerController controller = new DeviceExplorerController(project, model2, view, service, fileManager, (Executor)edtExecutor, taskExecutor);
        controller.setup();
    }
}

