/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.explorer.adbimpl;

import com.android.tools.idea.explorer.adbimpl.AdbDeviceFileSystem;
import com.android.tools.idea.explorer.adbimpl.AdbFileListingEntry;
import com.android.tools.idea.explorer.fs.DeviceFileEntry;
import com.android.tools.idea.explorer.fs.DeviceFileSystem;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AdbDeviceFileEntry
implements DeviceFileEntry {
    public static final String SYMBOLIC_LINK_INFO_PREFIX = "-> ";
    @NotNull
    protected final AdbDeviceFileSystem myDevice;
    @NotNull
    protected final AdbFileListingEntry myEntry;
    @Nullable
    protected final AdbDeviceFileEntry myParent;

    public AdbDeviceFileEntry(@NotNull AdbDeviceFileSystem device, @NotNull AdbFileListingEntry entry, @Nullable AdbDeviceFileEntry parent) {
        this.myDevice = device;
        this.myEntry = entry;
        this.myParent = parent;
    }

    public String toString() {
        return this.myEntry.toString();
    }

    @Override
    @NotNull
    public DeviceFileSystem getFileSystem() {
        return this.myDevice;
    }

    @Override
    @Nullable
    public AdbDeviceFileEntry getParent() {
        return this.myParent;
    }

    @Override
    @NotNull
    public String getName() {
        return this.myEntry.getName();
    }

    @Override
    @NotNull
    public String getFullPath() {
        return this.myEntry.getFullPath();
    }

    @Override
    @NotNull
    public DeviceFileEntry.Permissions getPermissions() {
        return new AdbPermissions(this.myEntry.getPermissions());
    }

    @Override
    @NotNull
    public DeviceFileEntry.DateTime getLastModifiedDate() {
        return new AdbDateTime(this.myEntry.getDate(), this.myEntry.getTime());
    }

    @Override
    public long getSize() {
        return this.myEntry.getSize();
    }

    @Override
    public boolean isDirectory() {
        return this.myEntry.isDirectory();
    }

    @Override
    public boolean isFile() {
        return this.myEntry.isFile();
    }

    @Override
    public boolean isSymbolicLink() {
        return this.myEntry.isSymbolicLink();
    }

    @Override
    @Nullable
    public String getSymbolicLinkTarget() {
        if (!this.isSymbolicLink()) {
            return null;
        }
        String info = this.myEntry.getInfo();
        if (StringUtil.isEmpty((String)info) || !info.startsWith(SYMBOLIC_LINK_INFO_PREFIX)) {
            return null;
        }
        return info.substring(SYMBOLIC_LINK_INFO_PREFIX.length());
    }

    public static class AdbDateTime
    implements DeviceFileEntry.DateTime {
        private final String myDate;
        private final String myTime;

        public AdbDateTime(String date, String time2) {
            this.myDate = date;
            this.myTime = time2;
        }

        @Override
        @NotNull
        public String getText() {
            if (StringUtil.isEmpty((String)this.myDate)) {
                return "";
            }
            if (StringUtil.isEmpty((String)this.myTime)) {
                return this.myDate;
            }
            return this.myDate + " " + this.myTime;
        }
    }

    public static class AdbPermissions
    implements DeviceFileEntry.Permissions {
        private final String myValue;

        public AdbPermissions(String value2) {
            this.myValue = value2;
        }

        @Override
        @NotNull
        public String getText() {
            return StringUtil.notNullize((String)this.myValue);
        }
    }
}

