/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.explorer.adbimpl;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.MultiLineReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.android.tools.idea.explorer.adbimpl.AdbShellCommandResult;
import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class AdbShellCommandsUtil {
    @NotNull
    private static final Logger LOGGER = Logger.getInstance(AdbShellCommandsUtil.class);
    @NotNull
    private static final String ERROR_LINE_MARKER = "ERR-ERR-ERR-ERR";
    @NotNull
    private static final String COMMAND_ERROR_CHECK_SUFFIX = " || echo ERR-ERR-ERR-ERR";

    public static AdbShellCommandResult executeCommand(@NotNull IDevice device, @NotNull String command) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        return AdbShellCommandsUtil.executeCommandImpl(device, command, true);
    }

    public static AdbShellCommandResult executeCommandNoErrorCheck(@NotNull IDevice device, @NotNull String command) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        return AdbShellCommandsUtil.executeCommandImpl(device, command, false);
    }

    public static void executeRawCommand(@NotNull IDevice device, @NotNull String command, IShellOutputReceiver receiver) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        long startTime = System.nanoTime();
        AdbShellCommandsUtil.executeCommandImpl(device, command, receiver);
        if (LOGGER.isTraceEnabled()) {
            long endTime = System.nanoTime();
            LOGGER.trace(String.format(Locale.US, "Command took %,d ms to execute: %s", (endTime - startTime) / 1000000L, command));
        }
    }

    private static AdbShellCommandResult executeCommandImpl(@NotNull IDevice device, @NotNull String command, boolean errorCheck) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        final ArrayList<String> commandOutput = new ArrayList<String>();
        String fullCommand = errorCheck ? String.format("%s%s", command, COMMAND_ERROR_CHECK_SUFFIX) : command;
        AdbShellCommandsUtil.executeCommandImpl(device, fullCommand, (IShellOutputReceiver)new MultiLineReceiver(){

            public void processNewLines(@NotNull String[] lines) {
                Arrays.stream(lines).forEach(commandOutput::add);
            }

            public boolean isCancelled() {
                return false;
            }
        });
        boolean isError = false;
        if (errorCheck && commandOutput.size() >= 2 && Objects.equals(commandOutput.get(commandOutput.size() - 2), ERROR_LINE_MARKER) && Objects.equals(commandOutput.get(commandOutput.size() - 1), "")) {
            isError = true;
            commandOutput.remove(commandOutput.get(commandOutput.size() - 1));
            commandOutput.remove(commandOutput.get(commandOutput.size() - 1));
        }
        if (commandOutput.size() >= 1) {
            LOGGER.info(String.format(Locale.US, "  Output line 1 (out of %d): %s", commandOutput.size(), commandOutput.get(0)));
        }
        if (commandOutput.size() >= 2) {
            LOGGER.info(String.format(Locale.US, "  Output line 2 (out of %d): %s", commandOutput.size(), commandOutput.get(1)));
        }
        if (LOGGER.isDebugEnabled()) {
            for (int i2 = 2; i2 < commandOutput.size(); ++i2) {
                LOGGER.debug(String.format(Locale.US, "  Output line %d (out of %d): %s", i2 + 1, commandOutput.size(), commandOutput.get(i2)));
            }
        }
        return new AdbShellCommandResult(command, commandOutput, isError);
    }

    private static void executeCommandImpl(@NotNull IDevice device, @NotNull String command, IShellOutputReceiver receiver) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        long startTime = System.nanoTime();
        device.executeShellCommand(command, receiver);
        long endTime = System.nanoTime();
        LOGGER.info(String.format(Locale.US, "Command took %,d ms to execute: %s", (endTime - startTime) / 1000000L, command));
    }
}

