/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.explorer.fs;

import com.android.tools.idea.explorer.fs.DeviceFileSystem;
import com.android.tools.idea.explorer.fs.FileTransferProgress;
import com.google.common.util.concurrent.ListenableFuture;
import java.nio.file.Path;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DeviceFileEntry {
    @NotNull
    public DeviceFileSystem getFileSystem();

    @Nullable
    public DeviceFileEntry getParent();

    @NotNull
    public String getName();

    @NotNull
    public String getFullPath();

    @NotNull
    public ListenableFuture<List<DeviceFileEntry>> getEntries();

    @NotNull
    public ListenableFuture<Void> delete();

    @NotNull
    public ListenableFuture<Void> createNewFile(@NotNull String var1);

    @NotNull
    public ListenableFuture<Void> createNewDirectory(@NotNull String var1);

    @NotNull
    public ListenableFuture<Boolean> isSymbolicLinkToDirectory();

    @NotNull
    public ListenableFuture<Void> downloadFile(@NotNull Path var1, @NotNull FileTransferProgress var2);

    @NotNull
    default public ListenableFuture<Void> uploadFile(@NotNull Path localPath, @NotNull FileTransferProgress progress) {
        return this.uploadFile(localPath, localPath.getFileName().toString(), progress);
    }

    @NotNull
    public ListenableFuture<Void> uploadFile(@NotNull Path var1, @NotNull String var2, @NotNull FileTransferProgress var3);

    @NotNull
    public Permissions getPermissions();

    @NotNull
    public DateTime getLastModifiedDate();

    public long getSize();

    public boolean isDirectory();

    public boolean isFile();

    public boolean isSymbolicLink();

    @Nullable
    public String getSymbolicLinkTarget();

    public static interface DateTime {
        @NotNull
        public String getText();
    }

    public static interface Permissions {
        @NotNull
        public String getText();
    }
}

