/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.explorer.ui;

import com.android.tools.adtui.common.ColumnTreeBuilder;
import com.android.tools.idea.apk.viewer.ApkViewPanel;
import com.android.tools.idea.explorer.DeviceFileEntryNode;
import com.android.tools.idea.explorer.ErrorNode;
import com.android.tools.idea.explorer.MyLoadingNode;
import com.android.tools.idea.explorer.fs.DeviceFileEntry;
import com.android.tools.idea.explorer.fs.DeviceFileSystem;
import com.android.tools.idea.explorer.ui.ProgressPanel;
import com.intellij.icons.AllIcons;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.LoadingNode;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeviceExplorerPanel {
    private static final int TEXT_RENDERER_HORIZ_PADDING = 6;
    private static final int TEXT_RENDERER_VERT_PADDING = 4;
    private JComboBox myDeviceCombo;
    private JComponent myColumnTreePane;
    private JPanel myComponent;
    private JPanel myToolbarPanel;
    private ProgressPanel myProgressPanel;
    private JPanel myErrorPanel;
    private JBLabel myErrorText;
    private Tree myTree;

    public DeviceExplorerPanel() {
        this.$$$setupUI$$$();
        this.myErrorPanel.setBackground(UIUtil.getTreeBackground());
        Font font = this.myErrorText.getFont();
        this.myErrorText.setFont(font.deriveFont(font.getStyle(), font.getSize() + 4));
        this.myErrorText.setForeground(UIUtil.getInactiveTextColor());
    }

    @NotNull
    public JPanel getComponent() {
        return this.myComponent;
    }

    @NotNull
    public JComboBox<DeviceFileSystem> getDeviceCombo() {
        return this.myDeviceCombo;
    }

    @NotNull
    public ProgressPanel getProgressPanel() {
        return this.myProgressPanel;
    }

    public JBScrollPane getColumnTreePane() {
        return (JBScrollPane)this.myColumnTreePane.getComponent(0);
    }

    public void showMessageLayer(@NotNull String message2, boolean showDeviceList) {
        this.showMessageLayerWorker(message2, UIUtil.getInactiveTextColor(), null, showDeviceList);
    }

    public void showMessageLayer(@NotNull String message2, @NotNull Icon messageIcon, boolean showDeviceList) {
        this.showMessageLayerWorker(message2, UIUtil.getInactiveTextColor(), messageIcon, showDeviceList);
    }

    public void showErrorMessageLayer(@NotNull String errorMessage, boolean showDeviceList) {
        this.showMessageLayerWorker(errorMessage, (Color)JBColor.RED, null, showDeviceList);
    }

    private void showMessageLayerWorker(@NotNull String message2, @NotNull Color color, @Nullable Icon icon2, boolean showDeviceList) {
        this.myErrorText.setForeground(color);
        this.myErrorText.setIcon(icon2);
        this.myDeviceCombo.setVisible(showDeviceList);
        this.myColumnTreePane.setVisible(false);
        String htmlText = String.format("<html><div style='text-align: center;'>%s</div></html>", StringUtil.escapeXml((String)message2));
        this.myErrorText.setText(htmlText);
        this.myErrorPanel.setVisible(true);
    }

    public void showTree() {
        this.myErrorPanel.setVisible(false);
        this.myDeviceCombo.setVisible(true);
        this.myColumnTreePane.setVisible(true);
        this.myErrorText.setText("");
    }

    public void setCancelActionListener(@Nullable ActionListener cancelActionListener) {
        this.myProgressPanel.setCancelActionListener(cancelActionListener);
    }

    private void createToolbar() {
        ActionManager actionManager = ActionManager.getInstance();
        ActionToolbar actionToolbar = actionManager.createActionToolbar("Device Explorer Toolbar", (ActionGroup)((DefaultActionGroup)actionManager.getAction("Android.DeviceExplorer.ActionsToolbar")), true);
        actionToolbar.setTargetComponent((JComponent)this.myTree);
        this.myToolbarPanel.add((Component)actionToolbar.getComponent(), "Center");
    }

    private void createUIComponents() {
        this.createTree();
    }

    private void createTree() {
        DefaultTreeModel treeModel = new DefaultTreeModel((TreeNode)new LoadingNode());
        this.myTree = new Tree(treeModel){

            protected boolean shouldShowBusyIconIfNeeded() {
                return true;
            }
        };
        this.myTree.setShowsRootHandles(true);
        this.myTree.setRootVisible(true);
        TreeSpeedSearch treeSpeedSearch = new TreeSpeedSearch(this.myTree, path -> {
            DeviceFileEntryNode node = DeviceFileEntryNode.fromNode(path.getLastPathComponent());
            if (node == null) {
                return null;
            }
            return node.getEntry().getName();
        }, true);
        ColumnTreeBuilder builder = new ColumnTreeBuilder((JTree)this.myTree).setBackground(UIUtil.getTreeBackground()).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Name").setPreferredWidth(JBUI.scale((int)600)).setHeaderAlignment(10).setHeaderBorder((Border)JBUI.Borders.empty((int)4, (int)6)).setRenderer((ColoredTreeCellRenderer)new NameRenderer(treeSpeedSearch))).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Permissions").setPreferredWidth(JBUI.scale((int)190)).setHeaderAlignment(10).setHeaderBorder((Border)JBUI.Borders.empty((int)4, (int)6)).setRenderer((ColoredTreeCellRenderer)new PermissionsRenderer())).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Date").setPreferredWidth(JBUI.scale((int)280)).setHeaderAlignment(10).setHeaderBorder((Border)JBUI.Borders.empty((int)4, (int)6)).setRenderer((ColoredTreeCellRenderer)new DateRenderer())).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Size").setPreferredWidth(JBUI.scale((int)130)).setHeaderAlignment(10).setHeaderBorder((Border)JBUI.Borders.empty((int)4, (int)6)).setRenderer((ColoredTreeCellRenderer)new SizeRenderer()));
        this.myColumnTreePane = builder.build();
    }

    @NotNull
    public Tree getTree() {
        return this.myTree;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        ProgressPanel progressPanel;
        JBLabel jBLabel;
        JPanel jPanel;
        JPanel jPanel2;
        JComboBox jComboBox;
        JPanel jPanel3;
        this.createUIComponents();
        this.myComponent = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), 1, 1, false, false));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        this.myDeviceCombo = jComboBox = new JComboBox();
        jPanel4.add(jComboBox, new GridConstraints(0, 0, 1, 1, 8, 1, 7, 0, null, null, null));
        this.myToolbarPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel2, new GridConstraints(0, 1, 1, 1, 0, 3, 0, 3, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel5, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        JComponent jComponent = this.myColumnTreePane;
        jPanel5.add((Component)jComponent, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myErrorPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        ((Component)jPanel).setVisible(false);
        jPanel5.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(120, 10, 0, 10), null, 0, 0, null, null));
        this.myErrorText = jBLabel = new JBLabel();
        jBLabel.setHorizontalAlignment(0);
        jBLabel.setHorizontalTextPosition(0);
        jBLabel.setVerticalAlignment(1);
        jBLabel.setVerticalTextPosition(3);
        jPanel.add((Component)jBLabel, "Center");
        this.myProgressPanel = progressPanel = new ProgressPanel();
        ((Component)progressPanel).setVisible(false);
        jPanel3.add((Component)progressPanel, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myComponent;
    }

    private static class SizeRenderer
    extends ColoredTreeCellRenderer {
        private SizeRenderer() {
        }

        public void customizeCellRenderer(@NotNull JTree tree, @Nullable Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DeviceFileEntryNode node = DeviceFileEntryNode.fromNode(value2);
            if (node != null) {
                long size;
                long l = size = node.isUploading() ? node.getCurrentTransferredBytes() : node.getEntry().getSize();
                if (size >= 0L) {
                    this.setTextAlign(4);
                    this.append(ApkViewPanel.getHumanizedSize(size));
                }
            }
            this.setIpad((Insets)JBUI.insets((int)0, (int)6, (int)0, (int)6));
        }
    }

    private static class DateRenderer
    extends ColoredTreeCellRenderer {
        private DateRenderer() {
        }

        public void customizeCellRenderer(@NotNull JTree tree, @Nullable Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DeviceFileEntryNode node = DeviceFileEntryNode.fromNode(value2);
            if (node != null) {
                DeviceFileEntry.DateTime date = node.getEntry().getLastModifiedDate();
                this.append(date.getText());
            }
            this.setIpad((Insets)JBUI.insets((int)0, (int)6, (int)0, (int)6));
        }
    }

    private static class PermissionsRenderer
    extends ColoredTreeCellRenderer {
        private PermissionsRenderer() {
        }

        public void customizeCellRenderer(@NotNull JTree tree, @Nullable Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DeviceFileEntryNode node = DeviceFileEntryNode.fromNode(value2);
            if (node != null) {
                this.append(node.getEntry().getPermissions().getText());
            }
            this.setIpad((Insets)JBUI.insets((int)0, (int)6, (int)0, (int)6));
        }
    }

    private static class NameRenderer
    extends ColoredTreeCellRenderer {
        @NotNull
        private final TreeSpeedSearch mySpeedSearch;

        public NameRenderer(@NotNull TreeSpeedSearch speedSearch) {
            this.mySpeedSearch = speedSearch;
        }

        public void customizeCellRenderer(@NotNull JTree tree, @Nullable Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            this.setToolTipText(null);
            this.setIcon(null);
            this.setIpad((Insets)JBUI.insets((int)0, (int)0, (int)0, (int)6));
            DeviceFileEntryNode node = DeviceFileEntryNode.fromNode(value2);
            if (node != null) {
                String linkTarget;
                this.setIcon(NameRenderer.getIconFor(node));
                SimpleTextAttributes attr = SimpleTextAttributes.REGULAR_ATTRIBUTES;
                SearchUtil.appendFragments((String)this.mySpeedSearch.getEnteredPrefix(), (String)node.getEntry().getName(), (int)attr.getStyle(), (Color)attr.getFgColor(), (Color)attr.getBgColor(), (SimpleColoredComponent)this);
                if (node.isTransferring()) {
                    if (node.getTotalTransferredBytes() > 0L) {
                        this.append(String.format(" (%s / %s) ", ApkViewPanel.getHumanizedSize(node.getCurrentTransferredBytes()), ApkViewPanel.getHumanizedSize(node.getTotalTransferredBytes())), SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
                    } else if (node.getCurrentTransferredBytes() > 0L) {
                        this.append(String.format(" (%s) ", ApkViewPanel.getHumanizedSize(node.getCurrentTransferredBytes())), SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
                    } else {
                        this.appendProgress(node.getTransferringTick());
                    }
                }
                if (!StringUtil.isEmpty((String)(linkTarget = node.getEntry().getSymbolicLinkTarget()))) {
                    this.setToolTipText("Link target: " + linkTarget);
                }
            } else if (value2 instanceof ErrorNode) {
                ErrorNode errorNode = (ErrorNode)value2;
                this.append(errorNode.getText(), SimpleTextAttributes.ERROR_ATTRIBUTES);
            } else if (value2 instanceof MyLoadingNode) {
                MyLoadingNode loadingNode = (MyLoadingNode)((Object)value2);
                this.append("loading", SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
                this.appendProgress(loadingNode.getTick());
            }
        }

        private void appendProgress(int tick) {
            int mod = 20;
            int progressTick = tick % mod;
            if (progressTick >= mod / 2) {
                progressTick = mod - progressTick;
            }
            this.append(StringUtil.repeatSymbol((char)' ', (int)progressTick));
            this.append(StringUtil.repeatSymbol((char)'.', (int)3));
        }

        @NotNull
        private static Icon getIconFor(@NotNull DeviceFileEntryNode node) {
            Icon icon2 = NameRenderer.getIconForImpl(node);
            if (node.getEntry().isSymbolicLink()) {
                return new LayeredIcon(new Icon[]{icon2, PlatformIcons.SYMLINK_ICON});
            }
            return icon2;
        }

        @NotNull
        private static Icon getIconForImpl(@NotNull DeviceFileEntryNode node) {
            DeviceFileEntry entry = node.getEntry();
            if (entry.isDirectory() || node.isSymbolicLinkToDirectory()) {
                return AllIcons.Nodes.Folder;
            }
            if (entry.isFile() || entry.isSymbolicLink()) {
                LightVirtualFile file = new LightVirtualFile(entry.getName());
                Icon ftIcon = file.getFileType().getIcon();
                return ftIcon == null ? AllIcons.FileTypes.Any_type : ftIcon;
            }
            return AllIcons.FileTypes.Any_type;
        }
    }
}

