/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.explorer.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.progress.util.ColorProgressBar;
import com.intellij.openapi.ui.popup.IconButton;
import com.intellij.ui.InplaceButton;
import com.intellij.ui.JBProgressBar;
import com.intellij.ui.SimpleColoredComponent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProgressPanel
extends JPanel {
    private static final int PROGRESS_STEPS = 1000;
    @NotNull
    private final JProgressBar myProgressBar;
    @NotNull
    private final SimpleColoredComponent myState = new SimpleColoredComponent(){

        @NotNull
        public Dimension getMinimumSize() {
            return new Dimension(0, 0);
        }
    };
    @Nullable
    private ActionListener myCancelActionListener;

    public ProgressPanel() {
        this.myProgressBar = new JBProgressBar();
        this.myProgressBar.setMaximum(1000);
        IconButton stopIcon = new IconButton("Cancel", AllIcons.Process.Stop, AllIcons.Process.StopHovered);
        InplaceButton cancelButton = new InplaceButton(stopIcon, e -> {
            if (this.myCancelActionListener != null) {
                this.myCancelActionListener.actionPerformed(e);
            }
        });
        this.setOkStatusColor();
        this.setVisible(false);
        BorderLayout layout2 = new BorderLayout(0, 0);
        this.setLayout(layout2);
        this.add((Component)this.myState, "North");
        this.add((Component)this.myProgressBar, "Center");
        this.add((Component)cancelButton, "East");
    }

    public void start() {
        this.clear();
        this.setVisible(true);
    }

    public void stop() {
        this.setVisible(false);
        this.clear();
    }

    private void clear() {
        this.setProgress(0.0);
        this.setText("");
        this.setOkStatusColor();
    }

    public void setCancelActionListener(@Nullable ActionListener cancelActionListener) {
        this.myCancelActionListener = cancelActionListener;
    }

    public void setOkStatusColor() {
        this.myProgressBar.setForeground(ColorProgressBar.GREEN);
    }

    public void setWarningStatusColor() {
        this.myProgressBar.setForeground(ColorProgressBar.YELLOW);
    }

    public void setErrorStatusColor() {
        this.myProgressBar.setForeground(ColorProgressBar.RED);
    }

    public void setProgress(double v) {
        int fraction = (int)(v * 1000.0);
        this.myProgressBar.setValue(fraction);
    }

    public void setIndeterminate(boolean indeterminate) {
        this.myProgressBar.setIndeterminate(indeterminate);
    }

    public void setText(@NotNull String text) {
        this.myState.clear();
        this.myState.append(text);
    }
}

