/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.flags;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.project.GradleExperimentalSettings;
import com.android.tools.idea.rendering.RenderSettings;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Hashtable;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.text.NumberFormatter;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExperimentalSettingsConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    @NotNull
    private final GradleExperimentalSettings mySettings;
    @NotNull
    private final RenderSettings myRenderSettings;
    private JPanel myPanel;
    private JSpinner myModuleNumberSpinner;
    private JCheckBox mySkipSourceGenOnSyncCheckbox;
    private JCheckBox myUseL2DependenciesCheckBox;
    private JCheckBox myUseSingleVariantSyncCheckbox;
    private JCheckBox mySkipSourcesAndJavadocDownload;
    private JSlider myLayoutEditorQualitySlider;
    private JCheckBox myNewPsdCheckbox;
    private TitledSeparator myNewPsdSeparator;

    public ExperimentalSettingsConfigurable(@NotNull Project project) {
        this(GradleExperimentalSettings.getInstance(), RenderSettings.getProjectSettings(project));
    }

    @VisibleForTesting
    ExperimentalSettingsConfigurable(@NotNull GradleExperimentalSettings settings, @NotNull RenderSettings renderSettings) {
        this.mySettings = settings;
        this.myRenderSettings = renderSettings;
        this.$$$setupUI$$$();
        this.myUseL2DependenciesCheckBox.setVisible(false);
        Hashtable<Integer, JLabel> qualityLabels = new Hashtable<Integer, JLabel>();
        qualityLabels.put(new Integer(0), new JLabel("Fastest"));
        qualityLabels.put(new Integer(100), new JLabel("Slowest"));
        this.myLayoutEditorQualitySlider.setLabelTable(qualityLabels);
        this.myLayoutEditorQualitySlider.setPaintLabels(true);
        this.myLayoutEditorQualitySlider.setPaintTicks(true);
        this.myLayoutEditorQualitySlider.setMajorTickSpacing(25);
        this.myNewPsdSeparator.setVisible(((Boolean)StudioFlags.NEW_PSD_ENABLED.get()).booleanValue());
        this.myNewPsdCheckbox.setVisible((Boolean)StudioFlags.NEW_PSD_ENABLED.get());
        this.reset();
    }

    @NotNull
    public String getId() {
        return "gradle.experimental";
    }

    @Nullable
    public Runnable enableSearch(String option) {
        return null;
    }

    @Nls
    public String getDisplayName() {
        return "Experimental";
    }

    @Nullable
    public String getHelpTopic() {
        return null;
    }

    @NotNull
    public JComponent createComponent() {
        return this.myPanel;
    }

    public boolean isModified() {
        if (this.mySettings.SKIP_SOURCE_GEN_ON_PROJECT_SYNC != this.isSkipSourceGenOnSync() || this.mySettings.USE_L2_DEPENDENCIES_ON_SYNC != this.isUseL2DependenciesInSync() || this.mySettings.USE_SINGLE_VARIANT_SYNC != this.isUseSingleVariantSync() || this.mySettings.SKIP_SRC_AND_JAVADOC_DOWNLOAD_ON_SYNC != this.skipSourcesAndJavadocDownload() || (int)(this.myRenderSettings.getQuality() * 100.0f) != this.getQualitySetting() || this.mySettings.USE_NEW_PSD != this.isUseNewPsd()) {
            return true;
        }
        Integer value2 = this.getMaxModuleCountForSourceGen();
        return value2 != null && this.mySettings.MAX_MODULE_COUNT_FOR_SOURCE_GEN != value2;
    }

    private int getQualitySetting() {
        return this.myLayoutEditorQualitySlider.getValue();
    }

    public void apply() throws ConfigurationException {
        this.mySettings.SKIP_SOURCE_GEN_ON_PROJECT_SYNC = this.isSkipSourceGenOnSync();
        this.mySettings.USE_L2_DEPENDENCIES_ON_SYNC = this.isUseL2DependenciesInSync();
        this.mySettings.USE_SINGLE_VARIANT_SYNC = this.isUseSingleVariantSync();
        this.mySettings.SKIP_SRC_AND_JAVADOC_DOWNLOAD_ON_SYNC = this.skipSourcesAndJavadocDownload();
        Integer value2 = this.getMaxModuleCountForSourceGen();
        if (value2 != null) {
            this.mySettings.MAX_MODULE_COUNT_FOR_SOURCE_GEN = value2;
        }
        this.myRenderSettings.setQuality((float)this.getQualitySetting() / 100.0f);
        this.mySettings.USE_NEW_PSD = this.isUseNewPsd();
    }

    @VisibleForTesting
    @Nullable
    Integer getMaxModuleCountForSourceGen() {
        Object value2 = this.myModuleNumberSpinner.getValue();
        return value2 instanceof Integer ? (Integer)value2 : null;
    }

    void setMaxModuleCountForSourceGen(int value2) {
        this.myModuleNumberSpinner.setValue(value2);
    }

    @VisibleForTesting
    boolean isSkipSourceGenOnSync() {
        return this.mySkipSourceGenOnSyncCheckbox.isSelected();
    }

    void setSkipSourceGenOnSync(boolean value2) {
        this.mySkipSourceGenOnSyncCheckbox.setSelected(value2);
    }

    @VisibleForTesting
    boolean isUseL2DependenciesInSync() {
        return this.myUseL2DependenciesCheckBox.isSelected();
    }

    void setUseL2DependenciesInSync(boolean value2) {
        this.myUseL2DependenciesCheckBox.setSelected(value2);
    }

    boolean isUseSingleVariantSync() {
        return this.myUseSingleVariantSyncCheckbox.isSelected();
    }

    boolean skipSourcesAndJavadocDownload() {
        return this.mySkipSourcesAndJavadocDownload.isSelected();
    }

    void setUseSingleVariantSync(boolean value2) {
        this.myUseSingleVariantSyncCheckbox.setSelected(value2);
    }

    boolean isUseNewPsd() {
        return this.myNewPsdCheckbox.isSelected();
    }

    void setUseNewPsd(boolean value2) {
        this.myNewPsdCheckbox.setSelected(value2);
    }

    public void reset() {
        this.mySkipSourceGenOnSyncCheckbox.setSelected(this.mySettings.SKIP_SOURCE_GEN_ON_PROJECT_SYNC);
        this.myModuleNumberSpinner.setValue(this.mySettings.MAX_MODULE_COUNT_FOR_SOURCE_GEN);
        this.myUseL2DependenciesCheckBox.setSelected(this.mySettings.USE_L2_DEPENDENCIES_ON_SYNC);
        this.myUseSingleVariantSyncCheckbox.setSelected(this.mySettings.USE_SINGLE_VARIANT_SYNC);
        this.mySkipSourcesAndJavadocDownload.setSelected(this.mySettings.SKIP_SRC_AND_JAVADOC_DOWNLOAD_ON_SYNC);
        this.myLayoutEditorQualitySlider.setValue((int)(this.myRenderSettings.getQuality() * 100.0f));
        this.myNewPsdCheckbox.setSelected(this.mySettings.USE_NEW_PSD);
    }

    private void createUIComponents() {
        JFormattedTextField textField2;
        JFormattedTextField.AbstractFormatter formatter;
        int value2 = GradleExperimentalSettings.getInstance().MAX_MODULE_COUNT_FOR_SOURCE_GEN;
        this.myModuleNumberSpinner = new JSpinner(new SpinnerNumberModel(value2, 0, Integer.MAX_VALUE, 1));
        JComponent editor2 = this.myModuleNumberSpinner.getEditor();
        if (editor2 instanceof JSpinner.NumberEditor && (formatter = (textField2 = ((JSpinner.NumberEditor)editor2).getTextField()).getFormatter()) instanceof NumberFormatter) {
            ((NumberFormatter)formatter).setAllowsInvalid(false);
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        TitledSeparator titledSeparator;
        JSlider jSlider;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JCheckBox jCheckBox5;
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(12, 8, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("<html><b>Note:</b> These settings are for features that are considered <b>experimental</b>.</html>");
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 8, 0, 1, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(11, 4, 1, 4, 0, 2, 1, 6, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("<html><br></html>");
        jPanel.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 6, 0, 0, 0, 0, null, null, null));
        this.mySkipSourceGenOnSyncCheckbox = jCheckBox5 = new JCheckBox();
        jCheckBox5.setText("Skip source generation on Gradle sync if a project has more than");
        jPanel.add((Component)jCheckBox5, new GridConstraints(3, 0, 1, 6, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("<html><br></html>");
        jPanel.add((Component)jBLabel3, new GridConstraints(4, 7, 1, 1, 0, 0, 0, 0, null, null, null));
        JSpinner jSpinner = this.myModuleNumberSpinner;
        jPanel.add((Component)jSpinner, new GridConstraints(3, 6, 1, 1, 8, 0, 1, 0, null, null, null));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setText("modules.");
        jPanel.add((Component)jBLabel4, new GridConstraints(3, 7, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myUseL2DependenciesCheckBox = jCheckBox4 = new JCheckBox();
        jCheckBox4.setText("Use new dependency mechanism during Gradle sync");
        jPanel.add((Component)jCheckBox4, new GridConstraints(5, 0, 1, 6, 8, 0, 3, 0, null, null, null));
        TitledSeparator titledSeparator2 = new TitledSeparator();
        titledSeparator2.setText("Gradle");
        jPanel.add((Component)titledSeparator2, new GridConstraints(2, 0, 1, 8, 0, 1, 3, 0, null, null, null));
        this.myUseSingleVariantSyncCheckbox = jCheckBox3 = new JCheckBox();
        jCheckBox3.setText("Only sync the active variant");
        jPanel.add((Component)jCheckBox3, new GridConstraints(4, 0, 1, 6, 8, 0, 3, 0, null, null, null));
        JBLabel jBLabel5 = new JBLabel();
        jBLabel5.setText("Layout Editor quality setting");
        jPanel.add((Component)jBLabel5, new GridConstraints(8, 0, 1, 5, 8, 0, 0, 0, null, null, null));
        this.myLayoutEditorQualitySlider = jSlider = new JSlider();
        jPanel.add((Component)jSlider, new GridConstraints(8, 6, 1, 1, 0, 1, 0, 0, null, new Dimension(90, -1), null));
        TitledSeparator titledSeparator3 = new TitledSeparator();
        titledSeparator3.setText("Editor");
        jPanel.add((Component)titledSeparator3, new GridConstraints(7, 0, 1, 8, 0, 1, 3, 0, null, null, null));
        this.myNewPsdSeparator = titledSeparator = new TitledSeparator();
        titledSeparator.setText("New Project Structure Dialog");
        jPanel.add((Component)titledSeparator, new GridConstraints(9, 0, 1, 8, 0, 1, 3, 0, null, null, null));
        this.myNewPsdCheckbox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Enable");
        jPanel.add((Component)jCheckBox2, new GridConstraints(10, 0, 1, 6, 8, 0, 3, 0, null, null, null));
        this.mySkipSourcesAndJavadocDownload = jCheckBox = new JCheckBox();
        ((Component)jCheckBox).setEnabled(true);
        jCheckBox.setSelected(false);
        jCheckBox.setText("Skip download of sources and javadoc on Gradle sync");
        jPanel.add((Component)jCheckBox, new GridConstraints(6, 0, 1, 1, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

