/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.fonts;

import com.android.ide.common.fonts.FontDetail;
import com.android.ide.common.fonts.FontFamily;
import com.android.tools.idea.fonts.DownloadableFontCacheServiceImpl;
import com.android.tools.idea.fonts.FontFileDownloader;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.download.DownloadableFileDescription;
import com.intellij.util.download.DownloadableFileService;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FontDownloadService {
    private final DownloadableFontCacheServiceImpl myCacheService = DownloadableFontCacheServiceImpl.getInstance();
    private final File myFontPath = this.myCacheService.getFontPath();
    private final List<FontFamily> myFontsToDownload;
    private final boolean myDownloadMenuFontsOnly;
    private final Runnable mySuccess;
    private final Runnable myFailure;

    public static void download(@NotNull List<FontFamily> fontsToDownload, boolean menuFontsOnly, @Nullable Runnable success, @Nullable Runnable failure) {
        FontDownloadService service = new FontDownloadService(fontsToDownload, menuFontsOnly, success, failure);
        service.download();
    }

    private FontDownloadService(@NotNull List<FontFamily> fontsToDownload, boolean menuFontsOnly, @Nullable Runnable success, @Nullable Runnable failure) {
        this.myFontsToDownload = fontsToDownload;
        this.myDownloadMenuFontsOnly = menuFontsOnly;
        this.mySuccess = success;
        this.myFailure = failure;
    }

    public void download() {
        ApplicationManager.getApplication().executeOnPooledThread(this::performDownload);
    }

    private void performDownload() {
        block5: {
            ArrayList<DownloadableFileDescription> files2 = new ArrayList<DownloadableFileDescription>();
            for (FontFamily fontFamily : this.myFontsToDownload) {
                this.addFontFamily(files2, fontFamily);
            }
            if (this.myFontPath == null) {
                FontDownloadService.notify(this.myFailure);
                return;
            }
            FontFileDownloader downloader = new FontFileDownloader(files2, null, null, "Download Fonts");
            try {
                downloader.download(this.myFontPath);
                FontDownloadService.notify(this.mySuccess);
            }
            catch (Exception ex) {
                if (FontDownloadService.performSingleFileDownloads(this.myFontPath, files2)) {
                    FontDownloadService.notify(this.mySuccess);
                }
                if (this.myFailure == null) break block5;
                FontDownloadService.notify(this.myFailure);
            }
        }
    }

    private static void notify(@Nullable Runnable callback2) {
        if (callback2 != null) {
            callback2.run();
        }
    }

    private static boolean performSingleFileDownloads(@NotNull File fontPath, @NotNull List<DownloadableFileDescription> files2) {
        boolean success = true;
        for (DownloadableFileDescription file : files2) {
            FontFileDownloader downloader = new FontFileDownloader(Collections.singletonList(file), null, null, "Download Fonts");
            try {
                downloader.download(fontPath);
            }
            catch (Exception ex) {
                Logger.getInstance(FontDownloadService.class).warn("Unable to download: " + file.getDownloadUrl(), (Throwable)ex);
                success = false;
            }
        }
        return success;
    }

    private boolean cachedFileExists(@NotNull File relativeCachedFile) {
        File file = new File(this.myFontPath, relativeCachedFile.getPath());
        return file.exists();
    }

    private void addFontFamily(@NotNull List<DownloadableFileDescription> files2, @NotNull FontFamily fontFamily) {
        File file = this.myCacheService.getRelativeCachedMenuFile(fontFamily);
        if (file != null && !this.cachedFileExists(file)) {
            files2.add(FontDownloadService.createFileDescription(fontFamily.getMenu(), file));
        }
        if (!this.myDownloadMenuFontsOnly) {
            for (FontDetail font : fontFamily.getFonts()) {
                this.addFont(files2, font);
            }
        }
    }

    private void addFont(@NotNull List<DownloadableFileDescription> files2, @NotNull FontDetail font) {
        File file = this.myCacheService.getRelativeFontFile(font);
        if (file != null && !this.cachedFileExists(file)) {
            files2.add(FontDownloadService.createFileDescription(font.getFontUrl(), file));
        }
    }

    @NotNull
    private static DownloadableFileDescription createFileDescription(@NotNull String url, @NotNull File relativeFile) {
        return DownloadableFileService.getInstance().createFileDescription(url, relativeFile.getPath());
    }
}

