/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle;

import com.android.builder.model.BaseArtifact;
import com.android.builder.model.Dependencies;
import com.android.builder.model.JavaLibrary;
import com.android.builder.model.MavenCoordinates;
import com.android.ide.common.gradle.model.IdeBaseArtifact;
import com.android.ide.common.gradle.model.IdeVariant;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.GradleVersion;
import com.android.repository.io.FileOpUtils;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.android.AndroidModel;
import com.android.tools.idea.gradle.dsl.api.android.CompileOptionsModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencySpec;
import com.android.tools.idea.gradle.dsl.api.dependencies.DependenciesModel;
import com.android.tools.idea.gradle.dsl.api.java.JavaModel;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.facet.java.JavaFacet;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.util.GradleProjects;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.projectsystem.GoogleMavenArtifactId;
import com.android.tools.idea.templates.RepositoryUrlManager;
import com.android.tools.idea.testartifacts.scopes.TestArtifactSearchScopes;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.command.undo.UnexpectedUndoException;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExternalLibraryDescriptor;
import com.intellij.openapi.roots.JavaProjectModelModifier;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class AndroidGradleJavaProjectModelModifier
extends JavaProjectModelModifier {
    @NotNull
    private static final Map<String, String> EXTERNAL_LIBRARY_VERSIONS = ImmutableMap.of((Object)"net.jcip:jcip-annotations", (Object)"1.0", (Object)"org.jetbrains:annotations-java5", (Object)"15.0", (Object)"org.jetbrains:annotations", (Object)"15.0", (Object)"junit:junit", (Object)"4.12", (Object)"org.testng:testng", (Object)"6.9.6");

    @Nullable
    public Promise<Void> addModuleDependency(@NotNull Module from, @NotNull Module to, @NotNull DependencyScope scope, boolean exported) {
        final Project project = from.getProject();
        VirtualFile openedFile = FileEditorManagerEx.getInstanceEx((Project)from.getProject()).getCurrentFile();
        String gradlePath = GradleUtil.getGradlePath(to);
        final GradleBuildModel buildModel = GradleBuildModel.get(from);
        if (buildModel != null && gradlePath != null) {
            DependenciesModel dependencies = buildModel.dependencies();
            String configurationName = AndroidGradleJavaProjectModelModifier.getConfigurationName(from, scope, openedFile);
            dependencies.addModule(configurationName, gradlePath, null);
            new WriteCommandAction(project, "Add Gradle Module Dependency", new PsiFile[0]){

                protected void run(@NotNull Result result2) throws Throwable {
                    buildModel.applyChanges();
                    AndroidGradleJavaProjectModelModifier.registerUndoAction(project);
                }
            }.execute();
            return AndroidGradleJavaProjectModelModifier.requestProjectSync(project, GradleSyncStats.Trigger.TRIGGER_MODIFIER_ADD_MODULE_DEPENDENCY);
        }
        if (buildModel == null ^ gradlePath == null) {
            return Promises.rejectedPromise();
        }
        return null;
    }

    @Nullable
    public Promise<Void> addExternalLibraryDependency(@NotNull Collection<? extends Module> modules, @NotNull ExternalLibraryDescriptor descriptor2, @NotNull DependencyScope scope) {
        ArtifactDependencySpec dependencySpec = ArtifactDependencySpec.create(descriptor2.getLibraryArtifactId(), descriptor2.getLibraryGroupId(), AndroidGradleJavaProjectModelModifier.selectVersion(descriptor2));
        return AndroidGradleJavaProjectModelModifier.addExternalLibraryDependency(modules, dependencySpec, scope);
    }

    @Nullable
    public Promise<Void> addLibraryDependency(@NotNull Module from, @NotNull Library library, @NotNull DependencyScope scope, boolean exported) {
        if (!GradleFacet.isAppliedTo(from)) {
            return null;
        }
        ArtifactDependencySpec dependencySpec = AndroidGradleJavaProjectModelModifier.findNewExternalDependency(from.getProject(), library);
        if (dependencySpec == null) {
            return Promises.rejectedPromise();
        }
        return AndroidGradleJavaProjectModelModifier.addExternalLibraryDependency((Collection<? extends Module>)ImmutableList.of((Object)from), dependencySpec, scope);
    }

    @Nullable
    private static Promise<Void> addExternalLibraryDependency(@NotNull Collection<? extends Module> modules, @NotNull ArtifactDependencySpec dependencySpec, @NotNull DependencyScope scope) {
        Module firstModule = (Module)Iterables.getFirst(modules, null);
        if (firstModule == null) {
            return null;
        }
        final Project project = firstModule.getProject();
        VirtualFile openedFile = FileEditorManagerEx.getInstanceEx((Project)firstModule.getProject()).getCurrentFile();
        final ArrayList buildModelsToUpdate = Lists.newArrayList();
        for (Module module : modules) {
            GradleBuildModel buildModel = GradleBuildModel.get(module);
            if (buildModel == null) {
                return null;
            }
            String configurationName = AndroidGradleJavaProjectModelModifier.getConfigurationName(module, scope, openedFile);
            String updatedConfigName = GradleUtil.mapConfigurationName(configurationName, GradleUtil.getAndroidGradleModelVersionInUse(module), false);
            DependenciesModel dependencies = buildModel.dependencies();
            dependencies.addArtifact(updatedConfigName, dependencySpec);
            buildModelsToUpdate.add(buildModel);
        }
        new WriteCommandAction(project, "Add Gradle Library Dependency", new PsiFile[0]){

            protected void run(@NotNull Result result2) throws Throwable {
                for (GradleBuildModel buildModel : buildModelsToUpdate) {
                    buildModel.applyChanges();
                }
                AndroidGradleJavaProjectModelModifier.registerUndoAction(project);
            }
        }.execute();
        return AndroidGradleJavaProjectModelModifier.requestProjectSync(project, GradleSyncStats.Trigger.TRIGGER_MODIFIER_ADD_LIBRARY_DEPENDENCY);
    }

    @Nullable
    public Promise<Void> changeLanguageLevel(@NotNull Module module, @NotNull LanguageLevel level) {
        final Project project = module.getProject();
        if (!GradleFacet.isAppliedTo(module)) {
            return null;
        }
        final GradleBuildModel buildModel = GradleBuildModel.get(module);
        if (buildModel == null) {
            return null;
        }
        if (GradleProjects.getAndroidModel(module) != null) {
            AndroidModel android = buildModel.android();
            CompileOptionsModel compileOptions = android.compileOptions();
            compileOptions.sourceCompatibility().setLanguageLevel(level);
            compileOptions.targetCompatibility().setLanguageLevel(level);
        } else {
            JavaFacet javaFacet = JavaFacet.getInstance(module);
            if (javaFacet == null || javaFacet.getJavaModuleModel() == null) {
                return null;
            }
            JavaModel javaModel = buildModel.java();
            javaModel.sourceCompatibility().setLanguageLevel(level);
            javaModel.targetCompatibility().setLanguageLevel(level);
        }
        new WriteCommandAction(project, "Change Gradle Language Level", new PsiFile[0]){

            protected void run(@NotNull Result result2) throws Throwable {
                buildModel.applyChanges();
                AndroidGradleJavaProjectModelModifier.registerUndoAction(project);
            }
        }.execute();
        return AndroidGradleJavaProjectModelModifier.requestProjectSync(project, GradleSyncStats.Trigger.TRIGGER_MODIFIER_LANGUAGE_LEVEL_CHANGED);
    }

    @NotNull
    private static String getConfigurationName(@NotNull Module module, @NotNull DependencyScope scope, @Nullable VirtualFile openedFile) {
        TestArtifactSearchScopes testScopes;
        if (!scope.isForProductionCompile() && (testScopes = TestArtifactSearchScopes.get(module)) != null && openedFile != null) {
            return testScopes.isAndroidTestSource(openedFile) ? "androidTestCompile" : "testCompile";
        }
        return "compile";
    }

    @Nullable
    private static String selectVersion(@NotNull ExternalLibraryDescriptor descriptor2) {
        GoogleMavenArtifactId library;
        String libraryArtifactId = descriptor2.getLibraryArtifactId();
        String libraryGroupId = descriptor2.getLibraryGroupId();
        String groupAndId = libraryGroupId + ":" + libraryArtifactId;
        String version2 = EXTERNAL_LIBRARY_VERSIONS.get(groupAndId);
        if (version2 == null && (library = GoogleMavenArtifactId.Companion.find(libraryGroupId, libraryArtifactId)) != null) {
            GradleCoordinate coordinate;
            Predicate<GradleVersion> filter2 = descriptor2.getMinVersion() == null ? null : v -> v.toString().startsWith(descriptor2.getMinVersion());
            String gc = RepositoryUrlManager.get().getArtifactStringCoordinate(library, filter2, false);
            if (gc == null) {
                gc = RepositoryUrlManager.get().getLibraryRevision(libraryGroupId, libraryArtifactId, filter2, false, FileOpUtils.create());
            }
            if (gc != null && (coordinate = GradleCoordinate.parseCoordinateString((String)gc)) != null) {
                version2 = coordinate.getRevision();
            }
        }
        return version2;
    }

    @NotNull
    private static Promise<Void> requestProjectSync(@NotNull Project project, @NotNull GradleSyncStats.Trigger trigger) {
        final AsyncPromise promise = new AsyncPromise();
        GradleSyncInvoker.Request request = new GradleSyncInvoker.Request(trigger);
        request.generateSourcesOnSuccess = false;
        GradleSyncInvoker.getInstance().requestProjectSync(project, request, new GradleSyncListener(){

            @Override
            public void syncSucceeded(@NotNull Project project) {
                promise.setResult(null);
            }

            @Override
            public void syncFailed(@NotNull Project project, @NotNull String errorMessage) {
                promise.setError(errorMessage);
            }
        });
        return promise;
    }

    private static void registerUndoAction(final @NotNull Project project) {
        UndoManager.getInstance((Project)project).undoableActionPerformed((UndoableAction)new BasicUndoableAction(){

            public void undo() throws UnexpectedUndoException {
                AndroidGradleJavaProjectModelModifier.requestProjectSync(project, GradleSyncStats.Trigger.TRIGGER_MODIFIER_ACTION_UNDONE);
            }

            public void redo() throws UnexpectedUndoException {
                AndroidGradleJavaProjectModelModifier.requestProjectSync(project, GradleSyncStats.Trigger.TRIGGER_MODIFIER_ACTION_REDONE);
            }
        });
    }

    @Nullable
    private static ArtifactDependencySpec findNewExternalDependency(@NotNull Project project, @NotNull Library library) {
        if (library.getName() == null) {
            return null;
        }
        ArtifactDependencySpec result2 = null;
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            AndroidModuleModel androidModel = AndroidModuleModel.get(module);
            if (androidModel == null || LibraryUtil.findLibrary((Module)module, (String)library.getName()) == null) continue;
            result2 = AndroidGradleJavaProjectModelModifier.findNewExternalDependency(library, androidModel.getSelectedVariant());
            break;
        }
        if (result2 == null) {
            result2 = AndroidGradleJavaProjectModelModifier.findNewExternalDependencyByExaminingPath(library);
        }
        return result2;
    }

    @Nullable
    private static ArtifactDependencySpec findNewExternalDependency(@NotNull Library library, @NotNull IdeVariant selectedVariant) {
        IdeBaseArtifact testArtifact;
        JavaLibrary matchedLibrary = null;
        Iterator iterator = selectedVariant.getTestArtifacts().iterator();
        while (iterator.hasNext() && (matchedLibrary = AndroidGradleJavaProjectModelModifier.findMatchedLibrary(library, (BaseArtifact)(testArtifact = (IdeBaseArtifact)iterator.next()))) == null) {
        }
        if (matchedLibrary == null) {
            matchedLibrary = AndroidGradleJavaProjectModelModifier.findMatchedLibrary(library, (BaseArtifact)selectedVariant.getMainArtifact());
        }
        if (matchedLibrary == null) {
            return null;
        }
        MavenCoordinates coordinates = matchedLibrary.getResolvedCoordinates();
        if (coordinates == null) {
            return null;
        }
        return ArtifactDependencySpec.create(coordinates.getArtifactId(), coordinates.getGroupId(), coordinates.getVersion());
    }

    @Nullable
    private static JavaLibrary findMatchedLibrary(@NotNull Library library, @NotNull BaseArtifact artifact) {
        Dependencies dependencies = artifact.getDependencies();
        for (JavaLibrary gradleLibrary : dependencies.getJavaLibraries()) {
            String libraryName = FileUtil.getNameWithoutExtension((File)gradleLibrary.getJarFile());
            if (!libraryName.equals(library.getName())) continue;
            return gradleLibrary;
        }
        return null;
    }

    @Nullable
    private static ArtifactDependencySpec findNewExternalDependencyByExaminingPath(@NotNull Library library) {
        VirtualFile[] files2 = library.getFiles(OrderRootType.CLASSES);
        if (files2.length == 0) {
            return null;
        }
        File file = VfsUtilCore.virtualToIoFile((VirtualFile)files2[0]);
        String libraryName = library.getName();
        if (libraryName == null) {
            return null;
        }
        List pathSegments = FileUtil.splitPath((String)file.getPath());
        for (int i2 = 1; i2 < pathSegments.size() - 2; ++i2) {
            if (!libraryName.startsWith((String)pathSegments.get(i2))) continue;
            String groupId = (String)pathSegments.get(i2 - 1);
            String artifactId = (String)pathSegments.get(i2);
            String version2 = (String)pathSegments.get(i2 + 1);
            if (!libraryName.endsWith(version2)) continue;
            return ArtifactDependencySpec.create(artifactId, groupId, version2);
        }
        return null;
    }
}

