/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.actions;

import com.android.tools.idea.gradle.actions.AndroidStudioGradleAction;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.structure.editors.AndroidProjectSettingsService;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.Icon;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractProjectStructureAction
extends AndroidStudioGradleAction {
    public AbstractProjectStructureAction(@Nullable String text) {
        super(text);
    }

    protected AbstractProjectStructureAction(@Nullable String text, @Nullable String description, @Nullable Icon icon2) {
        super(text, description, icon2);
    }

    @Override
    protected void doUpdate(@NotNull AnActionEvent e, @NotNull Project project) {
        e.getPresentation().setEnabled(this.getTargetModule(e) != null);
    }

    @Override
    protected final void doPerform(@NotNull AnActionEvent e, @NotNull Project project) {
        ProjectSettingsService service;
        Module module = this.getTargetModule(e);
        if (module != null && (service = ProjectSettingsService.getInstance((Project)module.getProject())) instanceof AndroidProjectSettingsService) {
            this.doPerform(module, (AndroidProjectSettingsService)service, e);
        }
    }

    protected abstract Module getTargetModule(@NotNull AnActionEvent var1);

    @Nullable
    protected static Module getSelectedAndroidModule(@NotNull AnActionEvent e) {
        Module module = AbstractProjectStructureAction.getSelectedGradleModule(e);
        if (module != null && AndroidFacet.getInstance(module) != null) {
            return module;
        }
        return null;
    }

    @Nullable
    protected static Module getSelectedGradleModule(@NotNull AnActionEvent e) {
        ProjectFileIndex fileIndex;
        VirtualFile file;
        DataContext dataContext = e.getDataContext();
        Module module = (Module)LangDataKeys.MODULE_CONTEXT.getData(dataContext);
        if (AbstractProjectStructureAction.isGradleModule(module)) {
            return module;
        }
        Project project = e.getProject();
        if (project != null && (file = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext)) != null && AbstractProjectStructureAction.isGradleModule(module = (fileIndex = ProjectFileIndex.SERVICE.getInstance((Project)project)).getModuleForFile(file))) {
            return module;
        }
        return null;
    }

    private static boolean isGradleModule(@Nullable Module module) {
        return module != null && GradleFacet.isAppliedTo(module);
    }

    protected abstract void doPerform(@NotNull Module var1, @NotNull AndroidProjectSettingsService var2, @NotNull AnActionEvent var3);
}

