/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.actions;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.actions.GoToBundleLocationTask;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.build.invoker.GradleBuildInvoker;
import com.android.tools.idea.gradle.run.OutputBuildAction;
import com.android.tools.idea.gradle.util.DynamicAppUtils;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildBundleAction
extends DumbAwareAction {
    private static final String ACTION_TEXT = "Build Bundle(s)";

    public BuildBundleAction() {
        super(ACTION_TEXT);
    }

    public void update(AnActionEvent e) {
        Project project = e.getProject();
        boolean enabled = (Boolean)StudioFlags.RUNDEBUG_ANDROID_BUILD_BUNDLE_ENABLED.get() != false && BuildBundleAction.isProjectBuildWithGradle(project);
        e.getPresentation().setEnabledAndVisible(enabled);
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = e.getProject();
        if (BuildBundleAction.isProjectBuildWithGradle(project)) {
            List<Module> appModules = DynamicAppUtils.getModulesSupportingBundleTask(project);
            if (!appModules.isEmpty()) {
                GradleBuildInvoker gradleBuildInvoker = GradleBuildInvoker.getInstance(project);
                gradleBuildInvoker.add(new GoToBundleLocationTask(project, appModules, ACTION_TEXT));
                Module[] modulesToBuild = appModules.toArray(Module.EMPTY_ARRAY);
                gradleBuildInvoker.bundle(modulesToBuild, Collections.emptyList(), new OutputBuildAction(BuildBundleAction.getModuleGradlePaths(appModules)));
            } else {
                DynamicAppUtils.promptUserForGradleUpdate(project);
            }
        }
    }

    @NotNull
    private static List<String> getModuleGradlePaths(@NotNull List<Module> modules) {
        ArrayList<String> gradlePaths = new ArrayList<String>();
        for (Module module : modules) {
            String gradlePath = GradleUtil.getGradlePath(module);
            if (gradlePath == null) continue;
            gradlePaths.add(gradlePath);
        }
        return gradlePaths;
    }

    private static boolean isProjectBuildWithGradle(@Nullable Project project) {
        return project != null && GradleProjectInfo.getInstance(project).isBuildWithGradle();
    }
}

