/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.actions;

import com.android.tools.idea.gradle.actions.AndroidStudioGradleAction;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.build.invoker.GradleBuildInvoker;
import com.android.tools.idea.gradle.project.build.invoker.TestCompileType;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public class MakeGradleModuleAction
extends AndroidStudioGradleAction {
    public MakeGradleModuleAction() {
        super("Make Module(s)");
    }

    @Override
    protected void doUpdate(@NotNull AnActionEvent e, @NotNull Project project) {
        MakeGradleModuleAction.updatePresentation(e, project);
    }

    public static void updatePresentation(@NotNull AnActionEvent e, @NotNull Project project) {
        String presentationText;
        DataContext dataContext = e.getDataContext();
        Module[] modules = GradleProjectInfo.getInstance(project).getModulesToBuildFromSelection(dataContext);
        int moduleCount = modules.length;
        Presentation presentation = e.getPresentation();
        presentation.setEnabled(moduleCount > 0);
        if (moduleCount > 0) {
            StringBuilder text = new StringBuilder("Make Module");
            if (moduleCount > 1) {
                text.append("s");
            }
            for (int i2 = 0; i2 < moduleCount; ++i2) {
                if (text.length() > 30) {
                    text = new StringBuilder("Make Selected Modules");
                    break;
                }
                Module toMake = modules[i2];
                if (i2 != 0) {
                    text.append(",");
                }
                text.append(" '").append(toMake.getName()).append("'");
            }
            presentationText = text.toString();
        } else {
            presentationText = "Make";
        }
        presentation.setText(presentationText);
        presentation.setVisible(moduleCount > 0 || !"ProjectViewPopup".equals(e.getPlace()));
    }

    @Override
    protected void doPerform(@NotNull AnActionEvent e, @NotNull Project project) {
        Module[] modules = GradleProjectInfo.getInstance(project).getModulesToBuildFromSelection(e.getDataContext());
        GradleBuildInvoker.getInstance(project).assemble(modules, TestCompileType.ALL);
    }
}

