/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.api;

import com.android.tools.idea.diagnostics.crash.StudioCrashReporter;
import com.android.tools.idea.diagnostics.crash.StudioExceptionReport;
import com.android.tools.idea.gradle.dsl.api.BuildScriptModel;
import com.android.tools.idea.gradle.dsl.api.GradleFileModel;
import com.android.tools.idea.gradle.dsl.api.GradleModelProvider;
import com.android.tools.idea.gradle.dsl.api.PluginModel;
import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.gradle.dsl.api.android.AndroidModel;
import com.android.tools.idea.gradle.dsl.api.configurations.ConfigurationsModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.DependenciesModel;
import com.android.tools.idea.gradle.dsl.api.ext.ExtModel;
import com.android.tools.idea.gradle.dsl.api.java.JavaModel;
import com.android.tools.idea.gradle.dsl.api.repositories.RepositoriesModel;
import com.android.tools.idea.gradle.dsl.api.values.GradleNotNullValue;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface GradleBuildModel
extends GradleFileModel {
    @Nullable
    public static <T> T tryOrLog(@NotNull Supplier<T> supplier) {
        try {
            return supplier.get();
        }
        catch (Exception e) {
            if (e instanceof ControlFlowException) {
                return null;
            }
            Logger logger = Logger.getInstance(ProjectBuildModel.class);
            logger.error((Throwable)e);
            StudioCrashReporter reporter = StudioCrashReporter.getInstance();
            reporter.submit(new StudioExceptionReport.Builder().setThrowable(e, false).build());
            return null;
        }
    }

    @Deprecated
    @Nullable
    public static GradleBuildModel get(@NotNull Project project) {
        return GradleBuildModel.tryOrLog(() -> GradleModelProvider.get().getBuildModel(project));
    }

    @Deprecated
    @Nullable
    public static GradleBuildModel get(@NotNull Module module) {
        return GradleBuildModel.tryOrLog(() -> GradleModelProvider.get().getBuildModel(module));
    }

    @Deprecated
    @NotNull
    public static GradleBuildModel parseBuildFile(@NotNull VirtualFile file, @NotNull Project project) {
        return GradleModelProvider.get().parseBuildFile(file, project);
    }

    @Deprecated
    @NotNull
    public static GradleBuildModel parseBuildFile(@NotNull VirtualFile file, @NotNull Project project, @NotNull String moduleName) {
        return GradleModelProvider.get().parseBuildFile(file, project, moduleName);
    }

    @Deprecated
    @NotNull
    public List<GradleNotNullValue<String>> appliedPlugins();

    @NotNull
    public List<PluginModel> plugins();

    @NotNull
    public PluginModel applyPlugin(@NotNull String var1);

    public void removePlugin(@NotNull String var1);

    @NotNull
    public AndroidModel android();

    @NotNull
    public BuildScriptModel buildscript();

    @NotNull
    public ConfigurationsModel configurations();

    @NotNull
    public DependenciesModel dependencies();

    @NotNull
    public ExtModel ext();

    @NotNull
    public JavaModel java();

    @NotNull
    public RepositoriesModel repositories();

    @NotNull
    public Set<GradleFileModel> getInvolvedFiles();

    public void removeRepositoriesBlocks();
}

