/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.api;

import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.GradleModelProvider;
import com.android.tools.idea.gradle.dsl.api.GradleSettingsModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;

public interface ProjectBuildModel {
    @NotNull
    public static ProjectBuildModel get(@NotNull Project project) {
        return GradleModelProvider.get().getProjectModel(project);
    }

    @Nullable
    public static ProjectBuildModel getForCompositeBuild(@NotNull Project hostProject, @NotNull String includedBuildRoot) {
        return GradleModelProvider.get().getProjectModel(hostProject, includedBuildRoot);
    }

    @NotNull
    public static List<ProjectBuildModel> getForIncludedBuilds(@NotNull Project project) {
        ArrayList<ProjectBuildModel> result2 = new ArrayList<ProjectBuildModel>();
        result2.add(ProjectBuildModel.get(project));
        String basePath = project.getBasePath();
        if (basePath == null) {
            return result2;
        }
        GradleProjectSettings settings = (GradleProjectSettings)GradleSettings.getInstance((Project)project).getLinkedProjectSettings(basePath);
        if (settings == null) {
            return result2;
        }
        GradleProjectSettings.CompositeBuild compositeBuild = settings.getCompositeBuild();
        if (compositeBuild == null) {
            return result2;
        }
        compositeBuild.getCompositeParticipants().stream().map(build2 -> build2.getRootPath()).forEach(path -> result2.add(ProjectBuildModel.getForCompositeBuild(project, path)));
        return result2;
    }

    @Nullable
    public static ProjectBuildModel getOrLog(@NotNull Project project) {
        return GradleBuildModel.tryOrLog(() -> ProjectBuildModel.get(project));
    }

    @Nullable
    public GradleBuildModel getProjectBuildModel();

    @Nullable
    public GradleBuildModel getModuleBuildModel(@NotNull Module var1);

    @Nullable
    public GradleBuildModel getModuleBuildModel(@NotNull File var1);

    @NotNull
    public GradleBuildModel getModuleBuildModel(@NotNull VirtualFile var1);

    @Nullable
    public GradleSettingsModel getProjectSettingsModel();

    public void applyChanges();

    public void resetState();

    public void reparse();

    @NotNull
    public List<GradleBuildModel> getAllIncludedBuildModels();
}

