/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model;

import com.android.tools.idea.Projects;
import com.android.tools.idea.gradle.dsl.api.BuildScriptModel;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.GradleFileModel;
import com.android.tools.idea.gradle.dsl.api.PluginModel;
import com.android.tools.idea.gradle.dsl.api.android.AndroidModel;
import com.android.tools.idea.gradle.dsl.api.configurations.ConfigurationsModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.DependenciesModel;
import com.android.tools.idea.gradle.dsl.api.ext.ExtModel;
import com.android.tools.idea.gradle.dsl.api.java.JavaModel;
import com.android.tools.idea.gradle.dsl.api.repositories.RepositoriesModel;
import com.android.tools.idea.gradle.dsl.api.values.GradleNotNullValue;
import com.android.tools.idea.gradle.dsl.model.GradleFileModelImpl;
import com.android.tools.idea.gradle.dsl.model.GradlePropertiesModel;
import com.android.tools.idea.gradle.dsl.model.GradleSettingsModelImpl;
import com.android.tools.idea.gradle.dsl.model.PluginModelImpl;
import com.android.tools.idea.gradle.dsl.model.android.AndroidModelImpl;
import com.android.tools.idea.gradle.dsl.model.build.BuildScriptModelImpl;
import com.android.tools.idea.gradle.dsl.model.configurations.ConfigurationsModelImpl;
import com.android.tools.idea.gradle.dsl.model.dependencies.DependenciesModelImpl;
import com.android.tools.idea.gradle.dsl.model.ext.ExtModelImpl;
import com.android.tools.idea.gradle.dsl.model.java.JavaModelImpl;
import com.android.tools.idea.gradle.dsl.model.repositories.RepositoriesModelImpl;
import com.android.tools.idea.gradle.dsl.parser.BuildModelContext;
import com.android.tools.idea.gradle.dsl.parser.android.AndroidDslElement;
import com.android.tools.idea.gradle.dsl.parser.apply.ApplyDslElement;
import com.android.tools.idea.gradle.dsl.parser.build.BuildScriptDslElement;
import com.android.tools.idea.gradle.dsl.parser.build.SubProjectsDslElement;
import com.android.tools.idea.gradle.dsl.parser.configurations.ConfigurationsDslElement;
import com.android.tools.idea.gradle.dsl.parser.dependencies.DependenciesDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.ext.ExtDslElement;
import com.android.tools.idea.gradle.dsl.parser.files.GradleBuildFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleDslFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradlePropertiesFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleSettingsFile;
import com.android.tools.idea.gradle.dsl.parser.java.JavaDslElement;
import com.android.tools.idea.gradle.dsl.parser.repositories.RepositoriesDslElement;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleBuildModelImpl
extends GradleFileModelImpl
implements GradleBuildModel {
    @NonNls
    private static final String PLUGIN = "plugin";

    @Deprecated
    @Nullable
    public static GradleBuildModel get(@NotNull Project project) {
        VirtualFile file = GradleUtil.getGradleBuildFile(Projects.getBaseDirPath((Project)project));
        return file != null ? GradleBuildModelImpl.parseBuildFile(file, project, project.getName()) : null;
    }

    @Deprecated
    @Nullable
    public static GradleBuildModel get(@NotNull Module module) {
        VirtualFile file = GradleUtil.getGradleBuildFile(module);
        return file != null ? GradleBuildModelImpl.parseBuildFile(file, module.getProject(), module.getName()) : null;
    }

    @Deprecated
    @NotNull
    public static GradleBuildModel parseBuildFile(@NotNull VirtualFile file, @NotNull Project project) {
        return GradleBuildModelImpl.parseBuildFile(file, project, "<Unknown>");
    }

    @Deprecated
    @NotNull
    public static GradleBuildModel parseBuildFile(@NotNull VirtualFile file, @NotNull Project project, @NotNull String moduleName) {
        return new GradleBuildModelImpl(GradleBuildModelImpl.parseBuildFile(file, project, moduleName, BuildModelContext.create(project), false));
    }

    @Override
    @Deprecated
    @NotNull
    public List<GradleNotNullValue<String>> appliedPlugins() {
        return this.plugins().stream().map(plugin -> new GradleNotNullValue<String>(){

            @Override
            @NotNull
            public VirtualFile getFile() {
                return plugin.name().getGradleFile();
            }

            @Override
            @NotNull
            public String getPropertyName() {
                return plugin.name().getName();
            }

            @Override
            @Nullable
            public String getDslText() {
                return (String)ApplicationManager.getApplication().runReadAction(() -> {
                    PsiElement e = plugin.name().getPsiElement();
                    return e == null ? null : e.getText();
                });
            }

            @Override
            @NotNull
            public Map<String, GradleNotNullValue<Object>> getResolvedVariables() {
                return ImmutableMap.of();
            }

            @Override
            @NotNull
            public String value() {
                return plugin.name().forceString();
            }

            @Override
            @Nullable
            public PsiElement getPsiElement() {
                return plugin.name().getPsiElement();
            }
        }).collect(Collectors.toList());
    }

    @NotNull
    public static GradleBuildFile parseBuildFile(@NotNull VirtualFile file, @NotNull Project project, @NotNull String moduleName, @NotNull BuildModelContext context, boolean isApplied) {
        GradleBuildFile buildDslFile = new GradleBuildFile(file, project, moduleName, context);
        ApplicationManager.getApplication().runReadAction(() -> {
            if (!isApplied) {
                GradleBuildModelImpl.populateWithParentModuleSubProjectsProperties(buildDslFile, context);
            }
            GradleBuildModelImpl.populateSiblingDslFileWithGradlePropertiesFile(buildDslFile, context);
            buildDslFile.parse();
        });
        return buildDslFile;
    }

    public static void populateWithParentModuleSubProjectsProperties(@NotNull GradleBuildFile buildDslFile, @NotNull BuildModelContext context) {
        VirtualFile maybeSettingsFile = buildDslFile.tryToFindSettingsFile();
        if (maybeSettingsFile == null) {
            return;
        }
        GradleSettingsFile settingsFile = context.getOrCreateSettingsFile(maybeSettingsFile);
        GradleSettingsModelImpl gradleSettingsModel = new GradleSettingsModelImpl(settingsFile);
        String modulePath = gradleSettingsModel.moduleWithDirectory(buildDslFile.getDirectoryPath());
        if (modulePath == null) {
            return;
        }
        GradleBuildModel parentModuleModel = gradleSettingsModel.getParentModuleModel(modulePath);
        if (!(parentModuleModel instanceof GradleBuildModelImpl)) {
            return;
        }
        GradleBuildModelImpl parentModuleModelImpl = (GradleBuildModelImpl)parentModuleModel;
        GradleDslFile parentModuleDslFile = parentModuleModelImpl.myGradleDslFile;
        buildDslFile.setParentModuleDslFile(parentModuleDslFile);
        SubProjectsDslElement subProjectsDslElement = parentModuleDslFile.getPropertyElement("subprojects", SubProjectsDslElement.class);
        if (subProjectsDslElement == null) {
            return;
        }
        buildDslFile.setParsedElement(subProjectsDslElement);
        for (Map.Entry<String, GradleDslElement> entry : subProjectsDslElement.getPropertyElements().entrySet()) {
            buildDslFile.setParsedElement(entry.getValue());
        }
    }

    public static void populateSiblingDslFileWithGradlePropertiesFile(@NotNull GradleBuildFile buildDslFile, @NotNull BuildModelContext context) {
        File propertiesFilePath = new File(buildDslFile.getDirectoryPath(), "gradle.properties");
        VirtualFile propertiesFile = VfsUtil.findFileByIoFile((File)propertiesFilePath, (boolean)false);
        if (propertiesFile == null) {
            return;
        }
        GradlePropertiesFile parsedProperties = context.getOrCreatePropertiesFile(propertiesFile, buildDslFile.getName());
        if (parsedProperties == null) {
            return;
        }
        GradlePropertiesModel propertiesModel = new GradlePropertiesModel(parsedProperties);
        GradleDslFile propertiesDslFile = propertiesModel.myGradleDslFile;
        buildDslFile.setSiblingDslFile(propertiesDslFile);
        propertiesDslFile.setSiblingDslFile(buildDslFile);
    }

    GradleBuildModelImpl(@NotNull GradleBuildFile buildDslFile) {
        super(buildDslFile);
    }

    @Override
    @NotNull
    public List<PluginModel> plugins() {
        ApplyDslElement applyDslElement = this.myGradleDslFile.getPropertyElement("apply", ApplyDslElement.class);
        if (applyDslElement == null) {
            return ImmutableList.of();
        }
        return new ArrayList<PluginModel>(PluginModelImpl.deduplicatePlugins(PluginModelImpl.create(applyDslElement)).values());
    }

    @Override
    @NotNull
    public PluginModel applyPlugin(@NotNull String plugin) {
        Map<String, PluginModel> models;
        ApplyDslElement applyDslElement = this.myGradleDslFile.getPropertyElement("apply", ApplyDslElement.class);
        if (applyDslElement == null) {
            applyDslElement = new ApplyDslElement(this.myGradleDslFile);
            this.myGradleDslFile.addNewElementAt(0, applyDslElement);
        }
        if ((models = PluginModelImpl.deduplicatePlugins(PluginModelImpl.create(applyDslElement))).containsKey(plugin)) {
            return models.get(plugin);
        }
        GradleDslExpressionMap applyMap = new GradleDslExpressionMap(this.myGradleDslFile, GradleNameElement.create("apply"));
        GradleDslLiteral literal = new GradleDslLiteral(applyMap, GradleNameElement.create(PLUGIN));
        literal.setValue(plugin.trim());
        applyMap.setNewElement(literal);
        applyDslElement.setNewElement(applyMap);
        return new PluginModelImpl(applyMap, literal);
    }

    @Override
    public void removePlugin(@NotNull String plugin) {
        ApplyDslElement applyDslElement = this.myGradleDslFile.getPropertyElement("apply", ApplyDslElement.class);
        if (applyDslElement == null) {
            return;
        }
        PluginModelImpl.removePlugins(PluginModelImpl.create(applyDslElement), plugin);
    }

    @Override
    @NotNull
    public AndroidModel android() {
        AndroidDslElement androidDslElement = this.myGradleDslFile.getPropertyElement("android", AndroidDslElement.class);
        if (androidDslElement == null) {
            androidDslElement = new AndroidDslElement(this.myGradleDslFile);
            this.myGradleDslFile.setNewElement(androidDslElement);
        }
        return new AndroidModelImpl(androidDslElement);
    }

    @Override
    @NotNull
    public BuildScriptModel buildscript() {
        BuildScriptDslElement buildScriptDslElement = this.myGradleDslFile.getPropertyElement("buildscript", BuildScriptDslElement.class);
        if (buildScriptDslElement == null) {
            buildScriptDslElement = new BuildScriptDslElement(this.myGradleDslFile);
            this.myGradleDslFile.setNewElement(buildScriptDslElement);
        }
        return new BuildScriptModelImpl(buildScriptDslElement);
    }

    @Override
    @NotNull
    public ConfigurationsModel configurations() {
        ConfigurationsDslElement configurationsDslElement = this.myGradleDslFile.getPropertyElement("configurations", ConfigurationsDslElement.class);
        if (configurationsDslElement == null) {
            configurationsDslElement = new ConfigurationsDslElement(this.myGradleDslFile);
            this.myGradleDslFile.addNewElementBeforeAllOfClass(configurationsDslElement, DependenciesDslElement.class);
        }
        return new ConfigurationsModelImpl(configurationsDslElement);
    }

    @Override
    @NotNull
    public DependenciesModel dependencies() {
        DependenciesDslElement dependenciesDslElement = this.myGradleDslFile.getPropertyElement("dependencies", DependenciesDslElement.class);
        if (dependenciesDslElement == null) {
            dependenciesDslElement = new DependenciesDslElement(this.myGradleDslFile);
            this.myGradleDslFile.setNewElement(dependenciesDslElement);
        }
        return new DependenciesModelImpl(dependenciesDslElement);
    }

    @Override
    @NotNull
    public ExtModel ext() {
        ExtDslElement extDslElement = this.myGradleDslFile.getPropertyElement("ext", ExtDslElement.class);
        if (extDslElement == null) {
            extDslElement = new ExtDslElement(this.myGradleDslFile);
            List<GradleDslElement> elements = this.myGradleDslFile.getAllElements();
            int index = !elements.isEmpty() && elements.get(0) instanceof ApplyDslElement ? 1 : 0;
            this.myGradleDslFile.addNewElementAt(index, extDslElement);
        }
        return new ExtModelImpl(extDslElement);
    }

    @Override
    @NotNull
    public JavaModel java() {
        JavaDslElement javaDslElement = this.myGradleDslFile.getPropertyElement("java", JavaDslElement.class);
        if (javaDslElement == null) {
            javaDslElement = new JavaDslElement(this.myGradleDslFile);
            this.myGradleDslFile.setNewElement(javaDslElement);
        }
        return new JavaModelImpl(javaDslElement);
    }

    @Override
    @NotNull
    public RepositoriesModel repositories() {
        RepositoriesDslElement repositoriesDslElement = this.myGradleDslFile.getPropertyElement("repositories", RepositoriesDslElement.class);
        if (repositoriesDslElement == null) {
            repositoriesDslElement = new RepositoriesDslElement(this.myGradleDslFile);
            this.myGradleDslFile.setNewElement(repositoriesDslElement);
        }
        return new RepositoriesModelImpl(repositoriesDslElement);
    }

    @Override
    @NotNull
    public Set<GradleFileModel> getInvolvedFiles() {
        return this.getAllInvolvedFiles().stream().distinct().map(e -> GradleBuildModelImpl.getFileModel(e)).collect(Collectors.toSet());
    }

    @NotNull
    private static GradleFileModel getFileModel(@NotNull GradleDslFile file) {
        if (file instanceof GradleBuildFile) {
            return new GradleBuildModelImpl((GradleBuildFile)file);
        }
        if (file instanceof GradleSettingsFile) {
            return new GradleSettingsModelImpl((GradleSettingsFile)file);
        }
        if (file instanceof GradlePropertiesFile) {
            return new GradlePropertiesModel(file);
        }
        throw new IllegalStateException("Unknown GradleDslFile type found!");
    }

    @Override
    public void removeRepositoriesBlocks() {
        this.myGradleDslFile.removeProperty("repositories");
    }
}

