/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model;

import com.android.tools.idea.Projects;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.GradleSettingsModel;
import com.android.tools.idea.gradle.dsl.model.GradleBuildModelImpl;
import com.android.tools.idea.gradle.dsl.model.GradleFileModelImpl;
import com.android.tools.idea.gradle.dsl.parser.BuildModelContext;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslSimpleExpression;
import com.android.tools.idea.gradle.dsl.parser.files.GradleBuildFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleSettingsFile;
import com.android.tools.idea.gradle.dsl.parser.settings.ProjectPropertiesDslElement;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.collect.Lists;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleSettingsModelImpl
extends GradleFileModelImpl
implements GradleSettingsModel {
    public static final String INCLUDE = "include";
    private static final String INCLUDE_BUILD = "includeBuild";

    @Deprecated
    @Nullable
    public static GradleSettingsModel get(@NotNull Project project) {
        VirtualFile file = GradleUtil.getGradleSettingsFile(Projects.getBaseDirPath((Project)project));
        return file != null ? GradleSettingsModelImpl.parseBuildFile(file, project, "settings") : null;
    }

    @Deprecated
    @NotNull
    public static GradleSettingsModel parseBuildFile(@NotNull VirtualFile file, @NotNull Project project, @NotNull String moduleName) {
        GradleSettingsFile settingsFile = new GradleSettingsFile(file, project, moduleName, BuildModelContext.create(project));
        settingsFile.parse();
        return new GradleSettingsModelImpl(settingsFile);
    }

    public GradleSettingsModelImpl(@NotNull GradleSettingsFile parsedModel) {
        super(parsedModel);
    }

    @Override
    @NotNull
    public List<String> modulePaths() {
        ArrayList result2 = Lists.newArrayList();
        result2.add(":");
        GradleDslExpressionList includePaths = this.myGradleDslFile.getPropertyElement(INCLUDE, GradleDslExpressionList.class);
        if (includePaths == null) {
            return result2;
        }
        for (GradleDslSimpleExpression includePath : includePaths.getSimpleExpressions()) {
            String value2 = includePath.getValue(String.class);
            if (value2 == null) continue;
            result2.add(GradleSettingsModelImpl.standardiseModulePath(value2));
        }
        return result2;
    }

    @Override
    public void addModulePath(@NotNull String modulePath) {
        modulePath = GradleSettingsModelImpl.standardiseModulePath(modulePath);
        this.myGradleDslFile.addToNewLiteralList(INCLUDE, modulePath);
    }

    @Override
    public void removeModulePath(@NotNull String modulePath) {
        if (!modulePath.startsWith(":")) {
            this.myGradleDslFile.removeFromExpressionList(INCLUDE, ":" + modulePath);
        }
        this.myGradleDslFile.removeFromExpressionList(INCLUDE, modulePath);
    }

    @Override
    public void replaceModulePath(@NotNull String oldModulePath, @NotNull String newModulePath) {
        if (!newModulePath.startsWith(":")) {
            newModulePath = ":" + newModulePath;
        }
        if (!oldModulePath.startsWith(":")) {
            this.myGradleDslFile.replaceInExpressionList(INCLUDE, ":" + oldModulePath, newModulePath);
        }
        this.myGradleDslFile.replaceInExpressionList(INCLUDE, oldModulePath, newModulePath);
    }

    @Override
    @Nullable
    public File moduleDirectory(String modulePath) {
        modulePath = GradleSettingsModelImpl.standardiseModulePath(modulePath);
        if (!this.modulePaths().contains(modulePath)) {
            return null;
        }
        return this.moduleDirectoryNoCheck(modulePath);
    }

    @Nullable
    private File moduleDirectoryNoCheck(String modulePath) {
        File parentDir;
        File projectDir;
        File rootDirPath = VfsUtilCore.virtualToIoFile((VirtualFile)this.myGradleDslFile.getFile().getParent());
        if (modulePath.equals(":")) {
            return rootDirPath;
        }
        String projectKey = "project('" + modulePath + "')";
        ProjectPropertiesDslElement projectProperties = this.myGradleDslFile.getPropertyElement(projectKey, ProjectPropertiesDslElement.class);
        if (projectProperties != null && (projectDir = projectProperties.projectDir()) != null) {
            return projectDir;
        }
        if (modulePath.lastIndexOf(58) == 0) {
            parentDir = rootDirPath;
        } else {
            String parentModule = GradleSettingsModelImpl.parentModuleNoCheck(modulePath);
            if (parentModule == null) {
                return null;
            }
            parentDir = this.moduleDirectoryNoCheck(parentModule);
        }
        String moduleName = modulePath.substring(modulePath.lastIndexOf(58) + 1);
        return new File(parentDir, moduleName);
    }

    @Override
    @Nullable
    public String moduleWithDirectory(@NotNull File moduleDir) {
        for (String modulePath : this.modulePaths()) {
            if (!FileUtil.filesEqual((File)moduleDir, (File)this.moduleDirectory(modulePath))) continue;
            return modulePath;
        }
        return null;
    }

    @Override
    @Nullable
    public GradleBuildModel moduleModel(@NotNull String modulePath) {
        File buildFilePath = this.buildFile(modulePath);
        if (buildFilePath == null) {
            return null;
        }
        VirtualFile buildFile = VfsUtil.findFileByIoFile((File)buildFilePath, (boolean)false);
        if (buildFile == null) {
            return null;
        }
        GradleBuildFile dslFile = this.myGradleDslFile.getContext().getOrCreateBuildFile(buildFile, modulePath.substring(modulePath.lastIndexOf(58) + 1), false);
        return new GradleBuildModelImpl(dslFile);
    }

    @Override
    @Nullable
    public String parentModule(@NotNull String modulePath) {
        modulePath = GradleSettingsModelImpl.standardiseModulePath(modulePath);
        List<String> allModulePaths = this.modulePaths();
        if (!allModulePaths.contains(modulePath)) {
            return null;
        }
        String currentPath = modulePath;
        do {
            if (!allModulePaths.contains(currentPath = GradleSettingsModelImpl.parentModuleNoCheck(currentPath))) continue;
            return currentPath;
        } while (currentPath != null && !currentPath.equals(":"));
        return null;
    }

    @Nullable
    private static String parentModuleNoCheck(@NotNull String modulePath) {
        if ((modulePath = GradleSettingsModelImpl.standardiseModulePath(modulePath)).equals(":")) {
            return null;
        }
        int lastPathElementIndex = modulePath.lastIndexOf(58);
        return lastPathElementIndex == 0 ? ":" : modulePath.substring(0, lastPathElementIndex);
    }

    @Override
    @Nullable
    public GradleBuildModel getParentModuleModel(@NotNull String modulePath) {
        String parentModule = this.parentModule(modulePath);
        if (parentModule == null) {
            return null;
        }
        return this.moduleModel(parentModule);
    }

    @Override
    @Nullable
    public File buildFile(@NotNull String modulePath) {
        File moduleDirectory = this.moduleDirectory(modulePath);
        if (moduleDirectory == null) {
            return null;
        }
        String buildFileName = null;
        String projectKey = "project('" + modulePath + "')";
        ProjectPropertiesDslElement projectProperties = this.myGradleDslFile.getPropertyElement(projectKey, ProjectPropertiesDslElement.class);
        if (projectProperties != null) {
            buildFileName = projectProperties.getLiteral("buildFileName", String.class);
        }
        if (buildFileName == null) {
            buildFileName = "build.gradle";
        }
        return new File(moduleDirectory, buildFileName);
    }

    @Override
    @NotNull
    public List<VirtualFile> includedBuilds() {
        List<GradleDslElement> properties = this.myGradleDslFile.getPropertyElementsByName(INCLUDE_BUILD);
        return properties.stream().map(element -> {
            String value2 = GradleSettingsModelImpl.extractValueFromElement(element);
            if (value2 == null) {
                return null;
            }
            return this.attemptToFindIncludedBuildRoot(value2);
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static String standardiseModulePath(@NotNull String modulePath) {
        return modulePath.startsWith(":") ? modulePath : ":" + modulePath;
    }

    @Nullable
    private static String extractValueFromElement(@Nullable GradleDslElement element) {
        if (!(element instanceof GradleDslSimpleExpression)) {
            return null;
        }
        return ((GradleDslSimpleExpression)element).getValue(String.class);
    }

    @Nullable
    private VirtualFile attemptToFindIncludedBuildRoot(@NotNull String fileName) {
        File realFile = new File(fileName);
        VirtualFile file = realFile.isAbsolute() ? LocalFileSystem.getInstance().findFileByIoFile(realFile) : this.myGradleDslFile.getFile().getParent().findFileByRelativePath(fileName);
        if (file != null && file.isDirectory()) {
            File compositeRoot = VfsUtilCore.virtualToIoFile((VirtualFile)file);
            VirtualFile buildFile = GradleUtil.getGradleBuildFile(compositeRoot);
            if (buildFile != null) {
                return file;
            }
            VirtualFile settingsFile = GradleUtil.getGradleSettingsFile(compositeRoot);
            if (settingsFile != null) {
                return file;
            }
        }
        return null;
    }
}

