/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model;

import com.android.tools.idea.gradle.dsl.api.PluginModel;
import com.android.tools.idea.gradle.dsl.api.ext.GradlePropertyModel;
import com.android.tools.idea.gradle.dsl.api.ext.ResolvedPropertyModel;
import com.android.tools.idea.gradle.dsl.model.ext.GradlePropertyModelBuilder;
import com.android.tools.idea.gradle.dsl.model.ext.PropertyUtil;
import com.android.tools.idea.gradle.dsl.parser.apply.ApplyDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslSimpleExpression;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PluginModelImpl
implements PluginModel {
    @NonNls
    private static final String PLUGIN = "plugin";
    @NotNull
    private final GradleDslElement myCompleteElement;
    @NotNull
    private final GradleDslSimpleExpression myDslElement;

    @NotNull
    public static List<PluginModelImpl> create(@NotNull ApplyDslElement dslElement) {
        List<GradleDslElement> elements = dslElement.getAllPropertyElements();
        ArrayList<PluginModelImpl> results = new ArrayList<PluginModelImpl>();
        for (GradleDslElement e : elements) {
            GradleDslElement element;
            if (e instanceof GradleDslSimpleExpression) {
                results.add(new PluginModelImpl(e, (GradleDslSimpleExpression)e));
                continue;
            }
            if (e instanceof GradleDslExpressionMap) {
                element = ((GradleDslExpressionMap)e).getElement(PLUGIN);
                if (!(element instanceof GradleDslSimpleExpression)) continue;
                results.add(new PluginModelImpl(e, (GradleDslSimpleExpression)element));
                continue;
            }
            if (!(e instanceof GradleDslExpressionList)) continue;
            element = (GradleDslExpressionList)e;
            for (GradleDslSimpleExpression item : ((GradleDslExpressionList)element).getSimpleExpressions()) {
                results.add(new PluginModelImpl(item, item));
            }
        }
        return results;
    }

    public static Map<String, PluginModel> deduplicatePlugins(@NotNull List<PluginModelImpl> models) {
        LinkedHashMap<String, PluginModel> modelMap = new LinkedHashMap<String, PluginModel>();
        for (PluginModel pluginModel : models) {
            ResolvedPropertyModel propertyModel = pluginModel.name();
            if (propertyModel.getValueType() != GradlePropertyModel.ValueType.STRING) continue;
            modelMap.put(propertyModel.forceString(), pluginModel);
        }
        return modelMap;
    }

    public static void removePlugins(@NotNull List<PluginModelImpl> models, @NotNull String name) {
        for (PluginModelImpl model2 : models) {
            if (!name.equals(model2.name().toString())) continue;
            model2.remove();
        }
    }

    public PluginModelImpl(@NotNull GradleDslElement completeElement, @NotNull GradleDslSimpleExpression element) {
        this.myDslElement = element;
        this.myCompleteElement = completeElement;
    }

    @Override
    @NotNull
    public ResolvedPropertyModel name() {
        return GradlePropertyModelBuilder.create(this.myDslElement).asMethod(true).buildResolved();
    }

    public void remove() {
        PropertyUtil.removeElement(this.myCompleteElement);
    }
}

