/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model;

import com.android.tools.idea.Projects;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.GradleSettingsModel;
import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.gradle.dsl.model.GradleBuildModelImpl;
import com.android.tools.idea.gradle.dsl.model.GradleSettingsModelImpl;
import com.android.tools.idea.gradle.dsl.parser.BuildModelContext;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElementImpl;
import com.android.tools.idea.gradle.dsl.parser.files.GradleBuildFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleDslFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleSettingsFile;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectBuildModelImpl
implements ProjectBuildModel {
    @NotNull
    private final BuildModelContext myBuildModelContext;
    @Nullable
    private final GradleBuildFile myProjectBuildFile;

    @NotNull
    public static ProjectBuildModel get(@NotNull Project project) {
        VirtualFile file = GradleUtil.getGradleBuildFile(Projects.getBaseDirPath((Project)project));
        return new ProjectBuildModelImpl(project, file);
    }

    @Nullable
    public static ProjectBuildModel get(@NotNull Project hostProject, @NotNull String compositeRoot) {
        VirtualFile file = GradleUtil.getGradleBuildFile(new File(compositeRoot));
        if (file == null) {
            return null;
        }
        return new ProjectBuildModelImpl(hostProject, file);
    }

    private ProjectBuildModelImpl(@NotNull Project project, @Nullable VirtualFile file) {
        this.myBuildModelContext = BuildModelContext.create(project);
        GradleBuildFile gradleBuildFile = this.myProjectBuildFile = file != null ? new GradleBuildFile(file, project, project.getName(), this.myBuildModelContext) : null;
        if (this.myProjectBuildFile != null) {
            this.myBuildModelContext.setRootProjectFile(this.myProjectBuildFile);
            ApplicationManager.getApplication().runReadAction(() -> {
                GradleBuildModelImpl.populateWithParentModuleSubProjectsProperties(this.myProjectBuildFile, this.myBuildModelContext);
                GradleBuildModelImpl.populateSiblingDslFileWithGradlePropertiesFile(this.myProjectBuildFile, this.myBuildModelContext);
                this.myProjectBuildFile.parse();
            });
            this.myBuildModelContext.putBuildFile(file.getUrl(), this.myProjectBuildFile);
        }
    }

    @Override
    @Nullable
    public GradleBuildModel getProjectBuildModel() {
        return this.myProjectBuildFile == null ? null : new GradleBuildModelImpl(this.myProjectBuildFile);
    }

    @Override
    @Nullable
    public GradleBuildModel getModuleBuildModel(@NotNull Module module) {
        VirtualFile file = GradleUtil.getGradleBuildFile(module);
        return file == null ? null : this.getModuleBuildModel(file);
    }

    @Override
    @Nullable
    public GradleBuildModel getModuleBuildModel(@NotNull File modulePath) {
        VirtualFile file = GradleUtil.getGradleBuildFile(modulePath);
        return file == null ? null : this.getModuleBuildModel(file);
    }

    @Override
    @NotNull
    public GradleBuildModel getModuleBuildModel(@NotNull VirtualFile file) {
        GradleBuildFile dslFile = this.myBuildModelContext.getOrCreateBuildFile(file, false);
        return new GradleBuildModelImpl(dslFile);
    }

    @Override
    @Nullable
    public GradleSettingsModel getProjectSettingsModel() {
        VirtualFile virtualFile = null;
        if (this.myProjectBuildFile == null) {
            VirtualFile projectDir = ProjectUtil.guessProjectDir((Project)this.myBuildModelContext.getProject());
            if (projectDir != null) {
                File ioFile = VfsUtilCore.virtualToIoFile((VirtualFile)projectDir);
                virtualFile = GradleUtil.getGradleSettingsFile(ioFile);
            }
        } else {
            virtualFile = this.myProjectBuildFile.tryToFindSettingsFile();
        }
        if (virtualFile == null) {
            return null;
        }
        GradleSettingsFile settingsFile = this.myBuildModelContext.getOrCreateSettingsFile(virtualFile);
        return new GradleSettingsModelImpl(settingsFile);
    }

    @Override
    public void applyChanges() {
        this.runOverProjectTree(file -> {
            file.applyChanges();
            file.saveAllChanges();
        });
    }

    @Override
    public void resetState() {
        this.runOverProjectTree(GradleDslElementImpl::resetState);
    }

    @Override
    public void reparse() {
        this.myBuildModelContext.reset();
        this.runOverProjectTree(GradleDslFile::reparse);
    }

    @Override
    @NotNull
    public List<GradleBuildModel> getAllIncludedBuildModels() {
        GradleSettingsModel settingsModel;
        ArrayList<GradleBuildModel> allModels = new ArrayList<GradleBuildModel>();
        if (this.myProjectBuildFile != null) {
            allModels.add(new GradleBuildModelImpl(this.myProjectBuildFile));
        }
        if ((settingsModel = this.getProjectSettingsModel()) == null) {
            return allModels;
        }
        allModels.addAll(settingsModel.modulePaths().stream().map(modulePath -> {
            if (modulePath.equals(":")) {
                return null;
            }
            File moduleDir = settingsModel.moduleDirectory((String)modulePath);
            if (moduleDir == null) {
                return null;
            }
            VirtualFile file = GradleUtil.getGradleBuildFile(moduleDir);
            if (file == null) {
                return null;
            }
            return this.getModuleBuildModel(file);
        }).filter(Objects::nonNull).collect(Collectors.toList()));
        return allModels;
    }

    private void runOverProjectTree(@NotNull Consumer<GradleDslFile> func) {
        this.myBuildModelContext.getAllRequestedFiles().forEach(func);
    }
}

