/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.android;

import com.android.tools.idea.gradle.dsl.api.android.ProductFlavorModel;
import com.android.tools.idea.gradle.dsl.api.android.productFlavors.ExternalNativeBuildOptionsModel;
import com.android.tools.idea.gradle.dsl.api.android.productFlavors.NdkOptionsModel;
import com.android.tools.idea.gradle.dsl.api.android.productFlavors.VectorDrawablesOptionsModel;
import com.android.tools.idea.gradle.dsl.api.ext.PropertyType;
import com.android.tools.idea.gradle.dsl.api.ext.ResolvedPropertyModel;
import com.android.tools.idea.gradle.dsl.model.android.FlavorTypeModelImpl;
import com.android.tools.idea.gradle.dsl.model.android.productFlavors.ExternalNativeBuildOptionsModelImpl;
import com.android.tools.idea.gradle.dsl.model.android.productFlavors.NdkOptionsModelImpl;
import com.android.tools.idea.gradle.dsl.model.android.productFlavors.VectorDrawablesOptionsModelImpl;
import com.android.tools.idea.gradle.dsl.model.ext.GradlePropertyModelBuilder;
import com.android.tools.idea.gradle.dsl.model.ext.PropertyUtil;
import com.android.tools.idea.gradle.dsl.model.ext.ResolvedPropertyModelImpl;
import com.android.tools.idea.gradle.dsl.parser.android.ProductFlavorDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.productFlavors.ExternalNativeBuildOptionsDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.productFlavors.NdkOptionsDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.productFlavors.VectorDrawablesOptionsDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class ProductFlavorModelImpl
extends FlavorTypeModelImpl
implements ProductFlavorModel {
    @NonNls
    private static final String APPLICATION_ID = "applicationId";
    @NonNls
    private static final String DIMENSION = "dimension";
    @NonNls
    private static final String MAX_SDK_VERSION = "maxSdkVersion";
    @NonNls
    private static final String MIN_SDK_VERSION = "minSdkVersion";
    @NonNls
    private static final String MISSING_DIMENSION_STRATEGY = "missingDimensionStrategy";
    @NonNls
    private static final String RENDER_SCRIPT_TARGET_API = "renderscriptTargetApi";
    @NonNls
    private static final String RENDER_SCRIPT_SUPPORT_MODE_ENABLED = "renderscriptSupportModeEnabled";
    @NonNls
    private static final String RENDER_SCRIPT_SUPPORT_MODE_BLAS_ENABLED = "renderscriptSupportModeBlasEnabled";
    @NonNls
    private static final String RENDER_SCRIPT_NDK_MODE_ENABLED = "renderscriptNdkModeEnabled";
    @NonNls
    private static final String RES_CONFIGS = "resConfigs";
    @NonNls
    private static final String TARGET_SDK_VERSION = "targetSdkVersion";
    @NonNls
    private static final String TEST_APPLICATION_ID = "testApplicationId";
    @NonNls
    private static final String TEST_FUNCTIONAL_TEST = "testFunctionalTest";
    @NonNls
    private static final String TEST_HANDLE_PROFILING = "testHandleProfiling";
    @NonNls
    private static final String TEST_INSTRUMENTATION_RUNNER = "testInstrumentationRunner";
    @NonNls
    private static final String TEST_INSTRUMENTATION_RUNNER_ARGUMENTS = "testInstrumentationRunnerArguments";
    @NonNls
    private static final String VERSION_CODE = "versionCode";
    @NonNls
    private static final String VERSION_NAME = "versionName";
    @NonNls
    private static final String WEAR_APP_UNBUNDLED = "wearAppUnbundled";

    public ProductFlavorModelImpl(@NotNull ProductFlavorDslElement dslElement) {
        super(dslElement);
    }

    @Override
    @NotNull
    public ResolvedPropertyModel applicationId() {
        return this.getModelForProperty(APPLICATION_ID);
    }

    @Override
    @NotNull
    public ResolvedPropertyModel dimension() {
        return this.getModelForProperty(DIMENSION);
    }

    @Override
    @NotNull
    public ExternalNativeBuildOptionsModel externalNativeBuild() {
        ExternalNativeBuildOptionsDslElement externalNativeBuildOptionsDslElement = this.myDslElement.getPropertyElement("externalNativeBuild", ExternalNativeBuildOptionsDslElement.class);
        if (externalNativeBuildOptionsDslElement == null) {
            externalNativeBuildOptionsDslElement = new ExternalNativeBuildOptionsDslElement(this.myDslElement);
            this.myDslElement.setNewElement(externalNativeBuildOptionsDslElement);
        }
        return new ExternalNativeBuildOptionsModelImpl(externalNativeBuildOptionsDslElement);
    }

    @Override
    public void removeExternalNativeBuild() {
        this.myDslElement.removeProperty("externalNativeBuild");
    }

    @Override
    @NotNull
    public ResolvedPropertyModel maxSdkVersion() {
        return this.getModelForProperty(MAX_SDK_VERSION, true);
    }

    @Override
    @NotNull
    public ResolvedPropertyModel minSdkVersion() {
        return this.getModelForProperty(MIN_SDK_VERSION, true);
    }

    @Override
    @NotNull
    public List<ResolvedPropertyModel> missingDimensionStrategies() {
        ArrayList<ResolvedPropertyModel> models = new ArrayList<ResolvedPropertyModel>();
        for (GradleDslExpressionList list : this.myDslElement.getPropertyElements(MISSING_DIMENSION_STRATEGY, GradleDslExpressionList.class)) {
            if (list.getExpressions().size() <= 1) continue;
            models.add(GradlePropertyModelBuilder.create(list).buildResolved());
        }
        return models;
    }

    @Override
    @NotNull
    public ResolvedPropertyModel addMissingDimensionStrategy(@NotNull String dimension2, Object ... fallbacks) {
        GradleDslExpressionList list = new GradleDslExpressionList((GradleDslElement)this.myDslElement, GradleNameElement.create(MISSING_DIMENSION_STRATEGY), false);
        this.myDslElement.setNewElement(list);
        list.setElementType(PropertyType.REGULAR);
        ResolvedPropertyModelImpl model2 = GradlePropertyModelBuilder.create(list).asMethod(true).buildResolved();
        model2.addListValue().setValue(dimension2);
        for (Object fallback : fallbacks) {
            model2.addListValue().setValue(fallback);
        }
        return model2;
    }

    @Override
    public boolean areMissingDimensionStrategiesModified() {
        List originalElements = this.myDslElement.getOriginalElements().stream().filter(e -> e.getName().equals(MISSING_DIMENSION_STRATEGY)).collect(Collectors.toList());
        List<GradleDslElement> currentElements = this.myDslElement.getPropertyElementsByName(MISSING_DIMENSION_STRATEGY);
        if (originalElements.size() != currentElements.size()) {
            return true;
        }
        for (GradleDslElement oldElement : originalElements) {
            boolean modified = true;
            for (GradleDslElement newElement : currentElements) {
                modified &= PropertyUtil.isElementModified(oldElement, newElement);
            }
            if (!modified) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public NdkOptionsModel ndk() {
        NdkOptionsDslElement ndkOptionsDslElement = this.myDslElement.getPropertyElement("ndk", NdkOptionsDslElement.class);
        if (ndkOptionsDslElement == null) {
            ndkOptionsDslElement = new NdkOptionsDslElement(this.myDslElement);
            this.myDslElement.setNewElement(ndkOptionsDslElement);
        }
        return new NdkOptionsModelImpl(ndkOptionsDslElement);
    }

    @Override
    public void removeNdk() {
        this.myDslElement.removeProperty("ndk");
    }

    @Override
    @NotNull
    public ResolvedPropertyModel resConfigs() {
        return this.getModelForProperty(RES_CONFIGS, true);
    }

    @Override
    @NotNull
    public ResolvedPropertyModel renderscriptTargetApi() {
        return this.getModelForProperty(RENDER_SCRIPT_TARGET_API);
    }

    @Override
    @NotNull
    public ResolvedPropertyModel renderscriptSupportModeEnabled() {
        return this.getModelForProperty(RENDER_SCRIPT_SUPPORT_MODE_ENABLED);
    }

    @Override
    @NotNull
    public ResolvedPropertyModel renderscriptSupportModelBlasEnabled() {
        return this.getModelForProperty(RENDER_SCRIPT_SUPPORT_MODE_BLAS_ENABLED);
    }

    @Override
    @NotNull
    public ResolvedPropertyModel renderscriptNdkModeEnabled() {
        return this.getModelForProperty(RENDER_SCRIPT_NDK_MODE_ENABLED);
    }

    @Override
    @NotNull
    public ResolvedPropertyModel targetSdkVersion() {
        return this.getModelForProperty(TARGET_SDK_VERSION, true);
    }

    @Override
    @NotNull
    public ResolvedPropertyModel testApplicationId() {
        return this.getModelForProperty(TEST_APPLICATION_ID);
    }

    @Override
    @NotNull
    public ResolvedPropertyModel testFunctionalTest() {
        return this.getModelForProperty(TEST_FUNCTIONAL_TEST);
    }

    @Override
    @NotNull
    public ResolvedPropertyModel testHandleProfiling() {
        return this.getModelForProperty(TEST_HANDLE_PROFILING);
    }

    @Override
    @NotNull
    public ResolvedPropertyModel testInstrumentationRunner() {
        return this.getModelForProperty(TEST_INSTRUMENTATION_RUNNER);
    }

    @Override
    @NotNull
    public ResolvedPropertyModel testInstrumentationRunnerArguments() {
        return this.getModelForProperty(TEST_INSTRUMENTATION_RUNNER_ARGUMENTS);
    }

    @Override
    @NotNull
    public ResolvedPropertyModel versionCode() {
        return this.getModelForProperty(VERSION_CODE);
    }

    @Override
    @NotNull
    public ResolvedPropertyModel versionName() {
        return this.getModelForProperty(VERSION_NAME);
    }

    @Override
    @NotNull
    public VectorDrawablesOptionsModel vectorDrawables() {
        VectorDrawablesOptionsDslElement vectorDrawableElement = this.myDslElement.getPropertyElement("vectorDrawables", VectorDrawablesOptionsDslElement.class);
        if (vectorDrawableElement == null) {
            vectorDrawableElement = new VectorDrawablesOptionsDslElement(this.myDslElement);
            this.myDslElement.setNewElement(vectorDrawableElement);
        }
        return new VectorDrawablesOptionsModelImpl(vectorDrawableElement);
    }

    @Override
    @NotNull
    public ResolvedPropertyModel wearAppUnbundled() {
        return this.getModelForProperty(WEAR_APP_UNBUNDLED);
    }
}

