/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.dependencies;

import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencySpec;
import com.android.tools.idea.gradle.dsl.api.dependencies.DependencyConfigurationModel;
import com.android.tools.idea.gradle.dsl.api.ext.GradlePropertyModel;
import com.android.tools.idea.gradle.dsl.api.ext.PropertyType;
import com.android.tools.idea.gradle.dsl.api.ext.ResolvedPropertyModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.ArtifactDependencySpecImpl;
import com.android.tools.idea.gradle.dsl.model.dependencies.DependencyConfigurationModelImpl;
import com.android.tools.idea.gradle.dsl.model.dependencies.DependencyModelImpl;
import com.android.tools.idea.gradle.dsl.model.ext.GradlePropertyModelBuilder;
import com.android.tools.idea.gradle.dsl.model.ext.PropertyUtil;
import com.android.tools.idea.gradle.dsl.model.ext.transforms.FakeElementTransform;
import com.android.tools.idea.gradle.dsl.parser.dependencies.FakeArtifactElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslClosure;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslSimpleExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradlePropertiesDslElement;
import com.google.common.collect.Lists;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ArtifactDependencyModelImpl
extends DependencyModelImpl
implements ArtifactDependencyModel {
    @Nullable
    private GradleDslClosure myConfigurationElement;
    protected boolean mySetThrough = false;

    public ArtifactDependencyModelImpl(@Nullable GradleDslClosure configurationElement, @NotNull String configurationName, @NotNull DependencyModelImpl.Maintainer maintainer) {
        super(configurationName, maintainer);
        this.myConfigurationElement = configurationElement;
    }

    @NotNull
    protected ArtifactDependencySpec getSpec() {
        String name = this.name().toString();
        assert (name != null);
        return new ArtifactDependencySpecImpl(name, this.group().toString(), this.version().toString(), this.classifier().toString(), this.extension().toString());
    }

    @Override
    @NotNull
    public String compactNotation() {
        return this.getSpec().compactNotation();
    }

    @Override
    @NotNull
    public abstract ResolvedPropertyModel name();

    @Override
    @NotNull
    public abstract ResolvedPropertyModel group();

    @Override
    @NotNull
    public abstract ResolvedPropertyModel version();

    @Override
    @NotNull
    public abstract ResolvedPropertyModel classifier();

    @Override
    @NotNull
    public abstract ResolvedPropertyModel extension();

    @Override
    @NotNull
    public abstract ResolvedPropertyModel completeModel();

    @Override
    @Nullable
    public DependencyConfigurationModel configuration() {
        if (this.myConfigurationElement == null) {
            return null;
        }
        return new DependencyConfigurationModelImpl(this.myConfigurationElement);
    }

    @Override
    public void enableSetThrough() {
        this.mySetThrough = true;
    }

    @Override
    public void disableSetThrough() {
        this.mySetThrough = false;
    }

    static void createNew(@NotNull GradlePropertiesDslElement parent, @NotNull String configurationName, @NotNull ArtifactDependencySpec dependency, @NotNull List<ArtifactDependencySpec> excludes) {
        GradleNameElement name = GradleNameElement.create(configurationName);
        GradleDslLiteral literal = new GradleDslLiteral(parent, name);
        literal.setElementType(PropertyType.REGULAR);
        literal.setValue(ArtifactDependencyModelImpl.createCompactNotationForLiterals(dependency));
        if (!excludes.isEmpty()) {
            PsiElement configBlock = parent.getDslFile().getParser().convertToExcludesBlock(excludes);
            assert (configBlock != null);
            literal.setConfigBlock(configBlock);
        }
        parent.setNewElement(literal);
    }

    @NotNull
    private static String createCompactNotationForLiterals(@NotNull ArtifactDependencySpec spec) {
        ArrayList segments = Lists.newArrayList((Object[])new String[]{spec.getGroup(), spec.getName(), spec.getVersion(), spec.getClassifier(), spec.getExtension()});
        boolean shouldInterpolate = segments.stream().filter(Objects::nonNull).anyMatch(FakeArtifactElement::shouldInterpolate);
        String compact = spec.compactNotation();
        return shouldInterpolate ? GradlePropertyModel.iStr(compact) : compact;
    }

    static class CompactNotation
    extends ArtifactDependencyModelImpl {
        @NotNull
        private GradleDslSimpleExpression myDslExpression;

        @Nullable
        static CompactNotation create(@NotNull String configurationName, @NotNull GradleDslSimpleExpression dslExpression, @Nullable GradleDslClosure configurationElement, @NotNull DependencyModelImpl.Maintainer maintainer) {
            String value2 = dslExpression.getValue(String.class);
            if (value2 == null || value2.trim().isEmpty()) {
                return null;
            }
            CompactNotation notation = new CompactNotation(configurationName, dslExpression, configurationElement, maintainer);
            return notation.name().getValueType() != GradlePropertyModel.ValueType.NONE ? notation : null;
        }

        private CompactNotation(@NotNull String configurationName, @NotNull GradleDslSimpleExpression dslExpression, @Nullable GradleDslClosure configurationElement, @NotNull DependencyModelImpl.Maintainer maintainer) {
            super(configurationElement, configurationName, maintainer);
            this.myDslExpression = dslExpression;
        }

        @NotNull
        public ResolvedPropertyModel createModelFor(@NotNull String name, @NotNull Function<ArtifactDependencySpec, String> getFunc, @NotNull BiConsumer<ArtifactDependencySpec, String> setFunc, boolean canDelete) {
            GradleDslSimpleExpression element = this.mySetThrough ? PropertyUtil.resolveElement(this.myDslExpression) : this.myDslExpression;
            FakeArtifactElement fakeElement = new FakeArtifactElement(element.getParent(), GradleNameElement.fake(name), element, getFunc, setFunc, canDelete);
            return GradlePropertyModelBuilder.create(fakeElement).addTransform(new FakeElementTransform()).asMethod(true).buildResolved();
        }

        @Override
        @NotNull
        public ResolvedPropertyModel name() {
            return this.createModelFor("name", ArtifactDependencySpec::getName, ArtifactDependencySpec::setName, false);
        }

        @Override
        @NotNull
        public ResolvedPropertyModel group() {
            return this.createModelFor("group", ArtifactDependencySpec::getGroup, ArtifactDependencySpec::setGroup, true);
        }

        @Override
        @NotNull
        public ResolvedPropertyModel version() {
            return this.createModelFor("version", ArtifactDependencySpec::getVersion, ArtifactDependencySpec::setVersion, true);
        }

        @Override
        @NotNull
        public ResolvedPropertyModel classifier() {
            return this.createModelFor("classifier", ArtifactDependencySpec::getClassifier, ArtifactDependencySpec::setClassifier, true);
        }

        @Override
        @NotNull
        public ResolvedPropertyModel extension() {
            return this.createModelFor("extension", ArtifactDependencySpec::getExtension, ArtifactDependencySpec::setExtension, true);
        }

        @Override
        @NotNull
        public ResolvedPropertyModel completeModel() {
            return GradlePropertyModelBuilder.create(this.myDslExpression).asMethod(true).buildResolved();
        }

        @Override
        @NotNull
        protected GradleDslElement getDslElement() {
            return this.myDslExpression;
        }

        @Override
        void setDslElement(@NotNull GradleDslElement dslElement) {
            assert (!this.mySetThrough);
            this.myDslExpression = (GradleDslSimpleExpression)dslElement;
        }

        @Override
        @Nullable
        public PsiElement getPsiElement() {
            return this.myDslExpression.getExpression();
        }
    }

    static class MapNotation
    extends ArtifactDependencyModelImpl {
        @NotNull
        private GradleDslExpressionMap myDslElement;

        @Nullable
        static MapNotation create(@NotNull String configurationName, @NotNull GradleDslExpressionMap dslElement, @Nullable GradleDslClosure configurationElement, @NotNull DependencyModelImpl.Maintainer maintainer) {
            if (dslElement.getLiteral("name", String.class) == null) {
                return null;
            }
            return new MapNotation(configurationName, dslElement, configurationElement, maintainer);
        }

        private MapNotation(@NotNull String configurationName, @NotNull GradleDslExpressionMap dslElement, @Nullable GradleDslClosure configurationElement, @NotNull DependencyModelImpl.Maintainer maintainer) {
            super(configurationElement, configurationName, maintainer);
            this.myDslElement = dslElement;
        }

        @Override
        @NotNull
        public ResolvedPropertyModel name() {
            return GradlePropertyModelBuilder.create(this.myDslElement, "name").asMethod(true).buildResolved();
        }

        @Override
        @NotNull
        public ResolvedPropertyModel group() {
            return GradlePropertyModelBuilder.create(this.myDslElement, "group").asMethod(true).buildResolved();
        }

        @Override
        @NotNull
        public ResolvedPropertyModel version() {
            return GradlePropertyModelBuilder.create(this.myDslElement, "version").asMethod(true).buildResolved();
        }

        @Override
        @NotNull
        public ResolvedPropertyModel classifier() {
            return GradlePropertyModelBuilder.create(this.myDslElement, "classifier").asMethod(true).buildResolved();
        }

        @Override
        @NotNull
        public ResolvedPropertyModel extension() {
            return GradlePropertyModelBuilder.create(this.myDslElement, "ext").asMethod(true).buildResolved();
        }

        @Override
        @NotNull
        public ResolvedPropertyModel completeModel() {
            return GradlePropertyModelBuilder.create(this.myDslElement).asMethod(true).buildResolved();
        }

        @Override
        @NotNull
        protected GradleDslElement getDslElement() {
            return this.myDslElement;
        }

        @Override
        void setDslElement(@NotNull GradleDslElement dslElement) {
            this.myDslElement = (GradleDslExpressionMap)dslElement;
        }
    }
}

